// printing/backend/mojom/print_backend.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "printing/backend/mojom/print_backend.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "printing/backend/mojom/print_backend.mojom-params-data.h"
namespace printing {
namespace mojom {

namespace internal {


// static
bool PrinterBasicInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrinterBasicInfo_Data* object =
      static_cast<const PrinterBasicInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->printer_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& printer_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->printer_name, validation_context,
                                         &printer_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& display_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->display_name, validation_context,
                                         &display_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->printer_description, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& printer_description_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->printer_description, validation_context,
                                         &printer_description_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& options_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->options, validation_context,
                                         &options_validate_params)) {
    return false;
  }

  return true;
}

PrinterBasicInfo_Data::PrinterBasicInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Paper_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Paper_Data* object =
      static_cast<const Paper_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& display_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->display_name, validation_context,
                                         &display_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->vendor_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& vendor_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->vendor_id, validation_context,
                                         &vendor_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size_um, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size_um, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->printable_area_um, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->printable_area_um, validation_context))
    return false;

  return true;
}

Paper_Data::Paper_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaType_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaType_Data* object =
      static_cast<const MediaType_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& display_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->display_name, validation_context,
                                         &display_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->vendor_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& vendor_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->vendor_id, validation_context,
                                         &vendor_id_validate_params)) {
    return false;
  }

  return true;
}

MediaType_Data::MediaType_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrinterSemanticCapsAndDefaults_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 96, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrinterSemanticCapsAndDefaults_Data* object =
      static_cast<const PrinterSemanticCapsAndDefaults_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->duplex_modes, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& duplex_modes_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::printing::mojom::internal::DuplexMode_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->duplex_modes, validation_context,
                                         &duplex_modes_validate_params)) {
    return false;
  }


  if (!::printing::mojom::internal::DuplexMode_Data
        ::Validate(object->duplex_default, validation_context))
    return false;


  if (!::printing::mojom::internal::ColorModel_Data
        ::Validate(object->color_model, validation_context))
    return false;


  if (!::printing::mojom::internal::ColorModel_Data
        ::Validate(object->bw_model, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->papers, 10, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& papers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->papers, validation_context,
                                         &papers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_defined_papers, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& user_defined_papers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_defined_papers, validation_context,
                                         &user_defined_papers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->default_paper, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->default_paper, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dpis, 13, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& dpis_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->dpis, validation_context,
                                         &dpis_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->default_dpi, 14, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->default_dpi, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& media_types_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->media_types, validation_context,
                                         &media_types_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->default_media_type, validation_context))
    return false;

  return true;
}

PrinterSemanticCapsAndDefaults_Data::PrinterSemanticCapsAndDefaults_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace printing