// printing/backend/mojom/print_backend.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef PRINTING_BACKEND_MOJOM_PRINT_BACKEND_MOJOM_DATA_VIEW_H_
#define PRINTING_BACKEND_MOJOM_PRINT_BACKEND_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "printing/backend/mojom/print_backend.mojom-shared-internal.h"
#include "printing/mojom/print.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace printing::mojom {
class PrinterBasicInfoDataView;

class PaperDataView;

class MediaTypeDataView;

class PrinterSemanticCapsAndDefaultsDataView;



}  // printing::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::printing::mojom::PrinterBasicInfoDataView> {
  using Data = ::printing::mojom::internal::PrinterBasicInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::PaperDataView> {
  using Data = ::printing::mojom::internal::Paper_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::MediaTypeDataView> {
  using Data = ::printing::mojom::internal::MediaType_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::PrinterSemanticCapsAndDefaultsDataView> {
  using Data = ::printing::mojom::internal::PrinterSemanticCapsAndDefaults_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace printing::mojom {


class PrinterBasicInfoDataView {
 public:
  PrinterBasicInfoDataView() = default;

  PrinterBasicInfoDataView(
      internal::PrinterBasicInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPrinterNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrinterName(UserType* output) {
    
    auto* pointer = data_->printer_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDisplayNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayName(UserType* output) {
    
    auto* pointer = data_->display_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPrinterDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrinterDescription(UserType* output) {
    
    auto* pointer = data_->printer_description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetOptionsDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptions(UserType* output) {
    
    auto* pointer = data_->options.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::PrinterBasicInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaperDataView {
 public:
  PaperDataView() = default;

  PaperDataView(
      internal::Paper_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDisplayNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayName(UserType* output) {
    
    auto* pointer = data_->display_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetVendorIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVendorId(UserType* output) {
    
    auto* pointer = data_->vendor_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSizeUmDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSizeUm(UserType* output) {
    
    auto* pointer = data_->size_um.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetPrintableAreaUmDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrintableAreaUm(UserType* output) {
    
    auto* pointer = data_->printable_area_um.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  int32_t max_height_um() const {
    return data_->max_height_um;
  }
  bool has_borderless_variant() const {
    return data_->has_borderless_variant;
  }
 private:
  internal::Paper_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaTypeDataView {
 public:
  MediaTypeDataView() = default;

  MediaTypeDataView(
      internal::MediaType_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDisplayNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayName(UserType* output) {
    
    auto* pointer = data_->display_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetVendorIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVendorId(UserType* output) {
    
    auto* pointer = data_->vendor_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaType_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PrinterSemanticCapsAndDefaultsDataView {
 public:
  PrinterSemanticCapsAndDefaultsDataView() = default;

  PrinterSemanticCapsAndDefaultsDataView(
      internal::PrinterSemanticCapsAndDefaults_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool collate_capable() const {
    return data_->collate_capable;
  }
  bool collate_default() const {
    return data_->collate_default;
  }
  int32_t copies_max() const {
    return data_->copies_max;
  }
  inline void GetDuplexModesDataView(
      mojo::ArrayDataView<::printing::mojom::DuplexMode>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDuplexModes(UserType* output) {
    
    auto* pointer = data_->duplex_modes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::printing::mojom::DuplexMode>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDuplexDefault(UserType* output) const {
    auto data_value = data_->duplex_default;
    return mojo::internal::Deserialize<::printing::mojom::DuplexMode>(
        data_value, output);
  }
  ::printing::mojom::DuplexMode duplex_default() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::DuplexMode>(data_->duplex_default));
  }
  bool color_changeable() const {
    return data_->color_changeable;
  }
  bool color_default() const {
    return data_->color_default;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadColorModel(UserType* output) const {
    auto data_value = data_->color_model;
    return mojo::internal::Deserialize<::printing::mojom::ColorModel>(
        data_value, output);
  }
  ::printing::mojom::ColorModel color_model() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::ColorModel>(data_->color_model));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadBwModel(UserType* output) const {
    auto data_value = data_->bw_model;
    return mojo::internal::Deserialize<::printing::mojom::ColorModel>(
        data_value, output);
  }
  ::printing::mojom::ColorModel bw_model() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::ColorModel>(data_->bw_model));
  }
  inline void GetPapersDataView(
      mojo::ArrayDataView<PaperDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPapers(UserType* output) {
    
    auto* pointer = data_->papers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::printing::mojom::PaperDataView>>(
        pointer, output, message_);
  }
  inline void GetUserDefinedPapersDataView(
      mojo::ArrayDataView<PaperDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserDefinedPapers(UserType* output) {
    
    auto* pointer = data_->user_defined_papers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::printing::mojom::PaperDataView>>(
        pointer, output, message_);
  }
  inline void GetDefaultPaperDataView(
      PaperDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDefaultPaper(UserType* output) {
    
    auto* pointer = data_->default_paper.Get();
    return mojo::internal::Deserialize<::printing::mojom::PaperDataView>(
        pointer, output, message_);
  }
  inline void GetDpisDataView(
      mojo::ArrayDataView<::gfx::mojom::SizeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDpis(UserType* output) {
    
    auto* pointer = data_->dpis.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
        pointer, output, message_);
  }
  inline void GetDefaultDpiDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDefaultDpi(UserType* output) {
    
    auto* pointer = data_->default_dpi.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetMediaTypesDataView(
      mojo::ArrayDataView<MediaTypeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaTypes(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::printing::mojom::MediaTypeDataView>, UserType>(),
    "Attempting to read the optional `media_types` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMediaTypes` instead "
    "of `ReadMediaTypes if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->media_types.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::printing::mojom::MediaTypeDataView>>(
        pointer, output, message_);
  }
  inline void GetDefaultMediaTypeDataView(
      MediaTypeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDefaultMediaType(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::printing::mojom::MediaTypeDataView, UserType>(),
    "Attempting to read the optional `default_media_type` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDefaultMediaType` instead "
    "of `ReadDefaultMediaType if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->default_media_type.Get();
    return mojo::internal::Deserialize<::printing::mojom::MediaTypeDataView>(
        pointer, output, message_);
  }
 private:
  internal::PrinterSemanticCapsAndDefaults_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // printing::mojom

#endif  // PRINTING_BACKEND_MOJOM_PRINT_BACKEND_MOJOM_DATA_VIEW_H_