// pdf/mojom/pdf.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef PDF_MOJOM_PDF_MOJOM_TEST_UTILS_H_
#define PDF_MOJOM_PDF_MOJOM_TEST_UTILS_H_

#include "pdf/mojom/pdf.mojom.h"


namespace pdf::mojom {


class  SaveDataBufferHandlerInterceptorForTesting : public SaveDataBufferHandler {
  virtual SaveDataBufferHandler* GetForwardingInterface() = 0;
  void Read(uint32_t offset, uint32_t block_size, ReadCallback callback) override;
};
class  SaveDataBufferHandlerAsyncWaiter {
 public:
  explicit SaveDataBufferHandlerAsyncWaiter(SaveDataBufferHandler* proxy);

  SaveDataBufferHandlerAsyncWaiter(const SaveDataBufferHandlerAsyncWaiter&) = delete;
  SaveDataBufferHandlerAsyncWaiter& operator=(const SaveDataBufferHandlerAsyncWaiter&) = delete;

  ~SaveDataBufferHandlerAsyncWaiter();
  void Read(
      uint32_t offset, uint32_t block_size, ::mojo_base::BigBuffer* out_block);
  ::mojo_base::BigBuffer Read(uint32_t offset, uint32_t block_size);

 private:
  SaveDataBufferHandler* const proxy_;
};


class  PdfListenerInterceptorForTesting : public PdfListener {
  virtual PdfListener* GetForwardingInterface() = 0;
  void SetCaretPosition(const ::gfx::PointF& position) override;
  void MoveRangeSelectionExtent(const ::gfx::PointF& extent) override;
  void SetSelectionBounds(const ::gfx::PointF& base, const ::gfx::PointF& extent) override;
  void GetPdfBytes(uint32_t size_limit, GetPdfBytesCallback callback) override;
  void GetPageText(int32_t page_index, GetPageTextCallback callback) override;
  void GetMostVisiblePageIndex(GetMostVisiblePageIndexCallback callback) override;
  void GetSaveDataBufferHandlerForDrive(SaveRequestType request_type, GetSaveDataBufferHandlerForDriveCallback callback) override;
};
class  PdfListenerAsyncWaiter {
 public:
  explicit PdfListenerAsyncWaiter(PdfListener* proxy);

  PdfListenerAsyncWaiter(const PdfListenerAsyncWaiter&) = delete;
  PdfListenerAsyncWaiter& operator=(const PdfListenerAsyncWaiter&) = delete;

  ~PdfListenerAsyncWaiter();
  void GetPdfBytes(
      uint32_t size_limit, PdfListener::GetPdfBytesStatus* out_status, std::vector<uint8_t>* out_bytes, uint32_t* out_page_count);
  
  void GetPageText(
      int32_t page_index, ::std::u16string* out_text);
  ::std::u16string GetPageText(int32_t page_index);
  void GetMostVisiblePageIndex(
      std::optional<uint32_t>* out_page_index);
  std::optional<uint32_t> GetMostVisiblePageIndex();
  void GetSaveDataBufferHandlerForDrive(
      SaveRequestType request_type, SaveDataBufferHandlerGetResultPtr* out_result);
  SaveDataBufferHandlerGetResultPtr GetSaveDataBufferHandlerForDrive(SaveRequestType request_type);

 private:
  PdfListener* const proxy_;
};


class  PdfHostInterceptorForTesting : public PdfHost {
  virtual PdfHost* GetForwardingInterface() = 0;
  void SetListener(::mojo::PendingRemote<PdfListener> client) override;
  void OnDocumentLoadComplete() override;
  void UpdateContentRestrictions(int32_t restrictions) override;
  void SaveUrlAs(const ::GURL& url, ::network::mojom::ReferrerPolicy policy) override;
  void SelectionChanged(const ::gfx::PointF& left, int32_t left_height, const ::gfx::PointF& right, int32_t right_height) override;
  void SetPluginCanSave(bool can_save) override;
  void OnSearchifyStarted() override;
};
class  PdfHostAsyncWaiter {
 public:
  explicit PdfHostAsyncWaiter(PdfHost* proxy);

  PdfHostAsyncWaiter(const PdfHostAsyncWaiter&) = delete;
  PdfHostAsyncWaiter& operator=(const PdfHostAsyncWaiter&) = delete;

  ~PdfHostAsyncWaiter();

 private:
  PdfHost* const proxy_;
};




}  // pdf::mojom

#endif  // PDF_MOJOM_PDF_MOJOM_TEST_UTILS_H_