// owl/mojom/window_bridge.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_WINDOW_BRIDGE_MOJOM_H_
#define OWL_MOJOM_WINDOW_BRIDGE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/window_bridge.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/window_bridge.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/window_bridge.mojom-forward.h"  // IWYU pragma: export
#include "ui/events/mojom/event.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class WindowBridgeHostProxy;

template <typename ImplRefTraits>
class WindowBridgeHostStub;

class WindowBridgeHostRequestValidator;


class WindowBridgeHost
    : public WindowBridgeHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.WindowBridgeHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WindowBridgeHostInterfaceBase;
  using Proxy_ = WindowBridgeHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = WindowBridgeHostStub<ImplRefTraits>;

  using RequestValidator_ = WindowBridgeHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnMouseEventMinVersion = 0,
    kOnScrollEventMinVersion = 0,
    kOnKeyEventMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnMouseEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnScrollEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnKeyEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WindowBridgeHost() = default;

  virtual void OnMouseEvent(::std::unique_ptr<::ui::Event> event) = 0;

  virtual void OnScrollEvent(::std::unique_ptr<::ui::Event> event) = 0;

  virtual void OnKeyEvent(::std::unique_ptr<::ui::Event> event) = 0;
};

class WindowBridgeHostClientProxy;

template <typename ImplRefTraits>
class WindowBridgeHostClientStub;

class WindowBridgeHostClientRequestValidator;


class WindowBridgeHostClient
    : public WindowBridgeHostClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.WindowBridgeHostClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WindowBridgeHostClientInterfaceBase;
  using Proxy_ = WindowBridgeHostClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = WindowBridgeHostClientStub<ImplRefTraits>;

  using RequestValidator_ = WindowBridgeHostClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetSurfaceHandleMinVersion = 0,
    kCloseWindowMinVersion = 0,
    kSetWindowBoundsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetSurfaceHandle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseWindow_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetWindowBounds_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WindowBridgeHostClient() = default;

  virtual void SetSurfaceHandle(::mojo::PlatformHandle surface) = 0;

  virtual void CloseWindow() = 0;

  virtual void SetWindowBounds(const ::gfx::Rect& bounds) = 0;
};



class  WindowBridgeHostProxy
    : public WindowBridgeHost {
 public:
  using InterfaceType = WindowBridgeHost;

  explicit WindowBridgeHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnMouseEvent(::std::unique_ptr<::ui::Event> event) final;
  
  void OnScrollEvent(::std::unique_ptr<::ui::Event> event) final;
  
  void OnKeyEvent(::std::unique_ptr<::ui::Event> event) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  WindowBridgeHostClientProxy
    : public WindowBridgeHostClient {
 public:
  using InterfaceType = WindowBridgeHostClient;

  explicit WindowBridgeHostClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetSurfaceHandle(::mojo::PlatformHandle surface) final;
  
  void CloseWindow() final;
  
  void SetWindowBounds(const ::gfx::Rect& bounds) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  WindowBridgeHostStubDispatch {
 public:
  static bool Accept(WindowBridgeHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WindowBridgeHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WindowBridgeHost>>
class WindowBridgeHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WindowBridgeHostStub() = default;
  ~WindowBridgeHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WindowBridgeHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WindowBridgeHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WindowBridgeHostClientStubDispatch {
 public:
  static bool Accept(WindowBridgeHostClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WindowBridgeHostClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WindowBridgeHostClient>>
class WindowBridgeHostClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WindowBridgeHostClientStub() = default;
  ~WindowBridgeHostClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WindowBridgeHostClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WindowBridgeHostClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WindowBridgeHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WindowBridgeHostClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // owl::mojom

namespace mojo {

}  // namespace mojo

#endif  // OWL_MOJOM_WINDOW_BRIDGE_MOJOM_H_