// owl/mojom/window_bridge.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/window_bridge.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/window_bridge.mojom-params-data.h"
#include "owl/mojom/window_bridge.mojom-shared-message-ids.h"

#include "owl/mojom/window_bridge.mojom-import-headers.h"
#include "owl/mojom/window_bridge.mojom-test-utils.h"
#include "ui/events/mojom/event_mojom_traits.h"


namespace owl::mojom {
// The declaration includes the definition on other builds.

WindowBridgeHost::IPCStableHashFunction WindowBridgeHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WindowBridgeHost>(message.name())) {
    case messages::WindowBridgeHost::kOnMouseEvent: {
      return &WindowBridgeHost::OnMouseEvent_Sym::IPCStableHash;
    }
    case messages::WindowBridgeHost::kOnScrollEvent: {
      return &WindowBridgeHost::OnScrollEvent_Sym::IPCStableHash;
    }
    case messages::WindowBridgeHost::kOnKeyEvent: {
      return &WindowBridgeHost::OnKeyEvent_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WindowBridgeHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WindowBridgeHost>(message.name())) {
      case messages::WindowBridgeHost::kOnMouseEvent:
            return "Receive owl::mojom::WindowBridgeHost::OnMouseEvent";
      case messages::WindowBridgeHost::kOnScrollEvent:
            return "Receive owl::mojom::WindowBridgeHost::OnScrollEvent";
      case messages::WindowBridgeHost::kOnKeyEvent:
            return "Receive owl::mojom::WindowBridgeHost::OnKeyEvent";
    }
  } else {
    switch (static_cast<messages::WindowBridgeHost>(message.name())) {
      case messages::WindowBridgeHost::kOnMouseEvent:
            return "Receive reply owl::mojom::WindowBridgeHost::OnMouseEvent";
      case messages::WindowBridgeHost::kOnScrollEvent:
            return "Receive reply owl::mojom::WindowBridgeHost::OnScrollEvent";
      case messages::WindowBridgeHost::kOnKeyEvent:
            return "Receive reply owl::mojom::WindowBridgeHost::OnKeyEvent";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WindowBridgeHost::OnMouseEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xed03d71c;  // IPCStableHash for owl::mojom::WindowBridgeHost::OnMouseEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WindowBridgeHost::OnScrollEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2c1aa359;  // IPCStableHash for owl::mojom::WindowBridgeHost::OnScrollEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WindowBridgeHost::OnKeyEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3fcc50a8;  // IPCStableHash for owl::mojom::WindowBridgeHost::OnKeyEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WindowBridgeHostProxy::WindowBridgeHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WindowBridgeHostProxy::OnMouseEvent(
    ::std::unique_ptr<::ui::Event> in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WindowBridgeHost::OnMouseEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::ui::Event>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WindowBridgeHost::kOnMouseEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WindowBridgeHost_OnMouseEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::ui::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in WindowBridgeHost.OnMouseEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WindowBridgeHost::Name_);
  message.set_method_name("OnMouseEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WindowBridgeHostProxy::OnScrollEvent(
    ::std::unique_ptr<::ui::Event> in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WindowBridgeHost::OnScrollEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::ui::Event>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WindowBridgeHost::kOnScrollEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WindowBridgeHost_OnScrollEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::ui::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in WindowBridgeHost.OnScrollEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WindowBridgeHost::Name_);
  message.set_method_name("OnScrollEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WindowBridgeHostProxy::OnKeyEvent(
    ::std::unique_ptr<::ui::Event> in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WindowBridgeHost::OnKeyEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::ui::Event>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WindowBridgeHost::kOnKeyEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WindowBridgeHost_OnKeyEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::ui::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in WindowBridgeHost.OnKeyEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WindowBridgeHost::Name_);
  message.set_method_name("OnKeyEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WindowBridgeHostStubDispatch::Accept(
    WindowBridgeHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WindowBridgeHost>(message->header()->name)) {
    case messages::WindowBridgeHost::kOnMouseEvent: {
      DCHECK(message->is_serialized());
      internal::WindowBridgeHost_OnMouseEvent_Params_Data* params =
          reinterpret_cast<internal::WindowBridgeHost_OnMouseEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WindowBridgeHost.0
      bool success = true;
      ::std::unique_ptr<::ui::Event> p_event{};
      WindowBridgeHost_OnMouseEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WindowBridgeHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMouseEvent(        
        std::move(p_event));
      return true;
    }
    case messages::WindowBridgeHost::kOnScrollEvent: {
      DCHECK(message->is_serialized());
      internal::WindowBridgeHost_OnScrollEvent_Params_Data* params =
          reinterpret_cast<internal::WindowBridgeHost_OnScrollEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WindowBridgeHost.1
      bool success = true;
      ::std::unique_ptr<::ui::Event> p_event{};
      WindowBridgeHost_OnScrollEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WindowBridgeHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnScrollEvent(        
        std::move(p_event));
      return true;
    }
    case messages::WindowBridgeHost::kOnKeyEvent: {
      DCHECK(message->is_serialized());
      internal::WindowBridgeHost_OnKeyEvent_Params_Data* params =
          reinterpret_cast<internal::WindowBridgeHost_OnKeyEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WindowBridgeHost.2
      bool success = true;
      ::std::unique_ptr<::ui::Event> p_event{};
      WindowBridgeHost_OnKeyEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WindowBridgeHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnKeyEvent(        
        std::move(p_event));
      return true;
    }
  }
  return false;
}

// static
bool WindowBridgeHostStubDispatch::AcceptWithResponder(
    WindowBridgeHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WindowBridgeHost>(message->header()->name)) {
    case messages::WindowBridgeHost::kOnMouseEvent: {
      break;
    }
    case messages::WindowBridgeHost::kOnScrollEvent: {
      break;
    }
    case messages::WindowBridgeHost::kOnKeyEvent: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWindowBridgeHostValidationInfo[] = {
    { &internal::WindowBridgeHost_OnMouseEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WindowBridgeHost_OnScrollEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WindowBridgeHost_OnKeyEvent_Params_Data::Validate,
     nullptr /* no response */},
};

bool WindowBridgeHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::WindowBridgeHost::Name_,
    kWindowBridgeHostValidationInfo);
}

// The declaration includes the definition on other builds.

WindowBridgeHostClient::IPCStableHashFunction WindowBridgeHostClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WindowBridgeHostClient>(message.name())) {
    case messages::WindowBridgeHostClient::kSetSurfaceHandle: {
      return &WindowBridgeHostClient::SetSurfaceHandle_Sym::IPCStableHash;
    }
    case messages::WindowBridgeHostClient::kCloseWindow: {
      return &WindowBridgeHostClient::CloseWindow_Sym::IPCStableHash;
    }
    case messages::WindowBridgeHostClient::kSetWindowBounds: {
      return &WindowBridgeHostClient::SetWindowBounds_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WindowBridgeHostClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WindowBridgeHostClient>(message.name())) {
      case messages::WindowBridgeHostClient::kSetSurfaceHandle:
            return "Receive owl::mojom::WindowBridgeHostClient::SetSurfaceHandle";
      case messages::WindowBridgeHostClient::kCloseWindow:
            return "Receive owl::mojom::WindowBridgeHostClient::CloseWindow";
      case messages::WindowBridgeHostClient::kSetWindowBounds:
            return "Receive owl::mojom::WindowBridgeHostClient::SetWindowBounds";
    }
  } else {
    switch (static_cast<messages::WindowBridgeHostClient>(message.name())) {
      case messages::WindowBridgeHostClient::kSetSurfaceHandle:
            return "Receive reply owl::mojom::WindowBridgeHostClient::SetSurfaceHandle";
      case messages::WindowBridgeHostClient::kCloseWindow:
            return "Receive reply owl::mojom::WindowBridgeHostClient::CloseWindow";
      case messages::WindowBridgeHostClient::kSetWindowBounds:
            return "Receive reply owl::mojom::WindowBridgeHostClient::SetWindowBounds";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WindowBridgeHostClient::SetSurfaceHandle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x57503229;  // IPCStableHash for owl::mojom::WindowBridgeHostClient::SetSurfaceHandle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WindowBridgeHostClient::CloseWindow_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd98f36e8;  // IPCStableHash for owl::mojom::WindowBridgeHostClient::CloseWindow
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WindowBridgeHostClient::SetWindowBounds_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd74e346a;  // IPCStableHash for owl::mojom::WindowBridgeHostClient::SetWindowBounds
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WindowBridgeHostClientProxy::WindowBridgeHostClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WindowBridgeHostClientProxy::SetSurfaceHandle(
    ::mojo::PlatformHandle in_surface) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WindowBridgeHostClient::SetSurfaceHandle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("surface"), in_surface,
                        "<value of type ::mojo::PlatformHandle>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WindowBridgeHostClient::kSetSurfaceHandle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WindowBridgeHostClient_SetSurfaceHandle_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::PlatformHandle>(
    in_surface,
    &params->surface,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->surface)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid surface in WindowBridgeHostClient.SetSurfaceHandle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WindowBridgeHostClient::Name_);
  message.set_method_name("SetSurfaceHandle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WindowBridgeHostClientProxy::CloseWindow(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WindowBridgeHostClient::CloseWindow");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WindowBridgeHostClient::kCloseWindow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WindowBridgeHostClient_CloseWindow_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WindowBridgeHostClient::Name_);
  message.set_method_name("CloseWindow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WindowBridgeHostClientProxy::SetWindowBounds(
    const ::gfx::Rect& in_bounds) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WindowBridgeHostClient::SetWindowBounds", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds"), in_bounds,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WindowBridgeHostClient::kSetWindowBounds), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WindowBridgeHostClient_SetWindowBounds_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bounds)::BaseType> bounds_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_bounds,
    bounds_fragment);

  params->bounds.Set(
      bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bounds.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bounds in WindowBridgeHostClient.SetWindowBounds request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WindowBridgeHostClient::Name_);
  message.set_method_name("SetWindowBounds");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WindowBridgeHostClientStubDispatch::Accept(
    WindowBridgeHostClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WindowBridgeHostClient>(message->header()->name)) {
    case messages::WindowBridgeHostClient::kSetSurfaceHandle: {
      DCHECK(message->is_serialized());
      internal::WindowBridgeHostClient_SetSurfaceHandle_Params_Data* params =
          reinterpret_cast<internal::WindowBridgeHostClient_SetSurfaceHandle_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WindowBridgeHostClient.0
      bool success = true;
      ::mojo::PlatformHandle p_surface{};
      WindowBridgeHostClient_SetSurfaceHandle_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_surface = input_data_view.TakeSurface();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WindowBridgeHostClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSurfaceHandle(        
        std::move(p_surface));
      return true;
    }
    case messages::WindowBridgeHostClient::kCloseWindow: {
      DCHECK(message->is_serialized());
      internal::WindowBridgeHostClient_CloseWindow_Params_Data* params =
          reinterpret_cast<internal::WindowBridgeHostClient_CloseWindow_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WindowBridgeHostClient.1
      bool success = true;
      WindowBridgeHostClient_CloseWindow_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WindowBridgeHostClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseWindow(        );
      return true;
    }
    case messages::WindowBridgeHostClient::kSetWindowBounds: {
      DCHECK(message->is_serialized());
      internal::WindowBridgeHostClient_SetWindowBounds_Params_Data* params =
          reinterpret_cast<internal::WindowBridgeHostClient_SetWindowBounds_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WindowBridgeHostClient.2
      bool success = true;
      ::gfx::Rect p_bounds{};
      WindowBridgeHostClient_SetWindowBounds_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBounds(&p_bounds))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WindowBridgeHostClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWindowBounds(        
        std::move(p_bounds));
      return true;
    }
  }
  return false;
}

// static
bool WindowBridgeHostClientStubDispatch::AcceptWithResponder(
    WindowBridgeHostClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WindowBridgeHostClient>(message->header()->name)) {
    case messages::WindowBridgeHostClient::kSetSurfaceHandle: {
      break;
    }
    case messages::WindowBridgeHostClient::kCloseWindow: {
      break;
    }
    case messages::WindowBridgeHostClient::kSetWindowBounds: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWindowBridgeHostClientValidationInfo[] = {
    { &internal::WindowBridgeHostClient_SetSurfaceHandle_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WindowBridgeHostClient_CloseWindow_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WindowBridgeHostClient_SetWindowBounds_Params_Data::Validate,
     nullptr /* no response */},
};

bool WindowBridgeHostClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::WindowBridgeHostClient::Name_,
    kWindowBridgeHostClientValidationInfo);
}



}  // owl::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void WindowBridgeHostInterceptorForTesting::OnMouseEvent(::std::unique_ptr<::ui::Event> event) {
  GetForwardingInterface()->OnMouseEvent(
    std::move(event)
    );
}
void WindowBridgeHostInterceptorForTesting::OnScrollEvent(::std::unique_ptr<::ui::Event> event) {
  GetForwardingInterface()->OnScrollEvent(
    std::move(event)
    );
}
void WindowBridgeHostInterceptorForTesting::OnKeyEvent(::std::unique_ptr<::ui::Event> event) {
  GetForwardingInterface()->OnKeyEvent(
    std::move(event)
    );
}
WindowBridgeHostAsyncWaiter::WindowBridgeHostAsyncWaiter(
    WindowBridgeHost* proxy) : proxy_(proxy) {}

WindowBridgeHostAsyncWaiter::~WindowBridgeHostAsyncWaiter() = default;





void WindowBridgeHostClientInterceptorForTesting::SetSurfaceHandle(::mojo::PlatformHandle surface) {
  GetForwardingInterface()->SetSurfaceHandle(
    std::move(surface)
    );
}
void WindowBridgeHostClientInterceptorForTesting::CloseWindow() {
  GetForwardingInterface()->CloseWindow();
}
void WindowBridgeHostClientInterceptorForTesting::SetWindowBounds(const ::gfx::Rect& bounds) {
  GetForwardingInterface()->SetWindowBounds(
    std::move(bounds)
    );
}
WindowBridgeHostClientAsyncWaiter::WindowBridgeHostClientAsyncWaiter(
    WindowBridgeHostClient* proxy) : proxy_(proxy) {}

WindowBridgeHostClientAsyncWaiter::~WindowBridgeHostClientAsyncWaiter() = default;







}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif