// owl/mojom/web_view_group.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_WEB_VIEW_GROUP_MOJOM_DATA_VIEW_H_
#define OWL_MOJOM_WEB_VIEW_GROUP_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "owl/mojom/web_view_group.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "owl/mojom/web_view.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace owl::mojom {
class CreateWebViewInitializationData_InitialDataDataView;

class CreateWebViewInitializationData_RestoreDataDataView;

class CreateWebViewParamsDataView;

class CreatedWebViewDetailsDataView;

class CreateWebViewInitializationDataDataView;
class CreateWebViewResultDataView;


}  // owl::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::owl::mojom::CreateWebViewInitializationData_InitialDataDataView> {
  using Data = ::owl::mojom::internal::CreateWebViewInitializationData_InitialData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::CreateWebViewInitializationData_RestoreDataDataView> {
  using Data = ::owl::mojom::internal::CreateWebViewInitializationData_RestoreData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::CreateWebViewParamsDataView> {
  using Data = ::owl::mojom::internal::CreateWebViewParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::CreatedWebViewDetailsDataView> {
  using Data = ::owl::mojom::internal::CreatedWebViewDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::CreateWebViewInitializationDataDataView> {
  using Data = ::owl::mojom::internal::CreateWebViewInitializationData_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::owl::mojom::CreateWebViewResultDataView> {
  using Data = ::owl::mojom::internal::CreateWebViewResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace owl::mojom {


enum class GroupScopedWebViewSource : int32_t {
  
  kNewTab = 0,
  
  kDevTools = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, GroupScopedWebViewSource value);
inline bool IsKnownEnumValue(GroupScopedWebViewSource value) {
  return internal::GroupScopedWebViewSource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class NavigationValidationResult : int32_t {
  
  kAllow = 0,
  
  kDeny = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, NavigationValidationResult value);
inline bool IsKnownEnumValue(NavigationValidationResult value) {
  return internal::NavigationValidationResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class WebViewGroupInterfaceBase {};

using WebViewGroupPtrDataView =
    mojo::InterfacePtrDataView<WebViewGroupInterfaceBase>;
using WebViewGroupRequestDataView =
    mojo::InterfaceRequestDataView<WebViewGroupInterfaceBase>;
using WebViewGroupAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebViewGroupInterfaceBase>;
using WebViewGroupAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebViewGroupInterfaceBase>;
class WebViewGroupClientInterfaceBase {};

using WebViewGroupClientPtrDataView =
    mojo::InterfacePtrDataView<WebViewGroupClientInterfaceBase>;
using WebViewGroupClientRequestDataView =
    mojo::InterfaceRequestDataView<WebViewGroupClientInterfaceBase>;
using WebViewGroupClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebViewGroupClientInterfaceBase>;
using WebViewGroupClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebViewGroupClientInterfaceBase>;


class CreateWebViewInitializationData_InitialDataDataView {
 public:
  CreateWebViewInitializationData_InitialDataDataView() = default;

  CreateWebViewInitializationData_InitialDataDataView(
      internal::CreateWebViewInitializationData_InitialData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadNavigationType(UserType* output) const {
    auto data_value = data_->navigation_type;
    return mojo::internal::Deserialize<::owl::mojom::NavigationType>(
        data_value, output);
  }
  ::owl::mojom::NavigationType navigation_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::owl::mojom::NavigationType>(data_->navigation_type));
  }
  inline void GetAdditionalHeadersDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdditionalHeaders(UserType* output) {
    
    auto* pointer = data_->additional_headers.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::CreateWebViewInitializationData_InitialData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateWebViewInitializationData_RestoreDataDataView {
 public:
  CreateWebViewInitializationData_RestoreDataDataView() = default;

  CreateWebViewInitializationData_RestoreDataDataView(
      internal::CreateWebViewInitializationData_RestoreData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSessionDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionData(UserType* output) {
    
    auto* pointer = data_->session_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  std::optional<int32_t> navigation_index_override() const {

    return data_->navigation_index_override_$flag
        ? std::make_optional(data_->navigation_index_override_$value)
        : std::nullopt;
  }
 private:
  internal::CreateWebViewInitializationData_RestoreData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateWebViewParamsDataView {
 public:
  CreateWebViewParamsDataView() = default;

  CreateWebViewParamsDataView(
      internal::CreateWebViewParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool foreground() const {
    return data_->foreground;
  }
  inline void GetInitializationDataDataView(
      CreateWebViewInitializationDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitializationData(UserType* output) {
    
    auto* pointer = !data_->initialization_data.is_null() ? &data_->initialization_data : nullptr;
    return mojo::internal::Deserialize<::owl::mojom::CreateWebViewInitializationDataDataView>(
        pointer, output, message_);
  }
  inline void GetInitialStoragePartitionDataView(
      ::owl::mojom::StoragePartitionDescriptorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitialStoragePartition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::owl::mojom::StoragePartitionDescriptorDataView, UserType>(),
    "Attempting to read the optional `initial_storage_partition` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitialStoragePartition` instead "
    "of `ReadInitialStoragePartition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initial_storage_partition.Get();
    return mojo::internal::Deserialize<::owl::mojom::StoragePartitionDescriptorDataView>(
        pointer, output, message_);
  }
 private:
  internal::CreateWebViewParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreatedWebViewDetailsDataView {
 public:
  CreatedWebViewDetailsDataView() = default;

  CreatedWebViewDetailsDataView(
      internal::CreatedWebViewDetails_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t web_content_id() const {
    return data_->web_content_id;
  }
 private:
  internal::CreatedWebViewDetails_Data* data_ = nullptr;
};


class CreateWebViewInitializationDataDataView {
 public:
  using Tag = internal::CreateWebViewInitializationData_Data::CreateWebViewInitializationData_Tag;

  CreateWebViewInitializationDataDataView() = default;

  CreateWebViewInitializationDataDataView(
      internal::CreateWebViewInitializationData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_initial_data() const { return data_->tag == Tag::kInitialData; }
  inline void GetInitialDataDataView(
      CreateWebViewInitializationData_InitialDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadInitialData(UserType* output) const {
    
    CHECK(is_initial_data());
    return mojo::internal::Deserialize<::owl::mojom::CreateWebViewInitializationData_InitialDataDataView>(
        data_->data.f_initial_data.Get(), output, message_);
  }
  bool is_restore_data() const { return data_->tag == Tag::kRestoreData; }
  inline void GetRestoreDataDataView(
      CreateWebViewInitializationData_RestoreDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRestoreData(UserType* output) const {
    
    CHECK(is_restore_data());
    return mojo::internal::Deserialize<::owl::mojom::CreateWebViewInitializationData_RestoreDataDataView>(
        data_->data.f_restore_data.Get(), output, message_);
  }

 private:
  internal::CreateWebViewInitializationData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class CreateWebViewResultDataView {
 public:
  using Tag = internal::CreateWebViewResult_Data::CreateWebViewResult_Tag;

  CreateWebViewResultDataView() = default;

  CreateWebViewResultDataView(
      internal::CreateWebViewResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  inline void GetFailureDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    
    CHECK(is_failure());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_failure.Get(), output, message_);
  }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      CreatedWebViewDetailsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::owl::mojom::CreatedWebViewDetailsDataView>(
        data_->data.f_success.Get(), output, message_);
  }

 private:
  internal::CreateWebViewResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // owl::mojom

#endif  // OWL_MOJOM_WEB_VIEW_GROUP_MOJOM_DATA_VIEW_H_