// owl/mojom/web_view.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_WEB_VIEW_MOJOM_SEND_VALIDATION_H_
#define OWL_MOJOM_WEB_VIEW_MOJOM_SEND_VALIDATION_H_

#include "owl/mojom/web_view.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "owl/mojom/address_prompt.mojom-shared.h"
#include "owl/mojom/autofill_popup.mojom-shared.h"
#include "owl/mojom/card_prompt.mojom-shared.h"
#include "owl/mojom/chatgpt_frontend.mojom-shared.h"
#include "owl/mojom/context_menu_params.mojom-shared.h"
#include "owl/mojom/password_prompt.mojom-shared.h"
#include "owl/mojom/permission_prompt.mojom-shared.h"
#include "owl/mojom/web_view_container_view.mojom-shared.h"
#include "owl/mojom/window_bridge.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/fullscreen.mojom-shared.h"
#include "third_party/blink/public/mojom/input/input_event.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions/permission.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions/permission_status.mojom-shared.h"
#include "third_party/blink/public/mojom/picture_in_picture_window_options/picture_in_picture_window_options.mojom-shared.h"
#include "third_party/blink/public/mojom/window_features/window_features.mojom-shared.h"
#include "ui/base/mojom/window_open_disposition.mojom-shared.h"
#include "ui/events/mojom/event.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "components/remote_cocoa/common/application.mojom-shared.h"

#include "owl/mojom/web_view.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::DevToolsPanel, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::TabAlertState, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::TabNetworkState, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::NavigationType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::TransitionType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::SecurityLevel, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::ThumbnailScaleMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::ThumbnailAnchor, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::FindDirection, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::JavaScriptDialogType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::FileDialogType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::TabSharingButtonState, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::TabSharingTabRole, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::RepostFormWarningResponse, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::WindowBridgeSource, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::DevToolsDockSide, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::RenderProcessStatus, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::WebViewDiagnosticsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::WebViewDiagnosticsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::WebViewDiagnostics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->needs_reload = Traits::needs_reload(input);

      fragment->has_uncommitted_navigation_in_primary_main_frame = Traits::has_uncommitted_navigation_in_primary_main_frame(input);

      fragment->is_waiting_for_response = Traits::is_waiting_for_response(input);

      fragment->is_deferred = Traits::is_deferred(input);
      fragment->net_load_state_$flag = Traits::net_load_state(input).has_value();
      if (Traits::net_load_state(input).has_value()) {
        fragment->net_load_state_$value = Traits::net_load_state(input).value();
      }

      decltype(Traits::primary_main_frame_lifecycle(input)) in_primary_main_frame_lifecycle = Traits::primary_main_frame_lifecycle(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->primary_main_frame_lifecycle)::BaseType> primary_main_frame_lifecycle_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_primary_main_frame_lifecycle,
        primary_main_frame_lifecycle_fragment);

      fragment->primary_main_frame_lifecycle.Set(
          primary_main_frame_lifecycle_fragment.is_null() ? nullptr : primary_main_frame_lifecycle_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->primary_main_frame_lifecycle.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null primary_main_frame_lifecycle in WebViewDiagnostics struct");

      decltype(Traits::last_committed_url(input)) in_last_committed_url = Traits::last_committed_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_committed_url)::BaseType> last_committed_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_last_committed_url,
        last_committed_url_fragment);

      fragment->last_committed_url.Set(
          last_committed_url_fragment.is_null() ? nullptr : last_committed_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_committed_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_committed_url in WebViewDiagnostics struct");

      fragment->entry_count = Traits::entry_count(input);

      fragment->pending_entry_index = Traits::pending_entry_index(input);

      fragment->current_entry_index = Traits::current_entry_index(input);

      fragment->is_web_contents_visible = Traits::is_web_contents_visible(input);
      fragment->is_rwhv_visible_$flag = Traits::is_rwhv_visible(input).has_value();
      if (Traits::is_rwhv_visible(input).has_value()) {
        fragment->is_rwhv_visible_$value = Traits::is_rwhv_visible(input).value();
      }

      decltype(Traits::rwhv_size(input)) in_rwhv_size = Traits::rwhv_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->rwhv_size)::BaseType> rwhv_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_rwhv_size,
        rwhv_size_fragment);

      fragment->rwhv_size.Set(
          rwhv_size_fragment.is_null() ? nullptr : rwhv_size_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::FindResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::FindResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::FindResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->current_match_index = Traits::current_match_index(input);

      fragment->number_of_matches = Traits::number_of_matches(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::DOMElementReferenceDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::DOMElementReferenceDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::DOMElementReference_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->frame_routing_id = Traits::frame_routing_id(input);

      fragment->frame_process_id = Traits::frame_process_id(input);

      fragment->x = Traits::x(input);

      fragment->y = Traits::y(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::NavigationEntryDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::NavigationEntryDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::NavigationEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->unique_id = Traits::unique_id(input);

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in NavigationEntry struct");

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in NavigationEntry struct");

      decltype(Traits::favicon_url(input)) in_favicon_url = Traits::favicon_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->favicon_url)::BaseType> favicon_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_favicon_url,
        favicon_url_fragment);

      fragment->favicon_url.Set(
          favicon_url_fragment.is_null() ? nullptr : favicon_url_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::SerializedDomElementInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::SerializedDomElementInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::SerializedDomElementInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::tag(input)) in_tag = Traits::tag(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tag)::BaseType> tag_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_tag,
        tag_fragment);

      fragment->tag.Set(
          tag_fragment.is_null() ? nullptr : tag_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tag.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tag in SerializedDomElementInfo struct");

      decltype(Traits::selector(input)) in_selector = Traits::selector(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->selector)::BaseType> selector_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_selector,
        selector_fragment);

      fragment->selector.Set(
          selector_fragment.is_null() ? nullptr : selector_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->selector.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null selector in SerializedDomElementInfo struct");

      decltype(Traits::visible_bounds(input)) in_visible_bounds = Traits::visible_bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->visible_bounds)::BaseType> visible_bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_visible_bounds,
        visible_bounds_fragment);

      fragment->visible_bounds.Set(
          visible_bounds_fragment.is_null() ? nullptr : visible_bounds_fragment.data());

      decltype(Traits::click_point(input)) in_click_point = Traits::click_point(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->click_point)::BaseType> click_point_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointDataView, send_validation>(
        in_click_point,
        click_point_fragment);

      fragment->click_point.Set(
          click_point_fragment.is_null() ? nullptr : click_point_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::TabRendererDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::TabRendererDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::TabRendererData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->blocked = Traits::blocked(input);

      fragment->crashed = Traits::crashed(input);

      decltype(Traits::alert_states(input)) in_alert_states = Traits::alert_states(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->alert_states)::BaseType>
          alert_states_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& alert_states_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::owl::mojom::internal::TabAlertState_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::TabAlertState>, send_validation>(
        in_alert_states,
        alert_states_fragment,
        &alert_states_validate_params);

      fragment->alert_states.Set(
          alert_states_fragment.is_null() ? nullptr : alert_states_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->alert_states.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null alert_states in TabRendererData struct");

      decltype(Traits::favicon_image(input)) in_favicon_image = Traits::favicon_image(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->favicon_image)::BaseType> favicon_image_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::ImageSkiaDataView, send_validation>(
        in_favicon_image,
        favicon_image_fragment);

      fragment->favicon_image.Set(
          favicon_image_fragment.is_null() ? nullptr : favicon_image_fragment.data());

      
      mojo::internal::Serialize<::owl::mojom::TabNetworkState>(
        Traits::network_state(input),
        &fragment->network_state);

      fragment->should_hide_loading_throbber = Traits::should_hide_loading_throbber(input);

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in TabRendererData struct");

      decltype(Traits::last_committed_url(input)) in_last_committed_url = Traits::last_committed_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_committed_url)::BaseType> last_committed_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_last_committed_url,
        last_committed_url_fragment);

      fragment->last_committed_url.Set(
          last_committed_url_fragment.is_null() ? nullptr : last_committed_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_committed_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_committed_url in TabRendererData struct");

      decltype(Traits::visible_url(input)) in_visible_url = Traits::visible_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->visible_url)::BaseType> visible_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_visible_url,
        visible_url_fragment);

      fragment->visible_url.Set(
          visible_url_fragment.is_null() ? nullptr : visible_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->visible_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null visible_url in TabRendererData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::ClipboardOverrideDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::ClipboardOverrideDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::ClipboardOverride_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::text(input)) in_text = Traits::text(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text)::BaseType> text_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_text,
        text_fragment);

      fragment->text.Set(
          text_fragment.is_null() ? nullptr : text_fragment.data());

      decltype(Traits::html(input)) in_html = Traits::html(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->html)::BaseType> html_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_html,
        html_fragment);

      fragment->html.Set(
          html_fragment.is_null() ? nullptr : html_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::CertificateChainDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::CertificateChainDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::CertificateChain_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::der_chain(input)) in_der_chain = Traits::der_chain(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->der_chain)::BaseType>
          der_chain_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& der_chain_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>, send_validation>(
        in_der_chain,
        der_chain_fragment,
        &der_chain_validate_params);

      fragment->der_chain.Set(
          der_chain_fragment.is_null() ? nullptr : der_chain_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->der_chain.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null der_chain in CertificateChain struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::StoragePartitionDescriptorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::StoragePartitionDescriptorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::StoragePartitionDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::partition_domain(input)) in_partition_domain = Traits::partition_domain(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->partition_domain)::BaseType> partition_domain_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_partition_domain,
        partition_domain_fragment);

      fragment->partition_domain.Set(
          partition_domain_fragment.is_null() ? nullptr : partition_domain_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->partition_domain.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null partition_domain in StoragePartitionDescriptor struct");

      decltype(Traits::partition_name(input)) in_partition_name = Traits::partition_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->partition_name)::BaseType> partition_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_partition_name,
        partition_name_fragment);

      fragment->partition_name.Set(
          partition_name_fragment.is_null() ? nullptr : partition_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->partition_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null partition_name in StoragePartitionDescriptor struct");

      fragment->in_memory = Traits::in_memory(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::ThumbnailSnapshotOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::ThumbnailSnapshotOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::ThumbnailSnapshotOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->target_width_px = Traits::target_width_px(input);

      fragment->target_height_px = Traits::target_height_px(input);

      
      mojo::internal::Serialize<::owl::mojom::ThumbnailScaleMode>(
        Traits::scale_mode(input),
        &fragment->scale_mode);

      
      mojo::internal::Serialize<::owl::mojom::ThumbnailAnchor>(
        Traits::anchor(input),
        &fragment->anchor);

      fragment->allow_upscaling = Traits::allow_upscaling(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::PermissionStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::PermissionStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::PermissionState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::blink::mojom::PermissionName>(
        Traits::name(input),
        &fragment->name);

      
      mojo::internal::Serialize<::blink::mojom::PermissionStatus>(
        Traits::status(input),
        &fragment->status);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::FileDialogTypeInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::FileDialogTypeInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::FileDialogTypeInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::extensions(input)) in_extensions = Traits::extensions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->extensions)::BaseType>
          extensions_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& extensions_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<mojo::StringDataView>>, send_validation>(
        in_extensions,
        extensions_fragment,
        &extensions_validate_params);

      fragment->extensions.Set(
          extensions_fragment.is_null() ? nullptr : extensions_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->extensions.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null extensions in FileDialogTypeInfo struct");

      decltype(Traits::extension_description_overrides(input)) in_extension_description_overrides = Traits::extension_description_overrides(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->extension_description_overrides)::BaseType>
          extension_description_overrides_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& extension_description_overrides_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>, send_validation>(
        in_extension_description_overrides,
        extension_description_overrides_fragment,
        &extension_description_overrides_validate_params);

      fragment->extension_description_overrides.Set(
          extension_description_overrides_fragment.is_null() ? nullptr : extension_description_overrides_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->extension_description_overrides.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null extension_description_overrides in FileDialogTypeInfo struct");

      fragment->include_all_files = Traits::include_all_files(input);

      fragment->keep_extension_visible = Traits::keep_extension_visible(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::FileDialogParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::FileDialogParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::FileDialogParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::owl::mojom::FileDialogType>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in FileDialogParams struct");

      decltype(Traits::default_path(input)) in_default_path = Traits::default_path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->default_path)::BaseType> default_path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_default_path,
        default_path_fragment);

      fragment->default_path.Set(
          default_path_fragment.is_null() ? nullptr : default_path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->default_path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null default_path in FileDialogParams struct");

      decltype(Traits::file_types(input)) in_file_types = Traits::file_types(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->file_types)::BaseType> file_types_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::owl::mojom::FileDialogTypeInfoDataView, send_validation>(
        in_file_types,
        file_types_fragment);

      fragment->file_types.Set(
          file_types_fragment.is_null() ? nullptr : file_types_fragment.data());

      fragment->file_type_index = Traits::file_type_index(input);

      decltype(Traits::default_extension(input)) in_default_extension = Traits::default_extension(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->default_extension)::BaseType> default_extension_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_default_extension,
        default_extension_fragment);

      fragment->default_extension.Set(
          default_extension_fragment.is_null() ? nullptr : default_extension_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->default_extension.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null default_extension in FileDialogParams struct");

      decltype(Traits::caller(input)) in_caller = Traits::caller(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->caller)::BaseType> caller_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_caller,
        caller_fragment);

      fragment->caller.Set(
          caller_fragment.is_null() ? nullptr : caller_fragment.data());

      decltype(Traits::file_type_label(input)) in_file_type_label = Traits::file_type_label(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->file_type_label)::BaseType> file_type_label_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_file_type_label,
        file_type_label_fragment);

      fragment->file_type_label.Set(
          file_type_label_fragment.is_null() ? nullptr : file_type_label_fragment.data());

      decltype(Traits::all_files_label(input)) in_all_files_label = Traits::all_files_label(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->all_files_label)::BaseType> all_files_label_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_all_files_label,
        all_files_label_fragment);

      fragment->all_files_label.Set(
          all_files_label_fragment.is_null() ? nullptr : all_files_label_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::FileDialogResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::FileDialogResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::FileDialogResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->was_cancelled = Traits::was_cancelled(input);

      decltype(Traits::files(input)) in_files = Traits::files(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->files)::BaseType>
          files_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& files_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>, send_validation>(
        in_files,
        files_fragment,
        &files_validate_params);

      fragment->files.Set(
          files_fragment.is_null() ? nullptr : files_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->files.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null files in FileDialogResult struct");

      fragment->index = Traits::index(input);

      decltype(Traits::file_tags(input)) in_file_tags = Traits::file_tags(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->file_tags)::BaseType>
          file_tags_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& file_tags_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_file_tags,
        file_tags_fragment,
        &file_tags_validate_params);

      fragment->file_tags.Set(
          file_tags_fragment.is_null() ? nullptr : file_tags_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->file_tags.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null file_tags in FileDialogResult struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::ClientCertMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::ClientCertMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::ClientCertMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::subject(input)) in_subject = Traits::subject(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->subject)::BaseType> subject_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_subject,
        subject_fragment);

      fragment->subject.Set(
          subject_fragment.is_null() ? nullptr : subject_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->subject.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subject in ClientCertMetadata struct");

      decltype(Traits::issuer(input)) in_issuer = Traits::issuer(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->issuer)::BaseType> issuer_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_issuer,
        issuer_fragment);

      fragment->issuer.Set(
          issuer_fragment.is_null() ? nullptr : issuer_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->issuer.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null issuer in ClientCertMetadata struct");

      decltype(Traits::serial(input)) in_serial = Traits::serial(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->serial)::BaseType> serial_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_serial,
        serial_fragment);

      fragment->serial.Set(
          serial_fragment.is_null() ? nullptr : serial_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->serial.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null serial in ClientCertMetadata struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::PictureInPictureConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::PictureInPictureConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::PictureInPictureConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::window_options(input)) in_window_options = Traits::window_options(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->window_options)::BaseType> window_options_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::PictureInPictureWindowOptionsDataView, send_validation>(
        in_window_options,
        window_options_fragment);

      fragment->window_options.Set(
          window_options_fragment.is_null() ? nullptr : window_options_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->window_options.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null window_options in PictureInPictureConfig struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::WindowOpenContextDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::WindowOpenContextDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::WindowOpenContext_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::ui::mojom::WindowOpenDisposition>(
        Traits::disposition(input),
        &fragment->disposition);

      decltype(Traits::window_features(input)) in_window_features = Traits::window_features(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->window_features)::BaseType> window_features_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::WindowFeaturesDataView, send_validation>(
        in_window_features,
        window_features_fragment);

      fragment->window_features.Set(
          window_features_fragment.is_null() ? nullptr : window_features_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->window_features.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null window_features in WindowOpenContext struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::ExtensionPopupContextDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::ExtensionPopupContextDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::ExtensionPopupContext_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::extension_id(input)) in_extension_id = Traits::extension_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->extension_id)::BaseType> extension_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_extension_id,
        extension_id_fragment);

      fragment->extension_id.Set(
          extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->extension_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null extension_id in ExtensionPopupContext struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::DevToolsContextDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::DevToolsContextDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::DevToolsContext_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::owl::mojom::DevToolsDockSide>(
        Traits::dock_side(input),
        &fragment->dock_side);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::BackForwardStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::BackForwardStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::BackForwardState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->can_go_back = Traits::can_go_back(input);

      fragment->can_go_forward = Traits::can_go_forward(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::NavigationEntryStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::NavigationEntryStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::NavigationEntryState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::owl::mojom::NavigationEntryUrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      decltype(Traits::back_forward_state(input)) in_back_forward_state = Traits::back_forward_state(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->back_forward_state)::BaseType> back_forward_state_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::owl::mojom::BackForwardStateDataView, send_validation>(
        in_back_forward_state,
        back_forward_state_fragment);

      fragment->back_forward_state.Set(
          back_forward_state_fragment.is_null() ? nullptr : back_forward_state_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::CommitDetailsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::CommitDetailsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::CommitDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::owl::mojom::TransitionType>(
        Traits::transition_type(input),
        &fragment->transition_type);

      fragment->is_redirect = Traits::is_redirect(input);

      fragment->is_chatgpt_frontend = Traits::is_chatgpt_frontend(input);

      fragment->did_replace_entry = Traits::did_replace_entry(input);

      fragment->is_same_document = Traits::is_same_document(input);

      fragment->entry_id = Traits::entry_id(input);

      decltype(Traits::removed_entry_ids(input)) in_removed_entry_ids = Traits::removed_entry_ids(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->removed_entry_ids)::BaseType>
          removed_entry_ids_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& removed_entry_ids_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<int32_t>, send_validation>(
        in_removed_entry_ids,
        removed_entry_ids_fragment,
        &removed_entry_ids_validate_params);

      fragment->removed_entry_ids.Set(
          removed_entry_ids_fragment.is_null() ? nullptr : removed_entry_ids_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->removed_entry_ids.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null removed_entry_ids in CommitDetails struct");

      fragment->main_frame_document_id = Traits::main_frame_document_id(input);

      decltype(Traits::removed_main_frame_document_ids(input)) in_removed_main_frame_document_ids = Traits::removed_main_frame_document_ids(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->removed_main_frame_document_ids)::BaseType>
          removed_main_frame_document_ids_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& removed_main_frame_document_ids_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<int64_t>, send_validation>(
        in_removed_main_frame_document_ids,
        removed_main_frame_document_ids_fragment,
        &removed_main_frame_document_ids_validate_params);

      fragment->removed_main_frame_document_ids.Set(
          removed_main_frame_document_ids_fragment.is_null() ? nullptr : removed_main_frame_document_ids_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->removed_main_frame_document_ids.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null removed_main_frame_document_ids in CommitDetails struct");

      decltype(Traits::entry_state(input)) in_entry_state = Traits::entry_state(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->entry_state)::BaseType> entry_state_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::owl::mojom::NavigationEntryStateDataView, send_validation>(
        in_entry_state,
        entry_state_fragment);

      fragment->entry_state.Set(
          entry_state_fragment.is_null() ? nullptr : entry_state_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->entry_state.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null entry_state in CommitDetails struct");

      fragment->http_status_code = Traits::http_status_code(input);

      decltype(Traits::cf_ray_id(input)) in_cf_ray_id = Traits::cf_ray_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cf_ray_id)::BaseType> cf_ray_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_cf_ray_id,
        cf_ray_id_fragment);

      fragment->cf_ray_id.Set(
          cf_ray_id_fragment.is_null() ? nullptr : cf_ray_id_fragment.data());

      fragment->is_error_page = Traits::is_error_page(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::NavigationEntryUrlDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::NavigationEntryUrlDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::NavigationEntryUrl_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in NavigationEntryUrl struct");

      decltype(Traits::redirect_chain_start(input)) in_redirect_chain_start = Traits::redirect_chain_start(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->redirect_chain_start)::BaseType> redirect_chain_start_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_redirect_chain_start,
        redirect_chain_start_fragment);

      fragment->redirect_chain_start.Set(
          redirect_chain_start_fragment.is_null() ? nullptr : redirect_chain_start_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->redirect_chain_start.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null redirect_chain_start in NavigationEntryUrl struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::SnapshotResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::owl::mojom::SnapshotResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::owl::mojom::internal::SnapshotResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::owl::mojom::SnapshotResultDataView::Tag::kImage: {
    decltype(Traits::image(input))
    in_image = Traits::image(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_image)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::skia::mojom::BitmapN32DataView, send_validation>(
  in_image,
  value_fragment);
    fragment->data.f_image.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::owl::mojom::SnapshotResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView, send_validation>(
  in_error,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error in SnapshotResult union");
    fragment->data.f_error.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::WebViewDispositionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::owl::mojom::WebViewDispositionDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::owl::mojom::internal::WebViewDisposition_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::owl::mojom::WebViewDispositionDataView::Tag::kWindowOpen: {
    decltype(Traits::window_open(input))
    in_window_open = Traits::window_open(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_window_open)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::owl::mojom::WindowOpenContextDataView, send_validation>(
  in_window_open,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null window_open in WebViewDisposition union");
    fragment->data.f_window_open.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::owl::mojom::WebViewDispositionDataView::Tag::kPictureInPicture: {
    decltype(Traits::picture_in_picture(input))
    in_picture_in_picture = Traits::picture_in_picture(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_picture_in_picture)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::owl::mojom::PictureInPictureConfigDataView, send_validation>(
  in_picture_in_picture,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null picture_in_picture in WebViewDisposition union");
    fragment->data.f_picture_in_picture.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::owl::mojom::WebViewDispositionDataView::Tag::kPrintPreview: {
    decltype(Traits::print_preview(input))
    in_print_preview = Traits::print_preview(input);
    fragment->data.f_print_preview = in_print_preview;
    break;
  }
  case ::owl::mojom::WebViewDispositionDataView::Tag::kExtensionPopup: {
    decltype(Traits::extension_popup(input))
    in_extension_popup = Traits::extension_popup(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_extension_popup)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::owl::mojom::ExtensionPopupContextDataView, send_validation>(
  in_extension_popup,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null extension_popup in WebViewDisposition union");
    fragment->data.f_extension_popup.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::owl::mojom::WebViewDispositionDataView::Tag::kDevTools: {
    decltype(Traits::dev_tools(input))
    in_dev_tools = Traits::dev_tools(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_dev_tools)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::owl::mojom::DevToolsContextDataView, send_validation>(
  in_dev_tools,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null dev_tools in WebViewDisposition union");
    fragment->data.f_dev_tools.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::owl::mojom::WebViewDispositionDataView::Tag::kDevToolsEmulationFrame: {
    decltype(Traits::dev_tools_emulation_frame(input))
    in_dev_tools_emulation_frame = Traits::dev_tools_emulation_frame(input);
    fragment->data.f_dev_tools_emulation_frame = in_dev_tools_emulation_frame;
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // OWL_MOJOM_WEB_VIEW_MOJOM_SEND_VALIDATION_H_