// owl/mojom/web_prefs.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_WEB_PREFS_MOJOM_H_
#define OWL_MOJOM_WEB_PREFS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/web_prefs.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/web_prefs.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/web_prefs.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>








namespace owl::mojom {





class  WebPreferences {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebPreferences, T>::value>;
  using DataView = WebPreferencesDataView;
  using Data_ = internal::WebPreferences_Data;

  template <typename... Args>
  static WebPreferencesPtr New(Args&&... args) {
    return WebPreferencesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebPreferencesPtr From(const U& u) {
    return mojo::TypeConverter<WebPreferencesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebPreferences>::Convert(*this);
  }


  WebPreferences();

  WebPreferences(
      int32_t default_font_size,
      double zoom_factor);


  ~WebPreferences();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebPreferencesPtr>
  WebPreferencesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebPreferences::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebPreferences::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebPreferences::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPreferences::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPreferences::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebPreferences::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebPreferences_UnserializedMessageContext<
            UserType, WebPreferences::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebPreferences::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebPreferences::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebPreferences_UnserializedMessageContext<
            UserType, WebPreferences::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebPreferences::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t default_font_size;
  
  double zoom_factor;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebPreferences::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebPreferences::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebPreferences::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebPreferences::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
WebPreferencesPtr WebPreferences::Clone() const {
  return New(
      mojo::Clone(default_font_size),
      mojo::Clone(zoom_factor)
  );
}

template <typename T, WebPreferences::EnableIfSame<T>*>
bool WebPreferences::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->default_font_size, other_struct.default_font_size))
    return false;
  if (!mojo::Equals(this->zoom_factor, other_struct.zoom_factor))
    return false;
  return true;
}

template <typename T, WebPreferences::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.default_font_size < rhs.default_font_size)
    return true;
  if (rhs.default_font_size < lhs.default_font_size)
    return false;
  if (lhs.zoom_factor < rhs.zoom_factor)
    return true;
  if (rhs.zoom_factor < lhs.zoom_factor)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::WebPreferences::DataView,
                                         ::owl::mojom::WebPreferencesPtr> {
  static bool IsNull(const ::owl::mojom::WebPreferencesPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::WebPreferencesPtr* output) { output->reset(); }

  static decltype(::owl::mojom::WebPreferences::default_font_size) default_font_size(
      const ::owl::mojom::WebPreferencesPtr& input) {
    return input->default_font_size;
  }

  static decltype(::owl::mojom::WebPreferences::zoom_factor) zoom_factor(
      const ::owl::mojom::WebPreferencesPtr& input) {
    return input->zoom_factor;
  }

  static bool Read(::owl::mojom::WebPreferences::DataView input, ::owl::mojom::WebPreferencesPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_WEB_PREFS_MOJOM_H_