// owl/mojom/web_content_renderer.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_WEB_CONTENT_RENDERER_MOJOM_H_
#define OWL_MOJOM_WEB_CONTENT_RENDERER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/web_content_renderer.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/web_content_renderer.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/web_content_renderer.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/process_id.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "owl/mojom/web_view_container_view.mojom-forward.h"
#include "third_party/blink/public/mojom/choosers/popup_menu.mojom.h"
#include "third_party/blink/public/mojom/input/input_handler.mojom.h"
#include "third_party/blink/public/mojom/webshare/share_error.mojom-forward.h"
#include "ui/base/cursor/mojom/cursor.mojom.h"
#include "ui/base/ime/mojom/ime_types.mojom.h"
#include "ui/display/mojom/screen_infos.mojom-forward.h"
#include "ui/events/mojom/event.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/ca_layer_params.mojom-forward.h"
#include "ui/gfx/range/mojom/range.mojom.h"
#include "ui/base/mojom/attributed_string.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class WebContentRendererProxy;

template <typename ImplRefTraits>
class WebContentRendererStub;

class WebContentRendererRequestValidator;
class WebContentRendererResponseValidator;


class WebContentRenderer
    : public WebContentRendererInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.WebContentRenderer";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0, 
    22, 
    23, 
    36
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebContentRendererInterfaceBase;
  using Proxy_ = WebContentRendererProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebContentRendererStub<ImplRefTraits>;

  using RequestValidator_ = WebContentRendererRequestValidator;
  using ResponseValidator_ = WebContentRendererResponseValidator;
  enum MethodMinVersions : uint32_t {
    kIsWidgetForMainFrameMinVersion = 0,
    kRequestShutdownMinVersion = 0,
    kSetFocusLockMinVersion = 0,
    kOnFirstResponderChangedMinVersion = 0,
    kOnWindowIsKeyChangedMinVersion = 0,
    kBeginKeyboardEventMinVersion = 0,
    kEndKeyboardEventMinVersion = 0,
    kForwardKeyboardEventWithCommandsMinVersion = 0,
    kForwardKeyboardEventWithCommandsAndAckMinVersion = 0,
    kRouteOrProcessMouseEventMinVersion = 0,
    kRouteOrProcessTouchEventMinVersion = 0,
    kRouteOrProcessWheelEventMinVersion = 0,
    kGestureBeginMinVersion = 0,
    kGestureUpdateMinVersion = 0,
    kGestureEndMinVersion = 0,
    kSmartMagnifyMinVersion = 0,
    kImeSetCompositionMinVersion = 0,
    kImeCommitTextMinVersion = 0,
    kImeFinishComposingTextMinVersion = 0,
    kImeCancelCompositionFromClientMinVersion = 0,
    kLookUpDictionaryOverlayAtPointMinVersion = 0,
    kLookUpDictionaryOverlayFromRangeMinVersion = 0,
    kGetCharacterIndexAtPointMinVersion = 0,
    kGetFirstRectForRangeMinVersion = 0,
    kExecuteEditCommandMinVersion = 0,
    kUndoMinVersion = 0,
    kRedoMinVersion = 0,
    kCutMinVersion = 0,
    kCopyMinVersion = 0,
    kCopyToFindPboardMinVersion = 0,
    kCenterSelectionMinVersion = 0,
    kPasteMinVersion = 0,
    kPasteAndMatchStyleMinVersion = 0,
    kSelectAllMinVersion = 0,
    kStartSpeakingMinVersion = 0,
    kStopSpeakingMinVersion = 0,
    kIsSpeakingMinVersion = 0,
    kGetWebContentRendererAccessibilityTokenMinVersion = 0,
    kSetRemoteAccessibilityTokensMinVersion = 0,
    kPingHostViewMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct IsWidgetForMainFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestShutdown_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetFocusLock_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFirstResponderChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWindowIsKeyChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BeginKeyboardEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EndKeyboardEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ForwardKeyboardEventWithCommands_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ForwardKeyboardEventWithCommandsAndAck_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RouteOrProcessMouseEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RouteOrProcessTouchEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RouteOrProcessWheelEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GestureBegin_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GestureUpdate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GestureEnd_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SmartMagnify_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ImeSetComposition_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ImeCommitText_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ImeFinishComposingText_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ImeCancelCompositionFromClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LookUpDictionaryOverlayAtPoint_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LookUpDictionaryOverlayFromRange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCharacterIndexAtPoint_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetFirstRectForRange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExecuteEditCommand_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Undo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Redo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Cut_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Copy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CopyToFindPboard_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CenterSelection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Paste_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PasteAndMatchStyle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SelectAll_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartSpeaking_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopSpeaking_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsSpeaking_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetWebContentRendererAccessibilityToken_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetRemoteAccessibilityTokens_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PingHostView_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebContentRenderer() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool IsWidgetForMainFrame(bool* out_is_for_main_frame);
  using IsWidgetForMainFrameCallback = base::OnceCallback<void(bool)>;
  using IsWidgetForMainFrameMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsWidgetForMainFrame(IsWidgetForMainFrameCallback callback) = 0;

  virtual void RequestShutdown() = 0;

  virtual void SetFocusLock(bool is_locked) = 0;

  virtual void OnFirstResponderChanged(bool is_first_responder) = 0;

  virtual void OnWindowIsKeyChanged(bool is_key) = 0;

  virtual void BeginKeyboardEvent() = 0;

  virtual void EndKeyboardEvent() = 0;

  virtual void ForwardKeyboardEventWithCommands(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, const std::vector<uint8_t>& native_event_data, bool skip_if_unhandled, std::vector<::blink::mojom::EditCommandPtr> commands) = 0;

  using ForwardKeyboardEventWithCommandsAndAckCallback = base::OnceCallback<void()>;
  using ForwardKeyboardEventWithCommandsAndAckMojoCallback = base::OnceCallback<void()>;

  virtual void ForwardKeyboardEventWithCommandsAndAck(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, const std::vector<uint8_t>& native_event_data, bool skip_if_unhandled, std::vector<::blink::mojom::EditCommandPtr> commands, ForwardKeyboardEventWithCommandsAndAckCallback callback) = 0;

  virtual void RouteOrProcessMouseEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) = 0;

  virtual void RouteOrProcessTouchEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) = 0;

  virtual void RouteOrProcessWheelEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) = 0;

  virtual void GestureBegin(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, bool is_synthetically_injected) = 0;

  virtual void GestureUpdate(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) = 0;

  virtual void GestureEnd(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) = 0;

  virtual void SmartMagnify(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) = 0;

  virtual void ImeSetComposition(const ::std::u16string& text, const std::vector<::ui::ImeTextSpan>& ime_text_spans, const ::gfx::Range& replacement_range, int32_t selection_start, int32_t selection_end) = 0;

  virtual void ImeCommitText(const ::std::u16string& text, const ::gfx::Range& replacement_range) = 0;

  virtual void ImeFinishComposingText() = 0;

  virtual void ImeCancelCompositionFromClient() = 0;

  virtual void LookUpDictionaryOverlayAtPoint(const ::gfx::PointF& root_point) = 0;

  virtual void LookUpDictionaryOverlayFromRange(const ::gfx::Range& range) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetCharacterIndexAtPoint(const ::gfx::PointF& root_point, std::optional<uint32_t>* out_index);
  using GetCharacterIndexAtPointCallback = base::OnceCallback<void(std::optional<uint32_t>)>;
  using GetCharacterIndexAtPointMojoCallback = base::OnceCallback<void(std::optional<uint32_t>)>;

  virtual void GetCharacterIndexAtPoint(const ::gfx::PointF& root_point, GetCharacterIndexAtPointCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetFirstRectForRange(const ::gfx::Range& requested_range, RectWithRangePtr* out_result);
  using GetFirstRectForRangeCallback = base::OnceCallback<void(RectWithRangePtr)>;
  using GetFirstRectForRangeMojoCallback = base::OnceCallback<void(RectWithRangePtr)>;

  virtual void GetFirstRectForRange(const ::gfx::Range& requested_range, GetFirstRectForRangeCallback callback) = 0;

  virtual void ExecuteEditCommand(const std::string& command) = 0;

  virtual void Undo() = 0;

  virtual void Redo() = 0;

  virtual void Cut() = 0;

  virtual void Copy() = 0;

  virtual void CopyToFindPboard() = 0;

  virtual void CenterSelection() = 0;

  virtual void Paste() = 0;

  virtual void PasteAndMatchStyle() = 0;

  virtual void SelectAll() = 0;

  virtual void StartSpeaking() = 0;

  virtual void StopSpeaking() = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool IsSpeaking(bool* out_is_speaking);
  using IsSpeakingCallback = base::OnceCallback<void(bool)>;
  using IsSpeakingMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsSpeaking(IsSpeakingCallback callback) = 0;

  using GetWebContentRendererAccessibilityTokenCallback = base::OnceCallback<void(::base::ProcessId, const std::vector<uint8_t>&)>;
  using GetWebContentRendererAccessibilityTokenMojoCallback = base::OnceCallback<void(::base::ProcessId, const std::vector<uint8_t>&)>;

  virtual void GetWebContentRendererAccessibilityToken(GetWebContentRendererAccessibilityTokenCallback callback) = 0;

  virtual void SetRemoteAccessibilityTokens(const std::vector<uint8_t>& window_token, const std::vector<uint8_t>& view_token) = 0;

  using PingHostViewCallback = base::OnceCallback<void()>;
  using PingHostViewMojoCallback = base::OnceCallback<void()>;

  virtual void PingHostView(PingHostViewCallback callback) = 0;
};

class PopupMenuRunnerProxy;

template <typename ImplRefTraits>
class PopupMenuRunnerStub;

class PopupMenuRunnerRequestValidator;


class PopupMenuRunner
    : public PopupMenuRunnerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.PopupMenuRunner";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PopupMenuRunnerInterfaceBase;
  using Proxy_ = PopupMenuRunnerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PopupMenuRunnerStub<ImplRefTraits>;

  using RequestValidator_ = PopupMenuRunnerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kHideMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Hide_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PopupMenuRunner() = default;

  virtual void Hide() = 0;
};

class WebContentRendererClientProxy;

template <typename ImplRefTraits>
class WebContentRendererClientStub;

class WebContentRendererClientRequestValidator;
class WebContentRendererClientResponseValidator;


class WebContentRendererClient
    : public WebContentRendererClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.WebContentRendererClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebContentRendererClientInterfaceBase;
  using Proxy_ = WebContentRendererClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebContentRendererClientStub<ImplRefTraits>;

  using RequestValidator_ = WebContentRendererClientRequestValidator;
  using ResponseValidator_ = WebContentRendererClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kInitAsPopupMinVersion = 0,
    kSetPopupBoundsMinVersion = 0,
    kTakeFocusMinVersion = 0,
    kSetVisibleMinVersion = 0,
    kSetTooltipTextMinVersion = 0,
    kSetTextInputStateMinVersion = 0,
    kSetTextSelectionMinVersion = 0,
    kSetCompositionRangeInfoMinVersion = 0,
    kCancelCompositionMinVersion = 0,
    kOnSelectionBoundsChangedMinVersion = 0,
    kSetShowingContextMenuMinVersion = 0,
    kDisplayCursorMinVersion = 0,
    kSetCursorLockedMinVersion = 0,
    kSetCursorLockedUnacceleratedMovementMinVersion = 0,
    kShowDictionaryOverlayForSelectionMinVersion = 0,
    kShowDictionaryOverlayMinVersion = 0,
    kLockKeyboardMinVersion = 0,
    kUnlockKeyboardMinVersion = 0,
    kShowSharingServicePickerMinVersion = 0,
    kDestroyMinVersion = 0,
    kGestureScrollEventAckMinVersion = 0,
    kDidOverscrollMinVersion = 0,
    kDisplayPopupMenuMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct InitAsPopup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPopupBounds_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TakeFocus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetVisible_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTooltipText_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTextInputState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTextSelection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCompositionRangeInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CancelComposition_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSelectionBoundsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetShowingContextMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DisplayCursor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCursorLocked_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCursorLockedUnacceleratedMovement_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowDictionaryOverlayForSelection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowDictionaryOverlay_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LockKeyboard_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UnlockKeyboard_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowSharingServicePicker_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Destroy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GestureScrollEventAck_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidOverscroll_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DisplayPopupMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebContentRendererClient() = default;

  virtual void InitAsPopup(const ::gfx::Rect& content_rect, uint64_t popup_parent_id, ::mojo::PendingAssociatedRemote<::owl::mojom::LayerHost> layer_host_remote, ::mojo::PendingAssociatedReceiver<::owl::mojom::LayerHostClient> layer_host_client) = 0;

  virtual void SetPopupBounds(const ::gfx::Rect& rect) = 0;

  virtual void TakeFocus() = 0;

  virtual void SetVisible(bool visible) = 0;

  virtual void SetTooltipText(const ::std::u16string& display_text) = 0;

  virtual void SetTextInputState(::ui::TextInputType text_input_type, uint32_t flags, const std::optional<::gfx::Rect>& edit_context_selection_bounds) = 0;

  virtual void SetTextSelection(const ::std::u16string& text, uint64_t offset, const ::gfx::Range& range) = 0;

  virtual void SetCompositionRangeInfo(const ::gfx::Range& range) = 0;

  virtual void CancelComposition() = 0;

  virtual void OnSelectionBoundsChanged(const ::gfx::Rect& selection_rect, const ::gfx::Rect& focus_rect, const ::gfx::Rect& anchor_rect) = 0;

  virtual void SetShowingContextMenu(bool showing) = 0;

  virtual void DisplayCursor(const ::ui::Cursor& cursor) = 0;

  virtual void SetCursorLocked(bool locked) = 0;

  virtual void SetCursorLockedUnacceleratedMovement(bool unaccelerated_movement) = 0;

  virtual void ShowDictionaryOverlayForSelection() = 0;

  virtual void ShowDictionaryOverlay(::ui::mojom::AttributedStringPtr attributed_string, const ::gfx::Point& baseline_point) = 0;

  virtual void LockKeyboard(const std::optional<std::vector<uint32_t>>& dom_codes) = 0;

  virtual void UnlockKeyboard() = 0;

  using ShowSharingServicePickerCallback = base::OnceCallback<void(::blink::mojom::ShareError)>;
  using ShowSharingServicePickerMojoCallback = base::OnceCallback<void(::blink::mojom::ShareError)>;

  virtual void ShowSharingServicePicker(const std::string& title, const std::string& text, const std::string& url, const std::vector<std::string>& file_paths, ShowSharingServicePickerCallback callback) = 0;

  virtual void Destroy() = 0;

  virtual void GestureScrollEventAck(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, bool consumed) = 0;

  virtual void DidOverscroll(OverscrollType x, OverscrollType y) = 0;

  using DisplayPopupMenuCallback = base::OnceCallback<void(std::optional<uint32_t>)>;
  using DisplayPopupMenuMojoCallback = base::OnceCallback<void(std::optional<uint32_t>)>;

  virtual void DisplayPopupMenu(PopupMenuPtr menu, DisplayPopupMenuCallback callback) = 0;
};



class  WebContentRendererProxy
    : public WebContentRenderer {
 public:
  using InterfaceType = WebContentRenderer;

  explicit WebContentRendererProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool IsWidgetForMainFrame(bool* out_is_for_main_frame) final;
  
  void IsWidgetForMainFrame(IsWidgetForMainFrameCallback callback) final;
  
  void RequestShutdown() final;
  
  void SetFocusLock(bool is_locked) final;
  
  void OnFirstResponderChanged(bool is_first_responder) final;
  
  void OnWindowIsKeyChanged(bool is_key) final;
  
  void BeginKeyboardEvent() final;
  
  void EndKeyboardEvent() final;
  
  void ForwardKeyboardEventWithCommands(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, const std::vector<uint8_t>& native_event_data, bool skip_if_unhandled, std::vector<::blink::mojom::EditCommandPtr> commands) final;
  
  void ForwardKeyboardEventWithCommandsAndAck(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, const std::vector<uint8_t>& native_event_data, bool skip_if_unhandled, std::vector<::blink::mojom::EditCommandPtr> commands, ForwardKeyboardEventWithCommandsAndAckCallback callback) final;
  
  void RouteOrProcessMouseEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) final;
  
  void RouteOrProcessTouchEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) final;
  
  void RouteOrProcessWheelEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) final;
  
  void GestureBegin(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, bool is_synthetically_injected) final;
  
  void GestureUpdate(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) final;
  
  void GestureEnd(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) final;
  
  void SmartMagnify(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) final;
  
  void ImeSetComposition(const ::std::u16string& text, const std::vector<::ui::ImeTextSpan>& ime_text_spans, const ::gfx::Range& replacement_range, int32_t selection_start, int32_t selection_end) final;
  
  void ImeCommitText(const ::std::u16string& text, const ::gfx::Range& replacement_range) final;
  
  void ImeFinishComposingText() final;
  
  void ImeCancelCompositionFromClient() final;
  
  void LookUpDictionaryOverlayAtPoint(const ::gfx::PointF& root_point) final;
  
  void LookUpDictionaryOverlayFromRange(const ::gfx::Range& range) final;
  
  bool GetCharacterIndexAtPoint(const ::gfx::PointF& root_point, std::optional<uint32_t>* out_index) final;
  
  void GetCharacterIndexAtPoint(const ::gfx::PointF& root_point, GetCharacterIndexAtPointCallback callback) final;
  
  bool GetFirstRectForRange(const ::gfx::Range& requested_range, RectWithRangePtr* out_result) final;
  
  void GetFirstRectForRange(const ::gfx::Range& requested_range, GetFirstRectForRangeCallback callback) final;
  
  void ExecuteEditCommand(const std::string& command) final;
  
  void Undo() final;
  
  void Redo() final;
  
  void Cut() final;
  
  void Copy() final;
  
  void CopyToFindPboard() final;
  
  void CenterSelection() final;
  
  void Paste() final;
  
  void PasteAndMatchStyle() final;
  
  void SelectAll() final;
  
  void StartSpeaking() final;
  
  void StopSpeaking() final;
  
  bool IsSpeaking(bool* out_is_speaking) final;
  
  void IsSpeaking(IsSpeakingCallback callback) final;
  
  void GetWebContentRendererAccessibilityToken(GetWebContentRendererAccessibilityTokenCallback callback) final;
  
  void SetRemoteAccessibilityTokens(const std::vector<uint8_t>& window_token, const std::vector<uint8_t>& view_token) final;
  
  void PingHostView(PingHostViewCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PopupMenuRunnerProxy
    : public PopupMenuRunner {
 public:
  using InterfaceType = PopupMenuRunner;

  explicit PopupMenuRunnerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Hide() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  WebContentRendererClientProxy
    : public WebContentRendererClient {
 public:
  using InterfaceType = WebContentRendererClient;

  explicit WebContentRendererClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void InitAsPopup(const ::gfx::Rect& content_rect, uint64_t popup_parent_id, ::mojo::PendingAssociatedRemote<::owl::mojom::LayerHost> layer_host_remote, ::mojo::PendingAssociatedReceiver<::owl::mojom::LayerHostClient> layer_host_client) final;
  
  void SetPopupBounds(const ::gfx::Rect& rect) final;
  
  void TakeFocus() final;
  
  void SetVisible(bool visible) final;
  
  void SetTooltipText(const ::std::u16string& display_text) final;
  
  void SetTextInputState(::ui::TextInputType text_input_type, uint32_t flags, const std::optional<::gfx::Rect>& edit_context_selection_bounds) final;
  
  void SetTextSelection(const ::std::u16string& text, uint64_t offset, const ::gfx::Range& range) final;
  
  void SetCompositionRangeInfo(const ::gfx::Range& range) final;
  
  void CancelComposition() final;
  
  void OnSelectionBoundsChanged(const ::gfx::Rect& selection_rect, const ::gfx::Rect& focus_rect, const ::gfx::Rect& anchor_rect) final;
  
  void SetShowingContextMenu(bool showing) final;
  
  void DisplayCursor(const ::ui::Cursor& cursor) final;
  
  void SetCursorLocked(bool locked) final;
  
  void SetCursorLockedUnacceleratedMovement(bool unaccelerated_movement) final;
  
  void ShowDictionaryOverlayForSelection() final;
  
  void ShowDictionaryOverlay(::ui::mojom::AttributedStringPtr attributed_string, const ::gfx::Point& baseline_point) final;
  
  void LockKeyboard(const std::optional<std::vector<uint32_t>>& dom_codes) final;
  
  void UnlockKeyboard() final;
  
  void ShowSharingServicePicker(const std::string& title, const std::string& text, const std::string& url, const std::vector<std::string>& file_paths, ShowSharingServicePickerCallback callback) final;
  
  void Destroy() final;
  
  void GestureScrollEventAck(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, bool consumed) final;
  
  void DidOverscroll(OverscrollType x, OverscrollType y) final;
  
  void DisplayPopupMenu(PopupMenuPtr menu, DisplayPopupMenuCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  WebContentRendererStubDispatch {
 public:
  static bool Accept(WebContentRenderer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebContentRenderer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebContentRenderer>>
class WebContentRendererStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebContentRendererStub() = default;
  ~WebContentRendererStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebContentRendererStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebContentRendererStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PopupMenuRunnerStubDispatch {
 public:
  static bool Accept(PopupMenuRunner* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PopupMenuRunner* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PopupMenuRunner>>
class PopupMenuRunnerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PopupMenuRunnerStub() = default;
  ~PopupMenuRunnerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PopupMenuRunnerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PopupMenuRunnerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebContentRendererClientStubDispatch {
 public:
  static bool Accept(WebContentRendererClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebContentRendererClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebContentRendererClient>>
class WebContentRendererClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebContentRendererClientStub() = default;
  ~WebContentRendererClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebContentRendererClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebContentRendererClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebContentRendererRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PopupMenuRunnerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebContentRendererClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebContentRendererResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebContentRendererClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  RectWithRange {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RectWithRange, T>::value>;
  using DataView = RectWithRangeDataView;
  using Data_ = internal::RectWithRange_Data;

  template <typename... Args>
  static RectWithRangePtr New(Args&&... args) {
    return RectWithRangePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RectWithRangePtr From(const U& u) {
    return mojo::TypeConverter<RectWithRangePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RectWithRange>::Convert(*this);
  }


  RectWithRange();

  RectWithRange(
      const ::gfx::Rect& rect,
      const ::gfx::Range& range);


  ~RectWithRange();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RectWithRangePtr>
  RectWithRangePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RectWithRange::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RectWithRange::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RectWithRange::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RectWithRange::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RectWithRange::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RectWithRange::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RectWithRange_UnserializedMessageContext<
            UserType, RectWithRange::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RectWithRange::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RectWithRange::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RectWithRange_UnserializedMessageContext<
            UserType, RectWithRange::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RectWithRange::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Rect rect;
  
  ::gfx::Range range;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RectWithRange::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RectWithRange::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RectWithRange::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RectWithRange::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PopupMenu {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PopupMenu, T>::value>;
  using DataView = PopupMenuDataView;
  using Data_ = internal::PopupMenu_Data;

  template <typename... Args>
  static PopupMenuPtr New(Args&&... args) {
    return PopupMenuPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PopupMenuPtr From(const U& u) {
    return mojo::TypeConverter<PopupMenuPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PopupMenu>::Convert(*this);
  }


  PopupMenu();

  PopupMenu(
      std::vector<::blink::mojom::MenuItemPtr> items,
      const ::gfx::Rect& bounds,
      double item_font_size,
      bool right_aligned,
      uint32_t selected_item,
      ::mojo::PendingReceiver<PopupMenuRunner> receiver);

PopupMenu(const PopupMenu&) = delete;
PopupMenu& operator=(const PopupMenu&) = delete;

  ~PopupMenu();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PopupMenuPtr>
  PopupMenuPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PopupMenu::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PopupMenu::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PopupMenu::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PopupMenu::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PopupMenu_UnserializedMessageContext<
            UserType, PopupMenu::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PopupMenu::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PopupMenu::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PopupMenu_UnserializedMessageContext<
            UserType, PopupMenu::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PopupMenu::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::blink::mojom::MenuItemPtr> items;
  
  ::gfx::Rect bounds;
  
  double item_font_size;
  
  bool right_aligned;
  
  uint32_t selected_item;
  
  ::mojo::PendingReceiver<PopupMenuRunner> receiver;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PopupMenu::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PopupMenu::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PopupMenu::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PopupMenu::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
RectWithRangePtr RectWithRange::Clone() const {
  return New(
      mojo::Clone(rect),
      mojo::Clone(range)
  );
}

template <typename T, RectWithRange::EnableIfSame<T>*>
bool RectWithRange::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->rect, other_struct.rect))
    return false;
  if (!mojo::Equals(this->range, other_struct.range))
    return false;
  return true;
}

template <typename T, RectWithRange::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.rect < rhs.rect)
    return true;
  if (rhs.rect < lhs.rect)
    return false;
  if (lhs.range < rhs.range)
    return true;
  if (rhs.range < lhs.range)
    return false;
  return false;
}
template <typename StructPtrType>
PopupMenuPtr PopupMenu::Clone() const {
  return New(
      mojo::Clone(items),
      mojo::Clone(bounds),
      mojo::Clone(item_font_size),
      mojo::Clone(right_aligned),
      mojo::Clone(selected_item),
      mojo::Clone(receiver)
  );
}

template <typename T, PopupMenu::EnableIfSame<T>*>
bool PopupMenu::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->items, other_struct.items))
    return false;
  if (!mojo::Equals(this->bounds, other_struct.bounds))
    return false;
  if (!mojo::Equals(this->item_font_size, other_struct.item_font_size))
    return false;
  if (!mojo::Equals(this->right_aligned, other_struct.right_aligned))
    return false;
  if (!mojo::Equals(this->selected_item, other_struct.selected_item))
    return false;
  if (!mojo::Equals(this->receiver, other_struct.receiver))
    return false;
  return true;
}

template <typename T, PopupMenu::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.items < rhs.items)
    return true;
  if (rhs.items < lhs.items)
    return false;
  if (lhs.bounds < rhs.bounds)
    return true;
  if (rhs.bounds < lhs.bounds)
    return false;
  if (lhs.item_font_size < rhs.item_font_size)
    return true;
  if (rhs.item_font_size < lhs.item_font_size)
    return false;
  if (lhs.right_aligned < rhs.right_aligned)
    return true;
  if (rhs.right_aligned < lhs.right_aligned)
    return false;
  if (lhs.selected_item < rhs.selected_item)
    return true;
  if (rhs.selected_item < lhs.selected_item)
    return false;
  if (lhs.receiver < rhs.receiver)
    return true;
  if (rhs.receiver < lhs.receiver)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::RectWithRange::DataView,
                                         ::owl::mojom::RectWithRangePtr> {
  static bool IsNull(const ::owl::mojom::RectWithRangePtr& input) { return !input; }
  static void SetToNull(::owl::mojom::RectWithRangePtr* output) { output->reset(); }

  static const decltype(::owl::mojom::RectWithRange::rect)& rect(
      const ::owl::mojom::RectWithRangePtr& input) {
    return input->rect;
  }

  static const decltype(::owl::mojom::RectWithRange::range)& range(
      const ::owl::mojom::RectWithRangePtr& input) {
    return input->range;
  }

  static bool Read(::owl::mojom::RectWithRange::DataView input, ::owl::mojom::RectWithRangePtr* output);
};


template <>
struct  StructTraits<::owl::mojom::PopupMenu::DataView,
                                         ::owl::mojom::PopupMenuPtr> {
  static bool IsNull(const ::owl::mojom::PopupMenuPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::PopupMenuPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::PopupMenu::items)& items(
      const ::owl::mojom::PopupMenuPtr& input) {
    return input->items;
  }

  static const decltype(::owl::mojom::PopupMenu::bounds)& bounds(
      const ::owl::mojom::PopupMenuPtr& input) {
    return input->bounds;
  }

  static decltype(::owl::mojom::PopupMenu::item_font_size) item_font_size(
      const ::owl::mojom::PopupMenuPtr& input) {
    return input->item_font_size;
  }

  static decltype(::owl::mojom::PopupMenu::right_aligned) right_aligned(
      const ::owl::mojom::PopupMenuPtr& input) {
    return input->right_aligned;
  }

  static decltype(::owl::mojom::PopupMenu::selected_item) selected_item(
      const ::owl::mojom::PopupMenuPtr& input) {
    return input->selected_item;
  }

  static  decltype(::owl::mojom::PopupMenu::receiver)& receiver(
       ::owl::mojom::PopupMenuPtr& input) {
    return input->receiver;
  }

  static bool Read(::owl::mojom::PopupMenu::DataView input, ::owl::mojom::PopupMenuPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_WEB_CONTENT_RENDERER_MOJOM_H_