// owl/mojom/web_content_renderer.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_WEB_CONTENT_RENDERER_MOJOM_SEND_VALIDATION_H_
#define OWL_MOJOM_WEB_CONTENT_RENDERER_MOJOM_SEND_VALIDATION_H_

#include "owl/mojom/web_content_renderer.mojom-shared-internal.h"
#include "mojo/public/mojom/base/process_id.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "owl/mojom/web_view_container_view.mojom-shared.h"
#include "third_party/blink/public/mojom/choosers/popup_menu.mojom-shared.h"
#include "third_party/blink/public/mojom/input/input_handler.mojom-shared.h"
#include "third_party/blink/public/mojom/webshare/share_error.mojom-shared.h"
#include "ui/base/cursor/mojom/cursor.mojom-shared.h"
#include "ui/base/ime/mojom/ime_types.mojom-shared.h"
#include "ui/display/mojom/screen_infos.mojom-shared.h"
#include "ui/events/mojom/event.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/ca_layer_params.mojom-shared.h"
#include "ui/gfx/range/mojom/range.mojom-shared.h"
#include "ui/base/mojom/attributed_string.mojom-shared.h"

#include "owl/mojom/web_content_renderer.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::OverscrollType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::RectWithRangeDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::RectWithRangeDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::RectWithRange_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::rect(input)) in_rect = Traits::rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->rect)::BaseType> rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_rect,
        rect_fragment);

      fragment->rect.Set(
          rect_fragment.is_null() ? nullptr : rect_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->rect.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rect in RectWithRange struct");

      decltype(Traits::range(input)) in_range = Traits::range(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->range)::BaseType> range_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RangeDataView, send_validation>(
        in_range,
        range_fragment);

      fragment->range.Set(
          range_fragment.is_null() ? nullptr : range_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->range.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null range in RectWithRange struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::PopupMenuDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::PopupMenuDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::PopupMenu_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::items(input)) in_items = Traits::items(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->items)::BaseType>
          items_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::MenuItemDataView>, send_validation>(
        in_items,
        items_fragment,
        &items_validate_params);

      fragment->items.Set(
          items_fragment.is_null() ? nullptr : items_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->items.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null items in PopupMenu struct");

      decltype(Traits::bounds(input)) in_bounds = Traits::bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bounds)::BaseType> bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_bounds,
        bounds_fragment);

      fragment->bounds.Set(
          bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bounds.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bounds in PopupMenu struct");

      fragment->item_font_size = Traits::item_font_size(input);

      fragment->right_aligned = Traits::right_aligned(input);

      fragment->selected_item = Traits::selected_item(input);

      decltype(Traits::receiver(input)) in_receiver = Traits::receiver(input);

      
      mojo::internal::Serialize<mojo::InterfaceRequestDataView<::owl::mojom::PopupMenuRunnerInterfaceBase>>(
        in_receiver,
        &fragment->receiver,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->receiver)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid receiver in PopupMenu struct");
  }
};

}  // namespace mojo::internal

#endif  // OWL_MOJOM_WEB_CONTENT_RENDERER_MOJOM_SEND_VALIDATION_H_