// owl/mojom/web_content.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_WEB_CONTENT_MOJOM_H_
#define OWL_MOJOM_WEB_CONTENT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/web_content.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/web_content.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/web_content.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/text_direction.mojom-forward.h"
#include "owl/mojom/context_menu_params.mojom-forward.h"
#include "owl/mojom/web_content_renderer.mojom-forward.h"
#include "services/network/public/mojom/referrer_policy.mojom-forward.h"
#include "ui/base/dragdrop/mojom/drag_drop_types.mojom-forward.h"
#include "ui/events/mojom/event.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/image/mojom/image.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class WebContentProxy;

template <typename ImplRefTraits>
class WebContentStub;

class WebContentRequestValidator;


class WebContent
    : public WebContentInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.WebContent";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebContentInterfaceBase;
  using Proxy_ = WebContentProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebContentStub<ImplRefTraits>;

  using RequestValidator_ = WebContentRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetInputModeMinVersion = 0,
    kOnMouseEventMinVersion = 0,
    kOnBecameFirstResponderMinVersion = 0,
    kDraggingEnteredMinVersion = 0,
    kDraggingExitedMinVersion = 0,
    kDraggingUpdatedMinVersion = 0,
    kPerformDragOperationMinVersion = 0,
    kEndDragMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetInputMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnMouseEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBecameFirstResponder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DraggingEntered_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DraggingExited_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DraggingUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PerformDragOperation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EndDrag_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebContent() = default;

  virtual void SetInputMode(InputMode mode) = 0;

  virtual void OnMouseEvent(::std::unique_ptr<::ui::Event> event) = 0;

  virtual void OnBecameFirstResponder(WindowSelectionMethod method) = 0;

  virtual void DraggingEntered(DropDataPtr drop_data, DraggingInfoPtr dragging_info) = 0;

  virtual void DraggingExited() = 0;

  virtual void DraggingUpdated(DraggingInfoPtr dragging_info) = 0;

  virtual void PerformDragOperation(DraggingInfoPtr dragging_info) = 0;

  virtual void EndDrag(uint64_t drag_operation, const ::gfx::PointF& local_point, const ::gfx::PointF& screen_point) = 0;
};

class WebContentClientProxy;

template <typename ImplRefTraits>
class WebContentClientStub;

class WebContentClientRequestValidator;
class WebContentClientResponseValidator;


class WebContentClient
    : public WebContentClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.WebContentClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebContentClientInterfaceBase;
  using Proxy_ = WebContentClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebContentClientStub<ImplRefTraits>;

  using RequestValidator_ = WebContentClientRequestValidator;
  using ResponseValidator_ = WebContentClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateRendererClientMinVersion = 0,
    kTakeFocusMinVersion = 0,
    kDestroyMinVersion = 0,
    kShowContextMenuMinVersion = 0,
    kStartDragMinVersion = 0,
    kStartNativeDragMinVersion = 0,
    kUpdateDragOperationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateRendererClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TakeFocus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Destroy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowContextMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartDrag_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartNativeDrag_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateDragOperation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebContentClient() = default;

  virtual void CreateRendererClient(uint64_t id, WebContentRendererType type, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebContentRendererClient> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebContentRenderer> renderer) = 0;

  virtual void TakeFocus(bool reverse) = 0;

  virtual void Destroy() = 0;

  virtual void ShowContextMenu(::owl::mojom::ContextMenuParamsPtr params) = 0;

  virtual void StartDrag(DropDataPtr drop_data, const ::url::Origin& source_origin, uint32_t operation_mask, const ::gfx::ImageSkia& image, const ::gfx::Vector2d& image_offset, bool is_privileged) = 0;

  using StartNativeDragCallback = base::OnceCallback<void()>;
  using StartNativeDragMojoCallback = base::OnceCallback<void()>;

  virtual void StartNativeDrag(const std::string& pasteboard_name, const ::gfx::ImageSkia& image, uint32_t operation, StartNativeDragCallback callback) = 0;

  virtual void UpdateDragOperation(::ui::mojom::DragOperation operation) = 0;
};



class  WebContentProxy
    : public WebContent {
 public:
  using InterfaceType = WebContent;

  explicit WebContentProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetInputMode(InputMode mode) final;
  
  void OnMouseEvent(::std::unique_ptr<::ui::Event> event) final;
  
  void OnBecameFirstResponder(WindowSelectionMethod method) final;
  
  void DraggingEntered(DropDataPtr drop_data, DraggingInfoPtr dragging_info) final;
  
  void DraggingExited() final;
  
  void DraggingUpdated(DraggingInfoPtr dragging_info) final;
  
  void PerformDragOperation(DraggingInfoPtr dragging_info) final;
  
  void EndDrag(uint64_t drag_operation, const ::gfx::PointF& local_point, const ::gfx::PointF& screen_point) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  WebContentClientProxy
    : public WebContentClient {
 public:
  using InterfaceType = WebContentClient;

  explicit WebContentClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateRendererClient(uint64_t id, WebContentRendererType type, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebContentRendererClient> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebContentRenderer> renderer) final;
  
  void TakeFocus(bool reverse) final;
  
  void Destroy() final;
  
  void ShowContextMenu(::owl::mojom::ContextMenuParamsPtr params) final;
  
  void StartDrag(DropDataPtr drop_data, const ::url::Origin& source_origin, uint32_t operation_mask, const ::gfx::ImageSkia& image, const ::gfx::Vector2d& image_offset, bool is_privileged) final;
  
  void StartNativeDrag(const std::string& pasteboard_name, const ::gfx::ImageSkia& image, uint32_t operation, StartNativeDragCallback callback) final;
  
  void UpdateDragOperation(::ui::mojom::DragOperation operation) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  WebContentStubDispatch {
 public:
  static bool Accept(WebContent* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebContent* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebContent>>
class WebContentStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebContentStub() = default;
  ~WebContentStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebContentStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebContentStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebContentClientStubDispatch {
 public:
  static bool Accept(WebContentClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebContentClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebContentClient>>
class WebContentClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebContentClientStub() = default;
  ~WebContentClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebContentClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebContentClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebContentRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebContentClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebContentClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class  FileSystemFileInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileSystemFileInfo, T>::value>;
  using DataView = FileSystemFileInfoDataView;
  using Data_ = internal::FileSystemFileInfo_Data;

  template <typename... Args>
  static FileSystemFileInfoPtr New(Args&&... args) {
    return FileSystemFileInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileSystemFileInfoPtr From(const U& u) {
    return mojo::TypeConverter<FileSystemFileInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileSystemFileInfo>::Convert(*this);
  }


  FileSystemFileInfo();

  FileSystemFileInfo(
      const ::GURL& url,
      int64_t size,
      const std::string& filesystem_id);


  ~FileSystemFileInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileSystemFileInfoPtr>
  FileSystemFileInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileSystemFileInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileSystemFileInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileSystemFileInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemFileInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemFileInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileSystemFileInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileSystemFileInfo_UnserializedMessageContext<
            UserType, FileSystemFileInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileSystemFileInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileSystemFileInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileSystemFileInfo_UnserializedMessageContext<
            UserType, FileSystemFileInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileSystemFileInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  int64_t size;
  
  std::string filesystem_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileSystemFileInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileSystemFileInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileSystemFileInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileSystemFileInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DropData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DropData, T>::value>;
  using DataView = DropDataDataView;
  using Data_ = internal::DropData_Data;

  template <typename... Args>
  static DropDataPtr New(Args&&... args) {
    return DropDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DropDataPtr From(const U& u) {
    return mojo::TypeConverter<DropDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DropData>::Convert(*this);
  }


  DropData();

  DropData(
      const std::optional<::GURL>& url,
      const std::optional<std::string>& url_title,
      const std::optional<std::string>& download_metadata,
      ::network::mojom::ReferrerPolicy referrer_policy,
      std::vector<::base::FilePath> filenames,
      std::vector<std::string> file_mime_types,
      const std::optional<std::string>& filesystem_id,
      std::vector<FileSystemFileInfoPtr> file_system_files,
      const std::optional<std::string>& text,
      const std::optional<std::string>& html,
      const std::optional<::GURL>& html_base_url,
      std::optional<std::vector<uint8_t>> file_contents,
      bool file_contents_image_accessible,
      const std::optional<::GURL>& file_contents_source_url,
      const std::string& file_contents_filename_extension,
      const std::string& file_contents_content_disposition,
      const base::flat_map<std::string, std::string>& custom_data,
      ::ui::mojom::DragOperation operation,
      bool document_is_handling_drag);

DropData(const DropData&) = delete;
DropData& operator=(const DropData&) = delete;

  ~DropData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DropDataPtr>
  DropDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DropData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DropData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DropData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DropData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DropData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DropData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DropData_UnserializedMessageContext<
            UserType, DropData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DropData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DropData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DropData_UnserializedMessageContext<
            UserType, DropData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DropData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::GURL> url;
  
  std::optional<std::string> url_title;
  
  std::optional<std::string> download_metadata;
  
  ::network::mojom::ReferrerPolicy referrer_policy;
  
  std::vector<::base::FilePath> filenames;
  
  std::vector<std::string> file_mime_types;
  
  std::optional<std::string> filesystem_id;
  
  std::vector<FileSystemFileInfoPtr> file_system_files;
  
  std::optional<std::string> text;
  
  std::optional<std::string> html;
  
  std::optional<::GURL> html_base_url;
  
  std::optional<std::vector<uint8_t>> file_contents;
  
  bool file_contents_image_accessible;
  
  std::optional<::GURL> file_contents_source_url;
  
  std::string file_contents_filename_extension;
  
  std::string file_contents_content_disposition;
  
  base::flat_map<std::string, std::string> custom_data;
  
  ::ui::mojom::DragOperation operation;
  
  bool document_is_handling_drag;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DropData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DropData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DropData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DropData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DraggingInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DraggingInfo, T>::value>;
  using DataView = DraggingInfoDataView;
  using Data_ = internal::DraggingInfo_Data;

  template <typename... Args>
  static DraggingInfoPtr New(Args&&... args) {
    return DraggingInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DraggingInfoPtr From(const U& u) {
    return mojo::TypeConverter<DraggingInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DraggingInfo>::Convert(*this);
  }


  DraggingInfo();

  DraggingInfo(
      const ::gfx::PointF& location_in_view,
      const ::gfx::PointF& location_in_screen,
      const std::optional<::GURL>& url,
      uint64_t operation_mask);


  ~DraggingInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DraggingInfoPtr>
  DraggingInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DraggingInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DraggingInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DraggingInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DraggingInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DraggingInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DraggingInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DraggingInfo_UnserializedMessageContext<
            UserType, DraggingInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DraggingInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DraggingInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DraggingInfo_UnserializedMessageContext<
            UserType, DraggingInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DraggingInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::PointF location_in_view;
  
  ::gfx::PointF location_in_screen;
  
  std::optional<::GURL> url;
  
  uint64_t operation_mask;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DraggingInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DraggingInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DraggingInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DraggingInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FileSystemFileInfoPtr FileSystemFileInfo::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(size),
      mojo::Clone(filesystem_id)
  );
}

template <typename T, FileSystemFileInfo::EnableIfSame<T>*>
bool FileSystemFileInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->filesystem_id, other_struct.filesystem_id))
    return false;
  return true;
}

template <typename T, FileSystemFileInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.filesystem_id < rhs.filesystem_id)
    return true;
  if (rhs.filesystem_id < lhs.filesystem_id)
    return false;
  return false;
}
template <typename StructPtrType>
DropDataPtr DropData::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(url_title),
      mojo::Clone(download_metadata),
      mojo::Clone(referrer_policy),
      mojo::Clone(filenames),
      mojo::Clone(file_mime_types),
      mojo::Clone(filesystem_id),
      mojo::Clone(file_system_files),
      mojo::Clone(text),
      mojo::Clone(html),
      mojo::Clone(html_base_url),
      mojo::Clone(file_contents),
      mojo::Clone(file_contents_image_accessible),
      mojo::Clone(file_contents_source_url),
      mojo::Clone(file_contents_filename_extension),
      mojo::Clone(file_contents_content_disposition),
      mojo::Clone(custom_data),
      mojo::Clone(operation),
      mojo::Clone(document_is_handling_drag)
  );
}

template <typename T, DropData::EnableIfSame<T>*>
bool DropData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->url_title, other_struct.url_title))
    return false;
  if (!mojo::Equals(this->download_metadata, other_struct.download_metadata))
    return false;
  if (!mojo::Equals(this->referrer_policy, other_struct.referrer_policy))
    return false;
  if (!mojo::Equals(this->filenames, other_struct.filenames))
    return false;
  if (!mojo::Equals(this->file_mime_types, other_struct.file_mime_types))
    return false;
  if (!mojo::Equals(this->filesystem_id, other_struct.filesystem_id))
    return false;
  if (!mojo::Equals(this->file_system_files, other_struct.file_system_files))
    return false;
  if (!mojo::Equals(this->text, other_struct.text))
    return false;
  if (!mojo::Equals(this->html, other_struct.html))
    return false;
  if (!mojo::Equals(this->html_base_url, other_struct.html_base_url))
    return false;
  if (!mojo::Equals(this->file_contents, other_struct.file_contents))
    return false;
  if (!mojo::Equals(this->file_contents_image_accessible, other_struct.file_contents_image_accessible))
    return false;
  if (!mojo::Equals(this->file_contents_source_url, other_struct.file_contents_source_url))
    return false;
  if (!mojo::Equals(this->file_contents_filename_extension, other_struct.file_contents_filename_extension))
    return false;
  if (!mojo::Equals(this->file_contents_content_disposition, other_struct.file_contents_content_disposition))
    return false;
  if (!mojo::Equals(this->custom_data, other_struct.custom_data))
    return false;
  if (!mojo::Equals(this->operation, other_struct.operation))
    return false;
  if (!mojo::Equals(this->document_is_handling_drag, other_struct.document_is_handling_drag))
    return false;
  return true;
}

template <typename T, DropData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.url_title < rhs.url_title)
    return true;
  if (rhs.url_title < lhs.url_title)
    return false;
  if (lhs.download_metadata < rhs.download_metadata)
    return true;
  if (rhs.download_metadata < lhs.download_metadata)
    return false;
  if (lhs.referrer_policy < rhs.referrer_policy)
    return true;
  if (rhs.referrer_policy < lhs.referrer_policy)
    return false;
  if (lhs.filenames < rhs.filenames)
    return true;
  if (rhs.filenames < lhs.filenames)
    return false;
  if (lhs.file_mime_types < rhs.file_mime_types)
    return true;
  if (rhs.file_mime_types < lhs.file_mime_types)
    return false;
  if (lhs.filesystem_id < rhs.filesystem_id)
    return true;
  if (rhs.filesystem_id < lhs.filesystem_id)
    return false;
  if (lhs.file_system_files < rhs.file_system_files)
    return true;
  if (rhs.file_system_files < lhs.file_system_files)
    return false;
  if (lhs.text < rhs.text)
    return true;
  if (rhs.text < lhs.text)
    return false;
  if (lhs.html < rhs.html)
    return true;
  if (rhs.html < lhs.html)
    return false;
  if (lhs.html_base_url < rhs.html_base_url)
    return true;
  if (rhs.html_base_url < lhs.html_base_url)
    return false;
  if (lhs.file_contents < rhs.file_contents)
    return true;
  if (rhs.file_contents < lhs.file_contents)
    return false;
  if (lhs.file_contents_image_accessible < rhs.file_contents_image_accessible)
    return true;
  if (rhs.file_contents_image_accessible < lhs.file_contents_image_accessible)
    return false;
  if (lhs.file_contents_source_url < rhs.file_contents_source_url)
    return true;
  if (rhs.file_contents_source_url < lhs.file_contents_source_url)
    return false;
  if (lhs.file_contents_filename_extension < rhs.file_contents_filename_extension)
    return true;
  if (rhs.file_contents_filename_extension < lhs.file_contents_filename_extension)
    return false;
  if (lhs.file_contents_content_disposition < rhs.file_contents_content_disposition)
    return true;
  if (rhs.file_contents_content_disposition < lhs.file_contents_content_disposition)
    return false;
  if (lhs.custom_data < rhs.custom_data)
    return true;
  if (rhs.custom_data < lhs.custom_data)
    return false;
  if (lhs.operation < rhs.operation)
    return true;
  if (rhs.operation < lhs.operation)
    return false;
  if (lhs.document_is_handling_drag < rhs.document_is_handling_drag)
    return true;
  if (rhs.document_is_handling_drag < lhs.document_is_handling_drag)
    return false;
  return false;
}
template <typename StructPtrType>
DraggingInfoPtr DraggingInfo::Clone() const {
  return New(
      mojo::Clone(location_in_view),
      mojo::Clone(location_in_screen),
      mojo::Clone(url),
      mojo::Clone(operation_mask)
  );
}

template <typename T, DraggingInfo::EnableIfSame<T>*>
bool DraggingInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->location_in_view, other_struct.location_in_view))
    return false;
  if (!mojo::Equals(this->location_in_screen, other_struct.location_in_screen))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->operation_mask, other_struct.operation_mask))
    return false;
  return true;
}

template <typename T, DraggingInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.location_in_view < rhs.location_in_view)
    return true;
  if (rhs.location_in_view < lhs.location_in_view)
    return false;
  if (lhs.location_in_screen < rhs.location_in_screen)
    return true;
  if (rhs.location_in_screen < lhs.location_in_screen)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.operation_mask < rhs.operation_mask)
    return true;
  if (rhs.operation_mask < lhs.operation_mask)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::FileSystemFileInfo::DataView,
                                         ::owl::mojom::FileSystemFileInfoPtr> {
  static bool IsNull(const ::owl::mojom::FileSystemFileInfoPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::FileSystemFileInfoPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::FileSystemFileInfo::url)& url(
      const ::owl::mojom::FileSystemFileInfoPtr& input) {
    return input->url;
  }

  static decltype(::owl::mojom::FileSystemFileInfo::size) size(
      const ::owl::mojom::FileSystemFileInfoPtr& input) {
    return input->size;
  }

  static const decltype(::owl::mojom::FileSystemFileInfo::filesystem_id)& filesystem_id(
      const ::owl::mojom::FileSystemFileInfoPtr& input) {
    return input->filesystem_id;
  }

  static bool Read(::owl::mojom::FileSystemFileInfo::DataView input, ::owl::mojom::FileSystemFileInfoPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::DropData::DataView,
                                         ::owl::mojom::DropDataPtr> {
  static bool IsNull(const ::owl::mojom::DropDataPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::DropDataPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::DropData::url)& url(
      const ::owl::mojom::DropDataPtr& input) {
    return input->url;
  }

  static const decltype(::owl::mojom::DropData::url_title)& url_title(
      const ::owl::mojom::DropDataPtr& input) {
    return input->url_title;
  }

  static const decltype(::owl::mojom::DropData::download_metadata)& download_metadata(
      const ::owl::mojom::DropDataPtr& input) {
    return input->download_metadata;
  }

  static decltype(::owl::mojom::DropData::referrer_policy) referrer_policy(
      const ::owl::mojom::DropDataPtr& input) {
    return input->referrer_policy;
  }

  static const decltype(::owl::mojom::DropData::filenames)& filenames(
      const ::owl::mojom::DropDataPtr& input) {
    return input->filenames;
  }

  static const decltype(::owl::mojom::DropData::file_mime_types)& file_mime_types(
      const ::owl::mojom::DropDataPtr& input) {
    return input->file_mime_types;
  }

  static const decltype(::owl::mojom::DropData::filesystem_id)& filesystem_id(
      const ::owl::mojom::DropDataPtr& input) {
    return input->filesystem_id;
  }

  static const decltype(::owl::mojom::DropData::file_system_files)& file_system_files(
      const ::owl::mojom::DropDataPtr& input) {
    return input->file_system_files;
  }

  static const decltype(::owl::mojom::DropData::text)& text(
      const ::owl::mojom::DropDataPtr& input) {
    return input->text;
  }

  static const decltype(::owl::mojom::DropData::html)& html(
      const ::owl::mojom::DropDataPtr& input) {
    return input->html;
  }

  static const decltype(::owl::mojom::DropData::html_base_url)& html_base_url(
      const ::owl::mojom::DropDataPtr& input) {
    return input->html_base_url;
  }

  static const decltype(::owl::mojom::DropData::file_contents)& file_contents(
      const ::owl::mojom::DropDataPtr& input) {
    return input->file_contents;
  }

  static decltype(::owl::mojom::DropData::file_contents_image_accessible) file_contents_image_accessible(
      const ::owl::mojom::DropDataPtr& input) {
    return input->file_contents_image_accessible;
  }

  static const decltype(::owl::mojom::DropData::file_contents_source_url)& file_contents_source_url(
      const ::owl::mojom::DropDataPtr& input) {
    return input->file_contents_source_url;
  }

  static const decltype(::owl::mojom::DropData::file_contents_filename_extension)& file_contents_filename_extension(
      const ::owl::mojom::DropDataPtr& input) {
    return input->file_contents_filename_extension;
  }

  static const decltype(::owl::mojom::DropData::file_contents_content_disposition)& file_contents_content_disposition(
      const ::owl::mojom::DropDataPtr& input) {
    return input->file_contents_content_disposition;
  }

  static const decltype(::owl::mojom::DropData::custom_data)& custom_data(
      const ::owl::mojom::DropDataPtr& input) {
    return input->custom_data;
  }

  static decltype(::owl::mojom::DropData::operation) operation(
      const ::owl::mojom::DropDataPtr& input) {
    return input->operation;
  }

  static decltype(::owl::mojom::DropData::document_is_handling_drag) document_is_handling_drag(
      const ::owl::mojom::DropDataPtr& input) {
    return input->document_is_handling_drag;
  }

  static bool Read(::owl::mojom::DropData::DataView input, ::owl::mojom::DropDataPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::DraggingInfo::DataView,
                                         ::owl::mojom::DraggingInfoPtr> {
  static bool IsNull(const ::owl::mojom::DraggingInfoPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::DraggingInfoPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::DraggingInfo::location_in_view)& location_in_view(
      const ::owl::mojom::DraggingInfoPtr& input) {
    return input->location_in_view;
  }

  static const decltype(::owl::mojom::DraggingInfo::location_in_screen)& location_in_screen(
      const ::owl::mojom::DraggingInfoPtr& input) {
    return input->location_in_screen;
  }

  static const decltype(::owl::mojom::DraggingInfo::url)& url(
      const ::owl::mojom::DraggingInfoPtr& input) {
    return input->url;
  }

  static decltype(::owl::mojom::DraggingInfo::operation_mask) operation_mask(
      const ::owl::mojom::DraggingInfoPtr& input) {
    return input->operation_mask;
  }

  static bool Read(::owl::mojom::DraggingInfo::DataView input, ::owl::mojom::DraggingInfoPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_WEB_CONTENT_MOJOM_H_