// owl/mojom/url_loader.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_URL_LOADER_MOJOM_H_
#define OWL_MOJOM_URL_LOADER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/url_loader.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/url_loader.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/url_loader.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class URLLoaderClientProxy;

template <typename ImplRefTraits>
class URLLoaderClientStub;

class URLLoaderClientRequestValidator;


class URLLoaderClient
    : public URLLoaderClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.URLLoaderClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = URLLoaderClientInterfaceBase;
  using Proxy_ = URLLoaderClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = URLLoaderClientStub<ImplRefTraits>;

  using RequestValidator_ = URLLoaderClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnResponseMinVersion = 0,
    kOnDataMinVersion = 0,
    kOnCompleteMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~URLLoaderClient() = default;

  virtual void OnResponse(URLResponsePtr response) = 0;

  virtual void OnData(::mojo_base::BigBuffer data) = 0;

  virtual void OnComplete(URLLoadStatusPtr status) = 0;
};

class URLLoaderProxy;

template <typename ImplRefTraits>
class URLLoaderStub;

class URLLoaderRequestValidator;


class URLLoader
    : public URLLoaderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.URLLoader";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = URLLoaderInterfaceBase;
  using Proxy_ = URLLoaderProxy;

  template <typename ImplRefTraits>
  using Stub_ = URLLoaderStub<ImplRefTraits>;

  using RequestValidator_ = URLLoaderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCancelMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Cancel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~URLLoader() = default;

  virtual void Cancel() = 0;
};

class URLLoaderFactoryProxy;

template <typename ImplRefTraits>
class URLLoaderFactoryStub;

class URLLoaderFactoryRequestValidator;


class URLLoaderFactory
    : public URLLoaderFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.URLLoaderFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = URLLoaderFactoryInterfaceBase;
  using Proxy_ = URLLoaderFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = URLLoaderFactoryStub<ImplRefTraits>;

  using RequestValidator_ = URLLoaderFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateLoaderMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateLoader_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~URLLoaderFactory() = default;

  virtual void CreateLoader(URLRequestPtr request, ::mojo::PendingAssociatedReceiver<URLLoader> loader, ::mojo::PendingAssociatedRemote<URLLoaderClient> client) = 0;
};



class  URLLoaderClientProxy
    : public URLLoaderClient {
 public:
  using InterfaceType = URLLoaderClient;

  explicit URLLoaderClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnResponse(URLResponsePtr response) final;
  
  void OnData(::mojo_base::BigBuffer data) final;
  
  void OnComplete(URLLoadStatusPtr status) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  URLLoaderProxy
    : public URLLoader {
 public:
  using InterfaceType = URLLoader;

  explicit URLLoaderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Cancel() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  URLLoaderFactoryProxy
    : public URLLoaderFactory {
 public:
  using InterfaceType = URLLoaderFactory;

  explicit URLLoaderFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateLoader(URLRequestPtr request, ::mojo::PendingAssociatedReceiver<URLLoader> loader, ::mojo::PendingAssociatedRemote<URLLoaderClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  URLLoaderClientStubDispatch {
 public:
  static bool Accept(URLLoaderClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      URLLoaderClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<URLLoaderClient>>
class URLLoaderClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  URLLoaderClientStub() = default;
  ~URLLoaderClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return URLLoaderClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return URLLoaderClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  URLLoaderStubDispatch {
 public:
  static bool Accept(URLLoader* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      URLLoader* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<URLLoader>>
class URLLoaderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  URLLoaderStub() = default;
  ~URLLoaderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return URLLoaderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return URLLoaderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  URLLoaderFactoryStubDispatch {
 public:
  static bool Accept(URLLoaderFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      URLLoaderFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<URLLoaderFactory>>
class URLLoaderFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  URLLoaderFactoryStub() = default;
  ~URLLoaderFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return URLLoaderFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return URLLoaderFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  URLLoaderClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  URLLoaderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  URLLoaderFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};







class  NetworkError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NetworkError, T>::value>;
  using DataView = NetworkErrorDataView;
  using Data_ = internal::NetworkError_Data;

  template <typename... Args>
  static NetworkErrorPtr New(Args&&... args) {
    return NetworkErrorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NetworkErrorPtr From(const U& u) {
    return mojo::TypeConverter<NetworkErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NetworkError>::Convert(*this);
  }


  NetworkError();

  NetworkError(
      int32_t net_error,
      const std::string& description);


  ~NetworkError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NetworkErrorPtr>
  NetworkErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NetworkError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NetworkError::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NetworkError::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NetworkError::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NetworkError::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NetworkError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NetworkError_UnserializedMessageContext<
            UserType, NetworkError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NetworkError::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NetworkError::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NetworkError_UnserializedMessageContext<
            UserType, NetworkError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NetworkError::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t net_error;
  
  std::string description;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NetworkError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NetworkError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NetworkError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NetworkError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  URLLoadStatus {
 public:
  using DataView = URLLoadStatusDataView;
  using Data_ = internal::URLLoadStatus_Data;
  using Tag = Data_::URLLoadStatus_Tag;

  template <typename... Args>
  static URLLoadStatusPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |ok|.
  static URLLoadStatusPtr NewOk(
      bool value);
  // Construct an instance holding |error|.
  static URLLoadStatusPtr NewError(
      NetworkErrorPtr value);

  template <typename U>
  static URLLoadStatusPtr From(const U& u) {
    return mojo::TypeConverter<URLLoadStatusPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, URLLoadStatus>::Convert(*this);
  }
  ~URLLoadStatus();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  URLLoadStatus(const URLLoadStatus& other) = delete;
  URLLoadStatus& operator=(const URLLoadStatus& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = URLLoadStatusPtr>
  URLLoadStatusPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, URLLoadStatus>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, URLLoadStatus>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_ok() const { return tag_ == Tag::kOk; }
  bool get_ok() const {
    CHECK(tag_ == Tag::kOk);
    return data_.ok;
  }
  void set_ok(bool ok);

  bool is_error() const { return tag_ == Tag::kError; }
  const NetworkErrorPtr& get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  NetworkErrorPtr& get_error() {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  void set_error(NetworkErrorPtr error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        URLLoadStatus::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<URLLoadStatus::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kOk)>,
        bool value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
        NetworkErrorPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    bool ok;
    NetworkErrorPtr error;
  };

  URLLoadStatus(
      std::in_place_index_t<static_cast<size_t>(Tag::kOk)>,
      bool value);
  URLLoadStatus(
      std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
      NetworkErrorPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  URLRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<URLRequest, T>::value>;
  using DataView = URLRequestDataView;
  using Data_ = internal::URLRequest_Data;

  template <typename... Args>
  static URLRequestPtr New(Args&&... args) {
    return URLRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static URLRequestPtr From(const U& u) {
    return mojo::TypeConverter<URLRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, URLRequest>::Convert(*this);
  }


  URLRequest();

  URLRequest(
      const ::GURL& url,
      const std::string& method,
      const base::flat_map<std::string, std::string>& headers,
      std::optional<::mojo_base::BigBuffer> body,
      std::optional<::base::TimeDelta> timeout);

URLRequest(const URLRequest&) = delete;
URLRequest& operator=(const URLRequest&) = delete;

  ~URLRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = URLRequestPtr>
  URLRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, URLRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, URLRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, URLRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        URLRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::URLRequest_UnserializedMessageContext<
            UserType, URLRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<URLRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return URLRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::URLRequest_UnserializedMessageContext<
            UserType, URLRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<URLRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  std::string method;
  
  base::flat_map<std::string, std::string> headers;
  
  std::optional<::mojo_base::BigBuffer> body;
  
  std::optional<::base::TimeDelta> timeout;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, URLRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, URLRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, URLRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, URLRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  URLResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<URLResponse, T>::value>;
  using DataView = URLResponseDataView;
  using Data_ = internal::URLResponse_Data;

  template <typename... Args>
  static URLResponsePtr New(Args&&... args) {
    return URLResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static URLResponsePtr From(const U& u) {
    return mojo::TypeConverter<URLResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, URLResponse>::Convert(*this);
  }


  URLResponse();

  URLResponse(
      const ::GURL& url,
      int32_t status_code,
      const base::flat_map<std::string, std::string>& headers,
      const std::optional<std::string>& mime_type,
      std::optional<int64_t> expected_content_length);


  ~URLResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = URLResponsePtr>
  URLResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, URLResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, URLResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, URLResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        URLResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        URLResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        URLResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::URLResponse_UnserializedMessageContext<
            UserType, URLResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<URLResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return URLResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::URLResponse_UnserializedMessageContext<
            UserType, URLResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<URLResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  int32_t status_code;
  
  base::flat_map<std::string, std::string> headers;
  
  std::optional<std::string> mime_type;
  
  std::optional<int64_t> expected_content_length;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, URLResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, URLResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, URLResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, URLResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename UnionPtrType>
URLLoadStatusPtr URLLoadStatus::Clone() const {
  switch (tag_) {
    case Tag::kOk:
      return NewOk(
          mojo::Clone(data_.ok));
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, URLLoadStatus>::value>::type*>
bool URLLoadStatus::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kOk:
      return mojo::Equals(data_.ok, other.data_.ok);
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
  }

  return false;
}
template <typename StructPtrType>
URLRequestPtr URLRequest::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(method),
      mojo::Clone(headers),
      mojo::Clone(body),
      mojo::Clone(timeout)
  );
}

template <typename T, URLRequest::EnableIfSame<T>*>
bool URLRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->method, other_struct.method))
    return false;
  if (!mojo::Equals(this->headers, other_struct.headers))
    return false;
  if (!mojo::Equals(this->body, other_struct.body))
    return false;
  if (!mojo::Equals(this->timeout, other_struct.timeout))
    return false;
  return true;
}

template <typename T, URLRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.method < rhs.method)
    return true;
  if (rhs.method < lhs.method)
    return false;
  if (lhs.headers < rhs.headers)
    return true;
  if (rhs.headers < lhs.headers)
    return false;
  if (lhs.body < rhs.body)
    return true;
  if (rhs.body < lhs.body)
    return false;
  if (lhs.timeout < rhs.timeout)
    return true;
  if (rhs.timeout < lhs.timeout)
    return false;
  return false;
}
template <typename StructPtrType>
URLResponsePtr URLResponse::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(status_code),
      mojo::Clone(headers),
      mojo::Clone(mime_type),
      mojo::Clone(expected_content_length)
  );
}

template <typename T, URLResponse::EnableIfSame<T>*>
bool URLResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->status_code, other_struct.status_code))
    return false;
  if (!mojo::Equals(this->headers, other_struct.headers))
    return false;
  if (!mojo::Equals(this->mime_type, other_struct.mime_type))
    return false;
  if (!mojo::Equals(this->expected_content_length, other_struct.expected_content_length))
    return false;
  return true;
}

template <typename T, URLResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.status_code < rhs.status_code)
    return true;
  if (rhs.status_code < lhs.status_code)
    return false;
  if (lhs.headers < rhs.headers)
    return true;
  if (rhs.headers < lhs.headers)
    return false;
  if (lhs.mime_type < rhs.mime_type)
    return true;
  if (rhs.mime_type < lhs.mime_type)
    return false;
  if (lhs.expected_content_length < rhs.expected_content_length)
    return true;
  if (rhs.expected_content_length < lhs.expected_content_length)
    return false;
  return false;
}
template <typename StructPtrType>
NetworkErrorPtr NetworkError::Clone() const {
  return New(
      mojo::Clone(net_error),
      mojo::Clone(description)
  );
}

template <typename T, NetworkError::EnableIfSame<T>*>
bool NetworkError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->net_error, other_struct.net_error))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  return true;
}

template <typename T, NetworkError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.net_error < rhs.net_error)
    return true;
  if (rhs.net_error < lhs.net_error)
    return false;
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::URLRequest::DataView,
                                         ::owl::mojom::URLRequestPtr> {
  static bool IsNull(const ::owl::mojom::URLRequestPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::URLRequestPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::URLRequest::url)& url(
      const ::owl::mojom::URLRequestPtr& input) {
    return input->url;
  }

  static const decltype(::owl::mojom::URLRequest::method)& method(
      const ::owl::mojom::URLRequestPtr& input) {
    return input->method;
  }

  static const decltype(::owl::mojom::URLRequest::headers)& headers(
      const ::owl::mojom::URLRequestPtr& input) {
    return input->headers;
  }

  static  decltype(::owl::mojom::URLRequest::body)& body(
       ::owl::mojom::URLRequestPtr& input) {
    return input->body;
  }

  static const decltype(::owl::mojom::URLRequest::timeout)& timeout(
      const ::owl::mojom::URLRequestPtr& input) {
    return input->timeout;
  }

  static bool Read(::owl::mojom::URLRequest::DataView input, ::owl::mojom::URLRequestPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::URLResponse::DataView,
                                         ::owl::mojom::URLResponsePtr> {
  static bool IsNull(const ::owl::mojom::URLResponsePtr& input) { return !input; }
  static void SetToNull(::owl::mojom::URLResponsePtr* output) { output->reset(); }

  static const decltype(::owl::mojom::URLResponse::url)& url(
      const ::owl::mojom::URLResponsePtr& input) {
    return input->url;
  }

  static decltype(::owl::mojom::URLResponse::status_code) status_code(
      const ::owl::mojom::URLResponsePtr& input) {
    return input->status_code;
  }

  static const decltype(::owl::mojom::URLResponse::headers)& headers(
      const ::owl::mojom::URLResponsePtr& input) {
    return input->headers;
  }

  static const decltype(::owl::mojom::URLResponse::mime_type)& mime_type(
      const ::owl::mojom::URLResponsePtr& input) {
    return input->mime_type;
  }

  static decltype(::owl::mojom::URLResponse::expected_content_length) expected_content_length(
      const ::owl::mojom::URLResponsePtr& input) {
    return input->expected_content_length;
  }

  static bool Read(::owl::mojom::URLResponse::DataView input, ::owl::mojom::URLResponsePtr* output);
};


template <>
struct  StructTraits<::owl::mojom::NetworkError::DataView,
                                         ::owl::mojom::NetworkErrorPtr> {
  static bool IsNull(const ::owl::mojom::NetworkErrorPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::NetworkErrorPtr* output) { output->reset(); }

  static decltype(::owl::mojom::NetworkError::net_error) net_error(
      const ::owl::mojom::NetworkErrorPtr& input) {
    return input->net_error;
  }

  static const decltype(::owl::mojom::NetworkError::description)& description(
      const ::owl::mojom::NetworkErrorPtr& input) {
    return input->description;
  }

  static bool Read(::owl::mojom::NetworkError::DataView input, ::owl::mojom::NetworkErrorPtr* output);
};


template <>
struct  UnionTraits<::owl::mojom::URLLoadStatus::DataView,
                                        ::owl::mojom::URLLoadStatusPtr> {
  static bool IsNull(const ::owl::mojom::URLLoadStatusPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::URLLoadStatusPtr* output) { output->reset(); }

  static ::owl::mojom::URLLoadStatus::Tag GetTag(const ::owl::mojom::URLLoadStatusPtr& input) {
    return input->which();
  }

  static  bool ok(const ::owl::mojom::URLLoadStatusPtr& input) {
    return input->get_ok();
  }

  static const ::owl::mojom::NetworkErrorPtr& error(const ::owl::mojom::URLLoadStatusPtr& input) {
    return input->get_error();
  }

  static bool Read(::owl::mojom::URLLoadStatus::DataView input, ::owl::mojom::URLLoadStatusPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_URL_LOADER_MOJOM_H_