// owl/mojom/url_loader.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/url_loader.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/url_loader.mojom-params-data.h"
#include "owl/mojom/url_loader.mojom-shared-message-ids.h"

#include "owl/mojom/url_loader.mojom-import-headers.h"
#include "owl/mojom/url_loader.mojom-test-utils.h"


namespace owl::mojom {
URLRequest::URLRequest()
    : url(),
      method(),
      headers(),
      body(),
      timeout() {}

URLRequest::URLRequest(
    const ::GURL& url_in,
    const std::string& method_in,
    const base::flat_map<std::string, std::string>& headers_in,
    std::optional<::mojo_base::BigBuffer> body_in,
    std::optional<::base::TimeDelta> timeout_in)
    : url(std::move(url_in)),
      method(std::move(method_in)),
      headers(std::move(headers_in)),
      body(std::move(body_in)),
      timeout(std::move(timeout_in)) {}

URLRequest::~URLRequest() = default;

void URLRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method"), this->method,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers"), this->headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "body"), this->body,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::mojo_base::BigBuffer>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timeout"), this->timeout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool URLRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
URLResponse::URLResponse()
    : url(),
      status_code(),
      headers(),
      mime_type(),
      expected_content_length() {}

URLResponse::URLResponse(
    const ::GURL& url_in,
    int32_t status_code_in,
    const base::flat_map<std::string, std::string>& headers_in,
    const std::optional<std::string>& mime_type_in,
    std::optional<int64_t> expected_content_length_in)
    : url(std::move(url_in)),
      status_code(std::move(status_code_in)),
      headers(std::move(headers_in)),
      mime_type(std::move(mime_type_in)),
      expected_content_length(std::move(expected_content_length_in)) {}

URLResponse::~URLResponse() = default;

void URLResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status_code"), this->status_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers"), this->headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mime_type"), this->mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expected_content_length"), this->expected_content_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int64_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool URLResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NetworkError::NetworkError()
    : net_error(),
      description() {}

NetworkError::NetworkError(
    int32_t net_error_in,
    const std::string& description_in)
    : net_error(std::move(net_error_in)),
      description(std::move(description_in)) {}

NetworkError::~NetworkError() = default;
size_t NetworkError::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->net_error);
  seed = mojo::internal::Hash(seed, this->description);
  return seed;
}

void NetworkError::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "net_error"), this->net_error,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NetworkError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
URLLoadStatusPtr
URLLoadStatus::NewOk(
    bool value) {
  return URLLoadStatusPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kOk)>,
      std::move(value));
}

URLLoadStatusPtr
URLLoadStatus::NewError(
    NetworkErrorPtr value) {
  return URLLoadStatusPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kError)>,
      std::move(value));
}

URLLoadStatus::URLLoadStatus(
    std::in_place_index_t<static_cast<size_t>(Tag::kOk)>,
    bool value)
    : tag_(Tag::kOk),
      data_(std::in_place_index<static_cast<size_t>(Tag::kOk)>,
            std::move(value)) {}

URLLoadStatus::URLLoadStatus(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    NetworkErrorPtr value)
    : tag_(Tag::kError),
      data_(std::in_place_index<static_cast<size_t>(Tag::kError)>,
            std::move(value)) {}
URLLoadStatus::~URLLoadStatus() {
  DestroyActive();
}

void URLLoadStatus::set_ok(bool ok) {
  if (tag_ != Tag::kOk) {
    DestroyActive();
    tag_ = Tag::kOk;
  }
  data_.ok = ok;
}

void URLLoadStatus::set_error(NetworkErrorPtr error) {
  if (tag_ == Tag::kError) {
    data_.error = std::move(error);
  } else {
    DestroyActive();
    tag_ = Tag::kError;
    new (&data_.error) NetworkErrorPtr(
        std::move(error));
  }
}


URLLoadStatus::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kOk)>,
    bool value)
    : ok(std::move(value)) {}

URLLoadStatus::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    NetworkErrorPtr value)
    : error(std::move(value)) {}

void URLLoadStatus::DestroyActive() {
  switch (tag_) {

    case Tag::kOk:
      std::destroy_at(&data_.ok);
      break;
    case Tag::kError:
      std::destroy_at(&data_.error);
      break;
  }
}
size_t URLLoadStatus::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kOk:
      return mojo::internal::Hash(seed, data_.ok);
    case Tag::kError:
      return mojo::internal::Hash(seed, data_.error);
    default:
      NOTREACHED();
  }
}

bool URLLoadStatus::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

URLLoaderClient::IPCStableHashFunction URLLoaderClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::URLLoaderClient>(message.name())) {
    case messages::URLLoaderClient::kOnResponse: {
      return &URLLoaderClient::OnResponse_Sym::IPCStableHash;
    }
    case messages::URLLoaderClient::kOnData: {
      return &URLLoaderClient::OnData_Sym::IPCStableHash;
    }
    case messages::URLLoaderClient::kOnComplete: {
      return &URLLoaderClient::OnComplete_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* URLLoaderClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::URLLoaderClient>(message.name())) {
      case messages::URLLoaderClient::kOnResponse:
            return "Receive owl::mojom::URLLoaderClient::OnResponse";
      case messages::URLLoaderClient::kOnData:
            return "Receive owl::mojom::URLLoaderClient::OnData";
      case messages::URLLoaderClient::kOnComplete:
            return "Receive owl::mojom::URLLoaderClient::OnComplete";
    }
  } else {
    switch (static_cast<messages::URLLoaderClient>(message.name())) {
      case messages::URLLoaderClient::kOnResponse:
            return "Receive reply owl::mojom::URLLoaderClient::OnResponse";
      case messages::URLLoaderClient::kOnData:
            return "Receive reply owl::mojom::URLLoaderClient::OnData";
      case messages::URLLoaderClient::kOnComplete:
            return "Receive reply owl::mojom::URLLoaderClient::OnComplete";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t URLLoaderClient::OnResponse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x191e9b21;  // IPCStableHash for owl::mojom::URLLoaderClient::OnResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t URLLoaderClient::OnData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbb9f27fa;  // IPCStableHash for owl::mojom::URLLoaderClient::OnData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t URLLoaderClient::OnComplete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x25103914;  // IPCStableHash for owl::mojom::URLLoaderClient::OnComplete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

URLLoaderClientProxy::URLLoaderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void URLLoaderClientProxy::OnResponse(
    URLResponsePtr in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::URLLoaderClient::OnResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type URLResponsePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderClient::kOnResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::URLLoaderClient_OnResponse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::URLResponseDataView>(
    in_response,
    response_fragment);

  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response in URLLoaderClient.OnResponse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void URLLoaderClientProxy::OnData(
    ::mojo_base::BigBuffer in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::URLLoaderClient::OnData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderClient::kOnData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::URLLoaderClient_OnData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_data,
    data_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in URLLoaderClient.OnData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void URLLoaderClientProxy::OnComplete(
    URLLoadStatusPtr in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::URLLoaderClient::OnComplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type URLLoadStatusPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderClient::kOnComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::URLLoaderClient_OnComplete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->status)>
      status_fragment(params.message());
  status_fragment.Claim(&params->status);
  
  mojo::internal::Serialize<::owl::mojom::URLLoadStatusDataView>(
    in_status,
    status_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in URLLoaderClient.OnComplete request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool URLLoaderClientStubDispatch::Accept(
    URLLoaderClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::URLLoaderClient>(message->header()->name)) {
    case messages::URLLoaderClient::kOnResponse: {
      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnResponse_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnResponse_Params_Data*>(
              message->mutable_payload());
      

      // Validation for URLLoaderClient.0
      bool success = true;
      URLResponsePtr p_response{};
      URLLoaderClient_OnResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResponse(&p_response))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnResponse(        
        std::move(p_response));
      return true;
    }
    case messages::URLLoaderClient::kOnData: {
      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnData_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnData_Params_Data*>(
              message->mutable_payload());
      

      // Validation for URLLoaderClient.1
      bool success = true;
      ::mojo_base::BigBuffer p_data{};
      URLLoaderClient_OnData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnData(        
        std::move(p_data));
      return true;
    }
    case messages::URLLoaderClient::kOnComplete: {
      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnComplete_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnComplete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for URLLoaderClient.2
      bool success = true;
      URLLoadStatusPtr p_status{};
      URLLoaderClient_OnComplete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnComplete(        
        std::move(p_status));
      return true;
    }
  }
  return false;
}

// static
bool URLLoaderClientStubDispatch::AcceptWithResponder(
    URLLoaderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::URLLoaderClient>(message->header()->name)) {
    case messages::URLLoaderClient::kOnResponse: {
      break;
    }
    case messages::URLLoaderClient::kOnData: {
      break;
    }
    case messages::URLLoaderClient::kOnComplete: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kURLLoaderClientValidationInfo[] = {
    { &internal::URLLoaderClient_OnResponse_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::URLLoaderClient_OnData_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::URLLoaderClient_OnComplete_Params_Data::Validate,
     nullptr /* no response */},
};

bool URLLoaderClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::URLLoaderClient::Name_,
    kURLLoaderClientValidationInfo);
}

// The declaration includes the definition on other builds.

URLLoader::IPCStableHashFunction URLLoader::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::URLLoader>(message.name())) {
    case messages::URLLoader::kCancel: {
      return &URLLoader::Cancel_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* URLLoader::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::URLLoader>(message.name())) {
      case messages::URLLoader::kCancel:
            return "Receive owl::mojom::URLLoader::Cancel";
    }
  } else {
    switch (static_cast<messages::URLLoader>(message.name())) {
      case messages::URLLoader::kCancel:
            return "Receive reply owl::mojom::URLLoader::Cancel";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t URLLoader::Cancel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x11cf97f5;  // IPCStableHash for owl::mojom::URLLoader::Cancel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

URLLoaderProxy::URLLoaderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void URLLoaderProxy::Cancel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::URLLoader::Cancel");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoader::kCancel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::URLLoader_Cancel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoader::Name_);
  message.set_method_name("Cancel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool URLLoaderStubDispatch::Accept(
    URLLoader* impl,
    mojo::Message* message) {
  switch (static_cast<messages::URLLoader>(message->header()->name)) {
    case messages::URLLoader::kCancel: {
      DCHECK(message->is_serialized());
      internal::URLLoader_Cancel_Params_Data* params =
          reinterpret_cast<internal::URLLoader_Cancel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for URLLoader.0
      bool success = true;
      URLLoader_Cancel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoader::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel(        );
      return true;
    }
  }
  return false;
}

// static
bool URLLoaderStubDispatch::AcceptWithResponder(
    URLLoader* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::URLLoader>(message->header()->name)) {
    case messages::URLLoader::kCancel: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kURLLoaderValidationInfo[] = {
    { &internal::URLLoader_Cancel_Params_Data::Validate,
     nullptr /* no response */},
};

bool URLLoaderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::URLLoader::Name_,
    kURLLoaderValidationInfo);
}

// The declaration includes the definition on other builds.

URLLoaderFactory::IPCStableHashFunction URLLoaderFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::URLLoaderFactory>(message.name())) {
    case messages::URLLoaderFactory::kCreateLoader: {
      return &URLLoaderFactory::CreateLoader_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* URLLoaderFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::URLLoaderFactory>(message.name())) {
      case messages::URLLoaderFactory::kCreateLoader:
            return "Receive owl::mojom::URLLoaderFactory::CreateLoader";
    }
  } else {
    switch (static_cast<messages::URLLoaderFactory>(message.name())) {
      case messages::URLLoaderFactory::kCreateLoader:
            return "Receive reply owl::mojom::URLLoaderFactory::CreateLoader";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t URLLoaderFactory::CreateLoader_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbb1498f8;  // IPCStableHash for owl::mojom::URLLoaderFactory::CreateLoader
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

URLLoaderFactoryProxy::URLLoaderFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void URLLoaderFactoryProxy::CreateLoader(
    URLRequestPtr in_request, ::mojo::PendingAssociatedReceiver<URLLoader> in_loader, ::mojo::PendingAssociatedRemote<URLLoaderClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::URLLoaderFactory::CreateLoader", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type URLRequestPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("loader"), in_loader,
                        "<value of type ::mojo::PendingAssociatedReceiver<URLLoader>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<URLLoaderClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderFactory::kCreateLoader), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::URLLoaderFactory_CreateLoader_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::URLRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in URLLoaderFactory.CreateLoader request");

  
  mojo::internal::Serialize<::owl::mojom::URLLoaderAssociatedRequestDataView>(
    in_loader,
    &params->loader,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->loader)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid loader in URLLoaderFactory.CreateLoader request");

  
  mojo::internal::Serialize<::owl::mojom::URLLoaderClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in URLLoaderFactory.CreateLoader request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderFactory::Name_);
  message.set_method_name("CreateLoader");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool URLLoaderFactoryStubDispatch::Accept(
    URLLoaderFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::URLLoaderFactory>(message->header()->name)) {
    case messages::URLLoaderFactory::kCreateLoader: {
      DCHECK(message->is_serialized());
      internal::URLLoaderFactory_CreateLoader_Params_Data* params =
          reinterpret_cast<internal::URLLoaderFactory_CreateLoader_Params_Data*>(
              message->mutable_payload());
      

      // Validation for URLLoaderFactory.0
      bool success = true;
      URLRequestPtr p_request{};
      ::mojo::PendingAssociatedReceiver<URLLoader> p_loader{};
      ::mojo::PendingAssociatedRemote<URLLoaderClient> p_client{};
      URLLoaderFactory_CreateLoader_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (success) {
        p_loader =
            input_data_view.TakeLoader<decltype(p_loader)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateLoader(        
        std::move(p_request), 
        std::move(p_loader), 
        std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool URLLoaderFactoryStubDispatch::AcceptWithResponder(
    URLLoaderFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::URLLoaderFactory>(message->header()->name)) {
    case messages::URLLoaderFactory::kCreateLoader: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kURLLoaderFactoryValidationInfo[] = {
    { &internal::URLLoaderFactory_CreateLoader_Params_Data::Validate,
     nullptr /* no response */},
};

bool URLLoaderFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::URLLoaderFactory::Name_,
    kURLLoaderFactoryValidationInfo);
}



}  // owl::mojom


namespace mojo {


// static
bool StructTraits<::owl::mojom::URLRequest::DataView, ::owl::mojom::URLRequestPtr>::Read(
    ::owl::mojom::URLRequest::DataView input,
    ::owl::mojom::URLRequestPtr* output) {
  bool success = true;
  ::owl::mojom::URLRequestPtr result(::owl::mojom::URLRequest::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadMethod(&result->method))
        success = false;
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success && !input.ReadBody(&result->body))
        success = false;
      if (success && !input.ReadTimeout(&result->timeout))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::URLResponse::DataView, ::owl::mojom::URLResponsePtr>::Read(
    ::owl::mojom::URLResponse::DataView input,
    ::owl::mojom::URLResponsePtr* output) {
  bool success = true;
  ::owl::mojom::URLResponsePtr result(::owl::mojom::URLResponse::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->status_code = input.status_code();
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success && !input.ReadMimeType(&result->mime_type))
        success = false;
      if (success) {
        result->expected_content_length = input.expected_content_length();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::NetworkError::DataView, ::owl::mojom::NetworkErrorPtr>::Read(
    ::owl::mojom::NetworkError::DataView input,
    ::owl::mojom::NetworkErrorPtr* output) {
  bool success = true;
  ::owl::mojom::NetworkErrorPtr result(::owl::mojom::NetworkError::New());
  
      if (success)
        result->net_error = input.net_error();
      if (success && !input.ReadDescription(&result->description))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::owl::mojom::URLLoadStatus::DataView, ::owl::mojom::URLLoadStatusPtr>::Read(
    ::owl::mojom::URLLoadStatus::DataView input,
    ::owl::mojom::URLLoadStatusPtr* output) {
  using UnionType = ::owl::mojom::URLLoadStatus;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kOk: {
      *output = UnionType::NewOk(input.ok());
      break;
    }
    case Tag::kError: {
      ::owl::mojom::NetworkErrorPtr result_error{};
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(
          std::move(result_error));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void URLLoaderClientInterceptorForTesting::OnResponse(URLResponsePtr response) {
  GetForwardingInterface()->OnResponse(
    std::move(response)
    );
}
void URLLoaderClientInterceptorForTesting::OnData(::mojo_base::BigBuffer data) {
  GetForwardingInterface()->OnData(
    std::move(data)
    );
}
void URLLoaderClientInterceptorForTesting::OnComplete(URLLoadStatusPtr status) {
  GetForwardingInterface()->OnComplete(
    std::move(status)
    );
}
URLLoaderClientAsyncWaiter::URLLoaderClientAsyncWaiter(
    URLLoaderClient* proxy) : proxy_(proxy) {}

URLLoaderClientAsyncWaiter::~URLLoaderClientAsyncWaiter() = default;





void URLLoaderInterceptorForTesting::Cancel() {
  GetForwardingInterface()->Cancel();
}
URLLoaderAsyncWaiter::URLLoaderAsyncWaiter(
    URLLoader* proxy) : proxy_(proxy) {}

URLLoaderAsyncWaiter::~URLLoaderAsyncWaiter() = default;





void URLLoaderFactoryInterceptorForTesting::CreateLoader(URLRequestPtr request, ::mojo::PendingAssociatedReceiver<URLLoader> loader, ::mojo::PendingAssociatedRemote<URLLoaderClient> client) {
  GetForwardingInterface()->CreateLoader(
    std::move(request)
    , 
    std::move(loader)
    , 
    std::move(client)
    );
}
URLLoaderFactoryAsyncWaiter::URLLoaderFactoryAsyncWaiter(
    URLLoaderFactory* proxy) : proxy_(proxy) {}

URLLoaderFactoryAsyncWaiter::~URLLoaderFactoryAsyncWaiter() = default;







}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif