// owl/mojom/url_loader.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_URL_LOADER_MOJOM_PARAMS_DATA_H_
#define OWL_MOJOM_URL_LOADER_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace owl::mojom {
namespace internal {
class  URLLoaderClient_OnResponse_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::URLResponse_Data> response;

 private:
  friend class mojo::internal::MessageFragment<URLLoaderClient_OnResponse_Params_Data>;

  URLLoaderClient_OnResponse_Params_Data();
  ~URLLoaderClient_OnResponse_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderClient_OnResponse_Params_Data) == 16,
              "Bad sizeof(URLLoaderClient_OnResponse_Params_Data)");
class  URLLoaderClient_OnData_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  ::mojo_base::mojom::internal::BigBuffer_Data data;

 private:
  friend class mojo::internal::MessageFragment<URLLoaderClient_OnData_Params_Data>;

  URLLoaderClient_OnData_Params_Data();
  ~URLLoaderClient_OnData_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderClient_OnData_Params_Data) == 24,
              "Bad sizeof(URLLoaderClient_OnData_Params_Data)");
class  URLLoaderClient_OnComplete_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::URLLoadStatus_Data status;

 private:
  friend class mojo::internal::MessageFragment<URLLoaderClient_OnComplete_Params_Data>;

  URLLoaderClient_OnComplete_Params_Data();
  ~URLLoaderClient_OnComplete_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderClient_OnComplete_Params_Data) == 24,
              "Bad sizeof(URLLoaderClient_OnComplete_Params_Data)");
class  URLLoader_Cancel_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<URLLoader_Cancel_Params_Data>;

  URLLoader_Cancel_Params_Data();
  ~URLLoader_Cancel_Params_Data() = delete;
};
static_assert(sizeof(URLLoader_Cancel_Params_Data) == 8,
              "Bad sizeof(URLLoader_Cancel_Params_Data)");
class  URLLoaderFactory_CreateLoader_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::URLRequest_Data> request;
  mojo::internal::AssociatedEndpointHandle_Data loader;
  mojo::internal::AssociatedInterface_Data client;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<URLLoaderFactory_CreateLoader_Params_Data>;

  URLLoaderFactory_CreateLoader_Params_Data();
  ~URLLoaderFactory_CreateLoader_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderFactory_CreateLoader_Params_Data) == 32,
              "Bad sizeof(URLLoaderFactory_CreateLoader_Params_Data)");

}  // namespace internal


class URLLoaderClient_OnResponse_ParamsDataView {
 public:
  URLLoaderClient_OnResponse_ParamsDataView() = default;

  URLLoaderClient_OnResponse_ParamsDataView(
      internal::URLLoaderClient_OnResponse_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResponseDataView(
      URLResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponse(UserType* output) {
    
    auto* pointer = data_->response.Get();
    return mojo::internal::Deserialize<::owl::mojom::URLResponseDataView>(
        pointer, output, message_);
  }
 private:
  internal::URLLoaderClient_OnResponse_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLLoaderClient_OnData_ParamsDataView {
 public:
  URLLoaderClient_OnData_ParamsDataView() = default;

  URLLoaderClient_OnData_ParamsDataView(
      internal::URLLoaderClient_OnData_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::URLLoaderClient_OnData_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLLoaderClient_OnComplete_ParamsDataView {
 public:
  URLLoaderClient_OnComplete_ParamsDataView() = default;

  URLLoaderClient_OnComplete_ParamsDataView(
      internal::URLLoaderClient_OnComplete_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStatusDataView(
      URLLoadStatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) {
    
    auto* pointer = !data_->status.is_null() ? &data_->status : nullptr;
    return mojo::internal::Deserialize<::owl::mojom::URLLoadStatusDataView>(
        pointer, output, message_);
  }
 private:
  internal::URLLoaderClient_OnComplete_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLLoader_Cancel_ParamsDataView {
 public:
  URLLoader_Cancel_ParamsDataView() = default;

  URLLoader_Cancel_ParamsDataView(
      internal::URLLoader_Cancel_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::URLLoader_Cancel_Params_Data* data_ = nullptr;
};


class URLLoaderFactory_CreateLoader_ParamsDataView {
 public:
  URLLoaderFactory_CreateLoader_ParamsDataView() = default;

  URLLoaderFactory_CreateLoader_ParamsDataView(
      internal::URLLoaderFactory_CreateLoader_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestDataView(
      URLRequestDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequest(UserType* output) {
    
    auto* pointer = data_->request.Get();
    return mojo::internal::Deserialize<::owl::mojom::URLRequestDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeLoader() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::owl::mojom::URLLoaderAssociatedRequestDataView>(
            &data_->loader, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::owl::mojom::URLLoaderClientAssociatedPtrInfoDataView>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::URLLoaderFactory_CreateLoader_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void URLLoaderClient_OnResponse_ParamsDataView::GetResponseDataView(
    URLResponseDataView* output) {
  auto pointer = data_->response.Get();
  *output = URLResponseDataView(pointer, message_);
}


inline void URLLoaderClient_OnData_ParamsDataView::GetDataDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->data;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}


inline void URLLoaderClient_OnComplete_ParamsDataView::GetStatusDataView(
    URLLoadStatusDataView* output) {
  auto pointer = &data_->status;
  *output = URLLoadStatusDataView(pointer, message_);
}




inline void URLLoaderFactory_CreateLoader_ParamsDataView::GetRequestDataView(
    URLRequestDataView* output) {
  auto pointer = data_->request.Get();
  *output = URLRequestDataView(pointer, message_);
}



}  // owl::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // OWL_MOJOM_URL_LOADER_MOJOM_PARAMS_DATA_H_