// owl/mojom/url_loader.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_URL_LOADER_MOJOM_DATA_VIEW_H_
#define OWL_MOJOM_URL_LOADER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "owl/mojom/url_loader.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace owl::mojom {
class URLRequestDataView;

class URLResponseDataView;

class NetworkErrorDataView;

class URLLoadStatusDataView;


}  // owl::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::owl::mojom::URLRequestDataView> {
  using Data = ::owl::mojom::internal::URLRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::URLResponseDataView> {
  using Data = ::owl::mojom::internal::URLResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::NetworkErrorDataView> {
  using Data = ::owl::mojom::internal::NetworkError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::URLLoadStatusDataView> {
  using Data = ::owl::mojom::internal::URLLoadStatus_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace owl::mojom {
// Interface base classes. They are used for type safety check.
class URLLoaderClientInterfaceBase {};

using URLLoaderClientPtrDataView =
    mojo::InterfacePtrDataView<URLLoaderClientInterfaceBase>;
using URLLoaderClientRequestDataView =
    mojo::InterfaceRequestDataView<URLLoaderClientInterfaceBase>;
using URLLoaderClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<URLLoaderClientInterfaceBase>;
using URLLoaderClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<URLLoaderClientInterfaceBase>;
class URLLoaderInterfaceBase {};

using URLLoaderPtrDataView =
    mojo::InterfacePtrDataView<URLLoaderInterfaceBase>;
using URLLoaderRequestDataView =
    mojo::InterfaceRequestDataView<URLLoaderInterfaceBase>;
using URLLoaderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<URLLoaderInterfaceBase>;
using URLLoaderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<URLLoaderInterfaceBase>;
class URLLoaderFactoryInterfaceBase {};

using URLLoaderFactoryPtrDataView =
    mojo::InterfacePtrDataView<URLLoaderFactoryInterfaceBase>;
using URLLoaderFactoryRequestDataView =
    mojo::InterfaceRequestDataView<URLLoaderFactoryInterfaceBase>;
using URLLoaderFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<URLLoaderFactoryInterfaceBase>;
using URLLoaderFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<URLLoaderFactoryInterfaceBase>;


class URLRequestDataView {
 public:
  URLRequestDataView() = default;

  URLRequestDataView(
      internal::URLRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethod(UserType* output) {
    
    auto* pointer = data_->method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetHeadersDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetBodyDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBody(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::BigBufferDataView, UserType>(),
    "Attempting to read the optional `body` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBody` instead "
    "of `ReadBody if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->body.is_null() ? &data_->body : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
  inline void GetTimeoutDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeout(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `timeout` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTimeout` instead "
    "of `ReadTimeout if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->timeout.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::URLRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLResponseDataView {
 public:
  URLResponseDataView() = default;

  URLResponseDataView(
      internal::URLResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  int32_t status_code() const {
    return data_->status_code;
  }
  inline void GetHeadersDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMimeType(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `mime_type` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMimeType` instead "
    "of `ReadMimeType if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  std::optional<int64_t> expected_content_length() const {

    return data_->expected_content_length_$flag
        ? std::make_optional(data_->expected_content_length_$value)
        : std::nullopt;
  }
 private:
  internal::URLResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkErrorDataView {
 public:
  NetworkErrorDataView() = default;

  NetworkErrorDataView(
      internal::NetworkError_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t net_error() const {
    return data_->net_error;
  }
  inline void GetDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::NetworkError_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLLoadStatusDataView {
 public:
  using Tag = internal::URLLoadStatus_Data::URLLoadStatus_Tag;

  URLLoadStatusDataView() = default;

  URLLoadStatusDataView(
      internal::URLLoadStatus_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_ok() const { return data_->tag == Tag::kOk; }
  bool ok() const {
    CHECK(is_ok());
    return data_->data.f_ok;
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  inline void GetErrorDataView(
      NetworkErrorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    
    CHECK(is_error());
    return mojo::internal::Deserialize<::owl::mojom::NetworkErrorDataView>(
        data_->data.f_error.Get(), output, message_);
  }

 private:
  internal::URLLoadStatus_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // owl::mojom

#endif  // OWL_MOJOM_URL_LOADER_MOJOM_DATA_VIEW_H_