// owl/mojom/session.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_SESSION_MOJOM_H_
#define OWL_MOJOM_SESSION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/session.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/session.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/session.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "owl/mojom/profile.mojom-forward.h"
#include "owl/mojom/url_loader.mojom-forward.h"
#include "owl/mojom/web_view_session_data.mojom-forward.h"
#include "services/tracing/public/mojom/perfetto_service.mojom.h"
#include "url/mojom/url.mojom.h"
#include "owl/mojom/icloud_passkeys.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class WatchdogClientProxy;

template <typename ImplRefTraits>
class WatchdogClientStub;

class WatchdogClientRequestValidator;
class WatchdogClientResponseValidator;


class WatchdogClient
    : public WatchdogClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.WatchdogClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WatchdogClientInterfaceBase;
  using Proxy_ = WatchdogClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = WatchdogClientStub<ImplRefTraits>;

  using RequestValidator_ = WatchdogClientRequestValidator;
  using ResponseValidator_ = WatchdogClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kPingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Ping_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WatchdogClient() = default;

  using PingCallback = base::OnceCallback<void()>;
  using PingMojoCallback = base::OnceCallback<void()>;

  virtual void Ping(PingCallback callback) = 0;
};

class SessionProxy;

template <typename ImplRefTraits>
class SessionStub;

class SessionRequestValidator;
class SessionResponseValidator;


class Session
    : public SessionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.Session";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SessionInterfaceBase;
  using Proxy_ = SessionProxy;

  template <typename ImplRefTraits>
  using Stub_ = SessionStub<ImplRefTraits>;

  using RequestValidator_ = SessionRequestValidator;
  using ResponseValidator_ = SessionResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetClientMinVersion = 0,
    kCreateSystemURLLoaderFactoryMinVersion = 0,
    kShowChromeMinVersion = 0,
    kOpenProfileMinVersion = 0,
    kOpenGuestProfileMinVersion = 0,
    kSetAllowedWebUIPrefixesMinVersion = 0,
    kSetInternalURLsMinVersion = 0,
    kCreateWebViewSessionDataDecoderMinVersion = 0,
    kConfigureFeaturesMinVersion = 0,
    kPingMinVersion = 0,
    kStartTracingMinVersion = 0,
    kStopTracingMinVersion = 0,
    kStartWatchdogMinVersion = 0,
    kGetWebViewsMemoryUsageMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateSystemURLLoaderFactory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowChrome_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenProfile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenGuestProfile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAllowedWebUIPrefixes_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetInternalURLs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateWebViewSessionDataDecoder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ConfigureFeatures_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Ping_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartTracing_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopTracing_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartWatchdog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetWebViewsMemoryUsage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Session() = default;

  virtual void SetClient(::mojo::PendingAssociatedRemote<SessionClient> client) = 0;

  virtual void CreateSystemURLLoaderFactory(::mojo::PendingAssociatedReceiver<::owl::mojom::URLLoaderFactory> receiver) = 0;

  virtual void ShowChrome(bool enabled) = 0;

  virtual void OpenProfile(const ::base::FilePath& name, ::mojo::PendingReceiver<::owl::mojom::Profile> receiver) = 0;

  virtual void OpenGuestProfile(::mojo::PendingReceiver<::owl::mojom::Profile> receiver) = 0;

  virtual void SetAllowedWebUIPrefixes(const std::optional<std::vector<::GURL>>& prefixes) = 0;

  virtual void SetInternalURLs(std::optional<std::vector<InternalURLPatternPtr>> patterns) = 0;

  virtual void CreateWebViewSessionDataDecoder(::mojo::PendingReceiver<::owl::mojom::WebViewSessionDataDecoder> receiver) = 0;

  virtual void ConfigureFeatures(const base::flat_map<std::string, std::string>& feature_flags) = 0;

  using PingCallback = base::OnceCallback<void()>;
  using PingMojoCallback = base::OnceCallback<void()>;

  virtual void Ping(PingCallback callback) = 0;

  using StartTracingCallback = base::OnceCallback<void(const std::optional<std::string>&)>;
  using StartTracingMojoCallback = base::OnceCallback<void(const std::optional<std::string>&)>;

  virtual void StartTracing(const ::perfetto::TraceConfig& trace_config, StartTracingCallback callback) = 0;

  using StopTracingCallback = base::OnceCallback<void(TraceResultPtr)>;
  using StopTracingMojoCallback = base::OnceCallback<void(TraceResultPtr)>;

  virtual void StopTracing(const ::base::FilePath& output_path, bool anonymize, StopTracingCallback callback) = 0;

  virtual void StartWatchdog(::mojo::PendingRemote<WatchdogClient> client) = 0;

  using GetWebViewsMemoryUsageCallback = base::OnceCallback<void(WebViewsMemoryUsagePtr)>;
  using GetWebViewsMemoryUsageMojoCallback = base::OnceCallback<void(WebViewsMemoryUsagePtr)>;

  virtual void GetWebViewsMemoryUsage(GetWebViewsMemoryUsageCallback callback) = 0;
};

class SessionClientProxy;

template <typename ImplRefTraits>
class SessionClientStub;

class SessionClientRequestValidator;


class SessionClient
    : public SessionClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.SessionClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SessionClientInterfaceBase;
  using Proxy_ = SessionClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = SessionClientStub<ImplRefTraits>;

  using RequestValidator_ = SessionClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnNetworkStatusChangedMinVersion = 0,
    kOnDNSChangedMinVersion = 0,
    kOnNetworkServiceRestartedMinVersion = 0,
    kOnCaptivePortalStatusChangedMinVersion = 0,
    kGetICloudKeychainPasskeyBridgeMinVersion = 0,
    kOnNavigationThrottleImpactedNavigationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnNetworkStatusChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDNSChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnNetworkServiceRestarted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnCaptivePortalStatusChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetICloudKeychainPasskeyBridge_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnNavigationThrottleImpactedNavigation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SessionClient() = default;

  virtual void OnNetworkStatusChanged(NetworkStatus network_status) = 0;

  virtual void OnDNSChanged() = 0;

  virtual void OnNetworkServiceRestarted(bool from_crash) = 0;

  virtual void OnCaptivePortalStatusChanged(bool is_behind_captive_portal) = 0;

  virtual void GetICloudKeychainPasskeyBridge(::mojo::PendingReceiver<::owl::mojom::ICloudKeychainPasskeyBridge> bridge) = 0;

  virtual void OnNavigationThrottleImpactedNavigation(const std::string& throttle_name, const std::string& event_description, const std::string& modification_type, const std::optional<::GURL>& url) = 0;
};



class  WatchdogClientProxy
    : public WatchdogClient {
 public:
  using InterfaceType = WatchdogClient;

  explicit WatchdogClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Ping(PingCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SessionProxy
    : public Session {
 public:
  using InterfaceType = Session;

  explicit SessionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetClient(::mojo::PendingAssociatedRemote<SessionClient> client) final;
  
  void CreateSystemURLLoaderFactory(::mojo::PendingAssociatedReceiver<::owl::mojom::URLLoaderFactory> receiver) final;
  
  void ShowChrome(bool enabled) final;
  
  void OpenProfile(const ::base::FilePath& name, ::mojo::PendingReceiver<::owl::mojom::Profile> receiver) final;
  
  void OpenGuestProfile(::mojo::PendingReceiver<::owl::mojom::Profile> receiver) final;
  
  void SetAllowedWebUIPrefixes(const std::optional<std::vector<::GURL>>& prefixes) final;
  
  void SetInternalURLs(std::optional<std::vector<InternalURLPatternPtr>> patterns) final;
  
  void CreateWebViewSessionDataDecoder(::mojo::PendingReceiver<::owl::mojom::WebViewSessionDataDecoder> receiver) final;
  
  void ConfigureFeatures(const base::flat_map<std::string, std::string>& feature_flags) final;
  
  void Ping(PingCallback callback) final;
  
  void StartTracing(const ::perfetto::TraceConfig& trace_config, StartTracingCallback callback) final;
  
  void StopTracing(const ::base::FilePath& output_path, bool anonymize, StopTracingCallback callback) final;
  
  void StartWatchdog(::mojo::PendingRemote<WatchdogClient> client) final;
  
  void GetWebViewsMemoryUsage(GetWebViewsMemoryUsageCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SessionClientProxy
    : public SessionClient {
 public:
  using InterfaceType = SessionClient;

  explicit SessionClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnNetworkStatusChanged(NetworkStatus network_status) final;
  
  void OnDNSChanged() final;
  
  void OnNetworkServiceRestarted(bool from_crash) final;
  
  void OnCaptivePortalStatusChanged(bool is_behind_captive_portal) final;
  
  void GetICloudKeychainPasskeyBridge(::mojo::PendingReceiver<::owl::mojom::ICloudKeychainPasskeyBridge> bridge) final;
  
  void OnNavigationThrottleImpactedNavigation(const std::string& throttle_name, const std::string& event_description, const std::string& modification_type, const std::optional<::GURL>& url) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  WatchdogClientStubDispatch {
 public:
  static bool Accept(WatchdogClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WatchdogClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WatchdogClient>>
class WatchdogClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WatchdogClientStub() = default;
  ~WatchdogClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WatchdogClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WatchdogClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SessionStubDispatch {
 public:
  static bool Accept(Session* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Session* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Session>>
class SessionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SessionStub() = default;
  ~SessionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SessionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SessionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SessionClientStubDispatch {
 public:
  static bool Accept(SessionClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SessionClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SessionClient>>
class SessionClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SessionClientStub() = default;
  ~SessionClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SessionClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SessionClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WatchdogClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SessionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SessionClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WatchdogClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SessionResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  InternalURLPattern {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InternalURLPattern, T>::value>;
  using DataView = InternalURLPatternDataView;
  using Data_ = internal::InternalURLPattern_Data;

  template <typename... Args>
  static InternalURLPatternPtr New(Args&&... args) {
    return InternalURLPatternPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InternalURLPatternPtr From(const U& u) {
    return mojo::TypeConverter<InternalURLPatternPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InternalURLPattern>::Convert(*this);
  }


  InternalURLPattern();

  InternalURLPattern(
      const std::string& prefix,
      const std::string& query);


  ~InternalURLPattern();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InternalURLPatternPtr>
  InternalURLPatternPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InternalURLPattern::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InternalURLPattern::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InternalURLPattern::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InternalURLPattern::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InternalURLPattern::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InternalURLPattern::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InternalURLPattern_UnserializedMessageContext<
            UserType, InternalURLPattern::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InternalURLPattern::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InternalURLPattern::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InternalURLPattern_UnserializedMessageContext<
            UserType, InternalURLPattern::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InternalURLPattern::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string prefix;
  
  std::string query;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InternalURLPattern::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InternalURLPattern::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InternalURLPattern::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InternalURLPattern::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  TraceResult {
 public:
  using DataView = TraceResultDataView;
  using Data_ = internal::TraceResult_Data;
  using Tag = Data_::TraceResult_Tag;

  template <typename... Args>
  static TraceResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |output_path|.
  static TraceResultPtr NewOutputPath(
      const ::base::FilePath& value);
  // Construct an instance holding |error|.
  static TraceResultPtr NewError(
      const std::string& value);

  template <typename U>
  static TraceResultPtr From(const U& u) {
    return mojo::TypeConverter<TraceResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TraceResult>::Convert(*this);
  }
  ~TraceResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  TraceResult(const TraceResult& other) = delete;
  TraceResult& operator=(const TraceResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = TraceResultPtr>
  TraceResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, TraceResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, TraceResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_output_path() const { return tag_ == Tag::kOutputPath; }
  const ::base::FilePath& get_output_path() const {
    CHECK(tag_ == Tag::kOutputPath);
    return data_.output_path;
  }
  ::base::FilePath& get_output_path() {
    CHECK(tag_ == Tag::kOutputPath);
    return data_.output_path;
  }
  void set_output_path(const ::base::FilePath& output_path);

  bool is_error() const { return tag_ == Tag::kError; }
  const std::string& get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  std::string& get_error() {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  void set_error(const std::string& error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TraceResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<TraceResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kOutputPath)>,
        const ::base::FilePath& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
        const std::string& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::base::FilePath output_path;
    std::string error;
  };

  TraceResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kOutputPath)>,
      const ::base::FilePath& value);
  TraceResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
      const std::string& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class  WebViewsMemoryUsage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebViewsMemoryUsage, T>::value>;
  using DataView = WebViewsMemoryUsageDataView;
  using Data_ = internal::WebViewsMemoryUsage_Data;

  template <typename... Args>
  static WebViewsMemoryUsagePtr New(Args&&... args) {
    return WebViewsMemoryUsagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebViewsMemoryUsagePtr From(const U& u) {
    return mojo::TypeConverter<WebViewsMemoryUsagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebViewsMemoryUsage>::Convert(*this);
  }


  WebViewsMemoryUsage();

  WebViewsMemoryUsage(
      const base::flat_map<uint64_t, std::vector<uint64_t>>& web_view_id_to_pids,
      const base::flat_map<uint64_t, uint64_t>& pid_to_pmf_in_kb);


  ~WebViewsMemoryUsage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebViewsMemoryUsagePtr>
  WebViewsMemoryUsagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebViewsMemoryUsage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebViewsMemoryUsage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebViewsMemoryUsage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebViewsMemoryUsage::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebViewsMemoryUsage::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebViewsMemoryUsage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebViewsMemoryUsage_UnserializedMessageContext<
            UserType, WebViewsMemoryUsage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebViewsMemoryUsage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebViewsMemoryUsage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebViewsMemoryUsage_UnserializedMessageContext<
            UserType, WebViewsMemoryUsage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebViewsMemoryUsage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  base::flat_map<uint64_t, std::vector<uint64_t>> web_view_id_to_pids;
  
  base::flat_map<uint64_t, uint64_t> pid_to_pmf_in_kb;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebViewsMemoryUsage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebViewsMemoryUsage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebViewsMemoryUsage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebViewsMemoryUsage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
TraceResultPtr TraceResult::Clone() const {
  switch (tag_) {
    case Tag::kOutputPath:
      return NewOutputPath(
          mojo::Clone(data_.output_path));
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, TraceResult>::value>::type*>
bool TraceResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kOutputPath:
      return mojo::Equals(data_.output_path, other.data_.output_path);
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
  }

  return false;
}
template <typename StructPtrType>
InternalURLPatternPtr InternalURLPattern::Clone() const {
  return New(
      mojo::Clone(prefix),
      mojo::Clone(query)
  );
}

template <typename T, InternalURLPattern::EnableIfSame<T>*>
bool InternalURLPattern::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->prefix, other_struct.prefix))
    return false;
  if (!mojo::Equals(this->query, other_struct.query))
    return false;
  return true;
}

template <typename T, InternalURLPattern::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.prefix < rhs.prefix)
    return true;
  if (rhs.prefix < lhs.prefix)
    return false;
  if (lhs.query < rhs.query)
    return true;
  if (rhs.query < lhs.query)
    return false;
  return false;
}
template <typename StructPtrType>
WebViewsMemoryUsagePtr WebViewsMemoryUsage::Clone() const {
  return New(
      mojo::Clone(web_view_id_to_pids),
      mojo::Clone(pid_to_pmf_in_kb)
  );
}

template <typename T, WebViewsMemoryUsage::EnableIfSame<T>*>
bool WebViewsMemoryUsage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->web_view_id_to_pids, other_struct.web_view_id_to_pids))
    return false;
  if (!mojo::Equals(this->pid_to_pmf_in_kb, other_struct.pid_to_pmf_in_kb))
    return false;
  return true;
}

template <typename T, WebViewsMemoryUsage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.web_view_id_to_pids < rhs.web_view_id_to_pids)
    return true;
  if (rhs.web_view_id_to_pids < lhs.web_view_id_to_pids)
    return false;
  if (lhs.pid_to_pmf_in_kb < rhs.pid_to_pmf_in_kb)
    return true;
  if (rhs.pid_to_pmf_in_kb < lhs.pid_to_pmf_in_kb)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::InternalURLPattern::DataView,
                                         ::owl::mojom::InternalURLPatternPtr> {
  static bool IsNull(const ::owl::mojom::InternalURLPatternPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::InternalURLPatternPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::InternalURLPattern::prefix)& prefix(
      const ::owl::mojom::InternalURLPatternPtr& input) {
    return input->prefix;
  }

  static const decltype(::owl::mojom::InternalURLPattern::query)& query(
      const ::owl::mojom::InternalURLPatternPtr& input) {
    return input->query;
  }

  static bool Read(::owl::mojom::InternalURLPattern::DataView input, ::owl::mojom::InternalURLPatternPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::WebViewsMemoryUsage::DataView,
                                         ::owl::mojom::WebViewsMemoryUsagePtr> {
  static bool IsNull(const ::owl::mojom::WebViewsMemoryUsagePtr& input) { return !input; }
  static void SetToNull(::owl::mojom::WebViewsMemoryUsagePtr* output) { output->reset(); }

  static const decltype(::owl::mojom::WebViewsMemoryUsage::web_view_id_to_pids)& web_view_id_to_pids(
      const ::owl::mojom::WebViewsMemoryUsagePtr& input) {
    return input->web_view_id_to_pids;
  }

  static const decltype(::owl::mojom::WebViewsMemoryUsage::pid_to_pmf_in_kb)& pid_to_pmf_in_kb(
      const ::owl::mojom::WebViewsMemoryUsagePtr& input) {
    return input->pid_to_pmf_in_kb;
  }

  static bool Read(::owl::mojom::WebViewsMemoryUsage::DataView input, ::owl::mojom::WebViewsMemoryUsagePtr* output);
};


template <>
struct  UnionTraits<::owl::mojom::TraceResult::DataView,
                                        ::owl::mojom::TraceResultPtr> {
  static bool IsNull(const ::owl::mojom::TraceResultPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::TraceResultPtr* output) { output->reset(); }

  static ::owl::mojom::TraceResult::Tag GetTag(const ::owl::mojom::TraceResultPtr& input) {
    return input->which();
  }

  static const ::base::FilePath& output_path(const ::owl::mojom::TraceResultPtr& input) {
    return input->get_output_path();
  }

  static const std::string& error(const ::owl::mojom::TraceResultPtr& input) {
    return input->get_error();
  }

  static bool Read(::owl::mojom::TraceResult::DataView input, ::owl::mojom::TraceResultPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_SESSION_MOJOM_H_