// owl/mojom/session.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_SESSION_MOJOM_TEST_UTILS_H_
#define OWL_MOJOM_SESSION_MOJOM_TEST_UTILS_H_

#include "owl/mojom/session.mojom.h"


namespace owl::mojom {


class  WatchdogClientInterceptorForTesting : public WatchdogClient {
  virtual WatchdogClient* GetForwardingInterface() = 0;
  void Ping(PingCallback callback) override;
};
class  WatchdogClientAsyncWaiter {
 public:
  explicit WatchdogClientAsyncWaiter(WatchdogClient* proxy);

  WatchdogClientAsyncWaiter(const WatchdogClientAsyncWaiter&) = delete;
  WatchdogClientAsyncWaiter& operator=(const WatchdogClientAsyncWaiter&) = delete;

  ~WatchdogClientAsyncWaiter();
  void Ping(
      );
  

 private:
  WatchdogClient* const proxy_;
};


class  SessionInterceptorForTesting : public Session {
  virtual Session* GetForwardingInterface() = 0;
  void SetClient(::mojo::PendingAssociatedRemote<SessionClient> client) override;
  void CreateSystemURLLoaderFactory(::mojo::PendingAssociatedReceiver<::owl::mojom::URLLoaderFactory> receiver) override;
  void ShowChrome(bool enabled) override;
  void OpenProfile(const ::base::FilePath& name, ::mojo::PendingReceiver<::owl::mojom::Profile> receiver) override;
  void OpenGuestProfile(::mojo::PendingReceiver<::owl::mojom::Profile> receiver) override;
  void SetAllowedWebUIPrefixes(const std::optional<std::vector<::GURL>>& prefixes) override;
  void SetInternalURLs(std::optional<std::vector<InternalURLPatternPtr>> patterns) override;
  void CreateWebViewSessionDataDecoder(::mojo::PendingReceiver<::owl::mojom::WebViewSessionDataDecoder> receiver) override;
  void ConfigureFeatures(const base::flat_map<std::string, std::string>& feature_flags) override;
  void Ping(PingCallback callback) override;
  void StartTracing(const ::perfetto::TraceConfig& trace_config, StartTracingCallback callback) override;
  void StopTracing(const ::base::FilePath& output_path, bool anonymize, StopTracingCallback callback) override;
  void StartWatchdog(::mojo::PendingRemote<WatchdogClient> client) override;
  void GetWebViewsMemoryUsage(GetWebViewsMemoryUsageCallback callback) override;
};
class  SessionAsyncWaiter {
 public:
  explicit SessionAsyncWaiter(Session* proxy);

  SessionAsyncWaiter(const SessionAsyncWaiter&) = delete;
  SessionAsyncWaiter& operator=(const SessionAsyncWaiter&) = delete;

  ~SessionAsyncWaiter();
  void Ping(
      );
  
  void StartTracing(
      const ::perfetto::TraceConfig& trace_config, std::optional<std::string>* out_error);
  std::optional<std::string> StartTracing(const ::perfetto::TraceConfig& trace_config);
  void StopTracing(
      const ::base::FilePath& output_path, bool anonymize, TraceResultPtr* out_result);
  TraceResultPtr StopTracing(const ::base::FilePath& output_path, bool anonymize);
  void GetWebViewsMemoryUsage(
      WebViewsMemoryUsagePtr* out_memory);
  WebViewsMemoryUsagePtr GetWebViewsMemoryUsage();

 private:
  Session* const proxy_;
};


class  SessionClientInterceptorForTesting : public SessionClient {
  virtual SessionClient* GetForwardingInterface() = 0;
  void OnNetworkStatusChanged(NetworkStatus network_status) override;
  void OnDNSChanged() override;
  void OnNetworkServiceRestarted(bool from_crash) override;
  void OnCaptivePortalStatusChanged(bool is_behind_captive_portal) override;
  void GetICloudKeychainPasskeyBridge(::mojo::PendingReceiver<::owl::mojom::ICloudKeychainPasskeyBridge> bridge) override;
  void OnNavigationThrottleImpactedNavigation(const std::string& throttle_name, const std::string& event_description, const std::string& modification_type, const std::optional<::GURL>& url) override;
};
class  SessionClientAsyncWaiter {
 public:
  explicit SessionClientAsyncWaiter(SessionClient* proxy);

  SessionClientAsyncWaiter(const SessionClientAsyncWaiter&) = delete;
  SessionClientAsyncWaiter& operator=(const SessionClientAsyncWaiter&) = delete;

  ~SessionClientAsyncWaiter();

 private:
  SessionClient* const proxy_;
};




}  // owl::mojom

#endif  // OWL_MOJOM_SESSION_MOJOM_TEST_UTILS_H_