// owl/mojom/session.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_SESSION_MOJOM_SHARED_H_
#define OWL_MOJOM_SESSION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/session.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "owl/mojom/profile.mojom-shared.h"
#include "owl/mojom/url_loader.mojom-shared.h"
#include "owl/mojom/web_view_session_data.mojom-shared.h"
#include "services/tracing/public/mojom/perfetto_service.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "owl/mojom/icloud_passkeys.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "owl/mojom/session.mojom-data-view.h"




namespace std {

template <>
struct hash<::owl::mojom::NetworkStatus>
    : public mojo::internal::EnumHashImpl<::owl::mojom::NetworkStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::NetworkStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::NetworkStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::NetworkStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::InternalURLPatternDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::InternalURLPatternDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::InternalURLPattern_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::prefix(input)) in_prefix = Traits::prefix(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->prefix)::BaseType> prefix_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_prefix,
      prefix_fragment);

    fragment->prefix.Set(
        prefix_fragment.is_null() ? nullptr : prefix_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->prefix.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null prefix in InternalURLPattern struct");

    decltype(Traits::query(input)) in_query = Traits::query(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->query)::BaseType> query_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_query,
      query_fragment);

    fragment->query.Set(
        query_fragment.is_null() ? nullptr : query_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->query.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null query in InternalURLPattern struct");
  }

  static bool Deserialize(::owl::mojom::internal::InternalURLPattern_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::InternalURLPatternDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::WebViewsMemoryUsageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::WebViewsMemoryUsageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::WebViewsMemoryUsage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::web_view_id_to_pids(input)) in_web_view_id_to_pids = Traits::web_view_id_to_pids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->web_view_id_to_pids)::BaseType>
        web_view_id_to_pids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& web_view_id_to_pids_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<uint64_t, mojo::ArrayDataView<uint64_t>>>(
      in_web_view_id_to_pids,
      web_view_id_to_pids_fragment,
      &web_view_id_to_pids_validate_params);

    fragment->web_view_id_to_pids.Set(
        web_view_id_to_pids_fragment.is_null() ? nullptr : web_view_id_to_pids_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->web_view_id_to_pids.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null web_view_id_to_pids in WebViewsMemoryUsage struct");

    decltype(Traits::pid_to_pmf_in_kb(input)) in_pid_to_pmf_in_kb = Traits::pid_to_pmf_in_kb(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pid_to_pmf_in_kb)::BaseType>
        pid_to_pmf_in_kb_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& pid_to_pmf_in_kb_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<uint64_t, uint64_t>>(
      in_pid_to_pmf_in_kb,
      pid_to_pmf_in_kb_fragment,
      &pid_to_pmf_in_kb_validate_params);

    fragment->pid_to_pmf_in_kb.Set(
        pid_to_pmf_in_kb_fragment.is_null() ? nullptr : pid_to_pmf_in_kb_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->pid_to_pmf_in_kb.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pid_to_pmf_in_kb in WebViewsMemoryUsage struct");
  }

  static bool Deserialize(::owl::mojom::internal::WebViewsMemoryUsage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::WebViewsMemoryUsageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::TraceResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::owl::mojom::TraceResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::owl::mojom::internal::TraceResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::owl::mojom::TraceResultDataView::Tag::kOutputPath: {
    decltype(Traits::output_path(input))
    in_output_path = Traits::output_path(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_output_path)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
  in_output_path,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null output_path in TraceResult union");
    fragment->data.f_output_path.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::owl::mojom::TraceResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_error,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error in TraceResult union");
    fragment->data.f_error.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::owl::mojom::internal::TraceResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::TraceResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace owl::mojom {

inline void InternalURLPatternDataView::GetPrefixDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->prefix.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void InternalURLPatternDataView::GetQueryDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->query.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void WebViewsMemoryUsageDataView::GetWebViewIdToPidsDataView(
    mojo::MapDataView<uint64_t, mojo::ArrayDataView<uint64_t>>* output) {
  auto pointer = data_->web_view_id_to_pids.Get();
  *output = mojo::MapDataView<uint64_t, mojo::ArrayDataView<uint64_t>>(pointer, message_);
}
inline void WebViewsMemoryUsageDataView::GetPidToPmfInKbDataView(
    mojo::MapDataView<uint64_t, uint64_t>* output) {
  auto pointer = data_->pid_to_pmf_in_kb.Get();
  *output = mojo::MapDataView<uint64_t, uint64_t>(pointer, message_);
}


inline void TraceResultDataView::GetOutputPathDataView(
    ::mojo_base::mojom::FilePathDataView* output) const {
  CHECK(is_output_path());
  *output = ::mojo_base::mojom::FilePathDataView(data_->data.f_output_path.Get(), message_);
}
inline void TraceResultDataView::GetErrorDataView(
    mojo::StringDataView* output) const {
  CHECK(is_error());
  *output = mojo::StringDataView(data_->data.f_error.Get(), message_);
}


}  // owl::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::NetworkStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::NetworkStatus value);
};

} // namespace perfetto

#endif  // OWL_MOJOM_SESSION_MOJOM_SHARED_H_