// owl/mojom/session.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "owl/mojom/session.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/session.mojom-params-data.h"
namespace owl {
namespace mojom {

NOINLINE static const char* NetworkStatusToStringHelper(NetworkStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NetworkStatus::kConnected:
      return "kConnected";
    case NetworkStatus::kOffline:
      return "kOffline";
    default:
      return nullptr;
  }
}

std::string NetworkStatusToString(NetworkStatus value) {
  const char *str = NetworkStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NetworkStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NetworkStatus value) {
  return os << NetworkStatusToString(value);
}

namespace internal {
// static
bool TraceResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const TraceResult_Data* object = static_cast<const TraceResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case TraceResult_Tag::kOutputPath: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_output_path, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_output_path, validation_context))
        return false;
      return true;
    }
    case TraceResult_Tag::kError: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& error_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_error, validation_context,
                                             &error_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in TraceResult");
      return false;
    }
  }
}


// static
bool InternalURLPattern_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const InternalURLPattern_Data* object =
      static_cast<const InternalURLPattern_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->prefix, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& prefix_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->prefix, validation_context,
                                         &prefix_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& query_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->query, validation_context,
                                         &query_validate_params)) {
    return false;
  }

  return true;
}

InternalURLPattern_Data::InternalURLPattern_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewsMemoryUsage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewsMemoryUsage_Data* object =
      static_cast<const WebViewsMemoryUsage_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->web_view_id_to_pids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& web_view_id_to_pids_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->web_view_id_to_pids, validation_context,
                                         &web_view_id_to_pids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pid_to_pmf_in_kb, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& pid_to_pmf_in_kb_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->pid_to_pmf_in_kb, validation_context,
                                         &pid_to_pmf_in_kb_validate_params)) {
    return false;
  }

  return true;
}

WebViewsMemoryUsage_Data::WebViewsMemoryUsage_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WatchdogClient_Ping_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WatchdogClient_Ping_Params_Data* object =
      static_cast<const WatchdogClient_Ping_Params_Data*>(data);

  return true;
}

WatchdogClient_Ping_Params_Data::WatchdogClient_Ping_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WatchdogClient_Ping_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WatchdogClient_Ping_ResponseParams_Data* object =
      static_cast<const WatchdogClient_Ping_ResponseParams_Data*>(data);

  return true;
}

WatchdogClient_Ping_ResponseParams_Data::WatchdogClient_Ping_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_SetClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_SetClient_Params_Data* object =
      static_cast<const Session_SetClient_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Session_SetClient_Params_Data::Session_SetClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_CreateSystemURLLoaderFactory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_CreateSystemURLLoaderFactory_Params_Data* object =
      static_cast<const Session_CreateSystemURLLoaderFactory_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Session_CreateSystemURLLoaderFactory_Params_Data::Session_CreateSystemURLLoaderFactory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_ShowChrome_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_ShowChrome_Params_Data* object =
      static_cast<const Session_ShowChrome_Params_Data*>(data);

  return true;
}

Session_ShowChrome_Params_Data::Session_ShowChrome_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_OpenProfile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_OpenProfile_Params_Data* object =
      static_cast<const Session_OpenProfile_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Session_OpenProfile_Params_Data::Session_OpenProfile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_OpenGuestProfile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_OpenGuestProfile_Params_Data* object =
      static_cast<const Session_OpenGuestProfile_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Session_OpenGuestProfile_Params_Data::Session_OpenGuestProfile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_SetAllowedWebUIPrefixes_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_SetAllowedWebUIPrefixes_Params_Data* object =
      static_cast<const Session_SetAllowedWebUIPrefixes_Params_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& prefixes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->prefixes, validation_context,
                                         &prefixes_validate_params)) {
    return false;
  }

  return true;
}

Session_SetAllowedWebUIPrefixes_Params_Data::Session_SetAllowedWebUIPrefixes_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_SetInternalURLs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_SetInternalURLs_Params_Data* object =
      static_cast<const Session_SetInternalURLs_Params_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& patterns_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->patterns, validation_context,
                                         &patterns_validate_params)) {
    return false;
  }

  return true;
}

Session_SetInternalURLs_Params_Data::Session_SetInternalURLs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_CreateWebViewSessionDataDecoder_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_CreateWebViewSessionDataDecoder_Params_Data* object =
      static_cast<const Session_CreateWebViewSessionDataDecoder_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Session_CreateWebViewSessionDataDecoder_Params_Data::Session_CreateWebViewSessionDataDecoder_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_ConfigureFeatures_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_ConfigureFeatures_Params_Data* object =
      static_cast<const Session_ConfigureFeatures_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->feature_flags, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& feature_flags_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->feature_flags, validation_context,
                                         &feature_flags_validate_params)) {
    return false;
  }

  return true;
}

Session_ConfigureFeatures_Params_Data::Session_ConfigureFeatures_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_Ping_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_Ping_Params_Data* object =
      static_cast<const Session_Ping_Params_Data*>(data);

  return true;
}

Session_Ping_Params_Data::Session_Ping_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_Ping_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_Ping_ResponseParams_Data* object =
      static_cast<const Session_Ping_ResponseParams_Data*>(data);

  return true;
}

Session_Ping_ResponseParams_Data::Session_Ping_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_StartTracing_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_StartTracing_Params_Data* object =
      static_cast<const Session_StartTracing_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->trace_config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->trace_config, validation_context))
    return false;

  return true;
}

Session_StartTracing_Params_Data::Session_StartTracing_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_StartTracing_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_StartTracing_ResponseParams_Data* object =
      static_cast<const Session_StartTracing_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& error_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error, validation_context,
                                         &error_validate_params)) {
    return false;
  }

  return true;
}

Session_StartTracing_ResponseParams_Data::Session_StartTracing_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_StopTracing_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_StopTracing_Params_Data* object =
      static_cast<const Session_StopTracing_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_path, validation_context))
    return false;

  return true;
}

Session_StopTracing_Params_Data::Session_StopTracing_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_StopTracing_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_StopTracing_ResponseParams_Data* object =
      static_cast<const Session_StopTracing_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

Session_StopTracing_ResponseParams_Data::Session_StopTracing_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_StartWatchdog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_StartWatchdog_Params_Data* object =
      static_cast<const Session_StartWatchdog_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Session_StartWatchdog_Params_Data::Session_StartWatchdog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_GetWebViewsMemoryUsage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_GetWebViewsMemoryUsage_Params_Data* object =
      static_cast<const Session_GetWebViewsMemoryUsage_Params_Data*>(data);

  return true;
}

Session_GetWebViewsMemoryUsage_Params_Data::Session_GetWebViewsMemoryUsage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_GetWebViewsMemoryUsage_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_GetWebViewsMemoryUsage_ResponseParams_Data* object =
      static_cast<const Session_GetWebViewsMemoryUsage_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->memory, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->memory, validation_context))
    return false;

  return true;
}

Session_GetWebViewsMemoryUsage_ResponseParams_Data::Session_GetWebViewsMemoryUsage_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SessionClient_OnNetworkStatusChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SessionClient_OnNetworkStatusChanged_Params_Data* object =
      static_cast<const SessionClient_OnNetworkStatusChanged_Params_Data*>(data);


  if (!::owl::mojom::internal::NetworkStatus_Data
        ::Validate(object->network_status, validation_context))
    return false;

  return true;
}

SessionClient_OnNetworkStatusChanged_Params_Data::SessionClient_OnNetworkStatusChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SessionClient_OnDNSChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SessionClient_OnDNSChanged_Params_Data* object =
      static_cast<const SessionClient_OnDNSChanged_Params_Data*>(data);

  return true;
}

SessionClient_OnDNSChanged_Params_Data::SessionClient_OnDNSChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SessionClient_OnNetworkServiceRestarted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SessionClient_OnNetworkServiceRestarted_Params_Data* object =
      static_cast<const SessionClient_OnNetworkServiceRestarted_Params_Data*>(data);

  return true;
}

SessionClient_OnNetworkServiceRestarted_Params_Data::SessionClient_OnNetworkServiceRestarted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SessionClient_OnCaptivePortalStatusChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SessionClient_OnCaptivePortalStatusChanged_Params_Data* object =
      static_cast<const SessionClient_OnCaptivePortalStatusChanged_Params_Data*>(data);

  return true;
}

SessionClient_OnCaptivePortalStatusChanged_Params_Data::SessionClient_OnCaptivePortalStatusChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SessionClient_GetICloudKeychainPasskeyBridge_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SessionClient_GetICloudKeychainPasskeyBridge_Params_Data* object =
      static_cast<const SessionClient_GetICloudKeychainPasskeyBridge_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->bridge, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->bridge,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SessionClient_GetICloudKeychainPasskeyBridge_Params_Data::SessionClient_GetICloudKeychainPasskeyBridge_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SessionClient_OnNavigationThrottleImpactedNavigation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SessionClient_OnNavigationThrottleImpactedNavigation_Params_Data* object =
      static_cast<const SessionClient_OnNavigationThrottleImpactedNavigation_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->throttle_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& throttle_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->throttle_name, validation_context,
                                         &throttle_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_description, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& event_description_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->event_description, validation_context,
                                         &event_description_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->modification_type, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& modification_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->modification_type, validation_context,
                                         &modification_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

SessionClient_OnNavigationThrottleImpactedNavigation_Params_Data::SessionClient_OnNavigationThrottleImpactedNavigation_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace owl

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::NetworkStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::NetworkStatus value) {
  return std::move(context).WriteString(::owl::mojom::NetworkStatusToString(value));
}

} // namespace perfetto