// owl/mojom/session.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_SESSION_MOJOM_SEND_VALIDATION_H_
#define OWL_MOJOM_SESSION_MOJOM_SEND_VALIDATION_H_

#include "owl/mojom/session.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "owl/mojom/profile.mojom-shared.h"
#include "owl/mojom/url_loader.mojom-shared.h"
#include "owl/mojom/web_view_session_data.mojom-shared.h"
#include "services/tracing/public/mojom/perfetto_service.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "owl/mojom/icloud_passkeys.mojom-shared.h"

#include "owl/mojom/session.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::NetworkStatus, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::InternalURLPatternDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::InternalURLPatternDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::InternalURLPattern_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::prefix(input)) in_prefix = Traits::prefix(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->prefix)::BaseType> prefix_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_prefix,
        prefix_fragment);

      fragment->prefix.Set(
          prefix_fragment.is_null() ? nullptr : prefix_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->prefix.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null prefix in InternalURLPattern struct");

      decltype(Traits::query(input)) in_query = Traits::query(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->query)::BaseType> query_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_query,
        query_fragment);

      fragment->query.Set(
          query_fragment.is_null() ? nullptr : query_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->query.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null query in InternalURLPattern struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::WebViewsMemoryUsageDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::WebViewsMemoryUsageDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::WebViewsMemoryUsage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::web_view_id_to_pids(input)) in_web_view_id_to_pids = Traits::web_view_id_to_pids(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->web_view_id_to_pids)::BaseType>
          web_view_id_to_pids_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& web_view_id_to_pids_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<uint64_t, mojo::ArrayDataView<uint64_t>>, send_validation>(
        in_web_view_id_to_pids,
        web_view_id_to_pids_fragment,
        &web_view_id_to_pids_validate_params);

      fragment->web_view_id_to_pids.Set(
          web_view_id_to_pids_fragment.is_null() ? nullptr : web_view_id_to_pids_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->web_view_id_to_pids.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null web_view_id_to_pids in WebViewsMemoryUsage struct");

      decltype(Traits::pid_to_pmf_in_kb(input)) in_pid_to_pmf_in_kb = Traits::pid_to_pmf_in_kb(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pid_to_pmf_in_kb)::BaseType>
          pid_to_pmf_in_kb_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& pid_to_pmf_in_kb_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<uint64_t, uint64_t>, send_validation>(
        in_pid_to_pmf_in_kb,
        pid_to_pmf_in_kb_fragment,
        &pid_to_pmf_in_kb_validate_params);

      fragment->pid_to_pmf_in_kb.Set(
          pid_to_pmf_in_kb_fragment.is_null() ? nullptr : pid_to_pmf_in_kb_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->pid_to_pmf_in_kb.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pid_to_pmf_in_kb in WebViewsMemoryUsage struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::TraceResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::owl::mojom::TraceResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::owl::mojom::internal::TraceResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::owl::mojom::TraceResultDataView::Tag::kOutputPath: {
    decltype(Traits::output_path(input))
    in_output_path = Traits::output_path(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_output_path)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
  in_output_path,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null output_path in TraceResult union");
    fragment->data.f_output_path.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::owl::mojom::TraceResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView, send_validation>(
  in_error,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error in TraceResult union");
    fragment->data.f_error.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // OWL_MOJOM_SESSION_MOJOM_SEND_VALIDATION_H_