// owl/mojom/session.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_SESSION_MOJOM_DATA_VIEW_H_
#define OWL_MOJOM_SESSION_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "owl/mojom/session.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "owl/mojom/profile.mojom-shared.h"
#include "owl/mojom/url_loader.mojom-shared.h"
#include "owl/mojom/web_view_session_data.mojom-shared.h"
#include "services/tracing/public/mojom/perfetto_service.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "owl/mojom/icloud_passkeys.mojom-shared.h"


namespace owl::mojom {
class InternalURLPatternDataView;

class WebViewsMemoryUsageDataView;

class TraceResultDataView;


}  // owl::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::owl::mojom::InternalURLPatternDataView> {
  using Data = ::owl::mojom::internal::InternalURLPattern_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::WebViewsMemoryUsageDataView> {
  using Data = ::owl::mojom::internal::WebViewsMemoryUsage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::TraceResultDataView> {
  using Data = ::owl::mojom::internal::TraceResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace owl::mojom {


enum class NetworkStatus : int32_t {
  
  kConnected = 0,
  
  kOffline = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, NetworkStatus value);
inline bool IsKnownEnumValue(NetworkStatus value) {
  return internal::NetworkStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class WatchdogClientInterfaceBase {};

using WatchdogClientPtrDataView =
    mojo::InterfacePtrDataView<WatchdogClientInterfaceBase>;
using WatchdogClientRequestDataView =
    mojo::InterfaceRequestDataView<WatchdogClientInterfaceBase>;
using WatchdogClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WatchdogClientInterfaceBase>;
using WatchdogClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WatchdogClientInterfaceBase>;
class SessionInterfaceBase {};

using SessionPtrDataView =
    mojo::InterfacePtrDataView<SessionInterfaceBase>;
using SessionRequestDataView =
    mojo::InterfaceRequestDataView<SessionInterfaceBase>;
using SessionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SessionInterfaceBase>;
using SessionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SessionInterfaceBase>;
class SessionClientInterfaceBase {};

using SessionClientPtrDataView =
    mojo::InterfacePtrDataView<SessionClientInterfaceBase>;
using SessionClientRequestDataView =
    mojo::InterfaceRequestDataView<SessionClientInterfaceBase>;
using SessionClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SessionClientInterfaceBase>;
using SessionClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SessionClientInterfaceBase>;


class InternalURLPatternDataView {
 public:
  InternalURLPatternDataView() = default;

  InternalURLPatternDataView(
      internal::InternalURLPattern_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPrefixDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrefix(UserType* output) {
    
    auto* pointer = data_->prefix.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetQueryDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadQuery(UserType* output) {
    
    auto* pointer = data_->query.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::InternalURLPattern_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebViewsMemoryUsageDataView {
 public:
  WebViewsMemoryUsageDataView() = default;

  WebViewsMemoryUsageDataView(
      internal::WebViewsMemoryUsage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetWebViewIdToPidsDataView(
      mojo::MapDataView<uint64_t, mojo::ArrayDataView<uint64_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebViewIdToPids(UserType* output) {
    
    auto* pointer = data_->web_view_id_to_pids.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<uint64_t, mojo::ArrayDataView<uint64_t>>>(
        pointer, output, message_);
  }
  inline void GetPidToPmfInKbDataView(
      mojo::MapDataView<uint64_t, uint64_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPidToPmfInKb(UserType* output) {
    
    auto* pointer = data_->pid_to_pmf_in_kb.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<uint64_t, uint64_t>>(
        pointer, output, message_);
  }
 private:
  internal::WebViewsMemoryUsage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TraceResultDataView {
 public:
  using Tag = internal::TraceResult_Data::TraceResult_Tag;

  TraceResultDataView() = default;

  TraceResultDataView(
      internal::TraceResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_output_path() const { return data_->tag == Tag::kOutputPath; }
  inline void GetOutputPathDataView(
      ::mojo_base::mojom::FilePathDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadOutputPath(UserType* output) const {
    
    CHECK(is_output_path());
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        data_->data.f_output_path.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  inline void GetErrorDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    
    CHECK(is_error());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_error.Get(), output, message_);
  }

 private:
  internal::TraceResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // owl::mojom

#endif  // OWL_MOJOM_SESSION_MOJOM_DATA_VIEW_H_