// owl/mojom/search_keyword.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_SEARCH_KEYWORD_MOJOM_SHARED_H_
#define OWL_MOJOM_SEARCH_KEYWORD_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/search_keyword.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "owl/mojom/search_keyword.mojom-data-view.h"




namespace std {

template <>
struct hash<::owl::mojom::SearchKeywordType>
    : public mojo::internal::EnumHashImpl<::owl::mojom::SearchKeywordType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::SearchKeywordType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::SearchKeywordType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::SearchKeywordType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::SearchKeywordDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::SearchKeywordDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::SearchKeyword_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in SearchKeyword struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in SearchKeyword struct");

    decltype(Traits::keyword(input)) in_keyword = Traits::keyword(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->keyword)::BaseType> keyword_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_keyword,
      keyword_fragment);

    fragment->keyword.Set(
        keyword_fragment.is_null() ? nullptr : keyword_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->keyword.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null keyword in SearchKeyword struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in SearchKeyword struct");

    fragment->replacement_offset = Traits::replacement_offset(input);

    decltype(Traits::favicon_url(input)) in_favicon_url = Traits::favicon_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->favicon_url)::BaseType> favicon_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_favicon_url,
      favicon_url_fragment);

    fragment->favicon_url.Set(
        favicon_url_fragment.is_null() ? nullptr : favicon_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->favicon_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null favicon_url in SearchKeyword struct");

    
    mojo::internal::Serialize<::owl::mojom::SearchKeywordType>(
      Traits::type(input),
      &fragment->type);

    fragment->is_default = Traits::is_default(input);

    decltype(Traits::suggestions_url(input)) in_suggestions_url = Traits::suggestions_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->suggestions_url)::BaseType> suggestions_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_suggestions_url,
      suggestions_url_fragment);

    fragment->suggestions_url.Set(
        suggestions_url_fragment.is_null() ? nullptr : suggestions_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->suggestions_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null suggestions_url in SearchKeyword struct");

    fragment->suggestions_url_replacement_offset = Traits::suggestions_url_replacement_offset(input);
  }

  static bool Deserialize(::owl::mojom::internal::SearchKeyword_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::SearchKeywordDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace owl::mojom {

inline void SearchKeywordDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SearchKeywordDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void SearchKeywordDataView::GetKeywordDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->keyword.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void SearchKeywordDataView::GetUrlDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->url.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void SearchKeywordDataView::GetFaviconUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->favicon_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void SearchKeywordDataView::GetSuggestionsUrlDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->suggestions_url.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}



}  // owl::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::SearchKeywordType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::SearchKeywordType value);
};

} // namespace perfetto

#endif  // OWL_MOJOM_SEARCH_KEYWORD_MOJOM_SHARED_H_