// owl/mojom/profile.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "owl/mojom/profile.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/profile.mojom-params-data.h"
namespace owl {
namespace mojom {

NOINLINE static const char* ClearBrowsingDataTypeToStringHelper(ClearBrowsingDataType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ClearBrowsingDataType::kBrowsingHistory:
      return "kBrowsingHistory";
    case ClearBrowsingDataType::kDownloadHistory:
      return "kDownloadHistory";
    case ClearBrowsingDataType::kCookiesAndSiteData:
      return "kCookiesAndSiteData";
    case ClearBrowsingDataType::kCachedImagesAndFiles:
      return "kCachedImagesAndFiles";
    case ClearBrowsingDataType::kPasswords:
      return "kPasswords";
    case ClearBrowsingDataType::kAutofill:
      return "kAutofill";
    case ClearBrowsingDataType::kSiteSettings:
      return "kSiteSettings";
    default:
      return nullptr;
  }
}

std::string ClearBrowsingDataTypeToString(ClearBrowsingDataType value) {
  const char *str = ClearBrowsingDataTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ClearBrowsingDataType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ClearBrowsingDataType value) {
  return os << ClearBrowsingDataTypeToString(value);
}

NOINLINE static const char* BrowserColorSchemeToStringHelper(BrowserColorScheme value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BrowserColorScheme::kSystem:
      return "kSystem";
    case BrowserColorScheme::kLight:
      return "kLight";
    case BrowserColorScheme::kDark:
      return "kDark";
    default:
      return nullptr;
  }
}

std::string BrowserColorSchemeToString(BrowserColorScheme value) {
  const char *str = BrowserColorSchemeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BrowserColorScheme value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BrowserColorScheme value) {
  return os << BrowserColorSchemeToString(value);
}

NOINLINE static const char* SetCookieResultToStringHelper(SetCookieResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SetCookieResult::kSuccess:
      return "kSuccess";
    case SetCookieResult::kFailure:
      return "kFailure";
    default:
      return nullptr;
  }
}

std::string SetCookieResultToString(SetCookieResult value) {
  const char *str = SetCookieResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SetCookieResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SetCookieResult value) {
  return os << SetCookieResultToString(value);
}

NOINLINE static const char* DeleteCookieResultToStringHelper(DeleteCookieResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DeleteCookieResult::kSuccess:
      return "kSuccess";
    case DeleteCookieResult::kFailure:
      return "kFailure";
    default:
      return nullptr;
  }
}

std::string DeleteCookieResultToString(DeleteCookieResult value) {
  const char *str = DeleteCookieResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DeleteCookieResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DeleteCookieResult value) {
  return os << DeleteCookieResultToString(value);
}

NOINLINE static const char* CookieSameSiteToStringHelper(CookieSameSite value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CookieSameSite::kUnspecified:
      return "kUnspecified";
    case CookieSameSite::kNone:
      return "kNone";
    case CookieSameSite::kLax:
      return "kLax";
    case CookieSameSite::kStrict:
      return "kStrict";
    default:
      return nullptr;
  }
}

std::string CookieSameSiteToString(CookieSameSite value) {
  const char *str = CookieSameSiteToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CookieSameSite value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CookieSameSite value) {
  return os << CookieSameSiteToString(value);
}

NOINLINE static const char* CookiePriorityToStringHelper(CookiePriority value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CookiePriority::kLow:
      return "kLow";
    case CookiePriority::kMedium:
      return "kMedium";
    case CookiePriority::kHigh:
      return "kHigh";
    default:
      return nullptr;
  }
}

std::string CookiePriorityToString(CookiePriority value) {
  const char *str = CookiePriorityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CookiePriority value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CookiePriority value) {
  return os << CookiePriorityToString(value);
}

NOINLINE static const char* CookieSourceSchemeToStringHelper(CookieSourceScheme value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CookieSourceScheme::kUnset:
      return "kUnset";
    case CookieSourceScheme::kNonSecure:
      return "kNonSecure";
    case CookieSourceScheme::kSecure:
      return "kSecure";
    default:
      return nullptr;
  }
}

std::string CookieSourceSchemeToString(CookieSourceScheme value) {
  const char *str = CookieSourceSchemeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CookieSourceScheme value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CookieSourceScheme value) {
  return os << CookieSourceSchemeToString(value);
}

NOINLINE static const char* CookieSourceTypeToStringHelper(CookieSourceType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CookieSourceType::kUnknown:
      return "kUnknown";
    case CookieSourceType::kHTTP:
      return "kHTTP";
    case CookieSourceType::kScript:
      return "kScript";
    case CookieSourceType::kOther:
      return "kOther";
    default:
      return nullptr;
  }
}

std::string CookieSourceTypeToString(CookieSourceType value) {
  const char *str = CookieSourceTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CookieSourceType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CookieSourceType value) {
  return os << CookieSourceTypeToString(value);
}

NOINLINE static const char* IsolatedWebViewSourceToStringHelper(IsolatedWebViewSource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IsolatedWebViewSource::kNewWindow:
      return "kNewWindow";
    default:
      return nullptr;
  }
}

std::string IsolatedWebViewSourceToString(IsolatedWebViewSource value) {
  const char *str = IsolatedWebViewSourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IsolatedWebViewSource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IsolatedWebViewSource value) {
  return os << IsolatedWebViewSourceToString(value);
}

NOINLINE static const char* BrowserWindowTypeToStringHelper(BrowserWindowType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BrowserWindowType::kNormal:
      return "kNormal";
    case BrowserWindowType::kPopup:
      return "kPopup";
    case BrowserWindowType::kApp:
      return "kApp";
    case BrowserWindowType::kAppPopup:
      return "kAppPopup";
    case BrowserWindowType::kDevTools:
      return "kDevTools";
    case BrowserWindowType::kPictureInPicture:
      return "kPictureInPicture";
    case BrowserWindowType::kCustomTab:
      return "kCustomTab";
    default:
      return nullptr;
  }
}

std::string BrowserWindowTypeToString(BrowserWindowType value) {
  const char *str = BrowserWindowTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BrowserWindowType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BrowserWindowType value) {
  return os << BrowserWindowTypeToString(value);
}

namespace internal {


// static
bool TypedUrl_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TypedUrl_Data* object =
      static_cast<const TypedUrl_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url_as_string, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& url_as_string_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->url_as_string, validation_context,
                                         &url_as_string_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_visit_time, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_visit_time, validation_context))
    return false;

  return true;
}

TypedUrl_Data::TypedUrl_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QueryHistoryItem_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const QueryHistoryItem_Data* object =
      static_cast<const QueryHistoryItem_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visit_time, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visit_time, validation_context))
    return false;

  return true;
}

QueryHistoryItem_Data::QueryHistoryItem_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QueryHistoryResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const QueryHistoryResponse_Data* object =
      static_cast<const QueryHistoryResponse_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->items, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->items, validation_context,
                                         &items_validate_params)) {
    return false;
  }

  return true;
}

QueryHistoryResponse_Data::QueryHistoryResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QueryHistoryOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const QueryHistoryOptions_Data* object =
      static_cast<const QueryHistoryOptions_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->start, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->end, validation_context))
    return false;

  return true;
}

QueryHistoryOptions_Data::QueryHistoryOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 104, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CookieData_Data* object =
      static_cast<const CookieData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& encrypted_value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->encrypted_value, validation_context,
                                         &encrypted_value_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->domain, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& domain_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->domain, validation_context,
                                         &domain_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& path_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->path, validation_context,
                                         &path_validate_params)) {
    return false;
  }


  if (!::owl::mojom::internal::CookieSameSite_Data
        ::Validate(object->same_site, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expiration_time, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->expiration_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->creation_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->last_access_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->last_update_time, validation_context))
    return false;


  if (!::owl::mojom::internal::CookiePriority_Data
        ::Validate(object->priority_$value, validation_context))
    return false;


  if (!::owl::mojom::internal::CookieSourceScheme_Data
        ::Validate(object->source_scheme_$value, validation_context))
    return false;


  if (!::owl::mojom::internal::CookieSourceType_Data
        ::Validate(object->source_type_$value, validation_context))
    return false;

  return true;
}

CookieData_Data::CookieData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HistoryVisit_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 96, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HistoryVisit_Data* object =
      static_cast<const HistoryVisit_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->url, validation_context,
                                         &url_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& external_referrer_url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->external_referrer_url, validation_context,
                                         &external_referrer_url_validate_params)) {
    return false;
  }

  return true;
}

HistoryVisit_Data::HistoryVisit_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IsolatedWebViewWindowInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IsolatedWebViewWindowInfo_Data* object =
      static_cast<const IsolatedWebViewWindowInfo_Data*>(data);


  if (!::owl::mojom::internal::BrowserWindowType_Data
        ::Validate(object->window_type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->window_bounds, validation_context))
    return false;

  return true;
}

IsolatedWebViewWindowInfo_Data::IsolatedWebViewWindowInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CreateBookmarkModelResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CreateBookmarkModelResult_Data* object =
      static_cast<const CreateBookmarkModelResult_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->model, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->model,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CreateBookmarkModelResult_Data::CreateBookmarkModelResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DownloadURLToFileClient_OnDoneOrErrored_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DownloadURLToFileClient_OnDoneOrErrored_Params_Data* object =
      static_cast<const DownloadURLToFileClient_OnDoneOrErrored_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& mime_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }

  return true;
}

DownloadURLToFileClient_OnDoneOrErrored_Params_Data::DownloadURLToFileClient_OnDoneOrErrored_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileCloseListener_OnClosed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileCloseListener_OnClosed_Params_Data* object =
      static_cast<const ProfileCloseListener_OnClosed_Params_Data*>(data);

  return true;
}

ProfileCloseListener_OnClosed_Params_Data::ProfileCloseListener_OnClosed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_SetClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_SetClient_Params_Data* object =
      static_cast<const Profile_SetClient_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Profile_SetClient_Params_Data::Profile_SetClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_GetIncognitoVariant_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_GetIncognitoVariant_Params_Data* object =
      static_cast<const Profile_GetIncognitoVariant_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Profile_GetIncognitoVariant_Params_Data::Profile_GetIncognitoVariant_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_SetBrowserColorScheme_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_SetBrowserColorScheme_Params_Data* object =
      static_cast<const Profile_SetBrowserColorScheme_Params_Data*>(data);


  if (!::owl::mojom::internal::BrowserColorScheme_Data
        ::Validate(object->scheme, validation_context))
    return false;

  return true;
}

Profile_SetBrowserColorScheme_Params_Data::Profile_SetBrowserColorScheme_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_SetOverrideColors_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_SetOverrideColors_Params_Data* object =
      static_cast<const Profile_SetOverrideColors_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->control_accent_color, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->selected_text_background_color, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->insertion_point_color, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->control_accent_background_color, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->control_accent_background_hover_color, validation_context))
    return false;

  return true;
}

Profile_SetOverrideColors_Params_Data::Profile_SetOverrideColors_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_CreateWebViewGroup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_CreateWebViewGroup_Params_Data* object =
      static_cast<const Profile_CreateWebViewGroup_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Profile_CreateWebViewGroup_Params_Data::Profile_CreateWebViewGroup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_RemoveWebViewGroup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_RemoveWebViewGroup_Params_Data* object =
      static_cast<const Profile_RemoveWebViewGroup_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

Profile_RemoveWebViewGroup_Params_Data::Profile_RemoveWebViewGroup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_CreateDownloadManager_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_CreateDownloadManager_Params_Data* object =
      static_cast<const Profile_CreateDownloadManager_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Profile_CreateDownloadManager_Params_Data::Profile_CreateDownloadManager_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_CreateBookmarkModel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_CreateBookmarkModel_Params_Data* object =
      static_cast<const Profile_CreateBookmarkModel_Params_Data*>(data);

  return true;
}

Profile_CreateBookmarkModel_Params_Data::Profile_CreateBookmarkModel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_CreateBookmarkModel_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_CreateBookmarkModel_ResponseParams_Data* object =
      static_cast<const Profile_CreateBookmarkModel_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

Profile_CreateBookmarkModel_ResponseParams_Data::Profile_CreateBookmarkModel_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_CreateExtensionService_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_CreateExtensionService_Params_Data* object =
      static_cast<const Profile_CreateExtensionService_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Profile_CreateExtensionService_Params_Data::Profile_CreateExtensionService_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_CreateAutofillController_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_CreateAutofillController_Params_Data* object =
      static_cast<const Profile_CreateAutofillController_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Profile_CreateAutofillController_Params_Data::Profile_CreateAutofillController_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_CreateMetricsService_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_CreateMetricsService_Params_Data* object =
      static_cast<const Profile_CreateMetricsService_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Profile_CreateMetricsService_Params_Data::Profile_CreateMetricsService_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_CreateNotificationService_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_CreateNotificationService_Params_Data* object =
      static_cast<const Profile_CreateNotificationService_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Profile_CreateNotificationService_Params_Data::Profile_CreateNotificationService_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_CreateWebViewContainerView_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_CreateWebViewContainerView_Params_Data* object =
      static_cast<const Profile_CreateWebViewContainerView_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->layer_host_receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->layer_host_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->layer_host_client, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->layer_host_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Profile_CreateWebViewContainerView_Params_Data::Profile_CreateWebViewContainerView_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_GetTypedUrls_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_GetTypedUrls_Params_Data* object =
      static_cast<const Profile_GetTypedUrls_Params_Data*>(data);

  return true;
}

Profile_GetTypedUrls_Params_Data::Profile_GetTypedUrls_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_GetTypedUrls_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_GetTypedUrls_ResponseParams_Data* object =
      static_cast<const Profile_GetTypedUrls_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->typed_urls, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& typed_urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->typed_urls, validation_context,
                                         &typed_urls_validate_params)) {
    return false;
  }

  return true;
}

Profile_GetTypedUrls_ResponseParams_Data::Profile_GetTypedUrls_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_GetAddressList_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_GetAddressList_Params_Data* object =
      static_cast<const Profile_GetAddressList_Params_Data*>(data);

  return true;
}

Profile_GetAddressList_Params_Data::Profile_GetAddressList_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_GetAddressList_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_GetAddressList_ResponseParams_Data* object =
      static_cast<const Profile_GetAddressList_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->addresses, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& addresses_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->addresses, validation_context,
                                         &addresses_validate_params)) {
    return false;
  }

  return true;
}

Profile_GetAddressList_ResponseParams_Data::Profile_GetAddressList_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_GetCreditCardList_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_GetCreditCardList_Params_Data* object =
      static_cast<const Profile_GetCreditCardList_Params_Data*>(data);

  return true;
}

Profile_GetCreditCardList_Params_Data::Profile_GetCreditCardList_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_GetCreditCardList_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_GetCreditCardList_ResponseParams_Data* object =
      static_cast<const Profile_GetCreditCardList_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->credit_cards, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& credit_cards_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->credit_cards, validation_context,
                                         &credit_cards_validate_params)) {
    return false;
  }

  return true;
}

Profile_GetCreditCardList_ResponseParams_Data::Profile_GetCreditCardList_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_SetCookie_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_SetCookie_Params_Data* object =
      static_cast<const Profile_SetCookie_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookie, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cookie, validation_context))
    return false;

  return true;
}

Profile_SetCookie_Params_Data::Profile_SetCookie_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_SetCookie_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_SetCookie_ResponseParams_Data* object =
      static_cast<const Profile_SetCookie_ResponseParams_Data*>(data);


  if (!::owl::mojom::internal::SetCookieResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

Profile_SetCookie_ResponseParams_Data::Profile_SetCookie_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_DeleteCookie_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_DeleteCookie_Params_Data* object =
      static_cast<const Profile_DeleteCookie_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookie, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cookie, validation_context))
    return false;

  return true;
}

Profile_DeleteCookie_Params_Data::Profile_DeleteCookie_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_DeleteCookie_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_DeleteCookie_ResponseParams_Data* object =
      static_cast<const Profile_DeleteCookie_ResponseParams_Data*>(data);


  if (!::owl::mojom::internal::DeleteCookieResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

Profile_DeleteCookie_ResponseParams_Data::Profile_DeleteCookie_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_MergeCookies_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_MergeCookies_Params_Data* object =
      static_cast<const Profile_MergeCookies_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookies, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cookies_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cookies, validation_context,
                                         &cookies_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& decryption_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->decryption_key, validation_context,
                                         &decryption_key_validate_params)) {
    return false;
  }

  return true;
}

Profile_MergeCookies_Params_Data::Profile_MergeCookies_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_MergeCookies_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_MergeCookies_ResponseParams_Data* object =
      static_cast<const Profile_MergeCookies_ResponseParams_Data*>(data);

  return true;
}

Profile_MergeCookies_ResponseParams_Data::Profile_MergeCookies_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_MergeLocalStorage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_MergeLocalStorage_Params_Data* object =
      static_cast<const Profile_MergeLocalStorage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_dirs, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& source_dirs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->source_dirs, validation_context,
                                         &source_dirs_validate_params)) {
    return false;
  }

  return true;
}

Profile_MergeLocalStorage_Params_Data::Profile_MergeLocalStorage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_MergeLocalStorage_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_MergeLocalStorage_ResponseParams_Data* object =
      static_cast<const Profile_MergeLocalStorage_ResponseParams_Data*>(data);

  return true;
}

Profile_MergeLocalStorage_ResponseParams_Data::Profile_MergeLocalStorage_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_GetAllCookies_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_GetAllCookies_Params_Data* object =
      static_cast<const Profile_GetAllCookies_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

Profile_GetAllCookies_Params_Data::Profile_GetAllCookies_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_GetAllCookies_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_GetAllCookies_ResponseParams_Data* object =
      static_cast<const Profile_GetAllCookies_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookies, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cookies_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cookies, validation_context,
                                         &cookies_validate_params)) {
    return false;
  }

  return true;
}

Profile_GetAllCookies_ResponseParams_Data::Profile_GetAllCookies_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_GetCookies_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_GetCookies_Params_Data* object =
      static_cast<const Profile_GetCookies_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  return true;
}

Profile_GetCookies_Params_Data::Profile_GetCookies_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_GetCookies_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_GetCookies_ResponseParams_Data* object =
      static_cast<const Profile_GetCookies_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookies, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cookies_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cookies, validation_context,
                                         &cookies_validate_params)) {
    return false;
  }

  return true;
}

Profile_GetCookies_ResponseParams_Data::Profile_GetCookies_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_GetFaviconFromFaviconUrl_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_GetFaviconFromFaviconUrl_Params_Data* object =
      static_cast<const Profile_GetFaviconFromFaviconUrl_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

Profile_GetFaviconFromFaviconUrl_Params_Data::Profile_GetFaviconFromFaviconUrl_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_GetFaviconFromFaviconUrl_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_GetFaviconFromFaviconUrl_ResponseParams_Data* object =
      static_cast<const Profile_GetFaviconFromFaviconUrl_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->image, validation_context))
    return false;

  return true;
}

Profile_GetFaviconFromFaviconUrl_ResponseParams_Data::Profile_GetFaviconFromFaviconUrl_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_GetFaviconForPageUrl_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_GetFaviconForPageUrl_Params_Data* object =
      static_cast<const Profile_GetFaviconForPageUrl_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

Profile_GetFaviconForPageUrl_Params_Data::Profile_GetFaviconForPageUrl_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_GetFaviconForPageUrl_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_GetFaviconForPageUrl_ResponseParams_Data* object =
      static_cast<const Profile_GetFaviconForPageUrl_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->image, validation_context))
    return false;

  return true;
}

Profile_GetFaviconForPageUrl_ResponseParams_Data::Profile_GetFaviconForPageUrl_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_CreateAutocompleteController_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_CreateAutocompleteController_Params_Data* object =
      static_cast<const Profile_CreateAutocompleteController_Params_Data*>(data);


  if (!::owl::mojom::internal::AutocompleteConfiguration_Data
        ::Validate(object->configuration, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Profile_CreateAutocompleteController_Params_Data::Profile_CreateAutocompleteController_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_CreateURLLoaderFactory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_CreateURLLoaderFactory_Params_Data* object =
      static_cast<const Profile_CreateURLLoaderFactory_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Profile_CreateURLLoaderFactory_Params_Data::Profile_CreateURLLoaderFactory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_GetDefaultDownloadsLocation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_GetDefaultDownloadsLocation_Params_Data* object =
      static_cast<const Profile_GetDefaultDownloadsLocation_Params_Data*>(data);

  return true;
}

Profile_GetDefaultDownloadsLocation_Params_Data::Profile_GetDefaultDownloadsLocation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_GetDefaultDownloadsLocation_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_GetDefaultDownloadsLocation_ResponseParams_Data* object =
      static_cast<const Profile_GetDefaultDownloadsLocation_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  return true;
}

Profile_GetDefaultDownloadsLocation_ResponseParams_Data::Profile_GetDefaultDownloadsLocation_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_SetDefaultDownloadsLocation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_SetDefaultDownloadsLocation_Params_Data* object =
      static_cast<const Profile_SetDefaultDownloadsLocation_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  return true;
}

Profile_SetDefaultDownloadsLocation_Params_Data::Profile_SetDefaultDownloadsLocation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_RegisterSearchKeywordsClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_RegisterSearchKeywordsClient_Params_Data* object =
      static_cast<const Profile_RegisterSearchKeywordsClient_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Profile_RegisterSearchKeywordsClient_Params_Data::Profile_RegisterSearchKeywordsClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_AddSearchKeyword_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_AddSearchKeyword_Params_Data* object =
      static_cast<const Profile_AddSearchKeyword_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keyword, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->keyword, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

Profile_AddSearchKeyword_Params_Data::Profile_AddSearchKeyword_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_AddSearchKeyword_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_AddSearchKeyword_ResponseParams_Data* object =
      static_cast<const Profile_AddSearchKeyword_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

Profile_AddSearchKeyword_ResponseParams_Data::Profile_AddSearchKeyword_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_RemoveSearchKeyword_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_RemoveSearchKeyword_Params_Data* object =
      static_cast<const Profile_RemoveSearchKeyword_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

Profile_RemoveSearchKeyword_Params_Data::Profile_RemoveSearchKeyword_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_UpdateSearchKeyword_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_UpdateSearchKeyword_Params_Data* object =
      static_cast<const Profile_UpdateSearchKeyword_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keyword, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->keyword, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

Profile_UpdateSearchKeyword_Params_Data::Profile_UpdateSearchKeyword_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_DownloadURLToFile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_DownloadURLToFile_Params_Data* object =
      static_cast<const Profile_DownloadURLToFile_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Profile_DownloadURLToFile_Params_Data::Profile_DownloadURLToFile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_FlushCookies_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_FlushCookies_Params_Data* object =
      static_cast<const Profile_FlushCookies_Params_Data*>(data);

  return true;
}

Profile_FlushCookies_Params_Data::Profile_FlushCookies_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_FlushCookies_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_FlushCookies_ResponseParams_Data* object =
      static_cast<const Profile_FlushCookies_ResponseParams_Data*>(data);

  return true;
}

Profile_FlushCookies_ResponseParams_Data::Profile_FlushCookies_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_CloseProfile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_CloseProfile_Params_Data* object =
      static_cast<const Profile_CloseProfile_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->listener, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Profile_CloseProfile_Params_Data::Profile_CloseProfile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_ImportHistory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_ImportHistory_Params_Data* object =
      static_cast<const Profile_ImportHistory_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visits, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& visits_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->visits, validation_context,
                                         &visits_validate_params)) {
    return false;
  }

  return true;
}

Profile_ImportHistory_Params_Data::Profile_ImportHistory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_ImportHistory_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_ImportHistory_ResponseParams_Data* object =
      static_cast<const Profile_ImportHistory_ResponseParams_Data*>(data);

  return true;
}

Profile_ImportHistory_ResponseParams_Data::Profile_ImportHistory_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_ImportChromePasswords_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_ImportChromePasswords_Params_Data* object =
      static_cast<const Profile_ImportChromePasswords_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->profile_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->profile_path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->decryption_key, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& decryption_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->decryption_key, validation_context,
                                         &decryption_key_validate_params)) {
    return false;
  }

  return true;
}

Profile_ImportChromePasswords_Params_Data::Profile_ImportChromePasswords_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_ImportChromePasswords_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_ImportChromePasswords_ResponseParams_Data* object =
      static_cast<const Profile_ImportChromePasswords_ResponseParams_Data*>(data);

  return true;
}

Profile_ImportChromePasswords_ResponseParams_Data::Profile_ImportChromePasswords_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_ClearBrowsingData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_ClearBrowsingData_Params_Data* object =
      static_cast<const Profile_ClearBrowsingData_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->types, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& types_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::owl::mojom::internal::ClearBrowsingDataType_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->types, validation_context,
                                         &types_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->delete_begin, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->delete_end, validation_context))
    return false;

  return true;
}

Profile_ClearBrowsingData_Params_Data::Profile_ClearBrowsingData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_ClearBrowsingData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_ClearBrowsingData_ResponseParams_Data* object =
      static_cast<const Profile_ClearBrowsingData_ResponseParams_Data*>(data);

  return true;
}

Profile_ClearBrowsingData_ResponseParams_Data::Profile_ClearBrowsingData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_DeferLoadsForOrigin_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_DeferLoadsForOrigin_Params_Data* object =
      static_cast<const Profile_DeferLoadsForOrigin_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->blocker_receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->blocker_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Profile_DeferLoadsForOrigin_Params_Data::Profile_DeferLoadsForOrigin_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_SetCustomHeaderForHosts_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_SetCustomHeaderForHosts_Params_Data* object =
      static_cast<const Profile_SetCustomHeaderForHosts_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->header_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& header_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->header_name, validation_context,
                                         &header_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->header_value, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& header_value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->header_value, validation_context,
                                         &header_value_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hosts, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& hosts_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->hosts, validation_context,
                                         &hosts_validate_params)) {
    return false;
  }

  return true;
}

Profile_SetCustomHeaderForHosts_Params_Data::Profile_SetCustomHeaderForHosts_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_ResetProfileSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_ResetProfileSettings_Params_Data* object =
      static_cast<const Profile_ResetProfileSettings_Params_Data*>(data);

  return true;
}

Profile_ResetProfileSettings_Params_Data::Profile_ResetProfileSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_ResetProfileSettings_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_ResetProfileSettings_ResponseParams_Data* object =
      static_cast<const Profile_ResetProfileSettings_ResponseParams_Data*>(data);

  return true;
}

Profile_ResetProfileSettings_ResponseParams_Data::Profile_ResetProfileSettings_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_SetWebPreferences_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_SetWebPreferences_Params_Data* object =
      static_cast<const Profile_SetWebPreferences_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->prefs, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->prefs, validation_context))
    return false;

  return true;
}

Profile_SetWebPreferences_Params_Data::Profile_SetWebPreferences_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_GetWebPreferences_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_GetWebPreferences_Params_Data* object =
      static_cast<const Profile_GetWebPreferences_Params_Data*>(data);

  return true;
}

Profile_GetWebPreferences_Params_Data::Profile_GetWebPreferences_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_GetWebPreferences_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_GetWebPreferences_ResponseParams_Data* object =
      static_cast<const Profile_GetWebPreferences_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->prefs, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->prefs, validation_context))
    return false;

  return true;
}

Profile_GetWebPreferences_ResponseParams_Data::Profile_GetWebPreferences_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_QueryHistory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_QueryHistory_Params_Data* object =
      static_cast<const Profile_QueryHistory_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->query, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

Profile_QueryHistory_Params_Data::Profile_QueryHistory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_QueryHistory_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_QueryHistory_ResponseParams_Data* object =
      static_cast<const Profile_QueryHistory_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  return true;
}

Profile_QueryHistory_ResponseParams_Data::Profile_QueryHistory_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_Ping_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_Ping_Params_Data* object =
      static_cast<const Profile_Ping_Params_Data*>(data);

  return true;
}

Profile_Ping_Params_Data::Profile_Ping_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Profile_Ping_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Profile_Ping_ResponseParams_Data* object =
      static_cast<const Profile_Ping_ResponseParams_Data*>(data);

  return true;
}

Profile_Ping_ResponseParams_Data::Profile_Ping_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileClient_UpdateDisplays_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileClient_UpdateDisplays_Params_Data* object =
      static_cast<const ProfileClient_UpdateDisplays_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->displays, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& displays_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->displays, validation_context,
                                         &displays_validate_params)) {
    return false;
  }

  return true;
}

ProfileClient_UpdateDisplays_Params_Data::ProfileClient_UpdateDisplays_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileClient_CreateWebContentClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileClient_CreateWebContentClient_Params_Data* object =
      static_cast<const ProfileClient_CreateWebContentClient_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->content, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->content,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ProfileClient_CreateWebContentClient_Params_Data::ProfileClient_CreateWebContentClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileClient_CreatedWebViewGroup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileClient_CreatedWebViewGroup_Params_Data* object =
      static_cast<const ProfileClient_CreatedWebViewGroup_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->group, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->group,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client_receiver, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ProfileClient_CreatedWebViewGroup_Params_Data::ProfileClient_CreatedWebViewGroup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileClient_CreatedIsolatedWebView_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileClient_CreatedIsolatedWebView_Params_Data* object =
      static_cast<const ProfileClient_CreatedIsolatedWebView_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_id, validation_context,
                                         &group_id_validate_params)) {
    return false;
  }


  if (!::owl::mojom::internal::IsolatedWebViewSource_Data
        ::Validate(object->source, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->window_info, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->group, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->group,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->group_client_receiver, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->group_client_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->view, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->view,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->view_client_receiver, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->view_client_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ProfileClient_CreatedIsolatedWebView_Params_Data::ProfileClient_CreatedIsolatedWebView_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileClient_CreateWindowBridge_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileClient_CreateWindowBridge_Params_Data* object =
      static_cast<const ProfileClient_CreateWindowBridge_Params_Data*>(data);


  if (!::owl::mojom::internal::WindowBridgeSource_Data
        ::Validate(object->source, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ProfileClient_CreateWindowBridge_Params_Data::ProfileClient_CreateWindowBridge_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileClient_OnMainFrameTypedNavigation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileClient_OnMainFrameTypedNavigation_Params_Data* object =
      static_cast<const ProfileClient_OnMainFrameTypedNavigation_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url_as_string, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& url_as_string_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->url_as_string, validation_context,
                                         &url_as_string_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  return true;
}

ProfileClient_OnMainFrameTypedNavigation_Params_Data::ProfileClient_OnMainFrameTypedNavigation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileClient_OnHistoryDeletions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileClient_OnHistoryDeletions_Params_Data* object =
      static_cast<const ProfileClient_OnHistoryDeletions_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->delete_begin, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->delete_end, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& restrict_urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->restrict_urls, validation_context,
                                         &restrict_urls_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->deleted_urls, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& deleted_urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->deleted_urls, validation_context,
                                         &deleted_urls_validate_params)) {
    return false;
  }

  return true;
}

ProfileClient_OnHistoryDeletions_Params_Data::ProfileClient_OnHistoryDeletions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfileClient_OnFaviconsChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileClient_OnFaviconsChanged_Params_Data* object =
      static_cast<const ProfileClient_OnFaviconsChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->page_urls, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& page_urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->page_urls, validation_context,
                                         &page_urls_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->icon_url, validation_context))
    return false;

  return true;
}

ProfileClient_OnFaviconsChanged_Params_Data::ProfileClient_OnFaviconsChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace owl

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::ClearBrowsingDataType>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::ClearBrowsingDataType value) {
  return std::move(context).WriteString(::owl::mojom::ClearBrowsingDataTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::BrowserColorScheme>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::BrowserColorScheme value) {
  return std::move(context).WriteString(::owl::mojom::BrowserColorSchemeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::SetCookieResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::SetCookieResult value) {
  return std::move(context).WriteString(::owl::mojom::SetCookieResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::DeleteCookieResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::DeleteCookieResult value) {
  return std::move(context).WriteString(::owl::mojom::DeleteCookieResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::CookieSameSite>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::CookieSameSite value) {
  return std::move(context).WriteString(::owl::mojom::CookieSameSiteToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::CookiePriority>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::CookiePriority value) {
  return std::move(context).WriteString(::owl::mojom::CookiePriorityToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::CookieSourceScheme>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::CookieSourceScheme value) {
  return std::move(context).WriteString(::owl::mojom::CookieSourceSchemeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::CookieSourceType>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::CookieSourceType value) {
  return std::move(context).WriteString(::owl::mojom::CookieSourceTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::IsolatedWebViewSource>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::IsolatedWebViewSource value) {
  return std::move(context).WriteString(::owl::mojom::IsolatedWebViewSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::BrowserWindowType>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::BrowserWindowType value) {
  return std::move(context).WriteString(::owl::mojom::BrowserWindowTypeToString(value));
}

} // namespace perfetto