// owl/mojom/permission_prompt.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_PERMISSION_PROMPT_MOJOM_H_
#define OWL_MOJOM_PERMISSION_PROMPT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/permission_prompt.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/permission_prompt.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/permission_prompt.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class PermissionPromptProxy;

template <typename ImplRefTraits>
class PermissionPromptStub;

class PermissionPromptRequestValidator;


class PermissionPrompt
    : public PermissionPromptInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.PermissionPrompt";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PermissionPromptInterfaceBase;
  using Proxy_ = PermissionPromptProxy;

  template <typename ImplRefTraits>
  using Stub_ = PermissionPromptStub<ImplRefTraits>;

  using RequestValidator_ = PermissionPromptRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCloseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Close_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PermissionPrompt() = default;

  virtual void Close() = 0;
};

class PermissionPromptClientProxy;

template <typename ImplRefTraits>
class PermissionPromptClientStub;

class PermissionPromptClientRequestValidator;


class PermissionPromptClient
    : public PermissionPromptClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.PermissionPromptClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PermissionPromptClientInterfaceBase;
  using Proxy_ = PermissionPromptClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = PermissionPromptClientStub<ImplRefTraits>;

  using RequestValidator_ = PermissionPromptClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAcceptMinVersion = 0,
    kAcceptOnceMinVersion = 0,
    kDenyMinVersion = 0,
    kDismissMinVersion = 0,
    kRunViewButtonMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Accept_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AcceptOnce_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Deny_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Dismiss_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RunViewButton_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PermissionPromptClient() = default;

  virtual void Accept() = 0;

  virtual void AcceptOnce() = 0;

  virtual void Deny() = 0;

  virtual void Dismiss() = 0;

  virtual void RunViewButton(int32_t id) = 0;
};



class  PermissionPromptProxy
    : public PermissionPrompt {
 public:
  using InterfaceType = PermissionPrompt;

  explicit PermissionPromptProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Close() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PermissionPromptClientProxy
    : public PermissionPromptClient {
 public:
  using InterfaceType = PermissionPromptClient;

  explicit PermissionPromptClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Accept() final;
  
  void AcceptOnce() final;
  
  void Deny() final;
  
  void Dismiss() final;
  
  void RunViewButton(int32_t id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PermissionPromptStubDispatch {
 public:
  static bool Accept(PermissionPrompt* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PermissionPrompt* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PermissionPrompt>>
class PermissionPromptStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PermissionPromptStub() = default;
  ~PermissionPromptStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PermissionPromptStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PermissionPromptStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PermissionPromptClientStubDispatch {
 public:
  static bool Accept(PermissionPromptClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PermissionPromptClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PermissionPromptClient>>
class PermissionPromptClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PermissionPromptClientStub() = default;
  ~PermissionPromptClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PermissionPromptClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PermissionPromptClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PermissionPromptRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PermissionPromptClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class  PermissionPromptViewButton {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PermissionPromptViewButton, T>::value>;
  using DataView = PermissionPromptViewButtonDataView;
  using Data_ = internal::PermissionPromptViewButton_Data;

  template <typename... Args>
  static PermissionPromptViewButtonPtr New(Args&&... args) {
    return PermissionPromptViewButtonPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PermissionPromptViewButtonPtr From(const U& u) {
    return mojo::TypeConverter<PermissionPromptViewButtonPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PermissionPromptViewButton>::Convert(*this);
  }


  PermissionPromptViewButton();

  PermissionPromptViewButton(
      const ::std::u16string& text,
      int32_t id);


  ~PermissionPromptViewButton();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PermissionPromptViewButtonPtr>
  PermissionPromptViewButtonPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PermissionPromptViewButton::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PermissionPromptViewButton::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PermissionPromptViewButton::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PermissionPromptViewButton::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PermissionPromptViewButton::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PermissionPromptViewButton::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PermissionPromptViewButton_UnserializedMessageContext<
            UserType, PermissionPromptViewButton::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PermissionPromptViewButton::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PermissionPromptViewButton::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PermissionPromptViewButton_UnserializedMessageContext<
            UserType, PermissionPromptViewButton::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PermissionPromptViewButton::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string text;
  
  int32_t id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PermissionPromptViewButton::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PermissionPromptViewButton::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PermissionPromptViewButton::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PermissionPromptViewButton::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PermissionPromptRequestItem {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PermissionPromptRequestItem, T>::value>;
  using DataView = PermissionPromptRequestItemDataView;
  using Data_ = internal::PermissionPromptRequestItem_Data;

  template <typename... Args>
  static PermissionPromptRequestItemPtr New(Args&&... args) {
    return PermissionPromptRequestItemPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PermissionPromptRequestItemPtr From(const U& u) {
    return mojo::TypeConverter<PermissionPromptRequestItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PermissionPromptRequestItem>::Convert(*this);
  }


  PermissionPromptRequestItem();

  PermissionPromptRequestItem(
      PermissionPromptRequestType request_type,
      const ::std::u16string& text);


  ~PermissionPromptRequestItem();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PermissionPromptRequestItemPtr>
  PermissionPromptRequestItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PermissionPromptRequestItem::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PermissionPromptRequestItem::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PermissionPromptRequestItem::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PermissionPromptRequestItem::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PermissionPromptRequestItem::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PermissionPromptRequestItem::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PermissionPromptRequestItem_UnserializedMessageContext<
            UserType, PermissionPromptRequestItem::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PermissionPromptRequestItem::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PermissionPromptRequestItem::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PermissionPromptRequestItem_UnserializedMessageContext<
            UserType, PermissionPromptRequestItem::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PermissionPromptRequestItem::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  PermissionPromptRequestType request_type;
  
  ::std::u16string text;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PermissionPromptRequestItem::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PermissionPromptRequestItem::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PermissionPromptRequestItem::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PermissionPromptRequestItem::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PermissionPromptDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PermissionPromptDetails, T>::value>;
  using DataView = PermissionPromptDetailsDataView;
  using Data_ = internal::PermissionPromptDetails_Data;

  template <typename... Args>
  static PermissionPromptDetailsPtr New(Args&&... args) {
    return PermissionPromptDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PermissionPromptDetailsPtr From(const U& u) {
    return mojo::TypeConverter<PermissionPromptDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PermissionPromptDetails>::Convert(*this);
  }


  PermissionPromptDetails();

  PermissionPromptDetails(
      const ::GURL& requesting_origin,
      const ::std::u16string& title,
      const std::optional<::std::u16string>& extra_text,
      bool is_embedded,
      std::vector<PermissionPromptRequestItemPtr> requests,
      const ::std::u16string& allow_text,
      const std::optional<::std::u16string>& allow_once_text,
      const ::std::u16string& block_text,
      std::vector<PermissionPromptViewButtonPtr> view_buttons);

PermissionPromptDetails(const PermissionPromptDetails&) = delete;
PermissionPromptDetails& operator=(const PermissionPromptDetails&) = delete;

  ~PermissionPromptDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PermissionPromptDetailsPtr>
  PermissionPromptDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PermissionPromptDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PermissionPromptDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PermissionPromptDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PermissionPromptDetails::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PermissionPromptDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PermissionPromptDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PermissionPromptDetails_UnserializedMessageContext<
            UserType, PermissionPromptDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PermissionPromptDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PermissionPromptDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PermissionPromptDetails_UnserializedMessageContext<
            UserType, PermissionPromptDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PermissionPromptDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL requesting_origin;
  
  ::std::u16string title;
  
  std::optional<::std::u16string> extra_text;
  
  bool is_embedded;
  
  std::vector<PermissionPromptRequestItemPtr> requests;
  
  ::std::u16string allow_text;
  
  std::optional<::std::u16string> allow_once_text;
  
  ::std::u16string block_text;
  
  std::vector<PermissionPromptViewButtonPtr> view_buttons;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PermissionPromptDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PermissionPromptDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PermissionPromptDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PermissionPromptDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PermissionPromptViewButtonPtr PermissionPromptViewButton::Clone() const {
  return New(
      mojo::Clone(text),
      mojo::Clone(id)
  );
}

template <typename T, PermissionPromptViewButton::EnableIfSame<T>*>
bool PermissionPromptViewButton::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->text, other_struct.text))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, PermissionPromptViewButton::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.text < rhs.text)
    return true;
  if (rhs.text < lhs.text)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}
template <typename StructPtrType>
PermissionPromptRequestItemPtr PermissionPromptRequestItem::Clone() const {
  return New(
      mojo::Clone(request_type),
      mojo::Clone(text)
  );
}

template <typename T, PermissionPromptRequestItem::EnableIfSame<T>*>
bool PermissionPromptRequestItem::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request_type, other_struct.request_type))
    return false;
  if (!mojo::Equals(this->text, other_struct.text))
    return false;
  return true;
}

template <typename T, PermissionPromptRequestItem::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.request_type < rhs.request_type)
    return true;
  if (rhs.request_type < lhs.request_type)
    return false;
  if (lhs.text < rhs.text)
    return true;
  if (rhs.text < lhs.text)
    return false;
  return false;
}
template <typename StructPtrType>
PermissionPromptDetailsPtr PermissionPromptDetails::Clone() const {
  return New(
      mojo::Clone(requesting_origin),
      mojo::Clone(title),
      mojo::Clone(extra_text),
      mojo::Clone(is_embedded),
      mojo::Clone(requests),
      mojo::Clone(allow_text),
      mojo::Clone(allow_once_text),
      mojo::Clone(block_text),
      mojo::Clone(view_buttons)
  );
}

template <typename T, PermissionPromptDetails::EnableIfSame<T>*>
bool PermissionPromptDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->requesting_origin, other_struct.requesting_origin))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->extra_text, other_struct.extra_text))
    return false;
  if (!mojo::Equals(this->is_embedded, other_struct.is_embedded))
    return false;
  if (!mojo::Equals(this->requests, other_struct.requests))
    return false;
  if (!mojo::Equals(this->allow_text, other_struct.allow_text))
    return false;
  if (!mojo::Equals(this->allow_once_text, other_struct.allow_once_text))
    return false;
  if (!mojo::Equals(this->block_text, other_struct.block_text))
    return false;
  if (!mojo::Equals(this->view_buttons, other_struct.view_buttons))
    return false;
  return true;
}

template <typename T, PermissionPromptDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.requesting_origin < rhs.requesting_origin)
    return true;
  if (rhs.requesting_origin < lhs.requesting_origin)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.extra_text < rhs.extra_text)
    return true;
  if (rhs.extra_text < lhs.extra_text)
    return false;
  if (lhs.is_embedded < rhs.is_embedded)
    return true;
  if (rhs.is_embedded < lhs.is_embedded)
    return false;
  if (lhs.requests < rhs.requests)
    return true;
  if (rhs.requests < lhs.requests)
    return false;
  if (lhs.allow_text < rhs.allow_text)
    return true;
  if (rhs.allow_text < lhs.allow_text)
    return false;
  if (lhs.allow_once_text < rhs.allow_once_text)
    return true;
  if (rhs.allow_once_text < lhs.allow_once_text)
    return false;
  if (lhs.block_text < rhs.block_text)
    return true;
  if (rhs.block_text < lhs.block_text)
    return false;
  if (lhs.view_buttons < rhs.view_buttons)
    return true;
  if (rhs.view_buttons < lhs.view_buttons)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::PermissionPromptViewButton::DataView,
                                         ::owl::mojom::PermissionPromptViewButtonPtr> {
  static bool IsNull(const ::owl::mojom::PermissionPromptViewButtonPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::PermissionPromptViewButtonPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::PermissionPromptViewButton::text)& text(
      const ::owl::mojom::PermissionPromptViewButtonPtr& input) {
    return input->text;
  }

  static decltype(::owl::mojom::PermissionPromptViewButton::id) id(
      const ::owl::mojom::PermissionPromptViewButtonPtr& input) {
    return input->id;
  }

  static bool Read(::owl::mojom::PermissionPromptViewButton::DataView input, ::owl::mojom::PermissionPromptViewButtonPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::PermissionPromptRequestItem::DataView,
                                         ::owl::mojom::PermissionPromptRequestItemPtr> {
  static bool IsNull(const ::owl::mojom::PermissionPromptRequestItemPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::PermissionPromptRequestItemPtr* output) { output->reset(); }

  static decltype(::owl::mojom::PermissionPromptRequestItem::request_type) request_type(
      const ::owl::mojom::PermissionPromptRequestItemPtr& input) {
    return input->request_type;
  }

  static const decltype(::owl::mojom::PermissionPromptRequestItem::text)& text(
      const ::owl::mojom::PermissionPromptRequestItemPtr& input) {
    return input->text;
  }

  static bool Read(::owl::mojom::PermissionPromptRequestItem::DataView input, ::owl::mojom::PermissionPromptRequestItemPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::PermissionPromptDetails::DataView,
                                         ::owl::mojom::PermissionPromptDetailsPtr> {
  static bool IsNull(const ::owl::mojom::PermissionPromptDetailsPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::PermissionPromptDetailsPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::PermissionPromptDetails::requesting_origin)& requesting_origin(
      const ::owl::mojom::PermissionPromptDetailsPtr& input) {
    return input->requesting_origin;
  }

  static const decltype(::owl::mojom::PermissionPromptDetails::title)& title(
      const ::owl::mojom::PermissionPromptDetailsPtr& input) {
    return input->title;
  }

  static const decltype(::owl::mojom::PermissionPromptDetails::extra_text)& extra_text(
      const ::owl::mojom::PermissionPromptDetailsPtr& input) {
    return input->extra_text;
  }

  static decltype(::owl::mojom::PermissionPromptDetails::is_embedded) is_embedded(
      const ::owl::mojom::PermissionPromptDetailsPtr& input) {
    return input->is_embedded;
  }

  static const decltype(::owl::mojom::PermissionPromptDetails::requests)& requests(
      const ::owl::mojom::PermissionPromptDetailsPtr& input) {
    return input->requests;
  }

  static const decltype(::owl::mojom::PermissionPromptDetails::allow_text)& allow_text(
      const ::owl::mojom::PermissionPromptDetailsPtr& input) {
    return input->allow_text;
  }

  static const decltype(::owl::mojom::PermissionPromptDetails::allow_once_text)& allow_once_text(
      const ::owl::mojom::PermissionPromptDetailsPtr& input) {
    return input->allow_once_text;
  }

  static const decltype(::owl::mojom::PermissionPromptDetails::block_text)& block_text(
      const ::owl::mojom::PermissionPromptDetailsPtr& input) {
    return input->block_text;
  }

  static const decltype(::owl::mojom::PermissionPromptDetails::view_buttons)& view_buttons(
      const ::owl::mojom::PermissionPromptDetailsPtr& input) {
    return input->view_buttons;
  }

  static bool Read(::owl::mojom::PermissionPromptDetails::DataView input, ::owl::mojom::PermissionPromptDetailsPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_PERMISSION_PROMPT_MOJOM_H_