// owl/mojom/permission_prompt.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_PERMISSION_PROMPT_MOJOM_DATA_VIEW_H_
#define OWL_MOJOM_PERMISSION_PROMPT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "owl/mojom/permission_prompt.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace owl::mojom {
class PermissionPromptViewButtonDataView;

class PermissionPromptRequestItemDataView;

class PermissionPromptDetailsDataView;



}  // owl::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::owl::mojom::PermissionPromptViewButtonDataView> {
  using Data = ::owl::mojom::internal::PermissionPromptViewButton_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::PermissionPromptRequestItemDataView> {
  using Data = ::owl::mojom::internal::PermissionPromptRequestItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::PermissionPromptDetailsDataView> {
  using Data = ::owl::mojom::internal::PermissionPromptDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace owl::mojom {


enum class PermissionPromptRequestType : int32_t {
  
  kUnknown = 0,
  
  kArSession = 1,
  
  kCameraPanTiltZoom = 2,
  
  kCameraStream = 3,
  
  kCapturedSurfaceControl = 4,
  
  kClipboard = 5,
  
  kTopLevelStorageAccess = 6,
  
  kDiskQuota = 7,
  
  kFileSystemAccess = 8,
  
  kGeolocation = 9,
  
  kHandTracking = 10,
  
  kIdentityProvider = 11,
  
  kIdleDetection = 12,
  
  kLocalFonts = 13,
  
  kLocalNetworkAccess = 14,
  
  kMicStream = 15,
  
  kMidiSysex = 16,
  
  kMultipleDownloads = 17,
  
  kNfcDevice = 18,
  
  kNotifications = 19,
  
  kKeyboardLock = 20,
  
  kPointerLock = 21,
  
  kProtectedMediaIdentifier = 22,
  
  kRegisterProtocolHandler = 23,
  
  kSmartCard = 24,
  
  kStorageAccess = 25,
  
  kVrSession = 26,
  
  kWebAppInstallation = 27,
  
  kWebPrinting = 28,
  
  kWindowManagement = 29,
  kMinValue = 0,
  kMaxValue = 29,
};

 std::ostream& operator<<(std::ostream& os, PermissionPromptRequestType value);
inline bool IsKnownEnumValue(PermissionPromptRequestType value) {
  return internal::PermissionPromptRequestType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PermissionPromptInterfaceBase {};

using PermissionPromptPtrDataView =
    mojo::InterfacePtrDataView<PermissionPromptInterfaceBase>;
using PermissionPromptRequestDataView =
    mojo::InterfaceRequestDataView<PermissionPromptInterfaceBase>;
using PermissionPromptAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PermissionPromptInterfaceBase>;
using PermissionPromptAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PermissionPromptInterfaceBase>;
class PermissionPromptClientInterfaceBase {};

using PermissionPromptClientPtrDataView =
    mojo::InterfacePtrDataView<PermissionPromptClientInterfaceBase>;
using PermissionPromptClientRequestDataView =
    mojo::InterfaceRequestDataView<PermissionPromptClientInterfaceBase>;
using PermissionPromptClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PermissionPromptClientInterfaceBase>;
using PermissionPromptClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PermissionPromptClientInterfaceBase>;


class PermissionPromptViewButtonDataView {
 public:
  PermissionPromptViewButtonDataView() = default;

  PermissionPromptViewButtonDataView(
      internal::PermissionPromptViewButton_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  int32_t id() const {
    return data_->id;
  }
 private:
  internal::PermissionPromptViewButton_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PermissionPromptRequestItemDataView {
 public:
  PermissionPromptRequestItemDataView() = default;

  PermissionPromptRequestItemDataView(
      internal::PermissionPromptRequestItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadRequestType(UserType* output) const {
    auto data_value = data_->request_type;
    return mojo::internal::Deserialize<::owl::mojom::PermissionPromptRequestType>(
        data_value, output);
  }
  PermissionPromptRequestType request_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::owl::mojom::PermissionPromptRequestType>(data_->request_type));
  }
  inline void GetTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::PermissionPromptRequestItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PermissionPromptDetailsDataView {
 public:
  PermissionPromptDetailsDataView() = default;

  PermissionPromptDetailsDataView(
      internal::PermissionPromptDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestingOriginDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestingOrigin(UserType* output) {
    
    auto* pointer = data_->requesting_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetExtraTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtraText(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `extra_text` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExtraText` instead "
    "of `ReadExtraText if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->extra_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool is_embedded() const {
    return data_->is_embedded;
  }
  inline void GetRequestsDataView(
      mojo::ArrayDataView<PermissionPromptRequestItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequests(UserType* output) {
    
    auto* pointer = data_->requests.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::owl::mojom::PermissionPromptRequestItemDataView>>(
        pointer, output, message_);
  }
  inline void GetAllowTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllowText(UserType* output) {
    
    auto* pointer = data_->allow_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetAllowOnceTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllowOnceText(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `allow_once_text` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAllowOnceText` instead "
    "of `ReadAllowOnceText if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->allow_once_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetBlockTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlockText(UserType* output) {
    
    auto* pointer = data_->block_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetViewButtonsDataView(
      mojo::ArrayDataView<PermissionPromptViewButtonDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewButtons(UserType* output) {
    
    auto* pointer = data_->view_buttons.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::owl::mojom::PermissionPromptViewButtonDataView>>(
        pointer, output, message_);
  }
 private:
  internal::PermissionPromptDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // owl::mojom

#endif  // OWL_MOJOM_PERMISSION_PROMPT_MOJOM_DATA_VIEW_H_