// owl/mojom/password_prompt.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_PASSWORD_PROMPT_MOJOM_H_
#define OWL_MOJOM_PASSWORD_PROMPT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/password_prompt.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/password_prompt.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/password_prompt.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "ui/gfx/image/mojom/image.mojom.h"
#include "url/mojom/url.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class SavePasswordPromptProxy;

template <typename ImplRefTraits>
class SavePasswordPromptStub;

class SavePasswordPromptRequestValidator;


class SavePasswordPrompt
    : public SavePasswordPromptInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.SavePasswordPrompt";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SavePasswordPromptInterfaceBase;
  using Proxy_ = SavePasswordPromptProxy;

  template <typename ImplRefTraits>
  using Stub_ = SavePasswordPromptStub<ImplRefTraits>;

  using RequestValidator_ = SavePasswordPromptRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnFederatedAvatarImageAvailableMinVersion = 0,
    kCloseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnFederatedAvatarImageAvailable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Close_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SavePasswordPrompt() = default;

  virtual void OnFederatedAvatarImageAvailable(const ::gfx::ImageSkia& image) = 0;

  virtual void Close() = 0;
};

class SavePasswordPromptClientProxy;

template <typename ImplRefTraits>
class SavePasswordPromptClientStub;

class SavePasswordPromptClientRequestValidator;


class SavePasswordPromptClient
    : public SavePasswordPromptClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.SavePasswordPromptClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SavePasswordPromptClientInterfaceBase;
  using Proxy_ = SavePasswordPromptClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = SavePasswordPromptClientStub<ImplRefTraits>;

  using RequestValidator_ = SavePasswordPromptClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetUsernameAndPasswordMinVersion = 0,
    kNeverSaveForThisSiteMinVersion = 0,
    kCreateOrUpdateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetUsernameAndPassword_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NeverSaveForThisSite_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateOrUpdate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SavePasswordPromptClient() = default;

  virtual void SetUsernameAndPassword(const ::std::u16string& username, const ::std::u16string& password) = 0;

  virtual void NeverSaveForThisSite() = 0;

  virtual void CreateOrUpdate() = 0;
};



class  SavePasswordPromptProxy
    : public SavePasswordPrompt {
 public:
  using InterfaceType = SavePasswordPrompt;

  explicit SavePasswordPromptProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnFederatedAvatarImageAvailable(const ::gfx::ImageSkia& image) final;
  
  void Close() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SavePasswordPromptClientProxy
    : public SavePasswordPromptClient {
 public:
  using InterfaceType = SavePasswordPromptClient;

  explicit SavePasswordPromptClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetUsernameAndPassword(const ::std::u16string& username, const ::std::u16string& password) final;
  
  void NeverSaveForThisSite() final;
  
  void CreateOrUpdate() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SavePasswordPromptStubDispatch {
 public:
  static bool Accept(SavePasswordPrompt* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SavePasswordPrompt* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SavePasswordPrompt>>
class SavePasswordPromptStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SavePasswordPromptStub() = default;
  ~SavePasswordPromptStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SavePasswordPromptStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SavePasswordPromptStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SavePasswordPromptClientStubDispatch {
 public:
  static bool Accept(SavePasswordPromptClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SavePasswordPromptClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SavePasswordPromptClient>>
class SavePasswordPromptClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SavePasswordPromptClientStub() = default;
  ~SavePasswordPromptClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SavePasswordPromptClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SavePasswordPromptClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SavePasswordPromptRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SavePasswordPromptClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  PasswordPromptCredentials {
 public:
  using DataView = PasswordPromptCredentialsDataView;
  using Data_ = internal::PasswordPromptCredentials_Data;
  using Tag = Data_::PasswordPromptCredentials_Tag;

  template <typename... Args>
  static PasswordPromptCredentialsPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |username_password_credentials|.
  static PasswordPromptCredentialsPtr NewUsernamePasswordCredentials(
      UsernamePasswordCredentialsPtr value);
  // Construct an instance holding |federated_credentials|.
  static PasswordPromptCredentialsPtr NewFederatedCredentials(
      FederatedCredentialsPtr value);

  template <typename U>
  static PasswordPromptCredentialsPtr From(const U& u) {
    return mojo::TypeConverter<PasswordPromptCredentialsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PasswordPromptCredentials>::Convert(*this);
  }
  ~PasswordPromptCredentials();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  PasswordPromptCredentials(const PasswordPromptCredentials& other) = delete;
  PasswordPromptCredentials& operator=(const PasswordPromptCredentials& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PasswordPromptCredentialsPtr>
  PasswordPromptCredentialsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PasswordPromptCredentials>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, PasswordPromptCredentials>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_username_password_credentials() const { return tag_ == Tag::kUsernamePasswordCredentials; }
  const UsernamePasswordCredentialsPtr& get_username_password_credentials() const {
    CHECK(tag_ == Tag::kUsernamePasswordCredentials);
    return data_.username_password_credentials;
  }
  UsernamePasswordCredentialsPtr& get_username_password_credentials() {
    CHECK(tag_ == Tag::kUsernamePasswordCredentials);
    return data_.username_password_credentials;
  }
  void set_username_password_credentials(UsernamePasswordCredentialsPtr username_password_credentials);

  bool is_federated_credentials() const { return tag_ == Tag::kFederatedCredentials; }
  const FederatedCredentialsPtr& get_federated_credentials() const {
    CHECK(tag_ == Tag::kFederatedCredentials);
    return data_.federated_credentials;
  }
  FederatedCredentialsPtr& get_federated_credentials() {
    CHECK(tag_ == Tag::kFederatedCredentials);
    return data_.federated_credentials;
  }
  void set_federated_credentials(FederatedCredentialsPtr federated_credentials);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PasswordPromptCredentials::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PasswordPromptCredentials::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kUsernamePasswordCredentials)>,
        UsernamePasswordCredentialsPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFederatedCredentials)>,
        FederatedCredentialsPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    UsernamePasswordCredentialsPtr username_password_credentials;
    FederatedCredentialsPtr federated_credentials;
  };

  PasswordPromptCredentials(
      std::in_place_index_t<static_cast<size_t>(Tag::kUsernamePasswordCredentials)>,
      UsernamePasswordCredentialsPtr value);
  PasswordPromptCredentials(
      std::in_place_index_t<static_cast<size_t>(Tag::kFederatedCredentials)>,
      FederatedCredentialsPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  FederatedCredentials {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FederatedCredentials, T>::value>;
  using DataView = FederatedCredentialsDataView;
  using Data_ = internal::FederatedCredentials_Data;

  template <typename... Args>
  static FederatedCredentialsPtr New(Args&&... args) {
    return FederatedCredentialsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FederatedCredentialsPtr From(const U& u) {
    return mojo::TypeConverter<FederatedCredentialsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FederatedCredentials>::Convert(*this);
  }


  FederatedCredentials();

  FederatedCredentials(
      const ::std::u16string& upper_text,
      const ::std::u16string& lower_text);


  ~FederatedCredentials();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FederatedCredentialsPtr>
  FederatedCredentialsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FederatedCredentials::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FederatedCredentials::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FederatedCredentials::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FederatedCredentials::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FederatedCredentials::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FederatedCredentials::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FederatedCredentials_UnserializedMessageContext<
            UserType, FederatedCredentials::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FederatedCredentials::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FederatedCredentials::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FederatedCredentials_UnserializedMessageContext<
            UserType, FederatedCredentials::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FederatedCredentials::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string upper_text;
  
  ::std::u16string lower_text;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FederatedCredentials::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FederatedCredentials::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FederatedCredentials::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FederatedCredentials::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  UsernamePasswordCredentials {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UsernamePasswordCredentials, T>::value>;
  using DataView = UsernamePasswordCredentialsDataView;
  using Data_ = internal::UsernamePasswordCredentials_Data;

  template <typename... Args>
  static UsernamePasswordCredentialsPtr New(Args&&... args) {
    return UsernamePasswordCredentialsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UsernamePasswordCredentialsPtr From(const U& u) {
    return mojo::TypeConverter<UsernamePasswordCredentialsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UsernamePasswordCredentials>::Convert(*this);
  }


  UsernamePasswordCredentials();

  UsernamePasswordCredentials(
      const ::std::u16string& username,
      const ::std::u16string& password,
      std::vector<::std::u16string> all_usernames,
      std::vector<::std::u16string> all_passwords);


  ~UsernamePasswordCredentials();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UsernamePasswordCredentialsPtr>
  UsernamePasswordCredentialsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UsernamePasswordCredentials::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UsernamePasswordCredentials::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UsernamePasswordCredentials::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UsernamePasswordCredentials::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UsernamePasswordCredentials::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UsernamePasswordCredentials::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UsernamePasswordCredentials_UnserializedMessageContext<
            UserType, UsernamePasswordCredentials::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UsernamePasswordCredentials::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UsernamePasswordCredentials::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UsernamePasswordCredentials_UnserializedMessageContext<
            UserType, UsernamePasswordCredentials::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UsernamePasswordCredentials::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string username;
  
  ::std::u16string password;
  
  std::vector<::std::u16string> all_usernames;
  
  std::vector<::std::u16string> all_passwords;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UsernamePasswordCredentials::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UsernamePasswordCredentials::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UsernamePasswordCredentials::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UsernamePasswordCredentials::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SavePasswordPromptDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SavePasswordPromptDetails, T>::value>;
  using DataView = SavePasswordPromptDetailsDataView;
  using Data_ = internal::SavePasswordPromptDetails_Data;

  template <typename... Args>
  static SavePasswordPromptDetailsPtr New(Args&&... args) {
    return SavePasswordPromptDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SavePasswordPromptDetailsPtr From(const U& u) {
    return mojo::TypeConverter<SavePasswordPromptDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SavePasswordPromptDetails>::Convert(*this);
  }


  SavePasswordPromptDetails();

  SavePasswordPromptDetails(
      SavePasswordPromptType type,
      PasswordPromptCredentialsPtr credentials);

SavePasswordPromptDetails(const SavePasswordPromptDetails&) = delete;
SavePasswordPromptDetails& operator=(const SavePasswordPromptDetails&) = delete;

  ~SavePasswordPromptDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SavePasswordPromptDetailsPtr>
  SavePasswordPromptDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SavePasswordPromptDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SavePasswordPromptDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SavePasswordPromptDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SavePasswordPromptDetails::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SavePasswordPromptDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SavePasswordPromptDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SavePasswordPromptDetails_UnserializedMessageContext<
            UserType, SavePasswordPromptDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SavePasswordPromptDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SavePasswordPromptDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SavePasswordPromptDetails_UnserializedMessageContext<
            UserType, SavePasswordPromptDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SavePasswordPromptDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  SavePasswordPromptType type;
  
  PasswordPromptCredentialsPtr credentials;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SavePasswordPromptDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SavePasswordPromptDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SavePasswordPromptDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SavePasswordPromptDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
PasswordPromptCredentialsPtr PasswordPromptCredentials::Clone() const {
  switch (tag_) {
    case Tag::kUsernamePasswordCredentials:
      return NewUsernamePasswordCredentials(
          mojo::Clone(data_.username_password_credentials));
    case Tag::kFederatedCredentials:
      return NewFederatedCredentials(
          mojo::Clone(data_.federated_credentials));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PasswordPromptCredentials>::value>::type*>
bool PasswordPromptCredentials::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kUsernamePasswordCredentials:
      return mojo::Equals(data_.username_password_credentials, other.data_.username_password_credentials);
    case Tag::kFederatedCredentials:
      return mojo::Equals(data_.federated_credentials, other.data_.federated_credentials);
  }

  return false;
}
template <typename StructPtrType>
FederatedCredentialsPtr FederatedCredentials::Clone() const {
  return New(
      mojo::Clone(upper_text),
      mojo::Clone(lower_text)
  );
}

template <typename T, FederatedCredentials::EnableIfSame<T>*>
bool FederatedCredentials::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->upper_text, other_struct.upper_text))
    return false;
  if (!mojo::Equals(this->lower_text, other_struct.lower_text))
    return false;
  return true;
}

template <typename T, FederatedCredentials::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.upper_text < rhs.upper_text)
    return true;
  if (rhs.upper_text < lhs.upper_text)
    return false;
  if (lhs.lower_text < rhs.lower_text)
    return true;
  if (rhs.lower_text < lhs.lower_text)
    return false;
  return false;
}
template <typename StructPtrType>
UsernamePasswordCredentialsPtr UsernamePasswordCredentials::Clone() const {
  return New(
      mojo::Clone(username),
      mojo::Clone(password),
      mojo::Clone(all_usernames),
      mojo::Clone(all_passwords)
  );
}

template <typename T, UsernamePasswordCredentials::EnableIfSame<T>*>
bool UsernamePasswordCredentials::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->username, other_struct.username))
    return false;
  if (!mojo::Equals(this->password, other_struct.password))
    return false;
  if (!mojo::Equals(this->all_usernames, other_struct.all_usernames))
    return false;
  if (!mojo::Equals(this->all_passwords, other_struct.all_passwords))
    return false;
  return true;
}

template <typename T, UsernamePasswordCredentials::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.username < rhs.username)
    return true;
  if (rhs.username < lhs.username)
    return false;
  if (lhs.password < rhs.password)
    return true;
  if (rhs.password < lhs.password)
    return false;
  if (lhs.all_usernames < rhs.all_usernames)
    return true;
  if (rhs.all_usernames < lhs.all_usernames)
    return false;
  if (lhs.all_passwords < rhs.all_passwords)
    return true;
  if (rhs.all_passwords < lhs.all_passwords)
    return false;
  return false;
}
template <typename StructPtrType>
SavePasswordPromptDetailsPtr SavePasswordPromptDetails::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(credentials)
  );
}

template <typename T, SavePasswordPromptDetails::EnableIfSame<T>*>
bool SavePasswordPromptDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->credentials, other_struct.credentials))
    return false;
  return true;
}

template <typename T, SavePasswordPromptDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.credentials < rhs.credentials)
    return true;
  if (rhs.credentials < lhs.credentials)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::FederatedCredentials::DataView,
                                         ::owl::mojom::FederatedCredentialsPtr> {
  static bool IsNull(const ::owl::mojom::FederatedCredentialsPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::FederatedCredentialsPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::FederatedCredentials::upper_text)& upper_text(
      const ::owl::mojom::FederatedCredentialsPtr& input) {
    return input->upper_text;
  }

  static const decltype(::owl::mojom::FederatedCredentials::lower_text)& lower_text(
      const ::owl::mojom::FederatedCredentialsPtr& input) {
    return input->lower_text;
  }

  static bool Read(::owl::mojom::FederatedCredentials::DataView input, ::owl::mojom::FederatedCredentialsPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::UsernamePasswordCredentials::DataView,
                                         ::owl::mojom::UsernamePasswordCredentialsPtr> {
  static bool IsNull(const ::owl::mojom::UsernamePasswordCredentialsPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::UsernamePasswordCredentialsPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::UsernamePasswordCredentials::username)& username(
      const ::owl::mojom::UsernamePasswordCredentialsPtr& input) {
    return input->username;
  }

  static const decltype(::owl::mojom::UsernamePasswordCredentials::password)& password(
      const ::owl::mojom::UsernamePasswordCredentialsPtr& input) {
    return input->password;
  }

  static const decltype(::owl::mojom::UsernamePasswordCredentials::all_usernames)& all_usernames(
      const ::owl::mojom::UsernamePasswordCredentialsPtr& input) {
    return input->all_usernames;
  }

  static const decltype(::owl::mojom::UsernamePasswordCredentials::all_passwords)& all_passwords(
      const ::owl::mojom::UsernamePasswordCredentialsPtr& input) {
    return input->all_passwords;
  }

  static bool Read(::owl::mojom::UsernamePasswordCredentials::DataView input, ::owl::mojom::UsernamePasswordCredentialsPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::SavePasswordPromptDetails::DataView,
                                         ::owl::mojom::SavePasswordPromptDetailsPtr> {
  static bool IsNull(const ::owl::mojom::SavePasswordPromptDetailsPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::SavePasswordPromptDetailsPtr* output) { output->reset(); }

  static decltype(::owl::mojom::SavePasswordPromptDetails::type) type(
      const ::owl::mojom::SavePasswordPromptDetailsPtr& input) {
    return input->type;
  }

  static const decltype(::owl::mojom::SavePasswordPromptDetails::credentials)& credentials(
      const ::owl::mojom::SavePasswordPromptDetailsPtr& input) {
    return input->credentials;
  }

  static bool Read(::owl::mojom::SavePasswordPromptDetails::DataView input, ::owl::mojom::SavePasswordPromptDetailsPtr* output);
};


template <>
struct  UnionTraits<::owl::mojom::PasswordPromptCredentials::DataView,
                                        ::owl::mojom::PasswordPromptCredentialsPtr> {
  static bool IsNull(const ::owl::mojom::PasswordPromptCredentialsPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::PasswordPromptCredentialsPtr* output) { output->reset(); }

  static ::owl::mojom::PasswordPromptCredentials::Tag GetTag(const ::owl::mojom::PasswordPromptCredentialsPtr& input) {
    return input->which();
  }

  static const ::owl::mojom::UsernamePasswordCredentialsPtr& username_password_credentials(const ::owl::mojom::PasswordPromptCredentialsPtr& input) {
    return input->get_username_password_credentials();
  }

  static const ::owl::mojom::FederatedCredentialsPtr& federated_credentials(const ::owl::mojom::PasswordPromptCredentialsPtr& input) {
    return input->get_federated_credentials();
  }

  static bool Read(::owl::mojom::PasswordPromptCredentials::DataView input, ::owl::mojom::PasswordPromptCredentialsPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_PASSWORD_PROMPT_MOJOM_H_