// owl/mojom/password_prompt.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_PASSWORD_PROMPT_MOJOM_SHARED_H_
#define OWL_MOJOM_PASSWORD_PROMPT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/password_prompt.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "owl/mojom/password_prompt.mojom-data-view.h"




namespace std {

template <>
struct hash<::owl::mojom::SavePasswordPromptType>
    : public mojo::internal::EnumHashImpl<::owl::mojom::SavePasswordPromptType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::SavePasswordPromptType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::SavePasswordPromptType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::SavePasswordPromptType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::FederatedCredentialsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::FederatedCredentialsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::FederatedCredentials_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::upper_text(input)) in_upper_text = Traits::upper_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->upper_text)::BaseType> upper_text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_upper_text,
      upper_text_fragment);

    fragment->upper_text.Set(
        upper_text_fragment.is_null() ? nullptr : upper_text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->upper_text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null upper_text in FederatedCredentials struct");

    decltype(Traits::lower_text(input)) in_lower_text = Traits::lower_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->lower_text)::BaseType> lower_text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_lower_text,
      lower_text_fragment);

    fragment->lower_text.Set(
        lower_text_fragment.is_null() ? nullptr : lower_text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->lower_text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null lower_text in FederatedCredentials struct");
  }

  static bool Deserialize(::owl::mojom::internal::FederatedCredentials_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::FederatedCredentialsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::UsernamePasswordCredentialsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::UsernamePasswordCredentialsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::UsernamePasswordCredentials_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::username(input)) in_username = Traits::username(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->username)::BaseType> username_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_username,
      username_fragment);

    fragment->username.Set(
        username_fragment.is_null() ? nullptr : username_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->username.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null username in UsernamePasswordCredentials struct");

    decltype(Traits::password(input)) in_password = Traits::password(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->password)::BaseType> password_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_password,
      password_fragment);

    fragment->password.Set(
        password_fragment.is_null() ? nullptr : password_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->password.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null password in UsernamePasswordCredentials struct");

    decltype(Traits::all_usernames(input)) in_all_usernames = Traits::all_usernames(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->all_usernames)::BaseType>
        all_usernames_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& all_usernames_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
      in_all_usernames,
      all_usernames_fragment,
      &all_usernames_validate_params);

    fragment->all_usernames.Set(
        all_usernames_fragment.is_null() ? nullptr : all_usernames_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->all_usernames.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null all_usernames in UsernamePasswordCredentials struct");

    decltype(Traits::all_passwords(input)) in_all_passwords = Traits::all_passwords(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->all_passwords)::BaseType>
        all_passwords_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& all_passwords_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
      in_all_passwords,
      all_passwords_fragment,
      &all_passwords_validate_params);

    fragment->all_passwords.Set(
        all_passwords_fragment.is_null() ? nullptr : all_passwords_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->all_passwords.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null all_passwords in UsernamePasswordCredentials struct");
  }

  static bool Deserialize(::owl::mojom::internal::UsernamePasswordCredentials_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::UsernamePasswordCredentialsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::SavePasswordPromptDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::SavePasswordPromptDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::SavePasswordPromptDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::owl::mojom::SavePasswordPromptType>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::credentials(input)) in_credentials = Traits::credentials(input);
    mojo::internal::MessageFragment<decltype(fragment->credentials)>
        credentials_fragment(fragment.message());
    credentials_fragment.Claim(&fragment->credentials);
    
    mojo::internal::Serialize<::owl::mojom::PasswordPromptCredentialsDataView>(
      in_credentials,
      credentials_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->credentials.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null credentials in SavePasswordPromptDetails struct");
  }

  static bool Deserialize(::owl::mojom::internal::SavePasswordPromptDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::SavePasswordPromptDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::PasswordPromptCredentialsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::owl::mojom::PasswordPromptCredentialsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::owl::mojom::internal::PasswordPromptCredentials_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::owl::mojom::PasswordPromptCredentialsDataView::Tag::kUsernamePasswordCredentials: {
    decltype(Traits::username_password_credentials(input))
    in_username_password_credentials = Traits::username_password_credentials(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_username_password_credentials)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::owl::mojom::UsernamePasswordCredentialsDataView>(
  in_username_password_credentials,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null username_password_credentials in PasswordPromptCredentials union");
    fragment->data.f_username_password_credentials.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::owl::mojom::PasswordPromptCredentialsDataView::Tag::kFederatedCredentials: {
    decltype(Traits::federated_credentials(input))
    in_federated_credentials = Traits::federated_credentials(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_federated_credentials)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::owl::mojom::FederatedCredentialsDataView>(
  in_federated_credentials,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null federated_credentials in PasswordPromptCredentials union");
    fragment->data.f_federated_credentials.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::owl::mojom::internal::PasswordPromptCredentials_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::PasswordPromptCredentialsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace owl::mojom {

inline void FederatedCredentialsDataView::GetUpperTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->upper_text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FederatedCredentialsDataView::GetLowerTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->lower_text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void UsernamePasswordCredentialsDataView::GetUsernameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->username.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void UsernamePasswordCredentialsDataView::GetPasswordDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->password.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void UsernamePasswordCredentialsDataView::GetAllUsernamesDataView(
    mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->all_usernames.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::String16DataView>(pointer, message_);
}
inline void UsernamePasswordCredentialsDataView::GetAllPasswordsDataView(
    mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->all_passwords.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::String16DataView>(pointer, message_);
}


inline void SavePasswordPromptDetailsDataView::GetCredentialsDataView(
    PasswordPromptCredentialsDataView* output) {
  auto pointer = &data_->credentials;
  *output = PasswordPromptCredentialsDataView(pointer, message_);
}


inline void PasswordPromptCredentialsDataView::GetUsernamePasswordCredentialsDataView(
    UsernamePasswordCredentialsDataView* output) const {
  CHECK(is_username_password_credentials());
  *output = UsernamePasswordCredentialsDataView(data_->data.f_username_password_credentials.Get(), message_);
}
inline void PasswordPromptCredentialsDataView::GetFederatedCredentialsDataView(
    FederatedCredentialsDataView* output) const {
  CHECK(is_federated_credentials());
  *output = FederatedCredentialsDataView(data_->data.f_federated_credentials.Get(), message_);
}


}  // owl::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::SavePasswordPromptType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::SavePasswordPromptType value);
};

} // namespace perfetto

#endif  // OWL_MOJOM_PASSWORD_PROMPT_MOJOM_SHARED_H_