// owl/mojom/password_prompt.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "owl/mojom/password_prompt.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/password_prompt.mojom-params-data.h"
namespace owl {
namespace mojom {

NOINLINE static const char* SavePasswordPromptTypeToStringHelper(SavePasswordPromptType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SavePasswordPromptType::kCreateNewEntry:
      return "kCreateNewEntry";
    case SavePasswordPromptType::kUpdateExitingEntry:
      return "kUpdateExitingEntry";
    default:
      return nullptr;
  }
}

std::string SavePasswordPromptTypeToString(SavePasswordPromptType value) {
  const char *str = SavePasswordPromptTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SavePasswordPromptType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SavePasswordPromptType value) {
  return os << SavePasswordPromptTypeToString(value);
}

namespace internal {
// static
bool PasswordPromptCredentials_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const PasswordPromptCredentials_Data* object = static_cast<const PasswordPromptCredentials_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case PasswordPromptCredentials_Tag::kUsernamePasswordCredentials: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_username_password_credentials, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_username_password_credentials, validation_context))
        return false;
      return true;
    }
    case PasswordPromptCredentials_Tag::kFederatedCredentials: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_federated_credentials, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_federated_credentials, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in PasswordPromptCredentials");
      return false;
    }
  }
}


// static
bool FederatedCredentials_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FederatedCredentials_Data* object =
      static_cast<const FederatedCredentials_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->upper_text, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->upper_text, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lower_text, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->lower_text, validation_context))
    return false;

  return true;
}

FederatedCredentials_Data::FederatedCredentials_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsernamePasswordCredentials_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsernamePasswordCredentials_Data* object =
      static_cast<const UsernamePasswordCredentials_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->username, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->username, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->password, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->password, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->all_usernames, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& all_usernames_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->all_usernames, validation_context,
                                         &all_usernames_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->all_passwords, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& all_passwords_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->all_passwords, validation_context,
                                         &all_passwords_validate_params)) {
    return false;
  }

  return true;
}

UsernamePasswordCredentials_Data::UsernamePasswordCredentials_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SavePasswordPromptDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SavePasswordPromptDetails_Data* object =
      static_cast<const SavePasswordPromptDetails_Data*>(data);


  if (!::owl::mojom::internal::SavePasswordPromptType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->credentials, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->credentials, validation_context))
    return false;

  return true;
}

SavePasswordPromptDetails_Data::SavePasswordPromptDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SavePasswordPrompt_OnFederatedAvatarImageAvailable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SavePasswordPrompt_OnFederatedAvatarImageAvailable_Params_Data* object =
      static_cast<const SavePasswordPrompt_OnFederatedAvatarImageAvailable_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image, validation_context))
    return false;

  return true;
}

SavePasswordPrompt_OnFederatedAvatarImageAvailable_Params_Data::SavePasswordPrompt_OnFederatedAvatarImageAvailable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SavePasswordPrompt_Close_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SavePasswordPrompt_Close_Params_Data* object =
      static_cast<const SavePasswordPrompt_Close_Params_Data*>(data);

  return true;
}

SavePasswordPrompt_Close_Params_Data::SavePasswordPrompt_Close_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SavePasswordPromptClient_SetUsernameAndPassword_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SavePasswordPromptClient_SetUsernameAndPassword_Params_Data* object =
      static_cast<const SavePasswordPromptClient_SetUsernameAndPassword_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->username, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->username, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->password, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->password, validation_context))
    return false;

  return true;
}

SavePasswordPromptClient_SetUsernameAndPassword_Params_Data::SavePasswordPromptClient_SetUsernameAndPassword_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SavePasswordPromptClient_NeverSaveForThisSite_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SavePasswordPromptClient_NeverSaveForThisSite_Params_Data* object =
      static_cast<const SavePasswordPromptClient_NeverSaveForThisSite_Params_Data*>(data);

  return true;
}

SavePasswordPromptClient_NeverSaveForThisSite_Params_Data::SavePasswordPromptClient_NeverSaveForThisSite_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SavePasswordPromptClient_CreateOrUpdate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SavePasswordPromptClient_CreateOrUpdate_Params_Data* object =
      static_cast<const SavePasswordPromptClient_CreateOrUpdate_Params_Data*>(data);

  return true;
}

SavePasswordPromptClient_CreateOrUpdate_Params_Data::SavePasswordPromptClient_CreateOrUpdate_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace owl

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::SavePasswordPromptType>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::SavePasswordPromptType value) {
  return std::move(context).WriteString(::owl::mojom::SavePasswordPromptTypeToString(value));
}

} // namespace perfetto