// owl/mojom/metrics.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/metrics.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/metrics.mojom-params-data.h"
#include "owl/mojom/metrics.mojom-shared-message-ids.h"

#include "owl/mojom/metrics.mojom-import-headers.h"
#include "owl/mojom/metrics.mojom-test-utils.h"


namespace owl::mojom {
HistogramSample::HistogramSample()
    : histogram_name(),
      name_hash(),
      sample(),
      event_id() {}

HistogramSample::HistogramSample(
    const std::string& histogram_name_in,
    uint64_t name_hash_in,
    int32_t sample_in,
    std::optional<uint64_t> event_id_in)
    : histogram_name(std::move(histogram_name_in)),
      name_hash(std::move(name_hash_in)),
      sample(std::move(sample_in)),
      event_id(std::move(event_id_in)) {}

HistogramSample::~HistogramSample() = default;

void HistogramSample::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "histogram_name"), this->histogram_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name_hash"), this->name_hash,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sample"), this->sample,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_id"), this->event_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint64_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HistogramSample::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

MetricsServiceClient::IPCStableHashFunction MetricsServiceClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MetricsServiceClient>(message.name())) {
    case messages::MetricsServiceClient::kOnHistogramSample: {
      return &MetricsServiceClient::OnHistogramSample_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MetricsServiceClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MetricsServiceClient>(message.name())) {
      case messages::MetricsServiceClient::kOnHistogramSample:
            return "Receive owl::mojom::MetricsServiceClient::OnHistogramSample";
    }
  } else {
    switch (static_cast<messages::MetricsServiceClient>(message.name())) {
      case messages::MetricsServiceClient::kOnHistogramSample:
            return "Receive reply owl::mojom::MetricsServiceClient::OnHistogramSample";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MetricsServiceClient::OnHistogramSample_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4071cb11;  // IPCStableHash for owl::mojom::MetricsServiceClient::OnHistogramSample
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MetricsServiceClientProxy::MetricsServiceClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MetricsServiceClientProxy::OnHistogramSample(
    HistogramSamplePtr in_sample) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::MetricsServiceClient::OnHistogramSample", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sample"), in_sample,
                        "<value of type HistogramSamplePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MetricsServiceClient::kOnHistogramSample), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::MetricsServiceClient_OnHistogramSample_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->sample)::BaseType> sample_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::HistogramSampleDataView>(
    in_sample,
    sample_fragment);

  params->sample.Set(
      sample_fragment.is_null() ? nullptr : sample_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sample.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sample in MetricsServiceClient.OnHistogramSample request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MetricsServiceClient::Name_);
  message.set_method_name("OnHistogramSample");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MetricsServiceClientStubDispatch::Accept(
    MetricsServiceClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MetricsServiceClient>(message->header()->name)) {
    case messages::MetricsServiceClient::kOnHistogramSample: {
      DCHECK(message->is_serialized());
      internal::MetricsServiceClient_OnHistogramSample_Params_Data* params =
          reinterpret_cast<internal::MetricsServiceClient_OnHistogramSample_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MetricsServiceClient.0
      bool success = true;
      HistogramSamplePtr p_sample{};
      MetricsServiceClient_OnHistogramSample_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSample(&p_sample))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MetricsServiceClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHistogramSample(        
        std::move(p_sample));
      return true;
    }
  }
  return false;
}

// static
bool MetricsServiceClientStubDispatch::AcceptWithResponder(
    MetricsServiceClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MetricsServiceClient>(message->header()->name)) {
    case messages::MetricsServiceClient::kOnHistogramSample: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMetricsServiceClientValidationInfo[] = {
    { &internal::MetricsServiceClient_OnHistogramSample_Params_Data::Validate,
     nullptr /* no response */},
};

bool MetricsServiceClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::MetricsServiceClient::Name_,
    kMetricsServiceClientValidationInfo);
}

// The declaration includes the definition on other builds.

MetricsService::IPCStableHashFunction MetricsService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MetricsService>(message.name())) {
    case messages::MetricsService::kSubscribe: {
      return &MetricsService::Subscribe_Sym::IPCStableHash;
    }
    case messages::MetricsService::kUnsubscribe: {
      return &MetricsService::Unsubscribe_Sym::IPCStableHash;
    }
    case messages::MetricsService::kSetSubscriptions: {
      return &MetricsService::SetSubscriptions_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MetricsService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MetricsService>(message.name())) {
      case messages::MetricsService::kSubscribe:
            return "Receive owl::mojom::MetricsService::Subscribe";
      case messages::MetricsService::kUnsubscribe:
            return "Receive owl::mojom::MetricsService::Unsubscribe";
      case messages::MetricsService::kSetSubscriptions:
            return "Receive owl::mojom::MetricsService::SetSubscriptions";
    }
  } else {
    switch (static_cast<messages::MetricsService>(message.name())) {
      case messages::MetricsService::kSubscribe:
            return "Receive reply owl::mojom::MetricsService::Subscribe";
      case messages::MetricsService::kUnsubscribe:
            return "Receive reply owl::mojom::MetricsService::Unsubscribe";
      case messages::MetricsService::kSetSubscriptions:
            return "Receive reply owl::mojom::MetricsService::SetSubscriptions";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MetricsService::Subscribe_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa5f90cd4;  // IPCStableHash for owl::mojom::MetricsService::Subscribe
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MetricsService::Unsubscribe_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x88ec54b1;  // IPCStableHash for owl::mojom::MetricsService::Unsubscribe
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MetricsService::SetSubscriptions_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9d30a0a5;  // IPCStableHash for owl::mojom::MetricsService::SetSubscriptions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MetricsServiceProxy::MetricsServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MetricsServiceProxy::Subscribe(
    const std::vector<std::string>& in_histogram_names) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::MetricsService::Subscribe", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("histogram_names"), in_histogram_names,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MetricsService::kSubscribe), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::MetricsService_Subscribe_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->histogram_names)::BaseType>
      histogram_names_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& histogram_names_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_histogram_names,
    histogram_names_fragment,
    &histogram_names_validate_params);

  params->histogram_names.Set(
      histogram_names_fragment.is_null() ? nullptr : histogram_names_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->histogram_names.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null histogram_names in MetricsService.Subscribe request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MetricsService::Name_);
  message.set_method_name("Subscribe");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MetricsServiceProxy::Unsubscribe(
    const std::vector<std::string>& in_histogram_names) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::MetricsService::Unsubscribe", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("histogram_names"), in_histogram_names,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MetricsService::kUnsubscribe), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::MetricsService_Unsubscribe_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->histogram_names)::BaseType>
      histogram_names_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& histogram_names_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_histogram_names,
    histogram_names_fragment,
    &histogram_names_validate_params);

  params->histogram_names.Set(
      histogram_names_fragment.is_null() ? nullptr : histogram_names_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->histogram_names.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null histogram_names in MetricsService.Unsubscribe request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MetricsService::Name_);
  message.set_method_name("Unsubscribe");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MetricsServiceProxy::SetSubscriptions(
    const std::vector<std::string>& in_histogram_names) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::MetricsService::SetSubscriptions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("histogram_names"), in_histogram_names,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MetricsService::kSetSubscriptions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::MetricsService_SetSubscriptions_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->histogram_names)::BaseType>
      histogram_names_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& histogram_names_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_histogram_names,
    histogram_names_fragment,
    &histogram_names_validate_params);

  params->histogram_names.Set(
      histogram_names_fragment.is_null() ? nullptr : histogram_names_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->histogram_names.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null histogram_names in MetricsService.SetSubscriptions request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MetricsService::Name_);
  message.set_method_name("SetSubscriptions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MetricsServiceStubDispatch::Accept(
    MetricsService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MetricsService>(message->header()->name)) {
    case messages::MetricsService::kSubscribe: {
      DCHECK(message->is_serialized());
      internal::MetricsService_Subscribe_Params_Data* params =
          reinterpret_cast<internal::MetricsService_Subscribe_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MetricsService.0
      bool success = true;
      std::vector<std::string> p_histogram_names{};
      MetricsService_Subscribe_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHistogramNames(&p_histogram_names))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MetricsService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Subscribe(        
        std::move(p_histogram_names));
      return true;
    }
    case messages::MetricsService::kUnsubscribe: {
      DCHECK(message->is_serialized());
      internal::MetricsService_Unsubscribe_Params_Data* params =
          reinterpret_cast<internal::MetricsService_Unsubscribe_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MetricsService.1
      bool success = true;
      std::vector<std::string> p_histogram_names{};
      MetricsService_Unsubscribe_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHistogramNames(&p_histogram_names))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MetricsService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Unsubscribe(        
        std::move(p_histogram_names));
      return true;
    }
    case messages::MetricsService::kSetSubscriptions: {
      DCHECK(message->is_serialized());
      internal::MetricsService_SetSubscriptions_Params_Data* params =
          reinterpret_cast<internal::MetricsService_SetSubscriptions_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MetricsService.2
      bool success = true;
      std::vector<std::string> p_histogram_names{};
      MetricsService_SetSubscriptions_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHistogramNames(&p_histogram_names))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MetricsService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSubscriptions(        
        std::move(p_histogram_names));
      return true;
    }
  }
  return false;
}

// static
bool MetricsServiceStubDispatch::AcceptWithResponder(
    MetricsService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MetricsService>(message->header()->name)) {
    case messages::MetricsService::kSubscribe: {
      break;
    }
    case messages::MetricsService::kUnsubscribe: {
      break;
    }
    case messages::MetricsService::kSetSubscriptions: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMetricsServiceValidationInfo[] = {
    { &internal::MetricsService_Subscribe_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MetricsService_Unsubscribe_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MetricsService_SetSubscriptions_Params_Data::Validate,
     nullptr /* no response */},
};

bool MetricsServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::MetricsService::Name_,
    kMetricsServiceValidationInfo);
}



}  // owl::mojom


namespace mojo {


// static
bool StructTraits<::owl::mojom::HistogramSample::DataView, ::owl::mojom::HistogramSamplePtr>::Read(
    ::owl::mojom::HistogramSample::DataView input,
    ::owl::mojom::HistogramSamplePtr* output) {
  bool success = true;
  ::owl::mojom::HistogramSamplePtr result(::owl::mojom::HistogramSample::New());
  
      if (success && !input.ReadHistogramName(&result->histogram_name))
        success = false;
      if (success)
        result->name_hash = input.name_hash();
      if (success)
        result->sample = input.sample();
      if (success) {
        result->event_id = input.event_id();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void MetricsServiceClientInterceptorForTesting::OnHistogramSample(HistogramSamplePtr sample) {
  GetForwardingInterface()->OnHistogramSample(
    std::move(sample)
    );
}
MetricsServiceClientAsyncWaiter::MetricsServiceClientAsyncWaiter(
    MetricsServiceClient* proxy) : proxy_(proxy) {}

MetricsServiceClientAsyncWaiter::~MetricsServiceClientAsyncWaiter() = default;





void MetricsServiceInterceptorForTesting::Subscribe(const std::vector<std::string>& histogram_names) {
  GetForwardingInterface()->Subscribe(
    std::move(histogram_names)
    );
}
void MetricsServiceInterceptorForTesting::Unsubscribe(const std::vector<std::string>& histogram_names) {
  GetForwardingInterface()->Unsubscribe(
    std::move(histogram_names)
    );
}
void MetricsServiceInterceptorForTesting::SetSubscriptions(const std::vector<std::string>& histogram_names) {
  GetForwardingInterface()->SetSubscriptions(
    std::move(histogram_names)
    );
}
MetricsServiceAsyncWaiter::MetricsServiceAsyncWaiter(
    MetricsService* proxy) : proxy_(proxy) {}

MetricsServiceAsyncWaiter::~MetricsServiceAsyncWaiter() = default;







}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif