// owl/mojom/metrics.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_METRICS_MOJOM_SHARED_H_
#define OWL_MOJOM_METRICS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/metrics.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "owl/mojom/metrics.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::HistogramSampleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::HistogramSampleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::HistogramSample_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::histogram_name(input)) in_histogram_name = Traits::histogram_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->histogram_name)::BaseType> histogram_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_histogram_name,
      histogram_name_fragment);

    fragment->histogram_name.Set(
        histogram_name_fragment.is_null() ? nullptr : histogram_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->histogram_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null histogram_name in HistogramSample struct");

    fragment->name_hash = Traits::name_hash(input);

    fragment->sample = Traits::sample(input);
    fragment->event_id_$flag = Traits::event_id(input).has_value();
    if (Traits::event_id(input).has_value()) {
      fragment->event_id_$value = Traits::event_id(input).value();
    }
  }

  static bool Deserialize(::owl::mojom::internal::HistogramSample_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::HistogramSampleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace owl::mojom {

inline void HistogramSampleDataView::GetHistogramNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->histogram_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // owl::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // OWL_MOJOM_METRICS_MOJOM_SHARED_H_