// owl/mojom/extension_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_EXTENSION_SERVICE_MOJOM_H_
#define OWL_MOJOM_EXTENSION_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/extension_service.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/extension_service.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/extension_service.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "ui/gfx/image/mojom/image.mojom.h"
#include "url/mojom/url.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class ExtensionServiceClientProxy;

template <typename ImplRefTraits>
class ExtensionServiceClientStub;

class ExtensionServiceClientRequestValidator;


class ExtensionServiceClient
    : public ExtensionServiceClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.ExtensionServiceClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ExtensionServiceClientInterfaceBase;
  using Proxy_ = ExtensionServiceClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = ExtensionServiceClientStub<ImplRefTraits>;

  using RequestValidator_ = ExtensionServiceClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnExtensionInstalledMinVersion = 0,
    kOnExtensionUninstalledMinVersion = 0,
    kOnExtensionLoadedMinVersion = 0,
    kOnExtensionUnloadedMinVersion = 0,
    kOnExtensionActionIconUpdatedMinVersion = 0,
    kOnExtensionMenuUpdatedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnExtensionInstalled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnExtensionUninstalled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnExtensionLoaded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnExtensionUnloaded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnExtensionActionIconUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnExtensionMenuUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ExtensionServiceClient() = default;

  virtual void OnExtensionInstalled(ExtensionInfoPtr extension_info, bool is_update) = 0;

  virtual void OnExtensionUninstalled(const std::string& extension_id) = 0;

  virtual void OnExtensionLoaded(const std::string& extension_id) = 0;

  virtual void OnExtensionUnloaded(const std::string& extension_id) = 0;

  virtual void OnExtensionActionIconUpdated(const std::string& extension_id, const ::gfx::ImageSkia& icon) = 0;

  virtual void OnExtensionMenuUpdated(const std::string& extension_id, std::vector<ExtensionMenuItemPtr> items) = 0;
};

class ExtensionServiceProxy;

template <typename ImplRefTraits>
class ExtensionServiceStub;

class ExtensionServiceRequestValidator;
class ExtensionServiceResponseValidator;


class ExtensionService
    : public ExtensionServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.ExtensionService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ExtensionServiceInterfaceBase;
  using Proxy_ = ExtensionServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = ExtensionServiceStub<ImplRefTraits>;

  using RequestValidator_ = ExtensionServiceRequestValidator;
  using ResponseValidator_ = ExtensionServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetInstalledExtensionsMinVersion = 0,
    kClickExtensionMinVersion = 0,
    kInstallExtensionByIdMinVersion = 0,
    kGrantPermissionsAndEnableExtensionMinVersion = 0,
    kSelectMenuItemMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetInstalledExtensions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClickExtension_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InstallExtensionById_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GrantPermissionsAndEnableExtension_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SelectMenuItem_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ExtensionService() = default;

  using GetInstalledExtensionsCallback = base::OnceCallback<void(std::vector<ExtensionInfoPtr>)>;
  using GetInstalledExtensionsMojoCallback = base::OnceCallback<void(std::vector<ExtensionInfoPtr>)>;

  virtual void GetInstalledExtensions(GetInstalledExtensionsCallback callback) = 0;

  virtual void ClickExtension(const std::string& extension_id) = 0;

  using InstallExtensionByIdCallback = base::OnceCallback<void(bool)>;
  using InstallExtensionByIdMojoCallback = base::OnceCallback<void(bool)>;

  virtual void InstallExtensionById(const std::string& extension_id, std::optional<bool> wait_for_activation, InstallExtensionByIdCallback callback) = 0;

  using GrantPermissionsAndEnableExtensionCallback = base::OnceCallback<void(bool)>;
  using GrantPermissionsAndEnableExtensionMojoCallback = base::OnceCallback<void(bool)>;

  virtual void GrantPermissionsAndEnableExtension(const std::string& extension_id, GrantPermissionsAndEnableExtensionCallback callback) = 0;

  virtual void SelectMenuItem(const std::string& extension_id, ExtensionMenuItemIdPtr item_id) = 0;
};



class  ExtensionServiceClientProxy
    : public ExtensionServiceClient {
 public:
  using InterfaceType = ExtensionServiceClient;

  explicit ExtensionServiceClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnExtensionInstalled(ExtensionInfoPtr extension_info, bool is_update) final;
  
  void OnExtensionUninstalled(const std::string& extension_id) final;
  
  void OnExtensionLoaded(const std::string& extension_id) final;
  
  void OnExtensionUnloaded(const std::string& extension_id) final;
  
  void OnExtensionActionIconUpdated(const std::string& extension_id, const ::gfx::ImageSkia& icon) final;
  
  void OnExtensionMenuUpdated(const std::string& extension_id, std::vector<ExtensionMenuItemPtr> items) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ExtensionServiceProxy
    : public ExtensionService {
 public:
  using InterfaceType = ExtensionService;

  explicit ExtensionServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetInstalledExtensions(GetInstalledExtensionsCallback callback) final;
  
  void ClickExtension(const std::string& extension_id) final;
  
  void InstallExtensionById(const std::string& extension_id, std::optional<bool> wait_for_activation, InstallExtensionByIdCallback callback) final;
  
  void GrantPermissionsAndEnableExtension(const std::string& extension_id, GrantPermissionsAndEnableExtensionCallback callback) final;
  
  void SelectMenuItem(const std::string& extension_id, ExtensionMenuItemIdPtr item_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ExtensionServiceClientStubDispatch {
 public:
  static bool Accept(ExtensionServiceClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ExtensionServiceClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ExtensionServiceClient>>
class ExtensionServiceClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ExtensionServiceClientStub() = default;
  ~ExtensionServiceClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ExtensionServiceClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ExtensionServiceClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ExtensionServiceStubDispatch {
 public:
  static bool Accept(ExtensionService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ExtensionService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ExtensionService>>
class ExtensionServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ExtensionServiceStub() = default;
  ~ExtensionServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ExtensionServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ExtensionServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ExtensionServiceClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ExtensionServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ExtensionServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};







class  ExtensionMenuItemId {
 public:
  using DataView = ExtensionMenuItemIdDataView;
  using Data_ = internal::ExtensionMenuItemId_Data;
  using Tag = Data_::ExtensionMenuItemId_Tag;

  template <typename... Args>
  static ExtensionMenuItemIdPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |id|.
  static ExtensionMenuItemIdPtr NewId(
      int64_t value);
  // Construct an instance holding |string_id|.
  static ExtensionMenuItemIdPtr NewStringId(
      const std::string& value);

  template <typename U>
  static ExtensionMenuItemIdPtr From(const U& u) {
    return mojo::TypeConverter<ExtensionMenuItemIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ExtensionMenuItemId>::Convert(*this);
  }
  ~ExtensionMenuItemId();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  ExtensionMenuItemId(const ExtensionMenuItemId& other) = delete;
  ExtensionMenuItemId& operator=(const ExtensionMenuItemId& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ExtensionMenuItemIdPtr>
  ExtensionMenuItemIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, ExtensionMenuItemId>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, ExtensionMenuItemId>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_id() const { return tag_ == Tag::kId; }
  int64_t get_id() const {
    CHECK(tag_ == Tag::kId);
    return data_.id;
  }
  void set_id(int64_t id);

  bool is_string_id() const { return tag_ == Tag::kStringId; }
  const std::string& get_string_id() const {
    CHECK(tag_ == Tag::kStringId);
    return data_.string_id;
  }
  std::string& get_string_id() {
    CHECK(tag_ == Tag::kStringId);
    return data_.string_id;
  }
  void set_string_id(const std::string& string_id);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ExtensionMenuItemId::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<ExtensionMenuItemId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kId)>,
        int64_t value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kStringId)>,
        const std::string& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    int64_t id;
    std::string string_id;
  };

  ExtensionMenuItemId(
      std::in_place_index_t<static_cast<size_t>(Tag::kId)>,
      int64_t value);
  ExtensionMenuItemId(
      std::in_place_index_t<static_cast<size_t>(Tag::kStringId)>,
      const std::string& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  ExtensionInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ExtensionInfo, T>::value>;
  using DataView = ExtensionInfoDataView;
  using Data_ = internal::ExtensionInfo_Data;

  template <typename... Args>
  static ExtensionInfoPtr New(Args&&... args) {
    return ExtensionInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ExtensionInfoPtr From(const U& u) {
    return mojo::TypeConverter<ExtensionInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ExtensionInfo>::Convert(*this);
  }


  ExtensionInfo();

  ExtensionInfo(
      const std::string& id,
      const ::std::u16string& name,
      const std::string& version,
      const std::string& icon_path);


  ~ExtensionInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ExtensionInfoPtr>
  ExtensionInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ExtensionInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ExtensionInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ExtensionInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExtensionInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExtensionInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ExtensionInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ExtensionInfo_UnserializedMessageContext<
            UserType, ExtensionInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ExtensionInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ExtensionInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ExtensionInfo_UnserializedMessageContext<
            UserType, ExtensionInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ExtensionInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  ::std::u16string name;
  
  std::string version;
  
  std::string icon_path;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ExtensionInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ExtensionInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ExtensionInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ExtensionInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ExtensionMenuItem {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ExtensionMenuItem, T>::value>;
  using DataView = ExtensionMenuItemDataView;
  using Data_ = internal::ExtensionMenuItem_Data;

  template <typename... Args>
  static ExtensionMenuItemPtr New(Args&&... args) {
    return ExtensionMenuItemPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ExtensionMenuItemPtr From(const U& u) {
    return mojo::TypeConverter<ExtensionMenuItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ExtensionMenuItem>::Convert(*this);
  }


  ExtensionMenuItem();

  ExtensionMenuItem(
      ExtensionMenuItemIdPtr id,
      const std::string& title,
      ExtensionMenuItemType type,
      std::vector<ExtensionMenuItemPtr> children);

ExtensionMenuItem(const ExtensionMenuItem&) = delete;
ExtensionMenuItem& operator=(const ExtensionMenuItem&) = delete;

  ~ExtensionMenuItem();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ExtensionMenuItemPtr>
  ExtensionMenuItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ExtensionMenuItem::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ExtensionMenuItem::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ExtensionMenuItem::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExtensionMenuItem::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExtensionMenuItem::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ExtensionMenuItem::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ExtensionMenuItem_UnserializedMessageContext<
            UserType, ExtensionMenuItem::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ExtensionMenuItem::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ExtensionMenuItem::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ExtensionMenuItem_UnserializedMessageContext<
            UserType, ExtensionMenuItem::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ExtensionMenuItem::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ExtensionMenuItemIdPtr id;
  
  std::string title;
  
  ExtensionMenuItemType type;
  
  std::vector<ExtensionMenuItemPtr> children;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ExtensionMenuItem::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ExtensionMenuItem::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ExtensionMenuItem::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ExtensionMenuItem::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
ExtensionMenuItemIdPtr ExtensionMenuItemId::Clone() const {
  switch (tag_) {
    case Tag::kId:
      return NewId(
          mojo::Clone(data_.id));
    case Tag::kStringId:
      return NewStringId(
          mojo::Clone(data_.string_id));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, ExtensionMenuItemId>::value>::type*>
bool ExtensionMenuItemId::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kId:
      return mojo::Equals(data_.id, other.data_.id);
    case Tag::kStringId:
      return mojo::Equals(data_.string_id, other.data_.string_id);
  }

  return false;
}
template <typename StructPtrType>
ExtensionInfoPtr ExtensionInfo::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(name),
      mojo::Clone(version),
      mojo::Clone(icon_path)
  );
}

template <typename T, ExtensionInfo::EnableIfSame<T>*>
bool ExtensionInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  if (!mojo::Equals(this->icon_path, other_struct.icon_path))
    return false;
  return true;
}

template <typename T, ExtensionInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.version < rhs.version)
    return true;
  if (rhs.version < lhs.version)
    return false;
  if (lhs.icon_path < rhs.icon_path)
    return true;
  if (rhs.icon_path < lhs.icon_path)
    return false;
  return false;
}
template <typename StructPtrType>
ExtensionMenuItemPtr ExtensionMenuItem::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(title),
      mojo::Clone(type),
      mojo::Clone(children)
  );
}

template <typename T, ExtensionMenuItem::EnableIfSame<T>*>
bool ExtensionMenuItem::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->children, other_struct.children))
    return false;
  return true;
}

template <typename T, ExtensionMenuItem::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.children < rhs.children)
    return true;
  if (rhs.children < lhs.children)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::ExtensionInfo::DataView,
                                         ::owl::mojom::ExtensionInfoPtr> {
  static bool IsNull(const ::owl::mojom::ExtensionInfoPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::ExtensionInfoPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::ExtensionInfo::id)& id(
      const ::owl::mojom::ExtensionInfoPtr& input) {
    return input->id;
  }

  static const decltype(::owl::mojom::ExtensionInfo::name)& name(
      const ::owl::mojom::ExtensionInfoPtr& input) {
    return input->name;
  }

  static const decltype(::owl::mojom::ExtensionInfo::version)& version(
      const ::owl::mojom::ExtensionInfoPtr& input) {
    return input->version;
  }

  static const decltype(::owl::mojom::ExtensionInfo::icon_path)& icon_path(
      const ::owl::mojom::ExtensionInfoPtr& input) {
    return input->icon_path;
  }

  static bool Read(::owl::mojom::ExtensionInfo::DataView input, ::owl::mojom::ExtensionInfoPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::ExtensionMenuItem::DataView,
                                         ::owl::mojom::ExtensionMenuItemPtr> {
  static bool IsNull(const ::owl::mojom::ExtensionMenuItemPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::ExtensionMenuItemPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::ExtensionMenuItem::id)& id(
      const ::owl::mojom::ExtensionMenuItemPtr& input) {
    return input->id;
  }

  static const decltype(::owl::mojom::ExtensionMenuItem::title)& title(
      const ::owl::mojom::ExtensionMenuItemPtr& input) {
    return input->title;
  }

  static decltype(::owl::mojom::ExtensionMenuItem::type) type(
      const ::owl::mojom::ExtensionMenuItemPtr& input) {
    return input->type;
  }

  static const decltype(::owl::mojom::ExtensionMenuItem::children)& children(
      const ::owl::mojom::ExtensionMenuItemPtr& input) {
    return input->children;
  }

  static bool Read(::owl::mojom::ExtensionMenuItem::DataView input, ::owl::mojom::ExtensionMenuItemPtr* output);
};


template <>
struct  UnionTraits<::owl::mojom::ExtensionMenuItemId::DataView,
                                        ::owl::mojom::ExtensionMenuItemIdPtr> {
  static bool IsNull(const ::owl::mojom::ExtensionMenuItemIdPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::ExtensionMenuItemIdPtr* output) { output->reset(); }

  static ::owl::mojom::ExtensionMenuItemId::Tag GetTag(const ::owl::mojom::ExtensionMenuItemIdPtr& input) {
    return input->which();
  }

  static  int64_t id(const ::owl::mojom::ExtensionMenuItemIdPtr& input) {
    return input->get_id();
  }

  static const std::string& string_id(const ::owl::mojom::ExtensionMenuItemIdPtr& input) {
    return input->get_string_id();
  }

  static bool Read(::owl::mojom::ExtensionMenuItemId::DataView input, ::owl::mojom::ExtensionMenuItemIdPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_EXTENSION_SERVICE_MOJOM_H_