// owl/mojom/extension_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/extension_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/extension_service.mojom-params-data.h"
#include "owl/mojom/extension_service.mojom-shared-message-ids.h"

#include "owl/mojom/extension_service.mojom-import-headers.h"
#include "owl/mojom/extension_service.mojom-test-utils.h"


namespace owl::mojom {
ExtensionInfo::ExtensionInfo()
    : id(),
      name(),
      version(),
      icon_path() {}

ExtensionInfo::ExtensionInfo(
    const std::string& id_in,
    const ::std::u16string& name_in,
    const std::string& version_in,
    const std::string& icon_path_in)
    : id(std::move(id_in)),
      name(std::move(name_in)),
      version(std::move(version_in)),
      icon_path(std::move(icon_path_in)) {}

ExtensionInfo::~ExtensionInfo() = default;

void ExtensionInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon_path"), this->icon_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ExtensionInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ExtensionMenuItem::ExtensionMenuItem()
    : id(),
      title(),
      type(),
      children() {}

ExtensionMenuItem::ExtensionMenuItem(
    ExtensionMenuItemIdPtr id_in,
    const std::string& title_in,
    ExtensionMenuItemType type_in,
    std::vector<ExtensionMenuItemPtr> children_in)
    : id(std::move(id_in)),
      title(std::move(title_in)),
      type(std::move(type_in)),
      children(std::move(children_in)) {}

ExtensionMenuItem::~ExtensionMenuItem() = default;

void ExtensionMenuItem::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ExtensionMenuItemIdPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ExtensionMenuItemType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "children"), this->children,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ExtensionMenuItemPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ExtensionMenuItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ExtensionMenuItemIdPtr
ExtensionMenuItemId::NewId(
    int64_t value) {
  return ExtensionMenuItemIdPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kId)>,
      std::move(value));
}

ExtensionMenuItemIdPtr
ExtensionMenuItemId::NewStringId(
    const std::string& value) {
  return ExtensionMenuItemIdPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kStringId)>,
      std::move(value));
}

ExtensionMenuItemId::ExtensionMenuItemId(
    std::in_place_index_t<static_cast<size_t>(Tag::kId)>,
    int64_t value)
    : tag_(Tag::kId),
      data_(std::in_place_index<static_cast<size_t>(Tag::kId)>,
            std::move(value)) {}

ExtensionMenuItemId::ExtensionMenuItemId(
    std::in_place_index_t<static_cast<size_t>(Tag::kStringId)>,
    const std::string& value)
    : tag_(Tag::kStringId),
      data_(std::in_place_index<static_cast<size_t>(Tag::kStringId)>,
            std::move(value)) {}
ExtensionMenuItemId::~ExtensionMenuItemId() {
  DestroyActive();
}

void ExtensionMenuItemId::set_id(int64_t id) {
  if (tag_ != Tag::kId) {
    DestroyActive();
    tag_ = Tag::kId;
  }
  data_.id = id;
}

void ExtensionMenuItemId::set_string_id(const std::string& string_id) {
  if (tag_ == Tag::kStringId) {
    data_.string_id = std::move(string_id);
  } else {
    DestroyActive();
    tag_ = Tag::kStringId;
    new (&data_.string_id) std::string(
        std::move(string_id));
  }
}


ExtensionMenuItemId::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kId)>,
    int64_t value)
    : id(std::move(value)) {}

ExtensionMenuItemId::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kStringId)>,
    const std::string& value)
    : string_id(std::move(value)) {}

void ExtensionMenuItemId::DestroyActive() {
  switch (tag_) {

    case Tag::kId:
      std::destroy_at(&data_.id);
      break;
    case Tag::kStringId:
      std::destroy_at(&data_.string_id);
      break;
  }
}
size_t ExtensionMenuItemId::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kId:
      return mojo::internal::Hash(seed, data_.id);
    case Tag::kStringId:
      return mojo::internal::Hash(seed, data_.string_id);
    default:
      NOTREACHED();
  }
}

bool ExtensionMenuItemId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

ExtensionServiceClient::IPCStableHashFunction ExtensionServiceClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ExtensionServiceClient>(message.name())) {
    case messages::ExtensionServiceClient::kOnExtensionInstalled: {
      return &ExtensionServiceClient::OnExtensionInstalled_Sym::IPCStableHash;
    }
    case messages::ExtensionServiceClient::kOnExtensionUninstalled: {
      return &ExtensionServiceClient::OnExtensionUninstalled_Sym::IPCStableHash;
    }
    case messages::ExtensionServiceClient::kOnExtensionLoaded: {
      return &ExtensionServiceClient::OnExtensionLoaded_Sym::IPCStableHash;
    }
    case messages::ExtensionServiceClient::kOnExtensionUnloaded: {
      return &ExtensionServiceClient::OnExtensionUnloaded_Sym::IPCStableHash;
    }
    case messages::ExtensionServiceClient::kOnExtensionActionIconUpdated: {
      return &ExtensionServiceClient::OnExtensionActionIconUpdated_Sym::IPCStableHash;
    }
    case messages::ExtensionServiceClient::kOnExtensionMenuUpdated: {
      return &ExtensionServiceClient::OnExtensionMenuUpdated_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ExtensionServiceClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ExtensionServiceClient>(message.name())) {
      case messages::ExtensionServiceClient::kOnExtensionInstalled:
            return "Receive owl::mojom::ExtensionServiceClient::OnExtensionInstalled";
      case messages::ExtensionServiceClient::kOnExtensionUninstalled:
            return "Receive owl::mojom::ExtensionServiceClient::OnExtensionUninstalled";
      case messages::ExtensionServiceClient::kOnExtensionLoaded:
            return "Receive owl::mojom::ExtensionServiceClient::OnExtensionLoaded";
      case messages::ExtensionServiceClient::kOnExtensionUnloaded:
            return "Receive owl::mojom::ExtensionServiceClient::OnExtensionUnloaded";
      case messages::ExtensionServiceClient::kOnExtensionActionIconUpdated:
            return "Receive owl::mojom::ExtensionServiceClient::OnExtensionActionIconUpdated";
      case messages::ExtensionServiceClient::kOnExtensionMenuUpdated:
            return "Receive owl::mojom::ExtensionServiceClient::OnExtensionMenuUpdated";
    }
  } else {
    switch (static_cast<messages::ExtensionServiceClient>(message.name())) {
      case messages::ExtensionServiceClient::kOnExtensionInstalled:
            return "Receive reply owl::mojom::ExtensionServiceClient::OnExtensionInstalled";
      case messages::ExtensionServiceClient::kOnExtensionUninstalled:
            return "Receive reply owl::mojom::ExtensionServiceClient::OnExtensionUninstalled";
      case messages::ExtensionServiceClient::kOnExtensionLoaded:
            return "Receive reply owl::mojom::ExtensionServiceClient::OnExtensionLoaded";
      case messages::ExtensionServiceClient::kOnExtensionUnloaded:
            return "Receive reply owl::mojom::ExtensionServiceClient::OnExtensionUnloaded";
      case messages::ExtensionServiceClient::kOnExtensionActionIconUpdated:
            return "Receive reply owl::mojom::ExtensionServiceClient::OnExtensionActionIconUpdated";
      case messages::ExtensionServiceClient::kOnExtensionMenuUpdated:
            return "Receive reply owl::mojom::ExtensionServiceClient::OnExtensionMenuUpdated";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ExtensionServiceClient::OnExtensionInstalled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xde139682;  // IPCStableHash for owl::mojom::ExtensionServiceClient::OnExtensionInstalled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ExtensionServiceClient::OnExtensionUninstalled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2a7a0458;  // IPCStableHash for owl::mojom::ExtensionServiceClient::OnExtensionUninstalled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ExtensionServiceClient::OnExtensionLoaded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbec373bd;  // IPCStableHash for owl::mojom::ExtensionServiceClient::OnExtensionLoaded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ExtensionServiceClient::OnExtensionUnloaded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x96a8d582;  // IPCStableHash for owl::mojom::ExtensionServiceClient::OnExtensionUnloaded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ExtensionServiceClient::OnExtensionActionIconUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x39d92a83;  // IPCStableHash for owl::mojom::ExtensionServiceClient::OnExtensionActionIconUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ExtensionServiceClient::OnExtensionMenuUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8074af82;  // IPCStableHash for owl::mojom::ExtensionServiceClient::OnExtensionMenuUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ExtensionServiceClientProxy::ExtensionServiceClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ExtensionServiceClientProxy::OnExtensionInstalled(
    ExtensionInfoPtr in_extension_info, bool in_is_update) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ExtensionServiceClient::OnExtensionInstalled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_info"), in_extension_info,
                        "<value of type ExtensionInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_update"), in_is_update,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ExtensionServiceClient::kOnExtensionInstalled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ExtensionServiceClient_OnExtensionInstalled_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_info)::BaseType> extension_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::ExtensionInfoDataView>(
    in_extension_info,
    extension_info_fragment);

  params->extension_info.Set(
      extension_info_fragment.is_null() ? nullptr : extension_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_info in ExtensionServiceClient.OnExtensionInstalled request");

  params->is_update = in_is_update;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ExtensionServiceClient::Name_);
  message.set_method_name("OnExtensionInstalled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ExtensionServiceClientProxy::OnExtensionUninstalled(
    const std::string& in_extension_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ExtensionServiceClient::OnExtensionUninstalled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ExtensionServiceClient::kOnExtensionUninstalled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ExtensionServiceClient_OnExtensionUninstalled_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_extension_id,
    extension_id_fragment);

  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_id in ExtensionServiceClient.OnExtensionUninstalled request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ExtensionServiceClient::Name_);
  message.set_method_name("OnExtensionUninstalled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ExtensionServiceClientProxy::OnExtensionLoaded(
    const std::string& in_extension_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ExtensionServiceClient::OnExtensionLoaded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ExtensionServiceClient::kOnExtensionLoaded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ExtensionServiceClient_OnExtensionLoaded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_extension_id,
    extension_id_fragment);

  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_id in ExtensionServiceClient.OnExtensionLoaded request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ExtensionServiceClient::Name_);
  message.set_method_name("OnExtensionLoaded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ExtensionServiceClientProxy::OnExtensionUnloaded(
    const std::string& in_extension_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ExtensionServiceClient::OnExtensionUnloaded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ExtensionServiceClient::kOnExtensionUnloaded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ExtensionServiceClient_OnExtensionUnloaded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_extension_id,
    extension_id_fragment);

  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_id in ExtensionServiceClient.OnExtensionUnloaded request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ExtensionServiceClient::Name_);
  message.set_method_name("OnExtensionUnloaded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ExtensionServiceClientProxy::OnExtensionActionIconUpdated(
    const std::string& in_extension_id, const ::gfx::ImageSkia& in_icon) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ExtensionServiceClient::OnExtensionActionIconUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("icon"), in_icon,
                        "<value of type const ::gfx::ImageSkia&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ExtensionServiceClient::kOnExtensionActionIconUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ExtensionServiceClient_OnExtensionActionIconUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_extension_id,
    extension_id_fragment);

  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_id in ExtensionServiceClient.OnExtensionActionIconUpdated request");
  mojo::internal::MessageFragment<
      typename decltype(params->icon)::BaseType> icon_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::ImageSkiaDataView>(
    in_icon,
    icon_fragment);

  params->icon.Set(
      icon_fragment.is_null() ? nullptr : icon_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->icon.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null icon in ExtensionServiceClient.OnExtensionActionIconUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ExtensionServiceClient::Name_);
  message.set_method_name("OnExtensionActionIconUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ExtensionServiceClientProxy::OnExtensionMenuUpdated(
    const std::string& in_extension_id, std::vector<ExtensionMenuItemPtr> in_items) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ExtensionServiceClient::OnExtensionMenuUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("items"), in_items,
                        "<value of type std::vector<ExtensionMenuItemPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ExtensionServiceClient::kOnExtensionMenuUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ExtensionServiceClient_OnExtensionMenuUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_extension_id,
    extension_id_fragment);

  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_id in ExtensionServiceClient.OnExtensionMenuUpdated request");
  mojo::internal::MessageFragment<
      typename decltype(params->items)::BaseType>
      items_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::ExtensionMenuItemDataView>>(
    in_items,
    items_fragment,
    &items_validate_params);

  params->items.Set(
      items_fragment.is_null() ? nullptr : items_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->items.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null items in ExtensionServiceClient.OnExtensionMenuUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ExtensionServiceClient::Name_);
  message.set_method_name("OnExtensionMenuUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ExtensionServiceClientStubDispatch::Accept(
    ExtensionServiceClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ExtensionServiceClient>(message->header()->name)) {
    case messages::ExtensionServiceClient::kOnExtensionInstalled: {
      DCHECK(message->is_serialized());
      internal::ExtensionServiceClient_OnExtensionInstalled_Params_Data* params =
          reinterpret_cast<internal::ExtensionServiceClient_OnExtensionInstalled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ExtensionServiceClient.0
      bool success = true;
      ExtensionInfoPtr p_extension_info{};
      bool p_is_update{};
      ExtensionServiceClient_OnExtensionInstalled_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionInfo(&p_extension_info))
        success = false;
      if (success)
        p_is_update = input_data_view.is_update();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ExtensionServiceClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnExtensionInstalled(        
        std::move(p_extension_info), 
        std::move(p_is_update));
      return true;
    }
    case messages::ExtensionServiceClient::kOnExtensionUninstalled: {
      DCHECK(message->is_serialized());
      internal::ExtensionServiceClient_OnExtensionUninstalled_Params_Data* params =
          reinterpret_cast<internal::ExtensionServiceClient_OnExtensionUninstalled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ExtensionServiceClient.1
      bool success = true;
      std::string p_extension_id{};
      ExtensionServiceClient_OnExtensionUninstalled_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ExtensionServiceClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnExtensionUninstalled(        
        std::move(p_extension_id));
      return true;
    }
    case messages::ExtensionServiceClient::kOnExtensionLoaded: {
      DCHECK(message->is_serialized());
      internal::ExtensionServiceClient_OnExtensionLoaded_Params_Data* params =
          reinterpret_cast<internal::ExtensionServiceClient_OnExtensionLoaded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ExtensionServiceClient.2
      bool success = true;
      std::string p_extension_id{};
      ExtensionServiceClient_OnExtensionLoaded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ExtensionServiceClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnExtensionLoaded(        
        std::move(p_extension_id));
      return true;
    }
    case messages::ExtensionServiceClient::kOnExtensionUnloaded: {
      DCHECK(message->is_serialized());
      internal::ExtensionServiceClient_OnExtensionUnloaded_Params_Data* params =
          reinterpret_cast<internal::ExtensionServiceClient_OnExtensionUnloaded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ExtensionServiceClient.3
      bool success = true;
      std::string p_extension_id{};
      ExtensionServiceClient_OnExtensionUnloaded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ExtensionServiceClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnExtensionUnloaded(        
        std::move(p_extension_id));
      return true;
    }
    case messages::ExtensionServiceClient::kOnExtensionActionIconUpdated: {
      DCHECK(message->is_serialized());
      internal::ExtensionServiceClient_OnExtensionActionIconUpdated_Params_Data* params =
          reinterpret_cast<internal::ExtensionServiceClient_OnExtensionActionIconUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ExtensionServiceClient.4
      bool success = true;
      std::string p_extension_id{};
      ::gfx::ImageSkia p_icon{};
      ExtensionServiceClient_OnExtensionActionIconUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadIcon(&p_icon))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ExtensionServiceClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnExtensionActionIconUpdated(        
        std::move(p_extension_id), 
        std::move(p_icon));
      return true;
    }
    case messages::ExtensionServiceClient::kOnExtensionMenuUpdated: {
      DCHECK(message->is_serialized());
      internal::ExtensionServiceClient_OnExtensionMenuUpdated_Params_Data* params =
          reinterpret_cast<internal::ExtensionServiceClient_OnExtensionMenuUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ExtensionServiceClient.5
      bool success = true;
      std::string p_extension_id{};
      std::vector<ExtensionMenuItemPtr> p_items{};
      ExtensionServiceClient_OnExtensionMenuUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadItems(&p_items))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ExtensionServiceClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnExtensionMenuUpdated(        
        std::move(p_extension_id), 
        std::move(p_items));
      return true;
    }
  }
  return false;
}

// static
bool ExtensionServiceClientStubDispatch::AcceptWithResponder(
    ExtensionServiceClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ExtensionServiceClient>(message->header()->name)) {
    case messages::ExtensionServiceClient::kOnExtensionInstalled: {
      break;
    }
    case messages::ExtensionServiceClient::kOnExtensionUninstalled: {
      break;
    }
    case messages::ExtensionServiceClient::kOnExtensionLoaded: {
      break;
    }
    case messages::ExtensionServiceClient::kOnExtensionUnloaded: {
      break;
    }
    case messages::ExtensionServiceClient::kOnExtensionActionIconUpdated: {
      break;
    }
    case messages::ExtensionServiceClient::kOnExtensionMenuUpdated: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kExtensionServiceClientValidationInfo[] = {
    { &internal::ExtensionServiceClient_OnExtensionInstalled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ExtensionServiceClient_OnExtensionUninstalled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ExtensionServiceClient_OnExtensionLoaded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ExtensionServiceClient_OnExtensionUnloaded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ExtensionServiceClient_OnExtensionActionIconUpdated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ExtensionServiceClient_OnExtensionMenuUpdated_Params_Data::Validate,
     nullptr /* no response */},
};

bool ExtensionServiceClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::ExtensionServiceClient::Name_,
    kExtensionServiceClientValidationInfo);
}

// The declaration includes the definition on other builds.

ExtensionService::IPCStableHashFunction ExtensionService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ExtensionService>(message.name())) {
    case messages::ExtensionService::kGetInstalledExtensions: {
      return &ExtensionService::GetInstalledExtensions_Sym::IPCStableHash;
    }
    case messages::ExtensionService::kClickExtension: {
      return &ExtensionService::ClickExtension_Sym::IPCStableHash;
    }
    case messages::ExtensionService::kInstallExtensionById: {
      return &ExtensionService::InstallExtensionById_Sym::IPCStableHash;
    }
    case messages::ExtensionService::kGrantPermissionsAndEnableExtension: {
      return &ExtensionService::GrantPermissionsAndEnableExtension_Sym::IPCStableHash;
    }
    case messages::ExtensionService::kSelectMenuItem: {
      return &ExtensionService::SelectMenuItem_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ExtensionService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ExtensionService>(message.name())) {
      case messages::ExtensionService::kGetInstalledExtensions:
            return "Receive owl::mojom::ExtensionService::GetInstalledExtensions";
      case messages::ExtensionService::kClickExtension:
            return "Receive owl::mojom::ExtensionService::ClickExtension";
      case messages::ExtensionService::kInstallExtensionById:
            return "Receive owl::mojom::ExtensionService::InstallExtensionById";
      case messages::ExtensionService::kGrantPermissionsAndEnableExtension:
            return "Receive owl::mojom::ExtensionService::GrantPermissionsAndEnableExtension";
      case messages::ExtensionService::kSelectMenuItem:
            return "Receive owl::mojom::ExtensionService::SelectMenuItem";
    }
  } else {
    switch (static_cast<messages::ExtensionService>(message.name())) {
      case messages::ExtensionService::kGetInstalledExtensions:
            return "Receive reply owl::mojom::ExtensionService::GetInstalledExtensions";
      case messages::ExtensionService::kClickExtension:
            return "Receive reply owl::mojom::ExtensionService::ClickExtension";
      case messages::ExtensionService::kInstallExtensionById:
            return "Receive reply owl::mojom::ExtensionService::InstallExtensionById";
      case messages::ExtensionService::kGrantPermissionsAndEnableExtension:
            return "Receive reply owl::mojom::ExtensionService::GrantPermissionsAndEnableExtension";
      case messages::ExtensionService::kSelectMenuItem:
            return "Receive reply owl::mojom::ExtensionService::SelectMenuItem";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ExtensionService::GetInstalledExtensions_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6a18f732;  // IPCStableHash for owl::mojom::ExtensionService::GetInstalledExtensions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ExtensionService::ClickExtension_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcc6dbd70;  // IPCStableHash for owl::mojom::ExtensionService::ClickExtension
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ExtensionService::InstallExtensionById_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0a0ef0ed;  // IPCStableHash for owl::mojom::ExtensionService::InstallExtensionById
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ExtensionService::GrantPermissionsAndEnableExtension_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x26a1242e;  // IPCStableHash for owl::mojom::ExtensionService::GrantPermissionsAndEnableExtension
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ExtensionService::SelectMenuItem_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x391a6d7e;  // IPCStableHash for owl::mojom::ExtensionService::SelectMenuItem
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ExtensionService_GetInstalledExtensions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ExtensionService_GetInstalledExtensions_ForwardToCallback(
      ExtensionService::GetInstalledExtensionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  ExtensionService_GetInstalledExtensions_ForwardToCallback(const ExtensionService_GetInstalledExtensions_ForwardToCallback&) = delete;
  ExtensionService_GetInstalledExtensions_ForwardToCallback& operator=(const ExtensionService_GetInstalledExtensions_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ExtensionService::GetInstalledExtensionsCallback callback_;
};

class ExtensionService_InstallExtensionById_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ExtensionService_InstallExtensionById_ForwardToCallback(
      ExtensionService::InstallExtensionByIdCallback callback
      ) : callback_(std::move(callback)) {
  }

  ExtensionService_InstallExtensionById_ForwardToCallback(const ExtensionService_InstallExtensionById_ForwardToCallback&) = delete;
  ExtensionService_InstallExtensionById_ForwardToCallback& operator=(const ExtensionService_InstallExtensionById_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ExtensionService::InstallExtensionByIdCallback callback_;
};

class ExtensionService_GrantPermissionsAndEnableExtension_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ExtensionService_GrantPermissionsAndEnableExtension_ForwardToCallback(
      ExtensionService::GrantPermissionsAndEnableExtensionCallback callback
      ) : callback_(std::move(callback)) {
  }

  ExtensionService_GrantPermissionsAndEnableExtension_ForwardToCallback(const ExtensionService_GrantPermissionsAndEnableExtension_ForwardToCallback&) = delete;
  ExtensionService_GrantPermissionsAndEnableExtension_ForwardToCallback& operator=(const ExtensionService_GrantPermissionsAndEnableExtension_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ExtensionService::GrantPermissionsAndEnableExtensionCallback callback_;
};

ExtensionServiceProxy::ExtensionServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ExtensionServiceProxy::GetInstalledExtensions(
    GetInstalledExtensionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::ExtensionService::GetInstalledExtensions");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ExtensionService::kGetInstalledExtensions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ExtensionService_GetInstalledExtensions_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ExtensionService::Name_);
  message.set_method_name("GetInstalledExtensions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ExtensionService_GetInstalledExtensions_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ExtensionServiceProxy::ClickExtension(
    const std::string& in_extension_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ExtensionService::ClickExtension", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ExtensionService::kClickExtension), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ExtensionService_ClickExtension_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_extension_id,
    extension_id_fragment);

  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_id in ExtensionService.ClickExtension request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ExtensionService::Name_);
  message.set_method_name("ClickExtension");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ExtensionServiceProxy::InstallExtensionById(
    const std::string& in_extension_id, std::optional<bool> in_wait_for_activation, InstallExtensionByIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ExtensionService::InstallExtensionById", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wait_for_activation"), in_wait_for_activation,
                        "<value of type std::optional<bool>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ExtensionService::kInstallExtensionById), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ExtensionService_InstallExtensionById_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_extension_id,
    extension_id_fragment);

  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_id in ExtensionService.InstallExtensionById request");
  params->wait_for_activation_$flag = in_wait_for_activation.has_value();
  if (in_wait_for_activation.has_value()) {
    params->wait_for_activation_$value = in_wait_for_activation.value();
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ExtensionService::Name_);
  message.set_method_name("InstallExtensionById");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ExtensionService_InstallExtensionById_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ExtensionServiceProxy::GrantPermissionsAndEnableExtension(
    const std::string& in_extension_id, GrantPermissionsAndEnableExtensionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ExtensionService::GrantPermissionsAndEnableExtension", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ExtensionService::kGrantPermissionsAndEnableExtension), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ExtensionService_GrantPermissionsAndEnableExtension_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_extension_id,
    extension_id_fragment);

  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_id in ExtensionService.GrantPermissionsAndEnableExtension request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ExtensionService::Name_);
  message.set_method_name("GrantPermissionsAndEnableExtension");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ExtensionService_GrantPermissionsAndEnableExtension_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ExtensionServiceProxy::SelectMenuItem(
    const std::string& in_extension_id, ExtensionMenuItemIdPtr in_item_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ExtensionService::SelectMenuItem", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("item_id"), in_item_id,
                        "<value of type ExtensionMenuItemIdPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ExtensionService::kSelectMenuItem), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ExtensionService_SelectMenuItem_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_extension_id,
    extension_id_fragment);

  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_id in ExtensionService.SelectMenuItem request");
  mojo::internal::MessageFragment<decltype(params->item_id)>
      item_id_fragment(params.message());
  item_id_fragment.Claim(&params->item_id);
  
  mojo::internal::Serialize<::owl::mojom::ExtensionMenuItemIdDataView>(
    in_item_id,
    item_id_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->item_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null item_id in ExtensionService.SelectMenuItem request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ExtensionService::Name_);
  message.set_method_name("SelectMenuItem");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class ExtensionService_GetInstalledExtensions_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ExtensionService::GetInstalledExtensionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ExtensionService_GetInstalledExtensions_ProxyToResponder> proxy(
        new ExtensionService_GetInstalledExtensions_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ExtensionService_GetInstalledExtensions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ExtensionService_GetInstalledExtensions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ExtensionService_GetInstalledExtensions_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ExtensionService::GetInstalledExtensionsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<ExtensionInfoPtr> in_extensions);
};

bool ExtensionService_GetInstalledExtensions_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ExtensionService_GetInstalledExtensions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ExtensionService_GetInstalledExtensions_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ExtensionService.0
  bool success = true;
  std::vector<ExtensionInfoPtr> p_extensions{};
  ExtensionService_GetInstalledExtensions_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadExtensions(&p_extensions))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ExtensionService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_extensions));
  }
  return true;
}

void ExtensionService_GetInstalledExtensions_ProxyToResponder::Run(
    std::vector<ExtensionInfoPtr> in_extensions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::ExtensionService::GetInstalledExtensions", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extensions"), in_extensions,
                        "<value of type std::vector<ExtensionInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ExtensionService::kGetInstalledExtensions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ExtensionService_GetInstalledExtensions_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extensions)::BaseType>
      extensions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& extensions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::ExtensionInfoDataView>>(
    in_extensions,
    extensions_fragment,
    &extensions_validate_params);

  params->extensions.Set(
      extensions_fragment.is_null() ? nullptr : extensions_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extensions.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extensions in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ExtensionService::Name_);
  message.set_method_name("GetInstalledExtensions");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ExtensionService_InstallExtensionById_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ExtensionService::InstallExtensionByIdCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ExtensionService_InstallExtensionById_ProxyToResponder> proxy(
        new ExtensionService_InstallExtensionById_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ExtensionService_InstallExtensionById_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ExtensionService_InstallExtensionById_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ExtensionService_InstallExtensionById_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ExtensionService::InstallExtensionByIdCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool ExtensionService_InstallExtensionById_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ExtensionService_InstallExtensionById_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ExtensionService_InstallExtensionById_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ExtensionService.2
  bool success = true;
  bool p_success{};
  ExtensionService_InstallExtensionById_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ExtensionService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void ExtensionService_InstallExtensionById_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::ExtensionService::InstallExtensionById", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ExtensionService::kInstallExtensionById), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ExtensionService_InstallExtensionById_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ExtensionService::Name_);
  message.set_method_name("InstallExtensionById");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ExtensionService_GrantPermissionsAndEnableExtension_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ExtensionService::GrantPermissionsAndEnableExtensionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ExtensionService_GrantPermissionsAndEnableExtension_ProxyToResponder> proxy(
        new ExtensionService_GrantPermissionsAndEnableExtension_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ExtensionService_GrantPermissionsAndEnableExtension_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ExtensionService_GrantPermissionsAndEnableExtension_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ExtensionService_GrantPermissionsAndEnableExtension_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ExtensionService::GrantPermissionsAndEnableExtensionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool ExtensionService_GrantPermissionsAndEnableExtension_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ExtensionService_GrantPermissionsAndEnableExtension_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ExtensionService_GrantPermissionsAndEnableExtension_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ExtensionService.3
  bool success = true;
  bool p_success{};
  ExtensionService_GrantPermissionsAndEnableExtension_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ExtensionService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void ExtensionService_GrantPermissionsAndEnableExtension_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::ExtensionService::GrantPermissionsAndEnableExtension", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ExtensionService::kGrantPermissionsAndEnableExtension), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ExtensionService_GrantPermissionsAndEnableExtension_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ExtensionService::Name_);
  message.set_method_name("GrantPermissionsAndEnableExtension");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ExtensionServiceStubDispatch::Accept(
    ExtensionService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ExtensionService>(message->header()->name)) {
    case messages::ExtensionService::kGetInstalledExtensions: {
      break;
    }
    case messages::ExtensionService::kClickExtension: {
      DCHECK(message->is_serialized());
      internal::ExtensionService_ClickExtension_Params_Data* params =
          reinterpret_cast<internal::ExtensionService_ClickExtension_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ExtensionService.1
      bool success = true;
      std::string p_extension_id{};
      ExtensionService_ClickExtension_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ExtensionService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClickExtension(        
        std::move(p_extension_id));
      return true;
    }
    case messages::ExtensionService::kInstallExtensionById: {
      break;
    }
    case messages::ExtensionService::kGrantPermissionsAndEnableExtension: {
      break;
    }
    case messages::ExtensionService::kSelectMenuItem: {
      DCHECK(message->is_serialized());
      internal::ExtensionService_SelectMenuItem_Params_Data* params =
          reinterpret_cast<internal::ExtensionService_SelectMenuItem_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ExtensionService.4
      bool success = true;
      std::string p_extension_id{};
      ExtensionMenuItemIdPtr p_item_id{};
      ExtensionService_SelectMenuItem_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadItemId(&p_item_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ExtensionService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SelectMenuItem(        
        std::move(p_extension_id), 
        std::move(p_item_id));
      return true;
    }
  }
  return false;
}

// static
bool ExtensionServiceStubDispatch::AcceptWithResponder(
    ExtensionService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ExtensionService>(message->header()->name)) {
    case messages::ExtensionService::kGetInstalledExtensions: {
      internal::ExtensionService_GetInstalledExtensions_Params_Data* params =
          reinterpret_cast<
              internal::ExtensionService_GetInstalledExtensions_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ExtensionService.0
      bool success = true;
      ExtensionService_GetInstalledExtensions_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ExtensionService::Name_, 0, false);
        return false;
      }
      auto callback =
          ExtensionService_GetInstalledExtensions_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetInstalledExtensions(std::move(callback));
      return true;
    }
    case messages::ExtensionService::kClickExtension: {
      break;
    }
    case messages::ExtensionService::kInstallExtensionById: {
      internal::ExtensionService_InstallExtensionById_Params_Data* params =
          reinterpret_cast<
              internal::ExtensionService_InstallExtensionById_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ExtensionService.2
      bool success = true;
      std::string p_extension_id{};
      std::optional<bool> p_wait_for_activation{};
      ExtensionService_InstallExtensionById_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success) {
        p_wait_for_activation = input_data_view.wait_for_activation();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ExtensionService::Name_, 2, false);
        return false;
      }
      auto callback =
          ExtensionService_InstallExtensionById_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InstallExtensionById(        
        std::move(p_extension_id), 
        std::move(p_wait_for_activation), std::move(callback));
      return true;
    }
    case messages::ExtensionService::kGrantPermissionsAndEnableExtension: {
      internal::ExtensionService_GrantPermissionsAndEnableExtension_Params_Data* params =
          reinterpret_cast<
              internal::ExtensionService_GrantPermissionsAndEnableExtension_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ExtensionService.3
      bool success = true;
      std::string p_extension_id{};
      ExtensionService_GrantPermissionsAndEnableExtension_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ExtensionService::Name_, 3, false);
        return false;
      }
      auto callback =
          ExtensionService_GrantPermissionsAndEnableExtension_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GrantPermissionsAndEnableExtension(        
        std::move(p_extension_id), std::move(callback));
      return true;
    }
    case messages::ExtensionService::kSelectMenuItem: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kExtensionServiceValidationInfo[] = {
    { &internal::ExtensionService_GetInstalledExtensions_Params_Data::Validate,
     &internal::ExtensionService_GetInstalledExtensions_ResponseParams_Data::Validate},
    { &internal::ExtensionService_ClickExtension_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ExtensionService_InstallExtensionById_Params_Data::Validate,
     &internal::ExtensionService_InstallExtensionById_ResponseParams_Data::Validate},
    { &internal::ExtensionService_GrantPermissionsAndEnableExtension_Params_Data::Validate,
     &internal::ExtensionService_GrantPermissionsAndEnableExtension_ResponseParams_Data::Validate},
    { &internal::ExtensionService_SelectMenuItem_Params_Data::Validate,
     nullptr /* no response */},
};

bool ExtensionServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::ExtensionService::Name_,
    kExtensionServiceValidationInfo);
}

bool ExtensionServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::owl::mojom::ExtensionService::Name_,
    kExtensionServiceValidationInfo);
}


}  // owl::mojom


namespace mojo {


// static
bool StructTraits<::owl::mojom::ExtensionInfo::DataView, ::owl::mojom::ExtensionInfoPtr>::Read(
    ::owl::mojom::ExtensionInfo::DataView input,
    ::owl::mojom::ExtensionInfoPtr* output) {
  bool success = true;
  ::owl::mojom::ExtensionInfoPtr result(::owl::mojom::ExtensionInfo::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadVersion(&result->version))
        success = false;
      if (success && !input.ReadIconPath(&result->icon_path))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::ExtensionMenuItem::DataView, ::owl::mojom::ExtensionMenuItemPtr>::Read(
    ::owl::mojom::ExtensionMenuItem::DataView input,
    ::owl::mojom::ExtensionMenuItemPtr* output) {
  bool success = true;
  ::owl::mojom::ExtensionMenuItemPtr result(::owl::mojom::ExtensionMenuItem::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadChildren(&result->children))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::owl::mojom::ExtensionMenuItemId::DataView, ::owl::mojom::ExtensionMenuItemIdPtr>::Read(
    ::owl::mojom::ExtensionMenuItemId::DataView input,
    ::owl::mojom::ExtensionMenuItemIdPtr* output) {
  using UnionType = ::owl::mojom::ExtensionMenuItemId;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kId: {
      *output = UnionType::NewId(input.id());
      break;
    }
    case Tag::kStringId: {
      std::string result_string_id{};
      if (!input.ReadStringId(&result_string_id))
        return false;

      *output = UnionType::NewStringId(
          std::move(result_string_id));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void ExtensionServiceClientInterceptorForTesting::OnExtensionInstalled(ExtensionInfoPtr extension_info, bool is_update) {
  GetForwardingInterface()->OnExtensionInstalled(
    std::move(extension_info)
    , 
    std::move(is_update)
    );
}
void ExtensionServiceClientInterceptorForTesting::OnExtensionUninstalled(const std::string& extension_id) {
  GetForwardingInterface()->OnExtensionUninstalled(
    std::move(extension_id)
    );
}
void ExtensionServiceClientInterceptorForTesting::OnExtensionLoaded(const std::string& extension_id) {
  GetForwardingInterface()->OnExtensionLoaded(
    std::move(extension_id)
    );
}
void ExtensionServiceClientInterceptorForTesting::OnExtensionUnloaded(const std::string& extension_id) {
  GetForwardingInterface()->OnExtensionUnloaded(
    std::move(extension_id)
    );
}
void ExtensionServiceClientInterceptorForTesting::OnExtensionActionIconUpdated(const std::string& extension_id, const ::gfx::ImageSkia& icon) {
  GetForwardingInterface()->OnExtensionActionIconUpdated(
    std::move(extension_id)
    , 
    std::move(icon)
    );
}
void ExtensionServiceClientInterceptorForTesting::OnExtensionMenuUpdated(const std::string& extension_id, std::vector<ExtensionMenuItemPtr> items) {
  GetForwardingInterface()->OnExtensionMenuUpdated(
    std::move(extension_id)
    , 
    std::move(items)
    );
}
ExtensionServiceClientAsyncWaiter::ExtensionServiceClientAsyncWaiter(
    ExtensionServiceClient* proxy) : proxy_(proxy) {}

ExtensionServiceClientAsyncWaiter::~ExtensionServiceClientAsyncWaiter() = default;





void ExtensionServiceInterceptorForTesting::GetInstalledExtensions(GetInstalledExtensionsCallback callback) {
  GetForwardingInterface()->GetInstalledExtensions(std::move(callback));
}
void ExtensionServiceInterceptorForTesting::ClickExtension(const std::string& extension_id) {
  GetForwardingInterface()->ClickExtension(
    std::move(extension_id)
    );
}
void ExtensionServiceInterceptorForTesting::InstallExtensionById(const std::string& extension_id, std::optional<bool> wait_for_activation, InstallExtensionByIdCallback callback) {
  GetForwardingInterface()->InstallExtensionById(
    std::move(extension_id)
    , 
    std::move(wait_for_activation)
    , std::move(callback));
}
void ExtensionServiceInterceptorForTesting::GrantPermissionsAndEnableExtension(const std::string& extension_id, GrantPermissionsAndEnableExtensionCallback callback) {
  GetForwardingInterface()->GrantPermissionsAndEnableExtension(
    std::move(extension_id)
    , std::move(callback));
}
void ExtensionServiceInterceptorForTesting::SelectMenuItem(const std::string& extension_id, ExtensionMenuItemIdPtr item_id) {
  GetForwardingInterface()->SelectMenuItem(
    std::move(extension_id)
    , 
    std::move(item_id)
    );
}
ExtensionServiceAsyncWaiter::ExtensionServiceAsyncWaiter(
    ExtensionService* proxy) : proxy_(proxy) {}

ExtensionServiceAsyncWaiter::~ExtensionServiceAsyncWaiter() = default;


void ExtensionServiceAsyncWaiter::GetInstalledExtensions(
    std::vector<ExtensionInfoPtr>* out_extensions) {
  base::RunLoop loop;
  proxy_->GetInstalledExtensions(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<ExtensionInfoPtr>* out_extensions
,
             std::vector<ExtensionInfoPtr> extensions) {*out_extensions = std::move(extensions);
            loop->Quit();
          },
          &loop,
          out_extensions));
  loop.Run();
}

std::vector<ExtensionInfoPtr> ExtensionServiceAsyncWaiter::GetInstalledExtensions(
    ) {
  std::vector<ExtensionInfoPtr> async_wait_result;
  GetInstalledExtensions(&async_wait_result);
  return async_wait_result;
}

void ExtensionServiceAsyncWaiter::InstallExtensionById(
    const std::string& extension_id, std::optional<bool> wait_for_activation, bool* out_success) {
  base::RunLoop loop;
  proxy_->InstallExtensionById(
      std::move(extension_id),
      std::move(wait_for_activation),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool ExtensionServiceAsyncWaiter::InstallExtensionById(
    const std::string& extension_id, std::optional<bool> wait_for_activation) {
  bool async_wait_result;
  InstallExtensionById(std::move(extension_id),std::move(wait_for_activation),&async_wait_result);
  return async_wait_result;
}

void ExtensionServiceAsyncWaiter::GrantPermissionsAndEnableExtension(
    const std::string& extension_id, bool* out_success) {
  base::RunLoop loop;
  proxy_->GrantPermissionsAndEnableExtension(
      std::move(extension_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool ExtensionServiceAsyncWaiter::GrantPermissionsAndEnableExtension(
    const std::string& extension_id) {
  bool async_wait_result;
  GrantPermissionsAndEnableExtension(std::move(extension_id),&async_wait_result);
  return async_wait_result;
}






}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif