// owl/mojom/extension_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "owl/mojom/extension_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/extension_service.mojom-params-data.h"
namespace owl {
namespace mojom {

NOINLINE static const char* ExtensionMenuItemTypeToStringHelper(ExtensionMenuItemType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ExtensionMenuItemType::kNormal:
      return "kNormal";
    case ExtensionMenuItemType::kCheckbox:
      return "kCheckbox";
    case ExtensionMenuItemType::kRadioButton:
      return "kRadioButton";
    case ExtensionMenuItemType::kSeparator:
      return "kSeparator";
    default:
      return nullptr;
  }
}

std::string ExtensionMenuItemTypeToString(ExtensionMenuItemType value) {
  const char *str = ExtensionMenuItemTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ExtensionMenuItemType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ExtensionMenuItemType value) {
  return os << ExtensionMenuItemTypeToString(value);
}

namespace internal {
// static
bool ExtensionMenuItemId_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const ExtensionMenuItemId_Data* object = static_cast<const ExtensionMenuItemId_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case ExtensionMenuItemId_Tag::kId: {

      return true;
    }
    case ExtensionMenuItemId_Tag::kStringId: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_string_id, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& string_id_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_string_id, validation_context,
                                             &string_id_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in ExtensionMenuItemId");
      return false;
    }
  }
}


// static
bool ExtensionInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExtensionInfo_Data* object =
      static_cast<const ExtensionInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->version, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->version, validation_context,
                                         &version_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon_path, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& icon_path_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->icon_path, validation_context,
                                         &icon_path_validate_params)) {
    return false;
  }

  return true;
}

ExtensionInfo_Data::ExtensionInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ExtensionMenuItem_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExtensionMenuItem_Data* object =
      static_cast<const ExtensionMenuItem_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }


  if (!::owl::mojom::internal::ExtensionMenuItemType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->children, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->children, validation_context,
                                         &children_validate_params)) {
    return false;
  }

  return true;
}

ExtensionMenuItem_Data::ExtensionMenuItem_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ExtensionServiceClient_OnExtensionInstalled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExtensionServiceClient_OnExtensionInstalled_Params_Data* object =
      static_cast<const ExtensionServiceClient_OnExtensionInstalled_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->extension_info, validation_context))
    return false;

  return true;
}

ExtensionServiceClient_OnExtensionInstalled_Params_Data::ExtensionServiceClient_OnExtensionInstalled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ExtensionServiceClient_OnExtensionUninstalled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExtensionServiceClient_OnExtensionUninstalled_Params_Data* object =
      static_cast<const ExtensionServiceClient_OnExtensionUninstalled_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extension_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  return true;
}

ExtensionServiceClient_OnExtensionUninstalled_Params_Data::ExtensionServiceClient_OnExtensionUninstalled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ExtensionServiceClient_OnExtensionLoaded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExtensionServiceClient_OnExtensionLoaded_Params_Data* object =
      static_cast<const ExtensionServiceClient_OnExtensionLoaded_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extension_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  return true;
}

ExtensionServiceClient_OnExtensionLoaded_Params_Data::ExtensionServiceClient_OnExtensionLoaded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ExtensionServiceClient_OnExtensionUnloaded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExtensionServiceClient_OnExtensionUnloaded_Params_Data* object =
      static_cast<const ExtensionServiceClient_OnExtensionUnloaded_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extension_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  return true;
}

ExtensionServiceClient_OnExtensionUnloaded_Params_Data::ExtensionServiceClient_OnExtensionUnloaded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ExtensionServiceClient_OnExtensionActionIconUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExtensionServiceClient_OnExtensionActionIconUpdated_Params_Data* object =
      static_cast<const ExtensionServiceClient_OnExtensionActionIconUpdated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extension_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->icon, validation_context))
    return false;

  return true;
}

ExtensionServiceClient_OnExtensionActionIconUpdated_Params_Data::ExtensionServiceClient_OnExtensionActionIconUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ExtensionServiceClient_OnExtensionMenuUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExtensionServiceClient_OnExtensionMenuUpdated_Params_Data* object =
      static_cast<const ExtensionServiceClient_OnExtensionMenuUpdated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extension_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->items, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->items, validation_context,
                                         &items_validate_params)) {
    return false;
  }

  return true;
}

ExtensionServiceClient_OnExtensionMenuUpdated_Params_Data::ExtensionServiceClient_OnExtensionMenuUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ExtensionService_GetInstalledExtensions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExtensionService_GetInstalledExtensions_Params_Data* object =
      static_cast<const ExtensionService_GetInstalledExtensions_Params_Data*>(data);

  return true;
}

ExtensionService_GetInstalledExtensions_Params_Data::ExtensionService_GetInstalledExtensions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ExtensionService_GetInstalledExtensions_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExtensionService_GetInstalledExtensions_ResponseParams_Data* object =
      static_cast<const ExtensionService_GetInstalledExtensions_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extensions, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extensions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extensions, validation_context,
                                         &extensions_validate_params)) {
    return false;
  }

  return true;
}

ExtensionService_GetInstalledExtensions_ResponseParams_Data::ExtensionService_GetInstalledExtensions_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ExtensionService_ClickExtension_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExtensionService_ClickExtension_Params_Data* object =
      static_cast<const ExtensionService_ClickExtension_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extension_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  return true;
}

ExtensionService_ClickExtension_Params_Data::ExtensionService_ClickExtension_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ExtensionService_InstallExtensionById_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExtensionService_InstallExtensionById_Params_Data* object =
      static_cast<const ExtensionService_InstallExtensionById_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extension_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  return true;
}

ExtensionService_InstallExtensionById_Params_Data::ExtensionService_InstallExtensionById_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ExtensionService_InstallExtensionById_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExtensionService_InstallExtensionById_ResponseParams_Data* object =
      static_cast<const ExtensionService_InstallExtensionById_ResponseParams_Data*>(data);

  return true;
}

ExtensionService_InstallExtensionById_ResponseParams_Data::ExtensionService_InstallExtensionById_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ExtensionService_GrantPermissionsAndEnableExtension_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExtensionService_GrantPermissionsAndEnableExtension_Params_Data* object =
      static_cast<const ExtensionService_GrantPermissionsAndEnableExtension_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extension_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  return true;
}

ExtensionService_GrantPermissionsAndEnableExtension_Params_Data::ExtensionService_GrantPermissionsAndEnableExtension_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ExtensionService_GrantPermissionsAndEnableExtension_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExtensionService_GrantPermissionsAndEnableExtension_ResponseParams_Data* object =
      static_cast<const ExtensionService_GrantPermissionsAndEnableExtension_ResponseParams_Data*>(data);

  return true;
}

ExtensionService_GrantPermissionsAndEnableExtension_ResponseParams_Data::ExtensionService_GrantPermissionsAndEnableExtension_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ExtensionService_SelectMenuItem_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExtensionService_SelectMenuItem_Params_Data* object =
      static_cast<const ExtensionService_SelectMenuItem_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extension_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->item_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->item_id, validation_context))
    return false;

  return true;
}

ExtensionService_SelectMenuItem_Params_Data::ExtensionService_SelectMenuItem_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace owl

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::ExtensionMenuItemType>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::ExtensionMenuItemType value) {
  return std::move(context).WriteString(::owl::mojom::ExtensionMenuItemTypeToString(value));
}

} // namespace perfetto