// owl/mojom/extension_service.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_EXTENSION_SERVICE_MOJOM_SHARED_INTERNAL_H_
#define OWL_MOJOM_EXTENSION_SERVICE_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/message_fragment.h"
#include "mojo/public/c/system/macros.h"
#include "mojo/public/mojom/base/string16.mojom-shared-internal.h"
#include "ui/gfx/image/mojom/image.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace owl::mojom {
namespace internal {
class ExtensionInfo_Data;
class ExtensionMenuItem_Data;
class ExtensionMenuItemId_Data;

struct ExtensionMenuItemType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)


class  ExtensionMenuItemId_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  ExtensionMenuItemId_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~ExtensionMenuItemId_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<ExtensionMenuItemId_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class ExtensionMenuItemId_Tag : uint32_t {

    
    kId,
    
    kStringId,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    int64_t f_id;
    mojo::internal::Pointer<mojo::internal::String_Data> f_string_id;
    uint64_t unknown;
  };

  uint32_t size;
  ExtensionMenuItemId_Tag tag;
  Union_ data;
};
static_assert(sizeof(ExtensionMenuItemId_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(ExtensionMenuItemId_Data)");
class  ExtensionInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> id;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> name;
  mojo::internal::Pointer<mojo::internal::String_Data> version;
  mojo::internal::Pointer<mojo::internal::String_Data> icon_path;

 private:
  friend class mojo::internal::MessageFragment<ExtensionInfo_Data>;

  ExtensionInfo_Data();
  ~ExtensionInfo_Data() = delete;
};
static_assert(sizeof(ExtensionInfo_Data) == 40,
              "Bad sizeof(ExtensionInfo_Data)");
// Used by ExtensionInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ExtensionInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ExtensionInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ExtensionInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ExtensionInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ExtensionInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ExtensionMenuItem_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::ExtensionMenuItemId_Data id;
  mojo::internal::Pointer<mojo::internal::String_Data> title;
  int32_t type;
  uint8_t pad2_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::ExtensionMenuItem_Data>>> children;

 private:
  friend class mojo::internal::MessageFragment<ExtensionMenuItem_Data>;

  ExtensionMenuItem_Data();
  ~ExtensionMenuItem_Data() = delete;
};
static_assert(sizeof(ExtensionMenuItem_Data) == 48,
              "Bad sizeof(ExtensionMenuItem_Data)");
// Used by ExtensionMenuItem::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ExtensionMenuItem_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ExtensionMenuItem_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ExtensionMenuItem_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ExtensionMenuItem_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ExtensionMenuItem_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // owl::mojom

#endif  // OWL_MOJOM_EXTENSION_SERVICE_MOJOM_SHARED_INTERNAL_H_