// owl/mojom/extension_service.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_EXTENSION_SERVICE_MOJOM_SEND_VALIDATION_H_
#define OWL_MOJOM_EXTENSION_SERVICE_MOJOM_SEND_VALIDATION_H_

#include "owl/mojom/extension_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "owl/mojom/extension_service.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::ExtensionMenuItemType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::ExtensionInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::ExtensionInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::ExtensionInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in ExtensionInfo struct");

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in ExtensionInfo struct");

      decltype(Traits::version(input)) in_version = Traits::version(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->version)::BaseType> version_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_version,
        version_fragment);

      fragment->version.Set(
          version_fragment.is_null() ? nullptr : version_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->version.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null version in ExtensionInfo struct");

      decltype(Traits::icon_path(input)) in_icon_path = Traits::icon_path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->icon_path)::BaseType> icon_path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_icon_path,
        icon_path_fragment);

      fragment->icon_path.Set(
          icon_path_fragment.is_null() ? nullptr : icon_path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->icon_path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icon_path in ExtensionInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::ExtensionMenuItemDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::ExtensionMenuItemDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::ExtensionMenuItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<decltype(fragment->id)>
          id_fragment(fragment.message());
      id_fragment.Claim(&fragment->id);
      
      mojo::internal::Serialize<::owl::mojom::ExtensionMenuItemIdDataView, send_validation>(
        in_id,
        id_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in ExtensionMenuItem struct");

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in ExtensionMenuItem struct");

      
      mojo::internal::Serialize<::owl::mojom::ExtensionMenuItemType>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::children(input)) in_children = Traits::children(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->children)::BaseType>
          children_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::ExtensionMenuItemDataView>, send_validation>(
        in_children,
        children_fragment,
        &children_validate_params);

      fragment->children.Set(
          children_fragment.is_null() ? nullptr : children_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->children.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null children in ExtensionMenuItem struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::ExtensionMenuItemIdDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::owl::mojom::ExtensionMenuItemIdDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::owl::mojom::internal::ExtensionMenuItemId_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::owl::mojom::ExtensionMenuItemIdDataView::Tag::kId: {
    decltype(Traits::id(input))
    in_id = Traits::id(input);
    fragment->data.f_id = in_id;
    break;
  }
  case ::owl::mojom::ExtensionMenuItemIdDataView::Tag::kStringId: {
    decltype(Traits::string_id(input))
    in_string_id = Traits::string_id(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_string_id)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView, send_validation>(
  in_string_id,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null string_id in ExtensionMenuItemId union");
    fragment->data.f_string_id.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // OWL_MOJOM_EXTENSION_SERVICE_MOJOM_SEND_VALIDATION_H_