// owl/mojom/download_manager.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_DOWNLOAD_MANAGER_MOJOM_SHARED_H_
#define OWL_MOJOM_DOWNLOAD_MANAGER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/download_manager.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "owl/mojom/download_manager.mojom-data-view.h"




namespace std {

template <>
struct hash<::owl::mojom::DownloadState>
    : public mojo::internal::EnumHashImpl<::owl::mojom::DownloadState> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::DownloadState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::DownloadState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::DownloadState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::DownloadItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::DownloadItemDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::DownloadItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::guid(input)) in_guid = Traits::guid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->guid)::BaseType> guid_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_guid,
      guid_fragment);

    fragment->guid.Set(
        guid_fragment.is_null() ? nullptr : guid_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->guid.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null guid in DownloadItem struct");

    
    mojo::internal::Serialize<::owl::mojom::DownloadState>(
      Traits::state(input),
      &fragment->state);

    fragment->is_transient = Traits::is_transient(input);

    decltype(Traits::target_file_path(input)) in_target_file_path = Traits::target_file_path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->target_file_path)::BaseType> target_file_path_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_target_file_path,
      target_file_path_fragment);

    fragment->target_file_path.Set(
        target_file_path_fragment.is_null() ? nullptr : target_file_path_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->target_file_path.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null target_file_path in DownloadItem struct");

    fragment->percent_complete = Traits::percent_complete(input);

    fragment->total_bytes = Traits::total_bytes(input);

    fragment->received_bytes = Traits::received_bytes(input);

    fragment->current_speed = Traits::current_speed(input);

    decltype(Traits::time_remaining(input)) in_time_remaining = Traits::time_remaining(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->time_remaining)::BaseType> time_remaining_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_time_remaining,
      time_remaining_fragment);

    fragment->time_remaining.Set(
        time_remaining_fragment.is_null() ? nullptr : time_remaining_fragment.data());

    decltype(Traits::end_time(input)) in_end_time = Traits::end_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->end_time)::BaseType> end_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_end_time,
      end_time_fragment);

    fragment->end_time.Set(
        end_time_fragment.is_null() ? nullptr : end_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->end_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null end_time in DownloadItem struct");
  }

  static bool Deserialize(::owl::mojom::internal::DownloadItem_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::DownloadItemDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace owl::mojom {

inline void DownloadItemDataView::GetGuidDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->guid.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DownloadItemDataView::GetTargetFilePathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->target_file_path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void DownloadItemDataView::GetTimeRemainingDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->time_remaining.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void DownloadItemDataView::GetEndTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->end_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}



}  // owl::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::DownloadState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::DownloadState value);
};

} // namespace perfetto

#endif  // OWL_MOJOM_DOWNLOAD_MANAGER_MOJOM_SHARED_H_