// owl/mojom/download_manager.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_DOWNLOAD_MANAGER_MOJOM_SHARED_INTERNAL_H_
#define OWL_MOJOM_DOWNLOAD_MANAGER_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/message_fragment.h"
#include "mojo/public/mojom/base/file_path.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace owl::mojom {
namespace internal {
class DownloadItem_Data;

struct DownloadState_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class  DownloadItem_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> guid;
  int32_t state;
  uint8_t is_transient : 1;
  uint8_t pad2_[3];
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> target_file_path;
  int32_t percent_complete;
  uint8_t pad4_[4];
  int64_t total_bytes;
  int64_t received_bytes;
  int64_t current_speed;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> time_remaining;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> end_time;

 private:
  friend class mojo::internal::MessageFragment<DownloadItem_Data>;

  DownloadItem_Data();
  ~DownloadItem_Data() = delete;
};
static_assert(sizeof(DownloadItem_Data) == 80,
              "Bad sizeof(DownloadItem_Data)");
// Used by DownloadItem::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DownloadItem_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DownloadItem_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DownloadItem_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<DownloadItem_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DownloadItem_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // owl::mojom

#endif  // OWL_MOJOM_DOWNLOAD_MANAGER_MOJOM_SHARED_INTERNAL_H_