// owl/mojom/download_manager.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_DOWNLOAD_MANAGER_MOJOM_SEND_VALIDATION_H_
#define OWL_MOJOM_DOWNLOAD_MANAGER_MOJOM_SEND_VALIDATION_H_

#include "owl/mojom/download_manager.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"

#include "owl/mojom/download_manager.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::DownloadState, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::DownloadItemDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::DownloadItemDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::DownloadItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::guid(input)) in_guid = Traits::guid(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->guid)::BaseType> guid_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_guid,
        guid_fragment);

      fragment->guid.Set(
          guid_fragment.is_null() ? nullptr : guid_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->guid.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null guid in DownloadItem struct");

      
      mojo::internal::Serialize<::owl::mojom::DownloadState>(
        Traits::state(input),
        &fragment->state);

      fragment->is_transient = Traits::is_transient(input);

      decltype(Traits::target_file_path(input)) in_target_file_path = Traits::target_file_path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->target_file_path)::BaseType> target_file_path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_target_file_path,
        target_file_path_fragment);

      fragment->target_file_path.Set(
          target_file_path_fragment.is_null() ? nullptr : target_file_path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->target_file_path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null target_file_path in DownloadItem struct");

      fragment->percent_complete = Traits::percent_complete(input);

      fragment->total_bytes = Traits::total_bytes(input);

      fragment->received_bytes = Traits::received_bytes(input);

      fragment->current_speed = Traits::current_speed(input);

      decltype(Traits::time_remaining(input)) in_time_remaining = Traits::time_remaining(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->time_remaining)::BaseType> time_remaining_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_time_remaining,
        time_remaining_fragment);

      fragment->time_remaining.Set(
          time_remaining_fragment.is_null() ? nullptr : time_remaining_fragment.data());

      decltype(Traits::end_time(input)) in_end_time = Traits::end_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->end_time)::BaseType> end_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_end_time,
        end_time_fragment);

      fragment->end_time.Set(
          end_time_fragment.is_null() ? nullptr : end_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->end_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null end_time in DownloadItem struct");
  }
};

}  // namespace mojo::internal

#endif  // OWL_MOJOM_DOWNLOAD_MANAGER_MOJOM_SEND_VALIDATION_H_