// owl/mojom/download_manager.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_DOWNLOAD_MANAGER_MOJOM_DATA_VIEW_H_
#define OWL_MOJOM_DOWNLOAD_MANAGER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "owl/mojom/download_manager.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace owl::mojom {
class DownloadItemDataView;



}  // owl::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::owl::mojom::DownloadItemDataView> {
  using Data = ::owl::mojom::internal::DownloadItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace owl::mojom {


enum class DownloadState : int32_t {
  
  kInProgress = 0,
  
  kComplete = 1,
  
  kCancelled = 2,
  
  kInterrupted = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, DownloadState value);
inline bool IsKnownEnumValue(DownloadState value) {
  return internal::DownloadState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class DownloadManagerInterfaceBase {};

using DownloadManagerPtrDataView =
    mojo::InterfacePtrDataView<DownloadManagerInterfaceBase>;
using DownloadManagerRequestDataView =
    mojo::InterfaceRequestDataView<DownloadManagerInterfaceBase>;
using DownloadManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DownloadManagerInterfaceBase>;
using DownloadManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DownloadManagerInterfaceBase>;
class DownloadManagerClientInterfaceBase {};

using DownloadManagerClientPtrDataView =
    mojo::InterfacePtrDataView<DownloadManagerClientInterfaceBase>;
using DownloadManagerClientRequestDataView =
    mojo::InterfaceRequestDataView<DownloadManagerClientInterfaceBase>;
using DownloadManagerClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DownloadManagerClientInterfaceBase>;
using DownloadManagerClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DownloadManagerClientInterfaceBase>;


class DownloadItemDataView {
 public:
  DownloadItemDataView() = default;

  DownloadItemDataView(
      internal::DownloadItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetGuidDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGuid(UserType* output) {
    
    auto* pointer = data_->guid.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::owl::mojom::DownloadState>(
        data_value, output);
  }
  DownloadState state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::owl::mojom::DownloadState>(data_->state));
  }
  bool is_transient() const {
    return data_->is_transient;
  }
  inline void GetTargetFilePathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTargetFilePath(UserType* output) {
    
    auto* pointer = data_->target_file_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  int32_t percent_complete() const {
    return data_->percent_complete;
  }
  int64_t total_bytes() const {
    return data_->total_bytes;
  }
  int64_t received_bytes() const {
    return data_->received_bytes;
  }
  int64_t current_speed() const {
    return data_->current_speed;
  }
  inline void GetTimeRemainingDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeRemaining(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `time_remaining` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTimeRemaining` instead "
    "of `ReadTimeRemaining if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->time_remaining.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetEndTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEndTime(UserType* output) {
    
    auto* pointer = data_->end_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::DownloadItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // owl::mojom

#endif  // OWL_MOJOM_DOWNLOAD_MANAGER_MOJOM_DATA_VIEW_H_