// owl/mojom/context_menu_params.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_CONTEXT_MENU_PARAMS_MOJOM_SHARED_H_
#define OWL_MOJOM_CONTEXT_MENU_PARAMS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/context_menu_params.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/context_menu/context_menu.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"




#include "owl/mojom/context_menu_params.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::ContextMenuParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::ContextMenuParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::ContextMenuParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::page_url(input)) in_page_url = Traits::page_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->page_url)::BaseType> page_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_page_url,
      page_url_fragment);

    fragment->page_url.Set(
        page_url_fragment.is_null() ? nullptr : page_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->page_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null page_url in ContextMenuParams struct");

    decltype(Traits::frame_url(input)) in_frame_url = Traits::frame_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_url)::BaseType> frame_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_frame_url,
      frame_url_fragment);

    fragment->frame_url.Set(
        frame_url_fragment.is_null() ? nullptr : frame_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->frame_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_url in ContextMenuParams struct");

    fragment->is_subframe = Traits::is_subframe(input);

    decltype(Traits::location_in_web_contents_origin_upper_left(input)) in_location_in_web_contents_origin_upper_left = Traits::location_in_web_contents_origin_upper_left(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->location_in_web_contents_origin_upper_left)::BaseType> location_in_web_contents_origin_upper_left_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_location_in_web_contents_origin_upper_left,
      location_in_web_contents_origin_upper_left_fragment);

    fragment->location_in_web_contents_origin_upper_left.Set(
        location_in_web_contents_origin_upper_left_fragment.is_null() ? nullptr : location_in_web_contents_origin_upper_left_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->location_in_web_contents_origin_upper_left.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null location_in_web_contents_origin_upper_left in ContextMenuParams struct");

    decltype(Traits::link_url(input)) in_link_url = Traits::link_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->link_url)::BaseType> link_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_link_url,
      link_url_fragment);

    fragment->link_url.Set(
        link_url_fragment.is_null() ? nullptr : link_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->link_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null link_url in ContextMenuParams struct");

    decltype(Traits::link_text(input)) in_link_text = Traits::link_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->link_text)::BaseType> link_text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_link_text,
      link_text_fragment);

    fragment->link_text.Set(
        link_text_fragment.is_null() ? nullptr : link_text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->link_text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null link_text in ContextMenuParams struct");

    decltype(Traits::src_url(input)) in_src_url = Traits::src_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->src_url)::BaseType> src_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_src_url,
      src_url_fragment);

    fragment->src_url.Set(
        src_url_fragment.is_null() ? nullptr : src_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->src_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null src_url in ContextMenuParams struct");

    decltype(Traits::selection_text(input)) in_selection_text = Traits::selection_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->selection_text)::BaseType> selection_text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_selection_text,
      selection_text_fragment);

    fragment->selection_text.Set(
        selection_text_fragment.is_null() ? nullptr : selection_text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->selection_text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null selection_text in ContextMenuParams struct");

    fragment->x = Traits::x(input);

    fragment->y = Traits::y(input);

    
    mojo::internal::Serialize<::blink::mojom::ContextMenuDataMediaType>(
      Traits::media_type(input),
      &fragment->media_type);

    fragment->media_flags = Traits::media_flags(input);

    
    mojo::internal::Serialize<::network::mojom::ReferrerPolicy>(
      Traits::referrer_policy(input),
      &fragment->referrer_policy);
    fragment->render_frame_view_id_$flag = Traits::render_frame_view_id(input).has_value();
    if (Traits::render_frame_view_id(input).has_value()) {
      fragment->render_frame_view_id_$value = Traits::render_frame_view_id(input).value();
    }

    fragment->frame_routing_id = Traits::frame_routing_id(input);

    fragment->frame_process_id = Traits::frame_process_id(input);

    fragment->has_image_contents = Traits::has_image_contents(input);

    decltype(Traits::suggested_filename(input)) in_suggested_filename = Traits::suggested_filename(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->suggested_filename)::BaseType> suggested_filename_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_suggested_filename,
      suggested_filename_fragment);

    fragment->suggested_filename.Set(
        suggested_filename_fragment.is_null() ? nullptr : suggested_filename_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->suggested_filename.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null suggested_filename in ContextMenuParams struct");

    fragment->is_editable = Traits::is_editable(input);

    fragment->edit_flags = Traits::edit_flags(input);

    decltype(Traits::misspelled_word(input)) in_misspelled_word = Traits::misspelled_word(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->misspelled_word)::BaseType> misspelled_word_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_misspelled_word,
      misspelled_word_fragment);

    fragment->misspelled_word.Set(
        misspelled_word_fragment.is_null() ? nullptr : misspelled_word_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->misspelled_word.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null misspelled_word in ContextMenuParams struct");

    decltype(Traits::dictionary_suggestions(input)) in_dictionary_suggestions = Traits::dictionary_suggestions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dictionary_suggestions)::BaseType>
        dictionary_suggestions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& dictionary_suggestions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
      in_dictionary_suggestions,
      dictionary_suggestions_fragment,
      &dictionary_suggestions_validate_params);

    fragment->dictionary_suggestions.Set(
        dictionary_suggestions_fragment.is_null() ? nullptr : dictionary_suggestions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->dictionary_suggestions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dictionary_suggestions in ContextMenuParams struct");
  }

  static bool Deserialize(::owl::mojom::internal::ContextMenuParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::ContextMenuParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace owl::mojom {

inline void ContextMenuParamsDataView::GetPageUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->page_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ContextMenuParamsDataView::GetFrameUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->frame_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ContextMenuParamsDataView::GetLocationInWebContentsOriginUpperLeftDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->location_in_web_contents_origin_upper_left.Get();
  *output = ::gfx::mojom::PointDataView(pointer, message_);
}
inline void ContextMenuParamsDataView::GetLinkUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->link_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ContextMenuParamsDataView::GetLinkTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->link_text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ContextMenuParamsDataView::GetSrcUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->src_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ContextMenuParamsDataView::GetSelectionTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->selection_text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ContextMenuParamsDataView::GetSuggestedFilenameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->suggested_filename.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ContextMenuParamsDataView::GetMisspelledWordDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->misspelled_word.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ContextMenuParamsDataView::GetDictionarySuggestionsDataView(
    mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->dictionary_suggestions.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::String16DataView>(pointer, message_);
}



}  // owl::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // OWL_MOJOM_CONTEXT_MENU_PARAMS_MOJOM_SHARED_H_