// owl/mojom/chatgpt_frontend.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_CHATGPT_FRONTEND_MOJOM_TEST_UTILS_H_
#define OWL_MOJOM_CHATGPT_FRONTEND_MOJOM_TEST_UTILS_H_

#include "owl/mojom/chatgpt_frontend.mojom.h"


namespace owl::mojom {


class  ChatGPTFrontendHostInterceptorForTesting : public ChatGPTFrontendHost {
  virtual ChatGPTFrontendHost* GetForwardingInterface() = 0;
  void SetFrontend(::mojo::PendingRemote<ChatGPTFrontend> frontend) override;
  void GetAccountID(GetAccountIDCallback callback) override;
  void SendMessage(const std::string& name, const std::optional<std::string>& payload, SendMessageCallback callback) override;
  void ReceivedFirstToken(const std::string& server_conversation_id) override;
  void BindReceiver(const std::string& interface_name, ::mojo::ScopedMessagePipeHandle pipe) override;
};
class  ChatGPTFrontendHostAsyncWaiter {
 public:
  explicit ChatGPTFrontendHostAsyncWaiter(ChatGPTFrontendHost* proxy);

  ChatGPTFrontendHostAsyncWaiter(const ChatGPTFrontendHostAsyncWaiter&) = delete;
  ChatGPTFrontendHostAsyncWaiter& operator=(const ChatGPTFrontendHostAsyncWaiter&) = delete;

  ~ChatGPTFrontendHostAsyncWaiter();
  void GetAccountID(
      std::optional<std::string>* out_id);
  std::optional<std::string> GetAccountID();
  void SendMessage(
      const std::string& name, const std::optional<std::string>& payload, std::optional<std::string>* out_reply);
  std::optional<std::string> SendMessage(const std::string& name, const std::optional<std::string>& payload);

 private:
  ChatGPTFrontendHost* const proxy_;
};


class  ChatGPTFrontendInterceptorForTesting : public ChatGPTFrontend {
  virtual ChatGPTFrontend* GetForwardingInterface() = 0;
  void LogConsoleMessage(const std::string& message) override;
  void SendMessage(const std::string& name, const std::optional<std::string>& payload, SendMessageCallback callback) override;
  void BindReceiver(const std::string& interface_name, ::mojo::ScopedMessagePipeHandle pipe) override;
};
class  ChatGPTFrontendAsyncWaiter {
 public:
  explicit ChatGPTFrontendAsyncWaiter(ChatGPTFrontend* proxy);

  ChatGPTFrontendAsyncWaiter(const ChatGPTFrontendAsyncWaiter&) = delete;
  ChatGPTFrontendAsyncWaiter& operator=(const ChatGPTFrontendAsyncWaiter&) = delete;

  ~ChatGPTFrontendAsyncWaiter();
  void SendMessage(
      const std::string& name, const std::optional<std::string>& payload, std::optional<std::string>* out_reply);
  std::optional<std::string> SendMessage(const std::string& name, const std::optional<std::string>& payload);

 private:
  ChatGPTFrontend* const proxy_;
};




}  // owl::mojom

#endif  // OWL_MOJOM_CHATGPT_FRONTEND_MOJOM_TEST_UTILS_H_