// owl/mojom/bookmark_model.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_BOOKMARK_MODEL_MOJOM_H_
#define OWL_MOJOM_BOOKMARK_MODEL_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/bookmark_model.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/bookmark_model.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/bookmark_model.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/uuid.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class BookmarkModelProxy;

template <typename ImplRefTraits>
class BookmarkModelStub;

class BookmarkModelRequestValidator;
class BookmarkModelResponseValidator;


class BookmarkModel
    : public BookmarkModelInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.BookmarkModel";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BookmarkModelInterfaceBase;
  using Proxy_ = BookmarkModelProxy;

  template <typename ImplRefTraits>
  using Stub_ = BookmarkModelStub<ImplRefTraits>;

  using RequestValidator_ = BookmarkModelRequestValidator;
  using ResponseValidator_ = BookmarkModelResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetBookmarksMinVersion = 0,
    kAddFolderMinVersion = 0,
    kAddURLMinVersion = 0,
    kUpdateMinVersion = 0,
    kUpdateLastUsedTimeMinVersion = 0,
    kMoveMinVersion = 0,
    kRemoveMinVersion = 0,
    kImportBookmarksMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetBookmarks_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddFolder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Update_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateLastUsedTime_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Move_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Remove_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ImportBookmarks_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BookmarkModel() = default;

  using GetBookmarksCallback = base::OnceCallback<void(BookmarksPtr)>;
  using GetBookmarksMojoCallback = base::OnceCallback<void(BookmarksPtr)>;

  virtual void GetBookmarks(GetBookmarksCallback callback) = 0;

  using AddFolderCallback = base::OnceCallback<void(const std::optional<::base::Uuid>&)>;
  using AddFolderMojoCallback = base::OnceCallback<void(const std::optional<::base::Uuid>&)>;

  virtual void AddFolder(const ::std::u16string& title, const ::base::Uuid& parent_uuid, int32_t index, AddFolderCallback callback) = 0;

  using AddURLCallback = base::OnceCallback<void(const std::optional<::base::Uuid>&)>;
  using AddURLMojoCallback = base::OnceCallback<void(const std::optional<::base::Uuid>&)>;

  virtual void AddURL(const ::std::u16string& title, const ::GURL& url, const ::base::Uuid& parent_uuid, int32_t index, AddURLCallback callback) = 0;

  virtual void Update(const ::base::Uuid& uuid, const ::std::u16string& title, const std::optional<::GURL>& url) = 0;

  virtual void UpdateLastUsedTime(const ::base::Uuid& uuid) = 0;

  virtual void Move(const ::base::Uuid& uuid, const ::base::Uuid& parent_uuid, int32_t index) = 0;

  virtual void Remove(const ::base::Uuid& uuid) = 0;

  virtual void ImportBookmarks(std::vector<BookmarkNodePtr> bookmark_bar_bookmarks, std::vector<BookmarkNodePtr> other_bookmarks) = 0;
};

class BookmarkModelClientProxy;

template <typename ImplRefTraits>
class BookmarkModelClientStub;

class BookmarkModelClientRequestValidator;


class BookmarkModelClient
    : public BookmarkModelClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.BookmarkModelClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BookmarkModelClientInterfaceBase;
  using Proxy_ = BookmarkModelClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = BookmarkModelClientStub<ImplRefTraits>;

  using RequestValidator_ = BookmarkModelClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnBookmarkUpdatedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnBookmarkUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BookmarkModelClient() = default;

  virtual void OnBookmarkUpdated(BookmarkNodePtr node) = 0;
};



class  BookmarkModelProxy
    : public BookmarkModel {
 public:
  using InterfaceType = BookmarkModel;

  explicit BookmarkModelProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetBookmarks(GetBookmarksCallback callback) final;
  
  void AddFolder(const ::std::u16string& title, const ::base::Uuid& parent_uuid, int32_t index, AddFolderCallback callback) final;
  
  void AddURL(const ::std::u16string& title, const ::GURL& url, const ::base::Uuid& parent_uuid, int32_t index, AddURLCallback callback) final;
  
  void Update(const ::base::Uuid& uuid, const ::std::u16string& title, const std::optional<::GURL>& url) final;
  
  void UpdateLastUsedTime(const ::base::Uuid& uuid) final;
  
  void Move(const ::base::Uuid& uuid, const ::base::Uuid& parent_uuid, int32_t index) final;
  
  void Remove(const ::base::Uuid& uuid) final;
  
  void ImportBookmarks(std::vector<BookmarkNodePtr> bookmark_bar_bookmarks, std::vector<BookmarkNodePtr> other_bookmarks) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  BookmarkModelClientProxy
    : public BookmarkModelClient {
 public:
  using InterfaceType = BookmarkModelClient;

  explicit BookmarkModelClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnBookmarkUpdated(BookmarkNodePtr node) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  BookmarkModelStubDispatch {
 public:
  static bool Accept(BookmarkModel* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BookmarkModel* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BookmarkModel>>
class BookmarkModelStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BookmarkModelStub() = default;
  ~BookmarkModelStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BookmarkModelStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BookmarkModelStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  BookmarkModelClientStubDispatch {
 public:
  static bool Accept(BookmarkModelClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BookmarkModelClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BookmarkModelClient>>
class BookmarkModelClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BookmarkModelClientStub() = default;
  ~BookmarkModelClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BookmarkModelClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BookmarkModelClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  BookmarkModelRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BookmarkModelClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BookmarkModelResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  BookmarkNode {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BookmarkNode, T>::value>;
  using DataView = BookmarkNodeDataView;
  using Data_ = internal::BookmarkNode_Data;

  template <typename... Args>
  static BookmarkNodePtr New(Args&&... args) {
    return BookmarkNodePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BookmarkNodePtr From(const U& u) {
    return mojo::TypeConverter<BookmarkNodePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BookmarkNode>::Convert(*this);
  }


  BookmarkNode();

  BookmarkNode(
      int64_t id,
      const ::base::Uuid& uuid,
      BookmarkType type,
      const ::std::u16string& title,
      const std::optional<::GURL>& url,
      std::vector<BookmarkNodePtr> children);

BookmarkNode(const BookmarkNode&) = delete;
BookmarkNode& operator=(const BookmarkNode&) = delete;

  ~BookmarkNode();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BookmarkNodePtr>
  BookmarkNodePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BookmarkNode::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BookmarkNode::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BookmarkNode::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BookmarkNode::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BookmarkNode::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BookmarkNode::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BookmarkNode_UnserializedMessageContext<
            UserType, BookmarkNode::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BookmarkNode::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BookmarkNode::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BookmarkNode_UnserializedMessageContext<
            UserType, BookmarkNode::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BookmarkNode::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t id;
  
  ::base::Uuid uuid;
  
  BookmarkType type;
  
  ::std::u16string title;
  
  std::optional<::GURL> url;
  
  std::vector<BookmarkNodePtr> children;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BookmarkNode::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BookmarkNode::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BookmarkNode::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BookmarkNode::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Bookmarks {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Bookmarks, T>::value>;
  using DataView = BookmarksDataView;
  using Data_ = internal::Bookmarks_Data;

  template <typename... Args>
  static BookmarksPtr New(Args&&... args) {
    return BookmarksPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BookmarksPtr From(const U& u) {
    return mojo::TypeConverter<BookmarksPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Bookmarks>::Convert(*this);
  }


  Bookmarks();

  Bookmarks(
      BookmarkNodePtr bookmark_bar_node,
      BookmarkNodePtr other_node,
      BookmarkNodePtr mobile_node);

Bookmarks(const Bookmarks&) = delete;
Bookmarks& operator=(const Bookmarks&) = delete;

  ~Bookmarks();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BookmarksPtr>
  BookmarksPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Bookmarks::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Bookmarks::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Bookmarks::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Bookmarks::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Bookmarks::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Bookmarks::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Bookmarks_UnserializedMessageContext<
            UserType, Bookmarks::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Bookmarks::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Bookmarks::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Bookmarks_UnserializedMessageContext<
            UserType, Bookmarks::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Bookmarks::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  BookmarkNodePtr bookmark_bar_node;
  
  BookmarkNodePtr other_node;
  
  BookmarkNodePtr mobile_node;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Bookmarks::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Bookmarks::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Bookmarks::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Bookmarks::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
BookmarkNodePtr BookmarkNode::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(uuid),
      mojo::Clone(type),
      mojo::Clone(title),
      mojo::Clone(url),
      mojo::Clone(children)
  );
}

template <typename T, BookmarkNode::EnableIfSame<T>*>
bool BookmarkNode::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->uuid, other_struct.uuid))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->children, other_struct.children))
    return false;
  return true;
}

template <typename T, BookmarkNode::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.uuid < rhs.uuid)
    return true;
  if (rhs.uuid < lhs.uuid)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.children < rhs.children)
    return true;
  if (rhs.children < lhs.children)
    return false;
  return false;
}
template <typename StructPtrType>
BookmarksPtr Bookmarks::Clone() const {
  return New(
      mojo::Clone(bookmark_bar_node),
      mojo::Clone(other_node),
      mojo::Clone(mobile_node)
  );
}

template <typename T, Bookmarks::EnableIfSame<T>*>
bool Bookmarks::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bookmark_bar_node, other_struct.bookmark_bar_node))
    return false;
  if (!mojo::Equals(this->other_node, other_struct.other_node))
    return false;
  if (!mojo::Equals(this->mobile_node, other_struct.mobile_node))
    return false;
  return true;
}

template <typename T, Bookmarks::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bookmark_bar_node < rhs.bookmark_bar_node)
    return true;
  if (rhs.bookmark_bar_node < lhs.bookmark_bar_node)
    return false;
  if (lhs.other_node < rhs.other_node)
    return true;
  if (rhs.other_node < lhs.other_node)
    return false;
  if (lhs.mobile_node < rhs.mobile_node)
    return true;
  if (rhs.mobile_node < lhs.mobile_node)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::BookmarkNode::DataView,
                                         ::owl::mojom::BookmarkNodePtr> {
  static bool IsNull(const ::owl::mojom::BookmarkNodePtr& input) { return !input; }
  static void SetToNull(::owl::mojom::BookmarkNodePtr* output) { output->reset(); }

  static decltype(::owl::mojom::BookmarkNode::id) id(
      const ::owl::mojom::BookmarkNodePtr& input) {
    return input->id;
  }

  static const decltype(::owl::mojom::BookmarkNode::uuid)& uuid(
      const ::owl::mojom::BookmarkNodePtr& input) {
    return input->uuid;
  }

  static decltype(::owl::mojom::BookmarkNode::type) type(
      const ::owl::mojom::BookmarkNodePtr& input) {
    return input->type;
  }

  static const decltype(::owl::mojom::BookmarkNode::title)& title(
      const ::owl::mojom::BookmarkNodePtr& input) {
    return input->title;
  }

  static const decltype(::owl::mojom::BookmarkNode::url)& url(
      const ::owl::mojom::BookmarkNodePtr& input) {
    return input->url;
  }

  static const decltype(::owl::mojom::BookmarkNode::children)& children(
      const ::owl::mojom::BookmarkNodePtr& input) {
    return input->children;
  }

  static bool Read(::owl::mojom::BookmarkNode::DataView input, ::owl::mojom::BookmarkNodePtr* output);
};


template <>
struct  StructTraits<::owl::mojom::Bookmarks::DataView,
                                         ::owl::mojom::BookmarksPtr> {
  static bool IsNull(const ::owl::mojom::BookmarksPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::BookmarksPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::Bookmarks::bookmark_bar_node)& bookmark_bar_node(
      const ::owl::mojom::BookmarksPtr& input) {
    return input->bookmark_bar_node;
  }

  static const decltype(::owl::mojom::Bookmarks::other_node)& other_node(
      const ::owl::mojom::BookmarksPtr& input) {
    return input->other_node;
  }

  static const decltype(::owl::mojom::Bookmarks::mobile_node)& mobile_node(
      const ::owl::mojom::BookmarksPtr& input) {
    return input->mobile_node;
  }

  static bool Read(::owl::mojom::Bookmarks::DataView input, ::owl::mojom::BookmarksPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_BOOKMARK_MODEL_MOJOM_H_