// owl/mojom/bookmark_model.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/bookmark_model.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/bookmark_model.mojom-params-data.h"
#include "owl/mojom/bookmark_model.mojom-shared-message-ids.h"

#include "owl/mojom/bookmark_model.mojom-import-headers.h"
#include "owl/mojom/bookmark_model.mojom-test-utils.h"


namespace owl::mojom {
BookmarkNode::BookmarkNode()
    : id(),
      uuid(),
      type(),
      title(),
      url(),
      children() {}

BookmarkNode::BookmarkNode(
    int64_t id_in,
    const ::base::Uuid& uuid_in,
    BookmarkType type_in,
    const ::std::u16string& title_in,
    const std::optional<::GURL>& url_in,
    std::vector<BookmarkNodePtr> children_in)
    : id(std::move(id_in)),
      uuid(std::move(uuid_in)),
      type(std::move(type_in)),
      title(std::move(title_in)),
      url(std::move(url_in)),
      children(std::move(children_in)) {}

BookmarkNode::~BookmarkNode() = default;

void BookmarkNode::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uuid"), this->uuid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::Uuid&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BookmarkType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "children"), this->children,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<BookmarkNodePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BookmarkNode::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Bookmarks::Bookmarks()
    : bookmark_bar_node(),
      other_node(),
      mobile_node() {}

Bookmarks::Bookmarks(
    BookmarkNodePtr bookmark_bar_node_in,
    BookmarkNodePtr other_node_in,
    BookmarkNodePtr mobile_node_in)
    : bookmark_bar_node(std::move(bookmark_bar_node_in)),
      other_node(std::move(other_node_in)),
      mobile_node(std::move(mobile_node_in)) {}

Bookmarks::~Bookmarks() = default;

void Bookmarks::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bookmark_bar_node"), this->bookmark_bar_node,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BookmarkNodePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "other_node"), this->other_node,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BookmarkNodePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mobile_node"), this->mobile_node,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BookmarkNodePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Bookmarks::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

BookmarkModel::IPCStableHashFunction BookmarkModel::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BookmarkModel>(message.name())) {
    case messages::BookmarkModel::kGetBookmarks: {
      return &BookmarkModel::GetBookmarks_Sym::IPCStableHash;
    }
    case messages::BookmarkModel::kAddFolder: {
      return &BookmarkModel::AddFolder_Sym::IPCStableHash;
    }
    case messages::BookmarkModel::kAddURL: {
      return &BookmarkModel::AddURL_Sym::IPCStableHash;
    }
    case messages::BookmarkModel::kUpdate: {
      return &BookmarkModel::Update_Sym::IPCStableHash;
    }
    case messages::BookmarkModel::kUpdateLastUsedTime: {
      return &BookmarkModel::UpdateLastUsedTime_Sym::IPCStableHash;
    }
    case messages::BookmarkModel::kMove: {
      return &BookmarkModel::Move_Sym::IPCStableHash;
    }
    case messages::BookmarkModel::kRemove: {
      return &BookmarkModel::Remove_Sym::IPCStableHash;
    }
    case messages::BookmarkModel::kImportBookmarks: {
      return &BookmarkModel::ImportBookmarks_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BookmarkModel::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BookmarkModel>(message.name())) {
      case messages::BookmarkModel::kGetBookmarks:
            return "Receive owl::mojom::BookmarkModel::GetBookmarks";
      case messages::BookmarkModel::kAddFolder:
            return "Receive owl::mojom::BookmarkModel::AddFolder";
      case messages::BookmarkModel::kAddURL:
            return "Receive owl::mojom::BookmarkModel::AddURL";
      case messages::BookmarkModel::kUpdate:
            return "Receive owl::mojom::BookmarkModel::Update";
      case messages::BookmarkModel::kUpdateLastUsedTime:
            return "Receive owl::mojom::BookmarkModel::UpdateLastUsedTime";
      case messages::BookmarkModel::kMove:
            return "Receive owl::mojom::BookmarkModel::Move";
      case messages::BookmarkModel::kRemove:
            return "Receive owl::mojom::BookmarkModel::Remove";
      case messages::BookmarkModel::kImportBookmarks:
            return "Receive owl::mojom::BookmarkModel::ImportBookmarks";
    }
  } else {
    switch (static_cast<messages::BookmarkModel>(message.name())) {
      case messages::BookmarkModel::kGetBookmarks:
            return "Receive reply owl::mojom::BookmarkModel::GetBookmarks";
      case messages::BookmarkModel::kAddFolder:
            return "Receive reply owl::mojom::BookmarkModel::AddFolder";
      case messages::BookmarkModel::kAddURL:
            return "Receive reply owl::mojom::BookmarkModel::AddURL";
      case messages::BookmarkModel::kUpdate:
            return "Receive reply owl::mojom::BookmarkModel::Update";
      case messages::BookmarkModel::kUpdateLastUsedTime:
            return "Receive reply owl::mojom::BookmarkModel::UpdateLastUsedTime";
      case messages::BookmarkModel::kMove:
            return "Receive reply owl::mojom::BookmarkModel::Move";
      case messages::BookmarkModel::kRemove:
            return "Receive reply owl::mojom::BookmarkModel::Remove";
      case messages::BookmarkModel::kImportBookmarks:
            return "Receive reply owl::mojom::BookmarkModel::ImportBookmarks";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BookmarkModel::GetBookmarks_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc6c393ec;  // IPCStableHash for owl::mojom::BookmarkModel::GetBookmarks
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarkModel::AddFolder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6a8f00b1;  // IPCStableHash for owl::mojom::BookmarkModel::AddFolder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarkModel::AddURL_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4bab1fcf;  // IPCStableHash for owl::mojom::BookmarkModel::AddURL
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarkModel::Update_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4ce48a6a;  // IPCStableHash for owl::mojom::BookmarkModel::Update
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarkModel::UpdateLastUsedTime_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd0d9fe95;  // IPCStableHash for owl::mojom::BookmarkModel::UpdateLastUsedTime
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarkModel::Move_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4dd6a012;  // IPCStableHash for owl::mojom::BookmarkModel::Move
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarkModel::Remove_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x83d2309a;  // IPCStableHash for owl::mojom::BookmarkModel::Remove
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarkModel::ImportBookmarks_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x89ff18a5;  // IPCStableHash for owl::mojom::BookmarkModel::ImportBookmarks
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class BookmarkModel_GetBookmarks_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BookmarkModel_GetBookmarks_ForwardToCallback(
      BookmarkModel::GetBookmarksCallback callback
      ) : callback_(std::move(callback)) {
  }

  BookmarkModel_GetBookmarks_ForwardToCallback(const BookmarkModel_GetBookmarks_ForwardToCallback&) = delete;
  BookmarkModel_GetBookmarks_ForwardToCallback& operator=(const BookmarkModel_GetBookmarks_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BookmarkModel::GetBookmarksCallback callback_;
};

class BookmarkModel_AddFolder_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BookmarkModel_AddFolder_ForwardToCallback(
      BookmarkModel::AddFolderCallback callback
      ) : callback_(std::move(callback)) {
  }

  BookmarkModel_AddFolder_ForwardToCallback(const BookmarkModel_AddFolder_ForwardToCallback&) = delete;
  BookmarkModel_AddFolder_ForwardToCallback& operator=(const BookmarkModel_AddFolder_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BookmarkModel::AddFolderCallback callback_;
};

class BookmarkModel_AddURL_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BookmarkModel_AddURL_ForwardToCallback(
      BookmarkModel::AddURLCallback callback
      ) : callback_(std::move(callback)) {
  }

  BookmarkModel_AddURL_ForwardToCallback(const BookmarkModel_AddURL_ForwardToCallback&) = delete;
  BookmarkModel_AddURL_ForwardToCallback& operator=(const BookmarkModel_AddURL_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BookmarkModel::AddURLCallback callback_;
};

BookmarkModelProxy::BookmarkModelProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BookmarkModelProxy::GetBookmarks(
    GetBookmarksCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::BookmarkModel::GetBookmarks");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarkModel::kGetBookmarks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::BookmarkModel_GetBookmarks_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarkModel::Name_);
  message.set_method_name("GetBookmarks");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BookmarkModel_GetBookmarks_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BookmarkModelProxy::AddFolder(
    const ::std::u16string& in_title, const ::base::Uuid& in_parent_uuid, int32_t in_index, AddFolderCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::BookmarkModel::AddFolder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parent_uuid"), in_parent_uuid,
                        "<value of type const ::base::Uuid&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarkModel::kAddFolder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::BookmarkModel_AddFolder_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_title,
    title_fragment);

  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null title in BookmarkModel.AddFolder request");
  mojo::internal::MessageFragment<
      typename decltype(params->parent_uuid)::BaseType> parent_uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_parent_uuid,
    parent_uuid_fragment);

  params->parent_uuid.Set(
      parent_uuid_fragment.is_null() ? nullptr : parent_uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->parent_uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null parent_uuid in BookmarkModel.AddFolder request");

  params->index = in_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarkModel::Name_);
  message.set_method_name("AddFolder");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BookmarkModel_AddFolder_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BookmarkModelProxy::AddURL(
    const ::std::u16string& in_title, const ::GURL& in_url, const ::base::Uuid& in_parent_uuid, int32_t in_index, AddURLCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::BookmarkModel::AddURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parent_uuid"), in_parent_uuid,
                        "<value of type const ::base::Uuid&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarkModel::kAddURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::BookmarkModel_AddURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_title,
    title_fragment);

  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null title in BookmarkModel.AddURL request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in BookmarkModel.AddURL request");
  mojo::internal::MessageFragment<
      typename decltype(params->parent_uuid)::BaseType> parent_uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_parent_uuid,
    parent_uuid_fragment);

  params->parent_uuid.Set(
      parent_uuid_fragment.is_null() ? nullptr : parent_uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->parent_uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null parent_uuid in BookmarkModel.AddURL request");

  params->index = in_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarkModel::Name_);
  message.set_method_name("AddURL");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BookmarkModel_AddURL_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BookmarkModelProxy::Update(
    const ::base::Uuid& in_uuid, const ::std::u16string& in_title, const std::optional<::GURL>& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::BookmarkModel::Update", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const ::base::Uuid&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const std::optional<::GURL>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarkModel::kUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::BookmarkModel_Update_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in BookmarkModel.Update request");
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_title,
    title_fragment);

  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null title in BookmarkModel.Update request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarkModel::Name_);
  message.set_method_name("Update");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarkModelProxy::UpdateLastUsedTime(
    const ::base::Uuid& in_uuid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::BookmarkModel::UpdateLastUsedTime", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const ::base::Uuid&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarkModel::kUpdateLastUsedTime), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::BookmarkModel_UpdateLastUsedTime_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in BookmarkModel.UpdateLastUsedTime request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarkModel::Name_);
  message.set_method_name("UpdateLastUsedTime");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarkModelProxy::Move(
    const ::base::Uuid& in_uuid, const ::base::Uuid& in_parent_uuid, int32_t in_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::BookmarkModel::Move", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const ::base::Uuid&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parent_uuid"), in_parent_uuid,
                        "<value of type const ::base::Uuid&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarkModel::kMove), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::BookmarkModel_Move_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in BookmarkModel.Move request");
  mojo::internal::MessageFragment<
      typename decltype(params->parent_uuid)::BaseType> parent_uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_parent_uuid,
    parent_uuid_fragment);

  params->parent_uuid.Set(
      parent_uuid_fragment.is_null() ? nullptr : parent_uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->parent_uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null parent_uuid in BookmarkModel.Move request");

  params->index = in_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarkModel::Name_);
  message.set_method_name("Move");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarkModelProxy::Remove(
    const ::base::Uuid& in_uuid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::BookmarkModel::Remove", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const ::base::Uuid&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarkModel::kRemove), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::BookmarkModel_Remove_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in BookmarkModel.Remove request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarkModel::Name_);
  message.set_method_name("Remove");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarkModelProxy::ImportBookmarks(
    std::vector<BookmarkNodePtr> in_bookmark_bar_bookmarks, std::vector<BookmarkNodePtr> in_other_bookmarks) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::BookmarkModel::ImportBookmarks", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bookmark_bar_bookmarks"), in_bookmark_bar_bookmarks,
                        "<value of type std::vector<BookmarkNodePtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("other_bookmarks"), in_other_bookmarks,
                        "<value of type std::vector<BookmarkNodePtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarkModel::kImportBookmarks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::BookmarkModel_ImportBookmarks_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bookmark_bar_bookmarks)::BaseType>
      bookmark_bar_bookmarks_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& bookmark_bar_bookmarks_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::BookmarkNodeDataView>>(
    in_bookmark_bar_bookmarks,
    bookmark_bar_bookmarks_fragment,
    &bookmark_bar_bookmarks_validate_params);

  params->bookmark_bar_bookmarks.Set(
      bookmark_bar_bookmarks_fragment.is_null() ? nullptr : bookmark_bar_bookmarks_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bookmark_bar_bookmarks.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bookmark_bar_bookmarks in BookmarkModel.ImportBookmarks request");
  mojo::internal::MessageFragment<
      typename decltype(params->other_bookmarks)::BaseType>
      other_bookmarks_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& other_bookmarks_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::BookmarkNodeDataView>>(
    in_other_bookmarks,
    other_bookmarks_fragment,
    &other_bookmarks_validate_params);

  params->other_bookmarks.Set(
      other_bookmarks_fragment.is_null() ? nullptr : other_bookmarks_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->other_bookmarks.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null other_bookmarks in BookmarkModel.ImportBookmarks request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarkModel::Name_);
  message.set_method_name("ImportBookmarks");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class BookmarkModel_GetBookmarks_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BookmarkModel::GetBookmarksCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BookmarkModel_GetBookmarks_ProxyToResponder> proxy(
        new BookmarkModel_GetBookmarks_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BookmarkModel_GetBookmarks_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BookmarkModel_GetBookmarks_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BookmarkModel_GetBookmarks_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BookmarkModel::GetBookmarksCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      BookmarksPtr in_bookmarks);
};

bool BookmarkModel_GetBookmarks_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BookmarkModel_GetBookmarks_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BookmarkModel_GetBookmarks_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BookmarkModel.0
  bool success = true;
  BookmarksPtr p_bookmarks{};
  BookmarkModel_GetBookmarks_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBookmarks(&p_bookmarks))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BookmarkModel::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_bookmarks));
  }
  return true;
}

void BookmarkModel_GetBookmarks_ProxyToResponder::Run(
    BookmarksPtr in_bookmarks) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::BookmarkModel::GetBookmarks", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bookmarks"), in_bookmarks,
                        "<value of type BookmarksPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarkModel::kGetBookmarks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::BookmarkModel_GetBookmarks_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bookmarks)::BaseType> bookmarks_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::BookmarksDataView>(
    in_bookmarks,
    bookmarks_fragment);

  params->bookmarks.Set(
      bookmarks_fragment.is_null() ? nullptr : bookmarks_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bookmarks.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bookmarks in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarkModel::Name_);
  message.set_method_name("GetBookmarks");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BookmarkModel_AddFolder_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BookmarkModel::AddFolderCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BookmarkModel_AddFolder_ProxyToResponder> proxy(
        new BookmarkModel_AddFolder_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BookmarkModel_AddFolder_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BookmarkModel_AddFolder_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BookmarkModel_AddFolder_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BookmarkModel::AddFolderCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::base::Uuid>& in_uuid);
};

bool BookmarkModel_AddFolder_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BookmarkModel_AddFolder_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BookmarkModel_AddFolder_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BookmarkModel.1
  bool success = true;
  std::optional<::base::Uuid> p_uuid{};
  BookmarkModel_AddFolder_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUuid(&p_uuid))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BookmarkModel::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_uuid));
  }
  return true;
}

void BookmarkModel_AddFolder_ProxyToResponder::Run(
    const std::optional<::base::Uuid>& in_uuid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::BookmarkModel::AddFolder", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const std::optional<::base::Uuid>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarkModel::kAddFolder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::BookmarkModel_AddFolder_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarkModel::Name_);
  message.set_method_name("AddFolder");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BookmarkModel_AddURL_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BookmarkModel::AddURLCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BookmarkModel_AddURL_ProxyToResponder> proxy(
        new BookmarkModel_AddURL_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BookmarkModel_AddURL_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BookmarkModel_AddURL_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BookmarkModel_AddURL_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BookmarkModel::AddURLCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::base::Uuid>& in_uuid);
};

bool BookmarkModel_AddURL_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BookmarkModel_AddURL_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BookmarkModel_AddURL_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BookmarkModel.2
  bool success = true;
  std::optional<::base::Uuid> p_uuid{};
  BookmarkModel_AddURL_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUuid(&p_uuid))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BookmarkModel::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_uuid));
  }
  return true;
}

void BookmarkModel_AddURL_ProxyToResponder::Run(
    const std::optional<::base::Uuid>& in_uuid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::BookmarkModel::AddURL", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const std::optional<::base::Uuid>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarkModel::kAddURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::BookmarkModel_AddURL_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarkModel::Name_);
  message.set_method_name("AddURL");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BookmarkModelStubDispatch::Accept(
    BookmarkModel* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BookmarkModel>(message->header()->name)) {
    case messages::BookmarkModel::kGetBookmarks: {
      break;
    }
    case messages::BookmarkModel::kAddFolder: {
      break;
    }
    case messages::BookmarkModel::kAddURL: {
      break;
    }
    case messages::BookmarkModel::kUpdate: {
      DCHECK(message->is_serialized());
      internal::BookmarkModel_Update_Params_Data* params =
          reinterpret_cast<internal::BookmarkModel_Update_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarkModel.3
      bool success = true;
      ::base::Uuid p_uuid{};
      ::std::u16string p_title{};
      std::optional<::GURL> p_url{};
      BookmarkModel_Update_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarkModel::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Update(        
        std::move(p_uuid), 
        std::move(p_title), 
        std::move(p_url));
      return true;
    }
    case messages::BookmarkModel::kUpdateLastUsedTime: {
      DCHECK(message->is_serialized());
      internal::BookmarkModel_UpdateLastUsedTime_Params_Data* params =
          reinterpret_cast<internal::BookmarkModel_UpdateLastUsedTime_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarkModel.4
      bool success = true;
      ::base::Uuid p_uuid{};
      BookmarkModel_UpdateLastUsedTime_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarkModel::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateLastUsedTime(        
        std::move(p_uuid));
      return true;
    }
    case messages::BookmarkModel::kMove: {
      DCHECK(message->is_serialized());
      internal::BookmarkModel_Move_Params_Data* params =
          reinterpret_cast<internal::BookmarkModel_Move_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarkModel.5
      bool success = true;
      ::base::Uuid p_uuid{};
      ::base::Uuid p_parent_uuid{};
      int32_t p_index{};
      BookmarkModel_Move_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (success && !input_data_view.ReadParentUuid(&p_parent_uuid))
        success = false;
      if (success)
        p_index = input_data_view.index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarkModel::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Move(        
        std::move(p_uuid), 
        std::move(p_parent_uuid), 
        std::move(p_index));
      return true;
    }
    case messages::BookmarkModel::kRemove: {
      DCHECK(message->is_serialized());
      internal::BookmarkModel_Remove_Params_Data* params =
          reinterpret_cast<internal::BookmarkModel_Remove_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarkModel.6
      bool success = true;
      ::base::Uuid p_uuid{};
      BookmarkModel_Remove_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarkModel::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Remove(        
        std::move(p_uuid));
      return true;
    }
    case messages::BookmarkModel::kImportBookmarks: {
      DCHECK(message->is_serialized());
      internal::BookmarkModel_ImportBookmarks_Params_Data* params =
          reinterpret_cast<internal::BookmarkModel_ImportBookmarks_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarkModel.7
      bool success = true;
      std::vector<BookmarkNodePtr> p_bookmark_bar_bookmarks{};
      std::vector<BookmarkNodePtr> p_other_bookmarks{};
      BookmarkModel_ImportBookmarks_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBookmarkBarBookmarks(&p_bookmark_bar_bookmarks))
        success = false;
      if (success && !input_data_view.ReadOtherBookmarks(&p_other_bookmarks))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarkModel::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImportBookmarks(        
        std::move(p_bookmark_bar_bookmarks), 
        std::move(p_other_bookmarks));
      return true;
    }
  }
  return false;
}

// static
bool BookmarkModelStubDispatch::AcceptWithResponder(
    BookmarkModel* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BookmarkModel>(message->header()->name)) {
    case messages::BookmarkModel::kGetBookmarks: {
      internal::BookmarkModel_GetBookmarks_Params_Data* params =
          reinterpret_cast<
              internal::BookmarkModel_GetBookmarks_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BookmarkModel.0
      bool success = true;
      BookmarkModel_GetBookmarks_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarkModel::Name_, 0, false);
        return false;
      }
      auto callback =
          BookmarkModel_GetBookmarks_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetBookmarks(std::move(callback));
      return true;
    }
    case messages::BookmarkModel::kAddFolder: {
      internal::BookmarkModel_AddFolder_Params_Data* params =
          reinterpret_cast<
              internal::BookmarkModel_AddFolder_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BookmarkModel.1
      bool success = true;
      ::std::u16string p_title{};
      ::base::Uuid p_parent_uuid{};
      int32_t p_index{};
      BookmarkModel_AddFolder_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (success && !input_data_view.ReadParentUuid(&p_parent_uuid))
        success = false;
      if (success)
        p_index = input_data_view.index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarkModel::Name_, 1, false);
        return false;
      }
      auto callback =
          BookmarkModel_AddFolder_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddFolder(        
        std::move(p_title), 
        std::move(p_parent_uuid), 
        std::move(p_index), std::move(callback));
      return true;
    }
    case messages::BookmarkModel::kAddURL: {
      internal::BookmarkModel_AddURL_Params_Data* params =
          reinterpret_cast<
              internal::BookmarkModel_AddURL_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BookmarkModel.2
      bool success = true;
      ::std::u16string p_title{};
      ::GURL p_url{};
      ::base::Uuid p_parent_uuid{};
      int32_t p_index{};
      BookmarkModel_AddURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadParentUuid(&p_parent_uuid))
        success = false;
      if (success)
        p_index = input_data_view.index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarkModel::Name_, 2, false);
        return false;
      }
      auto callback =
          BookmarkModel_AddURL_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddURL(        
        std::move(p_title), 
        std::move(p_url), 
        std::move(p_parent_uuid), 
        std::move(p_index), std::move(callback));
      return true;
    }
    case messages::BookmarkModel::kUpdate: {
      break;
    }
    case messages::BookmarkModel::kUpdateLastUsedTime: {
      break;
    }
    case messages::BookmarkModel::kMove: {
      break;
    }
    case messages::BookmarkModel::kRemove: {
      break;
    }
    case messages::BookmarkModel::kImportBookmarks: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBookmarkModelValidationInfo[] = {
    { &internal::BookmarkModel_GetBookmarks_Params_Data::Validate,
     &internal::BookmarkModel_GetBookmarks_ResponseParams_Data::Validate},
    { &internal::BookmarkModel_AddFolder_Params_Data::Validate,
     &internal::BookmarkModel_AddFolder_ResponseParams_Data::Validate},
    { &internal::BookmarkModel_AddURL_Params_Data::Validate,
     &internal::BookmarkModel_AddURL_ResponseParams_Data::Validate},
    { &internal::BookmarkModel_Update_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarkModel_UpdateLastUsedTime_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarkModel_Move_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarkModel_Remove_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarkModel_ImportBookmarks_Params_Data::Validate,
     nullptr /* no response */},
};

bool BookmarkModelRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::BookmarkModel::Name_,
    kBookmarkModelValidationInfo);
}

bool BookmarkModelResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::owl::mojom::BookmarkModel::Name_,
    kBookmarkModelValidationInfo);
}
// The declaration includes the definition on other builds.

BookmarkModelClient::IPCStableHashFunction BookmarkModelClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BookmarkModelClient>(message.name())) {
    case messages::BookmarkModelClient::kOnBookmarkUpdated: {
      return &BookmarkModelClient::OnBookmarkUpdated_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BookmarkModelClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BookmarkModelClient>(message.name())) {
      case messages::BookmarkModelClient::kOnBookmarkUpdated:
            return "Receive owl::mojom::BookmarkModelClient::OnBookmarkUpdated";
    }
  } else {
    switch (static_cast<messages::BookmarkModelClient>(message.name())) {
      case messages::BookmarkModelClient::kOnBookmarkUpdated:
            return "Receive reply owl::mojom::BookmarkModelClient::OnBookmarkUpdated";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BookmarkModelClient::OnBookmarkUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x22c1e9a3;  // IPCStableHash for owl::mojom::BookmarkModelClient::OnBookmarkUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

BookmarkModelClientProxy::BookmarkModelClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BookmarkModelClientProxy::OnBookmarkUpdated(
    BookmarkNodePtr in_node) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::BookmarkModelClient::OnBookmarkUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("node"), in_node,
                        "<value of type BookmarkNodePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarkModelClient::kOnBookmarkUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::BookmarkModelClient_OnBookmarkUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->node)::BaseType> node_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::BookmarkNodeDataView>(
    in_node,
    node_fragment);

  params->node.Set(
      node_fragment.is_null() ? nullptr : node_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->node.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null node in BookmarkModelClient.OnBookmarkUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarkModelClient::Name_);
  message.set_method_name("OnBookmarkUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool BookmarkModelClientStubDispatch::Accept(
    BookmarkModelClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BookmarkModelClient>(message->header()->name)) {
    case messages::BookmarkModelClient::kOnBookmarkUpdated: {
      DCHECK(message->is_serialized());
      internal::BookmarkModelClient_OnBookmarkUpdated_Params_Data* params =
          reinterpret_cast<internal::BookmarkModelClient_OnBookmarkUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarkModelClient.0
      bool success = true;
      BookmarkNodePtr p_node{};
      BookmarkModelClient_OnBookmarkUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNode(&p_node))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarkModelClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBookmarkUpdated(        
        std::move(p_node));
      return true;
    }
  }
  return false;
}

// static
bool BookmarkModelClientStubDispatch::AcceptWithResponder(
    BookmarkModelClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BookmarkModelClient>(message->header()->name)) {
    case messages::BookmarkModelClient::kOnBookmarkUpdated: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBookmarkModelClientValidationInfo[] = {
    { &internal::BookmarkModelClient_OnBookmarkUpdated_Params_Data::Validate,
     nullptr /* no response */},
};

bool BookmarkModelClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::BookmarkModelClient::Name_,
    kBookmarkModelClientValidationInfo);
}



}  // owl::mojom


namespace mojo {


// static
bool StructTraits<::owl::mojom::BookmarkNode::DataView, ::owl::mojom::BookmarkNodePtr>::Read(
    ::owl::mojom::BookmarkNode::DataView input,
    ::owl::mojom::BookmarkNodePtr* output) {
  bool success = true;
  ::owl::mojom::BookmarkNodePtr result(::owl::mojom::BookmarkNode::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadUuid(&result->uuid))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadChildren(&result->children))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::Bookmarks::DataView, ::owl::mojom::BookmarksPtr>::Read(
    ::owl::mojom::Bookmarks::DataView input,
    ::owl::mojom::BookmarksPtr* output) {
  bool success = true;
  ::owl::mojom::BookmarksPtr result(::owl::mojom::Bookmarks::New());
  
      if (success && !input.ReadBookmarkBarNode(&result->bookmark_bar_node))
        success = false;
      if (success && !input.ReadOtherNode(&result->other_node))
        success = false;
      if (success && !input.ReadMobileNode(&result->mobile_node))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void BookmarkModelInterceptorForTesting::GetBookmarks(GetBookmarksCallback callback) {
  GetForwardingInterface()->GetBookmarks(std::move(callback));
}
void BookmarkModelInterceptorForTesting::AddFolder(const ::std::u16string& title, const ::base::Uuid& parent_uuid, int32_t index, AddFolderCallback callback) {
  GetForwardingInterface()->AddFolder(
    std::move(title)
    , 
    std::move(parent_uuid)
    , 
    std::move(index)
    , std::move(callback));
}
void BookmarkModelInterceptorForTesting::AddURL(const ::std::u16string& title, const ::GURL& url, const ::base::Uuid& parent_uuid, int32_t index, AddURLCallback callback) {
  GetForwardingInterface()->AddURL(
    std::move(title)
    , 
    std::move(url)
    , 
    std::move(parent_uuid)
    , 
    std::move(index)
    , std::move(callback));
}
void BookmarkModelInterceptorForTesting::Update(const ::base::Uuid& uuid, const ::std::u16string& title, const std::optional<::GURL>& url) {
  GetForwardingInterface()->Update(
    std::move(uuid)
    , 
    std::move(title)
    , 
    std::move(url)
    );
}
void BookmarkModelInterceptorForTesting::UpdateLastUsedTime(const ::base::Uuid& uuid) {
  GetForwardingInterface()->UpdateLastUsedTime(
    std::move(uuid)
    );
}
void BookmarkModelInterceptorForTesting::Move(const ::base::Uuid& uuid, const ::base::Uuid& parent_uuid, int32_t index) {
  GetForwardingInterface()->Move(
    std::move(uuid)
    , 
    std::move(parent_uuid)
    , 
    std::move(index)
    );
}
void BookmarkModelInterceptorForTesting::Remove(const ::base::Uuid& uuid) {
  GetForwardingInterface()->Remove(
    std::move(uuid)
    );
}
void BookmarkModelInterceptorForTesting::ImportBookmarks(std::vector<BookmarkNodePtr> bookmark_bar_bookmarks, std::vector<BookmarkNodePtr> other_bookmarks) {
  GetForwardingInterface()->ImportBookmarks(
    std::move(bookmark_bar_bookmarks)
    , 
    std::move(other_bookmarks)
    );
}
BookmarkModelAsyncWaiter::BookmarkModelAsyncWaiter(
    BookmarkModel* proxy) : proxy_(proxy) {}

BookmarkModelAsyncWaiter::~BookmarkModelAsyncWaiter() = default;


void BookmarkModelAsyncWaiter::GetBookmarks(
    BookmarksPtr* out_bookmarks) {
  base::RunLoop loop;
  proxy_->GetBookmarks(
      base::BindOnce(
          [](base::RunLoop* loop,
             BookmarksPtr* out_bookmarks
,
             BookmarksPtr bookmarks) {*out_bookmarks = std::move(bookmarks);
            loop->Quit();
          },
          &loop,
          out_bookmarks));
  loop.Run();
}

BookmarksPtr BookmarkModelAsyncWaiter::GetBookmarks(
    ) {
  BookmarksPtr async_wait_result;
  GetBookmarks(&async_wait_result);
  return async_wait_result;
}

void BookmarkModelAsyncWaiter::AddFolder(
    const ::std::u16string& title, const ::base::Uuid& parent_uuid, int32_t index, std::optional<::base::Uuid>* out_uuid) {
  base::RunLoop loop;
  proxy_->AddFolder(
      std::move(title),
      std::move(parent_uuid),
      std::move(index),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::base::Uuid>* out_uuid
,
             const std::optional<::base::Uuid>& uuid) {*out_uuid = std::move(uuid);
            loop->Quit();
          },
          &loop,
          out_uuid));
  loop.Run();
}

std::optional<::base::Uuid> BookmarkModelAsyncWaiter::AddFolder(
    const ::std::u16string& title, const ::base::Uuid& parent_uuid, int32_t index) {
  std::optional<::base::Uuid> async_wait_result;
  AddFolder(std::move(title),std::move(parent_uuid),std::move(index),&async_wait_result);
  return async_wait_result;
}

void BookmarkModelAsyncWaiter::AddURL(
    const ::std::u16string& title, const ::GURL& url, const ::base::Uuid& parent_uuid, int32_t index, std::optional<::base::Uuid>* out_uuid) {
  base::RunLoop loop;
  proxy_->AddURL(
      std::move(title),
      std::move(url),
      std::move(parent_uuid),
      std::move(index),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::base::Uuid>* out_uuid
,
             const std::optional<::base::Uuid>& uuid) {*out_uuid = std::move(uuid);
            loop->Quit();
          },
          &loop,
          out_uuid));
  loop.Run();
}

std::optional<::base::Uuid> BookmarkModelAsyncWaiter::AddURL(
    const ::std::u16string& title, const ::GURL& url, const ::base::Uuid& parent_uuid, int32_t index) {
  std::optional<::base::Uuid> async_wait_result;
  AddURL(std::move(title),std::move(url),std::move(parent_uuid),std::move(index),&async_wait_result);
  return async_wait_result;
}




void BookmarkModelClientInterceptorForTesting::OnBookmarkUpdated(BookmarkNodePtr node) {
  GetForwardingInterface()->OnBookmarkUpdated(
    std::move(node)
    );
}
BookmarkModelClientAsyncWaiter::BookmarkModelClientAsyncWaiter(
    BookmarkModelClient* proxy) : proxy_(proxy) {}

BookmarkModelClientAsyncWaiter::~BookmarkModelClientAsyncWaiter() = default;







}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif