// owl/mojom/autofill_popup.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_AUTOFILL_POPUP_MOJOM_H_
#define OWL_MOJOM_AUTOFILL_POPUP_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/autofill_popup.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/autofill_popup.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/autofill_popup.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "ui/gfx/image/mojom/image.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class AutofillPopupProxy;

template <typename ImplRefTraits>
class AutofillPopupStub;

class AutofillPopupRequestValidator;


class AutofillPopup
    : public AutofillPopupInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.AutofillPopup";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AutofillPopupInterfaceBase;
  using Proxy_ = AutofillPopupProxy;

  template <typename ImplRefTraits>
  using Stub_ = AutofillPopupStub<ImplRefTraits>;

  using RequestValidator_ = AutofillPopupRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCloseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Close_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AutofillPopup() = default;

  virtual void Close() = 0;
};

class AutofillPopupClientProxy;

template <typename ImplRefTraits>
class AutofillPopupClientStub;

class AutofillPopupClientRequestValidator;


class AutofillPopupClient
    : public AutofillPopupClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.AutofillPopupClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AutofillPopupClientInterfaceBase;
  using Proxy_ = AutofillPopupClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = AutofillPopupClientStub<ImplRefTraits>;

  using RequestValidator_ = AutofillPopupClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAcceptMinVersion = 0,
    kSelectMinVersion = 0,
    kRemoveMinVersion = 0,
    kDismissMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Accept_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Select_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Remove_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Dismiss_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AutofillPopupClient() = default;

  virtual void Accept(int32_t index) = 0;

  virtual void Select(int32_t index) = 0;

  virtual void Remove(int32_t index) = 0;

  virtual void Dismiss() = 0;
};



class  AutofillPopupProxy
    : public AutofillPopup {
 public:
  using InterfaceType = AutofillPopup;

  explicit AutofillPopupProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Close() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  AutofillPopupClientProxy
    : public AutofillPopupClient {
 public:
  using InterfaceType = AutofillPopupClient;

  explicit AutofillPopupClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Accept(int32_t index) final;
  
  void Select(int32_t index) final;
  
  void Remove(int32_t index) final;
  
  void Dismiss() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  AutofillPopupStubDispatch {
 public:
  static bool Accept(AutofillPopup* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AutofillPopup* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AutofillPopup>>
class AutofillPopupStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AutofillPopupStub() = default;
  ~AutofillPopupStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AutofillPopupStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AutofillPopupStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AutofillPopupClientStubDispatch {
 public:
  static bool Accept(AutofillPopupClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AutofillPopupClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AutofillPopupClient>>
class AutofillPopupClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AutofillPopupClientStub() = default;
  ~AutofillPopupClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AutofillPopupClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AutofillPopupClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AutofillPopupRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AutofillPopupClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  AutofillSuggestionCustomIcon {
 public:
  using DataView = AutofillSuggestionCustomIconDataView;
  using Data_ = internal::AutofillSuggestionCustomIcon_Data;
  using Tag = Data_::AutofillSuggestionCustomIcon_Tag;

  template <typename... Args>
  static AutofillSuggestionCustomIconPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |image|.
  static AutofillSuggestionCustomIconPtr NewImage(
      const ::gfx::ImageSkia& value);
  // Construct an instance holding |url|.
  static AutofillSuggestionCustomIconPtr NewUrl(
      const ::GURL& value);
  // Construct an instance holding |monogram|.
  static AutofillSuggestionCustomIconPtr NewMonogram(
      const ::std::u16string& value);

  template <typename U>
  static AutofillSuggestionCustomIconPtr From(const U& u) {
    return mojo::TypeConverter<AutofillSuggestionCustomIconPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AutofillSuggestionCustomIcon>::Convert(*this);
  }
  ~AutofillSuggestionCustomIcon();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  AutofillSuggestionCustomIcon(const AutofillSuggestionCustomIcon& other) = delete;
  AutofillSuggestionCustomIcon& operator=(const AutofillSuggestionCustomIcon& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = AutofillSuggestionCustomIconPtr>
  AutofillSuggestionCustomIconPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, AutofillSuggestionCustomIcon>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, AutofillSuggestionCustomIcon>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_image() const { return tag_ == Tag::kImage; }
  const ::gfx::ImageSkia& get_image() const {
    CHECK(tag_ == Tag::kImage);
    return data_.image;
  }
  ::gfx::ImageSkia& get_image() {
    CHECK(tag_ == Tag::kImage);
    return data_.image;
  }
  void set_image(const ::gfx::ImageSkia& image);

  bool is_url() const { return tag_ == Tag::kUrl; }
  const ::GURL& get_url() const {
    CHECK(tag_ == Tag::kUrl);
    return data_.url;
  }
  ::GURL& get_url() {
    CHECK(tag_ == Tag::kUrl);
    return data_.url;
  }
  void set_url(const ::GURL& url);

  bool is_monogram() const { return tag_ == Tag::kMonogram; }
  const ::std::u16string& get_monogram() const {
    CHECK(tag_ == Tag::kMonogram);
    return data_.monogram;
  }
  ::std::u16string& get_monogram() {
    CHECK(tag_ == Tag::kMonogram);
    return data_.monogram;
  }
  void set_monogram(const ::std::u16string& monogram);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AutofillSuggestionCustomIcon::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<AutofillSuggestionCustomIcon::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kImage)>,
        const ::gfx::ImageSkia& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kUrl)>,
        const ::GURL& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kMonogram)>,
        const ::std::u16string& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::gfx::ImageSkia image;
    ::GURL url;
    ::std::u16string monogram;
  };

  AutofillSuggestionCustomIcon(
      std::in_place_index_t<static_cast<size_t>(Tag::kImage)>,
      const ::gfx::ImageSkia& value);
  AutofillSuggestionCustomIcon(
      std::in_place_index_t<static_cast<size_t>(Tag::kUrl)>,
      const ::GURL& value);
  AutofillSuggestionCustomIcon(
      std::in_place_index_t<static_cast<size_t>(Tag::kMonogram)>,
      const ::std::u16string& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  AutofillSuggestionText {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AutofillSuggestionText, T>::value>;
  using DataView = AutofillSuggestionTextDataView;
  using Data_ = internal::AutofillSuggestionText_Data;

  template <typename... Args>
  static AutofillSuggestionTextPtr New(Args&&... args) {
    return AutofillSuggestionTextPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AutofillSuggestionTextPtr From(const U& u) {
    return mojo::TypeConverter<AutofillSuggestionTextPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AutofillSuggestionText>::Convert(*this);
  }


  AutofillSuggestionText();

  AutofillSuggestionText(
      const ::std::u16string& value,
      bool is_primary,
      bool should_truncate);


  ~AutofillSuggestionText();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AutofillSuggestionTextPtr>
  AutofillSuggestionTextPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AutofillSuggestionText::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AutofillSuggestionText::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AutofillSuggestionText::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AutofillSuggestionText::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AutofillSuggestionText::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AutofillSuggestionText::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AutofillSuggestionText_UnserializedMessageContext<
            UserType, AutofillSuggestionText::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AutofillSuggestionText::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AutofillSuggestionText::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AutofillSuggestionText_UnserializedMessageContext<
            UserType, AutofillSuggestionText::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AutofillSuggestionText::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string value;
  
  bool is_primary;
  
  bool should_truncate;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AutofillSuggestionText::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AutofillSuggestionText::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AutofillSuggestionText::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AutofillSuggestionText::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AutofillSuggestion {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AutofillSuggestion, T>::value>;
  using DataView = AutofillSuggestionDataView;
  using Data_ = internal::AutofillSuggestion_Data;

  template <typename... Args>
  static AutofillSuggestionPtr New(Args&&... args) {
    return AutofillSuggestionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AutofillSuggestionPtr From(const U& u) {
    return mojo::TypeConverter<AutofillSuggestionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AutofillSuggestion>::Convert(*this);
  }


  AutofillSuggestion();

  AutofillSuggestion(
      uint32_t type,
      const ::std::u16string& main_text,
      const ::std::u16string& minor_text,
      const ::std::u16string& label,
      AutofillSuggestionType type_v1,
      AutofillSuggestionTextPtr main_text_v1,
      std::vector<AutofillSuggestionTextPtr> minor_texts,
      std::vector<std::vector<AutofillSuggestionTextPtr>> labels,
      const ::std::u16string& additional_label,
      bool additional_label_alignment_right,
      AutofillSuggestionCustomIconPtr custom_icon,
      AutofillSuggestionIcon icon,
      AutofillSuggestionIcon trailing_icon,
      const ::gfx::ImageSkia& icon_image);

AutofillSuggestion(const AutofillSuggestion&) = delete;
AutofillSuggestion& operator=(const AutofillSuggestion&) = delete;

  ~AutofillSuggestion();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AutofillSuggestionPtr>
  AutofillSuggestionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AutofillSuggestion::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AutofillSuggestion::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AutofillSuggestion::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AutofillSuggestion::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AutofillSuggestion_UnserializedMessageContext<
            UserType, AutofillSuggestion::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AutofillSuggestion::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AutofillSuggestion::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AutofillSuggestion_UnserializedMessageContext<
            UserType, AutofillSuggestion::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AutofillSuggestion::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t type;
  
  ::std::u16string main_text;
  
  ::std::u16string minor_text;
  
  ::std::u16string label;
  
  AutofillSuggestionType type_v1;
  
  AutofillSuggestionTextPtr main_text_v1;
  
  std::vector<AutofillSuggestionTextPtr> minor_texts;
  
  std::vector<std::vector<AutofillSuggestionTextPtr>> labels;
  
  ::std::u16string additional_label;
  
  bool additional_label_alignment_right;
  
  AutofillSuggestionCustomIconPtr custom_icon;
  
  AutofillSuggestionIcon icon;
  
  AutofillSuggestionIcon trailing_icon;
  
  ::gfx::ImageSkia icon_image;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AutofillSuggestion::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AutofillSuggestion::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AutofillSuggestion::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AutofillSuggestion::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AutofillPopupDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AutofillPopupDetails, T>::value>;
  using DataView = AutofillPopupDetailsDataView;
  using Data_ = internal::AutofillPopupDetails_Data;

  template <typename... Args>
  static AutofillPopupDetailsPtr New(Args&&... args) {
    return AutofillPopupDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AutofillPopupDetailsPtr From(const U& u) {
    return mojo::TypeConverter<AutofillPopupDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AutofillPopupDetails>::Convert(*this);
  }


  AutofillPopupDetails();

  AutofillPopupDetails(
      double x,
      double y,
      double width,
      double height,
      std::vector<AutofillSuggestionPtr> suggestions);

AutofillPopupDetails(const AutofillPopupDetails&) = delete;
AutofillPopupDetails& operator=(const AutofillPopupDetails&) = delete;

  ~AutofillPopupDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AutofillPopupDetailsPtr>
  AutofillPopupDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AutofillPopupDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AutofillPopupDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AutofillPopupDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AutofillPopupDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AutofillPopupDetails_UnserializedMessageContext<
            UserType, AutofillPopupDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AutofillPopupDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AutofillPopupDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AutofillPopupDetails_UnserializedMessageContext<
            UserType, AutofillPopupDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AutofillPopupDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double x;
  
  double y;
  
  double width;
  
  double height;
  
  std::vector<AutofillSuggestionPtr> suggestions;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AutofillPopupDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AutofillPopupDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AutofillPopupDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AutofillPopupDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
AutofillSuggestionCustomIconPtr AutofillSuggestionCustomIcon::Clone() const {
  switch (tag_) {
    case Tag::kImage:
      return NewImage(
          mojo::Clone(data_.image));
    case Tag::kUrl:
      return NewUrl(
          mojo::Clone(data_.url));
    case Tag::kMonogram:
      return NewMonogram(
          mojo::Clone(data_.monogram));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, AutofillSuggestionCustomIcon>::value>::type*>
bool AutofillSuggestionCustomIcon::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kImage:
      return mojo::Equals(data_.image, other.data_.image);
    case Tag::kUrl:
      return mojo::Equals(data_.url, other.data_.url);
    case Tag::kMonogram:
      return mojo::Equals(data_.monogram, other.data_.monogram);
  }

  return false;
}
template <typename StructPtrType>
AutofillSuggestionTextPtr AutofillSuggestionText::Clone() const {
  return New(
      mojo::Clone(value),
      mojo::Clone(is_primary),
      mojo::Clone(should_truncate)
  );
}

template <typename T, AutofillSuggestionText::EnableIfSame<T>*>
bool AutofillSuggestionText::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->is_primary, other_struct.is_primary))
    return false;
  if (!mojo::Equals(this->should_truncate, other_struct.should_truncate))
    return false;
  return true;
}

template <typename T, AutofillSuggestionText::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.is_primary < rhs.is_primary)
    return true;
  if (rhs.is_primary < lhs.is_primary)
    return false;
  if (lhs.should_truncate < rhs.should_truncate)
    return true;
  if (rhs.should_truncate < lhs.should_truncate)
    return false;
  return false;
}
template <typename StructPtrType>
AutofillSuggestionPtr AutofillSuggestion::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(main_text),
      mojo::Clone(minor_text),
      mojo::Clone(label),
      mojo::Clone(type_v1),
      mojo::Clone(main_text_v1),
      mojo::Clone(minor_texts),
      mojo::Clone(labels),
      mojo::Clone(additional_label),
      mojo::Clone(additional_label_alignment_right),
      mojo::Clone(custom_icon),
      mojo::Clone(icon),
      mojo::Clone(trailing_icon),
      mojo::Clone(icon_image)
  );
}

template <typename T, AutofillSuggestion::EnableIfSame<T>*>
bool AutofillSuggestion::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->main_text, other_struct.main_text))
    return false;
  if (!mojo::Equals(this->minor_text, other_struct.minor_text))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  if (!mojo::Equals(this->type_v1, other_struct.type_v1))
    return false;
  if (!mojo::Equals(this->main_text_v1, other_struct.main_text_v1))
    return false;
  if (!mojo::Equals(this->minor_texts, other_struct.minor_texts))
    return false;
  if (!mojo::Equals(this->labels, other_struct.labels))
    return false;
  if (!mojo::Equals(this->additional_label, other_struct.additional_label))
    return false;
  if (!mojo::Equals(this->additional_label_alignment_right, other_struct.additional_label_alignment_right))
    return false;
  if (!mojo::Equals(this->custom_icon, other_struct.custom_icon))
    return false;
  if (!mojo::Equals(this->icon, other_struct.icon))
    return false;
  if (!mojo::Equals(this->trailing_icon, other_struct.trailing_icon))
    return false;
  if (!mojo::Equals(this->icon_image, other_struct.icon_image))
    return false;
  return true;
}

template <typename T, AutofillSuggestion::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.main_text < rhs.main_text)
    return true;
  if (rhs.main_text < lhs.main_text)
    return false;
  if (lhs.minor_text < rhs.minor_text)
    return true;
  if (rhs.minor_text < lhs.minor_text)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  if (lhs.type_v1 < rhs.type_v1)
    return true;
  if (rhs.type_v1 < lhs.type_v1)
    return false;
  if (lhs.main_text_v1 < rhs.main_text_v1)
    return true;
  if (rhs.main_text_v1 < lhs.main_text_v1)
    return false;
  if (lhs.minor_texts < rhs.minor_texts)
    return true;
  if (rhs.minor_texts < lhs.minor_texts)
    return false;
  if (lhs.labels < rhs.labels)
    return true;
  if (rhs.labels < lhs.labels)
    return false;
  if (lhs.additional_label < rhs.additional_label)
    return true;
  if (rhs.additional_label < lhs.additional_label)
    return false;
  if (lhs.additional_label_alignment_right < rhs.additional_label_alignment_right)
    return true;
  if (rhs.additional_label_alignment_right < lhs.additional_label_alignment_right)
    return false;
  if (lhs.custom_icon < rhs.custom_icon)
    return true;
  if (rhs.custom_icon < lhs.custom_icon)
    return false;
  if (lhs.icon < rhs.icon)
    return true;
  if (rhs.icon < lhs.icon)
    return false;
  if (lhs.trailing_icon < rhs.trailing_icon)
    return true;
  if (rhs.trailing_icon < lhs.trailing_icon)
    return false;
  if (lhs.icon_image < rhs.icon_image)
    return true;
  if (rhs.icon_image < lhs.icon_image)
    return false;
  return false;
}
template <typename StructPtrType>
AutofillPopupDetailsPtr AutofillPopupDetails::Clone() const {
  return New(
      mojo::Clone(x),
      mojo::Clone(y),
      mojo::Clone(width),
      mojo::Clone(height),
      mojo::Clone(suggestions)
  );
}

template <typename T, AutofillPopupDetails::EnableIfSame<T>*>
bool AutofillPopupDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->y, other_struct.y))
    return false;
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  if (!mojo::Equals(this->suggestions, other_struct.suggestions))
    return false;
  return true;
}

template <typename T, AutofillPopupDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.x < rhs.x)
    return true;
  if (rhs.x < lhs.x)
    return false;
  if (lhs.y < rhs.y)
    return true;
  if (rhs.y < lhs.y)
    return false;
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  if (lhs.suggestions < rhs.suggestions)
    return true;
  if (rhs.suggestions < lhs.suggestions)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::AutofillSuggestionText::DataView,
                                         ::owl::mojom::AutofillSuggestionTextPtr> {
  static bool IsNull(const ::owl::mojom::AutofillSuggestionTextPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::AutofillSuggestionTextPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::AutofillSuggestionText::value)& value(
      const ::owl::mojom::AutofillSuggestionTextPtr& input) {
    return input->value;
  }

  static decltype(::owl::mojom::AutofillSuggestionText::is_primary) is_primary(
      const ::owl::mojom::AutofillSuggestionTextPtr& input) {
    return input->is_primary;
  }

  static decltype(::owl::mojom::AutofillSuggestionText::should_truncate) should_truncate(
      const ::owl::mojom::AutofillSuggestionTextPtr& input) {
    return input->should_truncate;
  }

  static bool Read(::owl::mojom::AutofillSuggestionText::DataView input, ::owl::mojom::AutofillSuggestionTextPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::AutofillSuggestion::DataView,
                                         ::owl::mojom::AutofillSuggestionPtr> {
  static bool IsNull(const ::owl::mojom::AutofillSuggestionPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::AutofillSuggestionPtr* output) { output->reset(); }

  static decltype(::owl::mojom::AutofillSuggestion::type) type(
      const ::owl::mojom::AutofillSuggestionPtr& input) {
    return input->type;
  }

  static const decltype(::owl::mojom::AutofillSuggestion::main_text)& main_text(
      const ::owl::mojom::AutofillSuggestionPtr& input) {
    return input->main_text;
  }

  static const decltype(::owl::mojom::AutofillSuggestion::minor_text)& minor_text(
      const ::owl::mojom::AutofillSuggestionPtr& input) {
    return input->minor_text;
  }

  static const decltype(::owl::mojom::AutofillSuggestion::label)& label(
      const ::owl::mojom::AutofillSuggestionPtr& input) {
    return input->label;
  }

  static decltype(::owl::mojom::AutofillSuggestion::type_v1) type_v1(
      const ::owl::mojom::AutofillSuggestionPtr& input) {
    return input->type_v1;
  }

  static const decltype(::owl::mojom::AutofillSuggestion::main_text_v1)& main_text_v1(
      const ::owl::mojom::AutofillSuggestionPtr& input) {
    return input->main_text_v1;
  }

  static const decltype(::owl::mojom::AutofillSuggestion::minor_texts)& minor_texts(
      const ::owl::mojom::AutofillSuggestionPtr& input) {
    return input->minor_texts;
  }

  static const decltype(::owl::mojom::AutofillSuggestion::labels)& labels(
      const ::owl::mojom::AutofillSuggestionPtr& input) {
    return input->labels;
  }

  static const decltype(::owl::mojom::AutofillSuggestion::additional_label)& additional_label(
      const ::owl::mojom::AutofillSuggestionPtr& input) {
    return input->additional_label;
  }

  static decltype(::owl::mojom::AutofillSuggestion::additional_label_alignment_right) additional_label_alignment_right(
      const ::owl::mojom::AutofillSuggestionPtr& input) {
    return input->additional_label_alignment_right;
  }

  static  decltype(::owl::mojom::AutofillSuggestion::custom_icon)& custom_icon(
       ::owl::mojom::AutofillSuggestionPtr& input) {
    return input->custom_icon;
  }

  static decltype(::owl::mojom::AutofillSuggestion::icon) icon(
      const ::owl::mojom::AutofillSuggestionPtr& input) {
    return input->icon;
  }

  static decltype(::owl::mojom::AutofillSuggestion::trailing_icon) trailing_icon(
      const ::owl::mojom::AutofillSuggestionPtr& input) {
    return input->trailing_icon;
  }

  static  decltype(::owl::mojom::AutofillSuggestion::icon_image)& icon_image(
       ::owl::mojom::AutofillSuggestionPtr& input) {
    return input->icon_image;
  }

  static bool Read(::owl::mojom::AutofillSuggestion::DataView input, ::owl::mojom::AutofillSuggestionPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::AutofillPopupDetails::DataView,
                                         ::owl::mojom::AutofillPopupDetailsPtr> {
  static bool IsNull(const ::owl::mojom::AutofillPopupDetailsPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::AutofillPopupDetailsPtr* output) { output->reset(); }

  static decltype(::owl::mojom::AutofillPopupDetails::x) x(
      const ::owl::mojom::AutofillPopupDetailsPtr& input) {
    return input->x;
  }

  static decltype(::owl::mojom::AutofillPopupDetails::y) y(
      const ::owl::mojom::AutofillPopupDetailsPtr& input) {
    return input->y;
  }

  static decltype(::owl::mojom::AutofillPopupDetails::width) width(
      const ::owl::mojom::AutofillPopupDetailsPtr& input) {
    return input->width;
  }

  static decltype(::owl::mojom::AutofillPopupDetails::height) height(
      const ::owl::mojom::AutofillPopupDetailsPtr& input) {
    return input->height;
  }

  static  decltype(::owl::mojom::AutofillPopupDetails::suggestions)& suggestions(
       ::owl::mojom::AutofillPopupDetailsPtr& input) {
    return input->suggestions;
  }

  static bool Read(::owl::mojom::AutofillPopupDetails::DataView input, ::owl::mojom::AutofillPopupDetailsPtr* output);
};


template <>
struct  UnionTraits<::owl::mojom::AutofillSuggestionCustomIcon::DataView,
                                        ::owl::mojom::AutofillSuggestionCustomIconPtr> {
  static bool IsNull(const ::owl::mojom::AutofillSuggestionCustomIconPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::AutofillSuggestionCustomIconPtr* output) { output->reset(); }

  static ::owl::mojom::AutofillSuggestionCustomIcon::Tag GetTag(const ::owl::mojom::AutofillSuggestionCustomIconPtr& input) {
    return input->which();
  }

  static  ::gfx::ImageSkia& image( ::owl::mojom::AutofillSuggestionCustomIconPtr& input) {
    return input->get_image();
  }

  static const ::GURL& url(const ::owl::mojom::AutofillSuggestionCustomIconPtr& input) {
    return input->get_url();
  }

  static const ::std::u16string& monogram(const ::owl::mojom::AutofillSuggestionCustomIconPtr& input) {
    return input->get_monogram();
  }

  static bool Read(::owl::mojom::AutofillSuggestionCustomIcon::DataView input, ::owl::mojom::AutofillSuggestionCustomIconPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_AUTOFILL_POPUP_MOJOM_H_