// owl/mojom/autofill_deprecated.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/autofill_deprecated.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/autofill_deprecated.mojom-params-data.h"
#include "owl/mojom/autofill_deprecated.mojom-shared-message-ids.h"

#include "owl/mojom/autofill_deprecated.mojom-import-headers.h"
#include "owl/mojom/autofill_deprecated.mojom-test-utils.h"


namespace owl::mojom {
AutofillPopupRequestDeprecated::AutofillPopupRequestDeprecated()
    : x(),
      y(),
      width(),
      height(),
      suggestions() {}

AutofillPopupRequestDeprecated::AutofillPopupRequestDeprecated(
    double x_in,
    double y_in,
    double width_in,
    double height_in,
    std::vector<::owl::mojom::AutofillSuggestionPtr> suggestions_in)
    : x(std::move(x_in)),
      y(std::move(y_in)),
      width(std::move(width_in)),
      height(std::move(height_in)),
      suggestions(std::move(suggestions_in)) {}

AutofillPopupRequestDeprecated::~AutofillPopupRequestDeprecated() = default;

void AutofillPopupRequestDeprecated::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "x"), this->x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "y"), this->y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width"), this->width,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "height"), this->height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggestions"), this->suggestions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::owl::mojom::AutofillSuggestionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AutofillPopupRequestDeprecated::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

AutofillControllerClient::IPCStableHashFunction AutofillControllerClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AutofillControllerClient>(message.name())) {
    case messages::AutofillControllerClient::kShow: {
      return &AutofillControllerClient::Show_Sym::IPCStableHash;
    }
    case messages::AutofillControllerClient::kHide: {
      return &AutofillControllerClient::Hide_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AutofillControllerClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AutofillControllerClient>(message.name())) {
      case messages::AutofillControllerClient::kShow:
            return "Receive owl::mojom::AutofillControllerClient::Show";
      case messages::AutofillControllerClient::kHide:
            return "Receive owl::mojom::AutofillControllerClient::Hide";
    }
  } else {
    switch (static_cast<messages::AutofillControllerClient>(message.name())) {
      case messages::AutofillControllerClient::kShow:
            return "Receive reply owl::mojom::AutofillControllerClient::Show";
      case messages::AutofillControllerClient::kHide:
            return "Receive reply owl::mojom::AutofillControllerClient::Hide";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AutofillControllerClient::Show_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x97035cbf;  // IPCStableHash for owl::mojom::AutofillControllerClient::Show
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillControllerClient::Hide_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6ee36bf1;  // IPCStableHash for owl::mojom::AutofillControllerClient::Hide
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AutofillControllerClientProxy::AutofillControllerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AutofillControllerClientProxy::Show(
    AutofillPopupRequestDeprecatedPtr in_request) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::AutofillControllerClient::Show", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type AutofillPopupRequestDeprecatedPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillControllerClient::kShow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::AutofillControllerClient_Show_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::AutofillPopupRequestDeprecatedDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in AutofillControllerClient.Show request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillControllerClient::Name_);
  message.set_method_name("Show");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillControllerClientProxy::Hide(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::AutofillControllerClient::Hide");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillControllerClient::kHide), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::AutofillControllerClient_Hide_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillControllerClient::Name_);
  message.set_method_name("Hide");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AutofillControllerClientStubDispatch::Accept(
    AutofillControllerClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AutofillControllerClient>(message->header()->name)) {
    case messages::AutofillControllerClient::kShow: {
      DCHECK(message->is_serialized());
      internal::AutofillControllerClient_Show_Params_Data* params =
          reinterpret_cast<internal::AutofillControllerClient_Show_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutofillControllerClient.0
      bool success = true;
      AutofillPopupRequestDeprecatedPtr p_request{};
      AutofillControllerClient_Show_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillControllerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Show(        
        std::move(p_request));
      return true;
    }
    case messages::AutofillControllerClient::kHide: {
      DCHECK(message->is_serialized());
      internal::AutofillControllerClient_Hide_Params_Data* params =
          reinterpret_cast<internal::AutofillControllerClient_Hide_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutofillControllerClient.1
      bool success = true;
      AutofillControllerClient_Hide_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillControllerClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Hide(        );
      return true;
    }
  }
  return false;
}

// static
bool AutofillControllerClientStubDispatch::AcceptWithResponder(
    AutofillControllerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AutofillControllerClient>(message->header()->name)) {
    case messages::AutofillControllerClient::kShow: {
      break;
    }
    case messages::AutofillControllerClient::kHide: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAutofillControllerClientValidationInfo[] = {
    { &internal::AutofillControllerClient_Show_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AutofillControllerClient_Hide_Params_Data::Validate,
     nullptr /* no response */},
};

bool AutofillControllerClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::AutofillControllerClient::Name_,
    kAutofillControllerClientValidationInfo);
}

// The declaration includes the definition on other builds.

AutofillControllerHost::IPCStableHashFunction AutofillControllerHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AutofillControllerHost>(message.name())) {
    case messages::AutofillControllerHost::kAccept: {
      return &AutofillControllerHost::Accept_Sym::IPCStableHash;
    }
    case messages::AutofillControllerHost::kSelect: {
      return &AutofillControllerHost::Select_Sym::IPCStableHash;
    }
    case messages::AutofillControllerHost::kDismiss: {
      return &AutofillControllerHost::Dismiss_Sym::IPCStableHash;
    }
    case messages::AutofillControllerHost::kGetAddressList: {
      return &AutofillControllerHost::GetAddressList_Sym::IPCStableHash;
    }
    case messages::AutofillControllerHost::kGetCreditCardList: {
      return &AutofillControllerHost::GetCreditCardList_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AutofillControllerHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AutofillControllerHost>(message.name())) {
      case messages::AutofillControllerHost::kAccept:
            return "Receive owl::mojom::AutofillControllerHost::Accept";
      case messages::AutofillControllerHost::kSelect:
            return "Receive owl::mojom::AutofillControllerHost::Select";
      case messages::AutofillControllerHost::kDismiss:
            return "Receive owl::mojom::AutofillControllerHost::Dismiss";
      case messages::AutofillControllerHost::kGetAddressList:
            return "Receive owl::mojom::AutofillControllerHost::GetAddressList";
      case messages::AutofillControllerHost::kGetCreditCardList:
            return "Receive owl::mojom::AutofillControllerHost::GetCreditCardList";
    }
  } else {
    switch (static_cast<messages::AutofillControllerHost>(message.name())) {
      case messages::AutofillControllerHost::kAccept:
            return "Receive reply owl::mojom::AutofillControllerHost::Accept";
      case messages::AutofillControllerHost::kSelect:
            return "Receive reply owl::mojom::AutofillControllerHost::Select";
      case messages::AutofillControllerHost::kDismiss:
            return "Receive reply owl::mojom::AutofillControllerHost::Dismiss";
      case messages::AutofillControllerHost::kGetAddressList:
            return "Receive reply owl::mojom::AutofillControllerHost::GetAddressList";
      case messages::AutofillControllerHost::kGetCreditCardList:
            return "Receive reply owl::mojom::AutofillControllerHost::GetCreditCardList";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AutofillControllerHost::Accept_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x303a3c64;  // IPCStableHash for owl::mojom::AutofillControllerHost::Accept
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillControllerHost::Select_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2a512fce;  // IPCStableHash for owl::mojom::AutofillControllerHost::Select
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillControllerHost::Dismiss_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6a774e81;  // IPCStableHash for owl::mojom::AutofillControllerHost::Dismiss
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillControllerHost::GetAddressList_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd66f04d7;  // IPCStableHash for owl::mojom::AutofillControllerHost::GetAddressList
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillControllerHost::GetCreditCardList_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd5621ef7;  // IPCStableHash for owl::mojom::AutofillControllerHost::GetCreditCardList
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class AutofillControllerHost_GetAddressList_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AutofillControllerHost_GetAddressList_ForwardToCallback(
      AutofillControllerHost::GetAddressListCallback callback
      ) : callback_(std::move(callback)) {
  }

  AutofillControllerHost_GetAddressList_ForwardToCallback(const AutofillControllerHost_GetAddressList_ForwardToCallback&) = delete;
  AutofillControllerHost_GetAddressList_ForwardToCallback& operator=(const AutofillControllerHost_GetAddressList_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AutofillControllerHost::GetAddressListCallback callback_;
};

class AutofillControllerHost_GetCreditCardList_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AutofillControllerHost_GetCreditCardList_ForwardToCallback(
      AutofillControllerHost::GetCreditCardListCallback callback
      ) : callback_(std::move(callback)) {
  }

  AutofillControllerHost_GetCreditCardList_ForwardToCallback(const AutofillControllerHost_GetCreditCardList_ForwardToCallback&) = delete;
  AutofillControllerHost_GetCreditCardList_ForwardToCallback& operator=(const AutofillControllerHost_GetCreditCardList_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AutofillControllerHost::GetCreditCardListCallback callback_;
};

AutofillControllerHostProxy::AutofillControllerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AutofillControllerHostProxy::Accept(
    int32_t in_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::AutofillControllerHost::Accept", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillControllerHost::kAccept), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::AutofillControllerHost_Accept_Params_Data> params(
          message);
  params.Allocate();

  params->index = in_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillControllerHost::Name_);
  message.set_method_name("Accept");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillControllerHostProxy::Select(
    int32_t in_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::AutofillControllerHost::Select", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillControllerHost::kSelect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::AutofillControllerHost_Select_Params_Data> params(
          message);
  params.Allocate();

  params->index = in_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillControllerHost::Name_);
  message.set_method_name("Select");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillControllerHostProxy::Dismiss(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::AutofillControllerHost::Dismiss");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillControllerHost::kDismiss), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::AutofillControllerHost_Dismiss_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillControllerHost::Name_);
  message.set_method_name("Dismiss");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillControllerHostProxy::GetAddressList(
    GetAddressListCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::AutofillControllerHost::GetAddressList");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillControllerHost::kGetAddressList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::AutofillControllerHost_GetAddressList_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillControllerHost::Name_);
  message.set_method_name("GetAddressList");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AutofillControllerHost_GetAddressList_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AutofillControllerHostProxy::GetCreditCardList(
    GetCreditCardListCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::AutofillControllerHost::GetCreditCardList");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillControllerHost::kGetCreditCardList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::AutofillControllerHost_GetCreditCardList_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillControllerHost::Name_);
  message.set_method_name("GetCreditCardList");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AutofillControllerHost_GetCreditCardList_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class AutofillControllerHost_GetAddressList_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AutofillControllerHost::GetAddressListCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AutofillControllerHost_GetAddressList_ProxyToResponder> proxy(
        new AutofillControllerHost_GetAddressList_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AutofillControllerHost_GetAddressList_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AutofillControllerHost_GetAddressList_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AutofillControllerHost_GetAddressList_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AutofillControllerHost::GetAddressListCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::owl::mojom::AutofillAddressEntryPtr> in_addresses);
};

bool AutofillControllerHost_GetAddressList_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AutofillControllerHost_GetAddressList_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AutofillControllerHost_GetAddressList_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AutofillControllerHost.3
  bool success = true;
  std::vector<::owl::mojom::AutofillAddressEntryPtr> p_addresses{};
  AutofillControllerHost_GetAddressList_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAddresses(&p_addresses))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AutofillControllerHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_addresses));
  }
  return true;
}

void AutofillControllerHost_GetAddressList_ProxyToResponder::Run(
    std::vector<::owl::mojom::AutofillAddressEntryPtr> in_addresses) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::AutofillControllerHost::GetAddressList", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("addresses"), in_addresses,
                        "<value of type std::vector<::owl::mojom::AutofillAddressEntryPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillControllerHost::kGetAddressList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::AutofillControllerHost_GetAddressList_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->addresses)::BaseType>
      addresses_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& addresses_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::AutofillAddressEntryDataView>>(
    in_addresses,
    addresses_fragment,
    &addresses_validate_params);

  params->addresses.Set(
      addresses_fragment.is_null() ? nullptr : addresses_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->addresses.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null addresses in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillControllerHost::Name_);
  message.set_method_name("GetAddressList");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AutofillControllerHost_GetCreditCardList_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AutofillControllerHost::GetCreditCardListCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AutofillControllerHost_GetCreditCardList_ProxyToResponder> proxy(
        new AutofillControllerHost_GetCreditCardList_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AutofillControllerHost_GetCreditCardList_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AutofillControllerHost_GetCreditCardList_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AutofillControllerHost_GetCreditCardList_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AutofillControllerHost::GetCreditCardListCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::owl::mojom::AutofillCreditCardEntryPtr> in_credit_cards);
};

bool AutofillControllerHost_GetCreditCardList_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AutofillControllerHost_GetCreditCardList_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AutofillControllerHost_GetCreditCardList_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AutofillControllerHost.4
  bool success = true;
  std::vector<::owl::mojom::AutofillCreditCardEntryPtr> p_credit_cards{};
  AutofillControllerHost_GetCreditCardList_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCreditCards(&p_credit_cards))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AutofillControllerHost::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_credit_cards));
  }
  return true;
}

void AutofillControllerHost_GetCreditCardList_ProxyToResponder::Run(
    std::vector<::owl::mojom::AutofillCreditCardEntryPtr> in_credit_cards) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::AutofillControllerHost::GetCreditCardList", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("credit_cards"), in_credit_cards,
                        "<value of type std::vector<::owl::mojom::AutofillCreditCardEntryPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillControllerHost::kGetCreditCardList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::AutofillControllerHost_GetCreditCardList_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->credit_cards)::BaseType>
      credit_cards_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& credit_cards_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::AutofillCreditCardEntryDataView>>(
    in_credit_cards,
    credit_cards_fragment,
    &credit_cards_validate_params);

  params->credit_cards.Set(
      credit_cards_fragment.is_null() ? nullptr : credit_cards_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->credit_cards.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null credit_cards in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillControllerHost::Name_);
  message.set_method_name("GetCreditCardList");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AutofillControllerHostStubDispatch::Accept(
    AutofillControllerHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AutofillControllerHost>(message->header()->name)) {
    case messages::AutofillControllerHost::kAccept: {
      DCHECK(message->is_serialized());
      internal::AutofillControllerHost_Accept_Params_Data* params =
          reinterpret_cast<internal::AutofillControllerHost_Accept_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutofillControllerHost.0
      bool success = true;
      int32_t p_index{};
      AutofillControllerHost_Accept_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_index = input_data_view.index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillControllerHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Accept(        
        std::move(p_index));
      return true;
    }
    case messages::AutofillControllerHost::kSelect: {
      DCHECK(message->is_serialized());
      internal::AutofillControllerHost_Select_Params_Data* params =
          reinterpret_cast<internal::AutofillControllerHost_Select_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutofillControllerHost.1
      bool success = true;
      int32_t p_index{};
      AutofillControllerHost_Select_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_index = input_data_view.index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillControllerHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Select(        
        std::move(p_index));
      return true;
    }
    case messages::AutofillControllerHost::kDismiss: {
      DCHECK(message->is_serialized());
      internal::AutofillControllerHost_Dismiss_Params_Data* params =
          reinterpret_cast<internal::AutofillControllerHost_Dismiss_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutofillControllerHost.2
      bool success = true;
      AutofillControllerHost_Dismiss_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillControllerHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Dismiss(        );
      return true;
    }
    case messages::AutofillControllerHost::kGetAddressList: {
      break;
    }
    case messages::AutofillControllerHost::kGetCreditCardList: {
      break;
    }
  }
  return false;
}

// static
bool AutofillControllerHostStubDispatch::AcceptWithResponder(
    AutofillControllerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AutofillControllerHost>(message->header()->name)) {
    case messages::AutofillControllerHost::kAccept: {
      break;
    }
    case messages::AutofillControllerHost::kSelect: {
      break;
    }
    case messages::AutofillControllerHost::kDismiss: {
      break;
    }
    case messages::AutofillControllerHost::kGetAddressList: {
      internal::AutofillControllerHost_GetAddressList_Params_Data* params =
          reinterpret_cast<
              internal::AutofillControllerHost_GetAddressList_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AutofillControllerHost.3
      bool success = true;
      AutofillControllerHost_GetAddressList_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillControllerHost::Name_, 3, false);
        return false;
      }
      auto callback =
          AutofillControllerHost_GetAddressList_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAddressList(std::move(callback));
      return true;
    }
    case messages::AutofillControllerHost::kGetCreditCardList: {
      internal::AutofillControllerHost_GetCreditCardList_Params_Data* params =
          reinterpret_cast<
              internal::AutofillControllerHost_GetCreditCardList_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AutofillControllerHost.4
      bool success = true;
      AutofillControllerHost_GetCreditCardList_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillControllerHost::Name_, 4, false);
        return false;
      }
      auto callback =
          AutofillControllerHost_GetCreditCardList_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCreditCardList(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAutofillControllerHostValidationInfo[] = {
    { &internal::AutofillControllerHost_Accept_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AutofillControllerHost_Select_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AutofillControllerHost_Dismiss_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AutofillControllerHost_GetAddressList_Params_Data::Validate,
     &internal::AutofillControllerHost_GetAddressList_ResponseParams_Data::Validate},
    { &internal::AutofillControllerHost_GetCreditCardList_Params_Data::Validate,
     &internal::AutofillControllerHost_GetCreditCardList_ResponseParams_Data::Validate},
};

bool AutofillControllerHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::AutofillControllerHost::Name_,
    kAutofillControllerHostValidationInfo);
}

bool AutofillControllerHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::owl::mojom::AutofillControllerHost::Name_,
    kAutofillControllerHostValidationInfo);
}


}  // owl::mojom


namespace mojo {


// static
bool StructTraits<::owl::mojom::AutofillPopupRequestDeprecated::DataView, ::owl::mojom::AutofillPopupRequestDeprecatedPtr>::Read(
    ::owl::mojom::AutofillPopupRequestDeprecated::DataView input,
    ::owl::mojom::AutofillPopupRequestDeprecatedPtr* output) {
  bool success = true;
  ::owl::mojom::AutofillPopupRequestDeprecatedPtr result(::owl::mojom::AutofillPopupRequestDeprecated::New());
  
      if (success)
        result->x = input.x();
      if (success)
        result->y = input.y();
      if (success)
        result->width = input.width();
      if (success)
        result->height = input.height();
      if (success && !input.ReadSuggestions(&result->suggestions))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void AutofillControllerClientInterceptorForTesting::Show(AutofillPopupRequestDeprecatedPtr request) {
  GetForwardingInterface()->Show(
    std::move(request)
    );
}
void AutofillControllerClientInterceptorForTesting::Hide() {
  GetForwardingInterface()->Hide();
}
AutofillControllerClientAsyncWaiter::AutofillControllerClientAsyncWaiter(
    AutofillControllerClient* proxy) : proxy_(proxy) {}

AutofillControllerClientAsyncWaiter::~AutofillControllerClientAsyncWaiter() = default;





void AutofillControllerHostInterceptorForTesting::Accept(int32_t index) {
  GetForwardingInterface()->Accept(
    std::move(index)
    );
}
void AutofillControllerHostInterceptorForTesting::Select(int32_t index) {
  GetForwardingInterface()->Select(
    std::move(index)
    );
}
void AutofillControllerHostInterceptorForTesting::Dismiss() {
  GetForwardingInterface()->Dismiss();
}
void AutofillControllerHostInterceptorForTesting::GetAddressList(GetAddressListCallback callback) {
  GetForwardingInterface()->GetAddressList(std::move(callback));
}
void AutofillControllerHostInterceptorForTesting::GetCreditCardList(GetCreditCardListCallback callback) {
  GetForwardingInterface()->GetCreditCardList(std::move(callback));
}
AutofillControllerHostAsyncWaiter::AutofillControllerHostAsyncWaiter(
    AutofillControllerHost* proxy) : proxy_(proxy) {}

AutofillControllerHostAsyncWaiter::~AutofillControllerHostAsyncWaiter() = default;


void AutofillControllerHostAsyncWaiter::GetAddressList(
    std::vector<::owl::mojom::AutofillAddressEntryPtr>* out_addresses) {
  base::RunLoop loop;
  proxy_->GetAddressList(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::owl::mojom::AutofillAddressEntryPtr>* out_addresses
,
             std::vector<::owl::mojom::AutofillAddressEntryPtr> addresses) {*out_addresses = std::move(addresses);
            loop->Quit();
          },
          &loop,
          out_addresses));
  loop.Run();
}

std::vector<::owl::mojom::AutofillAddressEntryPtr> AutofillControllerHostAsyncWaiter::GetAddressList(
    ) {
  std::vector<::owl::mojom::AutofillAddressEntryPtr> async_wait_result;
  GetAddressList(&async_wait_result);
  return async_wait_result;
}

void AutofillControllerHostAsyncWaiter::GetCreditCardList(
    std::vector<::owl::mojom::AutofillCreditCardEntryPtr>* out_credit_cards) {
  base::RunLoop loop;
  proxy_->GetCreditCardList(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::owl::mojom::AutofillCreditCardEntryPtr>* out_credit_cards
,
             std::vector<::owl::mojom::AutofillCreditCardEntryPtr> credit_cards) {*out_credit_cards = std::move(credit_cards);
            loop->Quit();
          },
          &loop,
          out_credit_cards));
  loop.Run();
}

std::vector<::owl::mojom::AutofillCreditCardEntryPtr> AutofillControllerHostAsyncWaiter::GetCreditCardList(
    ) {
  std::vector<::owl::mojom::AutofillCreditCardEntryPtr> async_wait_result;
  GetCreditCardList(&async_wait_result);
  return async_wait_result;
}






}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif