// owl/mojom/autofill.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_AUTOFILL_MOJOM_SHARED_H_
#define OWL_MOJOM_AUTOFILL_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/autofill.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"




#include "owl/mojom/autofill.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::AutofillAddressEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::AutofillAddressEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::AutofillAddressEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::guid(input)) in_guid = Traits::guid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->guid)::BaseType> guid_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_guid,
      guid_fragment);

    fragment->guid.Set(
        guid_fragment.is_null() ? nullptr : guid_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->guid.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null guid in AutofillAddressEntry struct");

    decltype(Traits::full_name(input)) in_full_name = Traits::full_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->full_name)::BaseType> full_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_full_name,
      full_name_fragment);

    fragment->full_name.Set(
        full_name_fragment.is_null() ? nullptr : full_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->full_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null full_name in AutofillAddressEntry struct");

    decltype(Traits::single_line_address(input)) in_single_line_address = Traits::single_line_address(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->single_line_address)::BaseType> single_line_address_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_single_line_address,
      single_line_address_fragment);

    fragment->single_line_address.Set(
        single_line_address_fragment.is_null() ? nullptr : single_line_address_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->single_line_address.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null single_line_address in AutofillAddressEntry struct");
  }

  static bool Deserialize(::owl::mojom::internal::AutofillAddressEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::AutofillAddressEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::AutofillCreditCardEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::AutofillCreditCardEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::AutofillCreditCardEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::guid(input)) in_guid = Traits::guid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->guid)::BaseType> guid_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_guid,
      guid_fragment);

    fragment->guid.Set(
        guid_fragment.is_null() ? nullptr : guid_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->guid.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null guid in AutofillCreditCardEntry struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in AutofillCreditCardEntry struct");

    decltype(Traits::card_number(input)) in_card_number = Traits::card_number(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->card_number)::BaseType> card_number_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_card_number,
      card_number_fragment);

    fragment->card_number.Set(
        card_number_fragment.is_null() ? nullptr : card_number_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->card_number.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null card_number in AutofillCreditCardEntry struct");

    decltype(Traits::expiration(input)) in_expiration = Traits::expiration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->expiration)::BaseType> expiration_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_expiration,
      expiration_fragment);

    fragment->expiration.Set(
        expiration_fragment.is_null() ? nullptr : expiration_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->expiration.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null expiration in AutofillCreditCardEntry struct");

    decltype(Traits::network(input)) in_network = Traits::network(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->network)::BaseType> network_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_network,
      network_fragment);

    fragment->network.Set(
        network_fragment.is_null() ? nullptr : network_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->network.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null network in AutofillCreditCardEntry struct");

    decltype(Traits::nickname(input)) in_nickname = Traits::nickname(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->nickname)::BaseType> nickname_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_nickname,
      nickname_fragment);

    fragment->nickname.Set(
        nickname_fragment.is_null() ? nullptr : nickname_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->nickname.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null nickname in AutofillCreditCardEntry struct");
  }

  static bool Deserialize(::owl::mojom::internal::AutofillCreditCardEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::AutofillCreditCardEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace owl::mojom {

inline void AutofillAddressEntryDataView::GetGuidDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->guid.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AutofillAddressEntryDataView::GetFullNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->full_name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void AutofillAddressEntryDataView::GetSingleLineAddressDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->single_line_address.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void AutofillCreditCardEntryDataView::GetGuidDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->guid.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AutofillCreditCardEntryDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void AutofillCreditCardEntryDataView::GetCardNumberDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->card_number.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void AutofillCreditCardEntryDataView::GetExpirationDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->expiration.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void AutofillCreditCardEntryDataView::GetNetworkDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->network.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void AutofillCreditCardEntryDataView::GetNicknameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->nickname.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}



}  // owl::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // OWL_MOJOM_AUTOFILL_MOJOM_SHARED_H_