// owl/host/blink/public/mojom/heap_snapshot_agent.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  File as mojoBase_mojom_File,
  FileSpec as mojoBase_mojom_FileSpec
} from '../../../../../mojo/public/mojom/base/file.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class HeapSnapshotAgentPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.HeapSnapshotAgent', scope);
  }
}

/** @interface */
export class HeapSnapshotAgentInterface {
  
  /**
   * @param { !mojoBase_mojom_File } file
   * @return {!Promise}
   */

  writeHeapSnapshot(file) {}
}

/**
 * @implements { HeapSnapshotAgentInterface }
 */
export class HeapSnapshotAgentRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!HeapSnapshotAgentPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          HeapSnapshotAgentPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!HeapSnapshotAgentPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase_mojom_File } file
   * @return {!Promise}
   */

  writeHeapSnapshot(
      file) {
    return this.proxy.sendMessage(
        0,
        HeapSnapshotAgent_WriteHeapSnapshot_ParamsSpec.$,
        HeapSnapshotAgent_WriteHeapSnapshot_ResponseParamsSpec.$,
        [
          file
        ],
        false);
  }
}

/**
 * An object which receives request messages for the HeapSnapshotAgent
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class HeapSnapshotAgentReceiver {
  /**
   * @param {!HeapSnapshotAgentInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!HeapSnapshotAgentRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        HeapSnapshotAgentRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HeapSnapshotAgentRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        HeapSnapshotAgent_WriteHeapSnapshot_ParamsSpec.$,
        HeapSnapshotAgent_WriteHeapSnapshot_ResponseParamsSpec.$,
        impl.writeHeapSnapshot.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class HeapSnapshotAgent {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.HeapSnapshotAgent";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!HeapSnapshotAgentRemote}
   */
  static getRemote() {
    let remote = new HeapSnapshotAgentRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the HeapSnapshotAgent
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class HeapSnapshotAgentCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      HeapSnapshotAgentRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HeapSnapshotAgentRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeHeapSnapshot =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        HeapSnapshotAgent_WriteHeapSnapshot_ParamsSpec.$,
        HeapSnapshotAgent_WriteHeapSnapshot_ResponseParamsSpec.$,
        this.writeHeapSnapshot.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HeapSnapshotAgent_WriteHeapSnapshot_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HeapSnapshotAgent_WriteHeapSnapshot_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    HeapSnapshotAgent_WriteHeapSnapshot_ParamsSpec.$,
    'HeapSnapshotAgent_WriteHeapSnapshot_Params',
    [
      mojo.internal.StructField(
        'file', 0,
        0,
        mojoBase_mojom_FileSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HeapSnapshotAgent_WriteHeapSnapshot_Params {
  constructor() {
    /** @type { !mojoBase_mojom_File } */
    this.file;
  }
}



mojo.internal.Struct(
    HeapSnapshotAgent_WriteHeapSnapshot_ResponseParamsSpec.$,
    'HeapSnapshotAgent_WriteHeapSnapshot_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class HeapSnapshotAgent_WriteHeapSnapshot_ResponseParams {
  constructor() {
  }
}

