// owl/host/blink/public/mojom/heap_snapshot_agent.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'owl/host/blink/public/mojom/heap_snapshot_agent.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var file$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file.mojom', '../../../../../mojo/public/mojom/base/file.mojom.js');
  }



  function HeapSnapshotAgent_WriteHeapSnapshot_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HeapSnapshotAgent_WriteHeapSnapshot_Params.prototype.initDefaults_ = function() {
    this.file = null;
  };
  HeapSnapshotAgent_WriteHeapSnapshot_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HeapSnapshotAgent_WriteHeapSnapshot_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HeapSnapshotAgent_WriteHeapSnapshot_Params.file
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file$.File, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HeapSnapshotAgent_WriteHeapSnapshot_Params.encodedSize = codec.kStructHeaderSize + 8;

  HeapSnapshotAgent_WriteHeapSnapshot_Params.decode = function(decoder) {
    var packed;
    var val = new HeapSnapshotAgent_WriteHeapSnapshot_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.file =
        decoder.decodeStructPointer(file$.File);
    return val;
  };

  HeapSnapshotAgent_WriteHeapSnapshot_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HeapSnapshotAgent_WriteHeapSnapshot_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file$.File, val.file);
  };
  function HeapSnapshotAgent_WriteHeapSnapshot_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HeapSnapshotAgent_WriteHeapSnapshot_ResponseParams.prototype.initDefaults_ = function() {
  };
  HeapSnapshotAgent_WriteHeapSnapshot_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HeapSnapshotAgent_WriteHeapSnapshot_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HeapSnapshotAgent_WriteHeapSnapshot_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  HeapSnapshotAgent_WriteHeapSnapshot_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new HeapSnapshotAgent_WriteHeapSnapshot_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  HeapSnapshotAgent_WriteHeapSnapshot_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HeapSnapshotAgent_WriteHeapSnapshot_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  var kHeapSnapshotAgent_WriteHeapSnapshot_Name = 0;

  function HeapSnapshotAgentPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(HeapSnapshotAgent,
                                                   handleOrPtrInfo);
  }

  function HeapSnapshotAgentAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        HeapSnapshotAgent, associatedInterfacePtrInfo);
  }

  HeapSnapshotAgentAssociatedPtr.prototype =
      Object.create(HeapSnapshotAgentPtr.prototype);
  HeapSnapshotAgentAssociatedPtr.prototype.constructor =
      HeapSnapshotAgentAssociatedPtr;

  function HeapSnapshotAgentProxy(receiver) {
    this.receiver_ = receiver;
  }
  HeapSnapshotAgentPtr.prototype.writeHeapSnapshot = function() {
    return HeapSnapshotAgentProxy.prototype.writeHeapSnapshot
        .apply(this.ptr.getProxy(), arguments);
  };

  HeapSnapshotAgentProxy.prototype.writeHeapSnapshot = function(file) {
    var params_ = new HeapSnapshotAgent_WriteHeapSnapshot_Params();
    params_.file = file;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kHeapSnapshotAgent_WriteHeapSnapshot_Name,
          codec.align(HeapSnapshotAgent_WriteHeapSnapshot_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(HeapSnapshotAgent_WriteHeapSnapshot_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(HeapSnapshotAgent_WriteHeapSnapshot_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function HeapSnapshotAgentStub(delegate) {
    this.delegate_ = delegate;
  }
  HeapSnapshotAgentStub.prototype.writeHeapSnapshot = function(file) {
    return this.delegate_ && this.delegate_.writeHeapSnapshot && this.delegate_.writeHeapSnapshot(file);
  }

  HeapSnapshotAgentStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  HeapSnapshotAgentStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kHeapSnapshotAgent_WriteHeapSnapshot_Name:
      var params = reader.decodeStruct(HeapSnapshotAgent_WriteHeapSnapshot_Params);
      this.writeHeapSnapshot(params.file).then(function(response) {
        var responseParams =
            new HeapSnapshotAgent_WriteHeapSnapshot_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kHeapSnapshotAgent_WriteHeapSnapshot_Name,
            codec.align(HeapSnapshotAgent_WriteHeapSnapshot_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(HeapSnapshotAgent_WriteHeapSnapshot_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateHeapSnapshotAgentRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kHeapSnapshotAgent_WriteHeapSnapshot_Name:
        if (message.expectsResponse())
          paramsClass = HeapSnapshotAgent_WriteHeapSnapshot_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateHeapSnapshotAgentResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kHeapSnapshotAgent_WriteHeapSnapshot_Name:
        if (message.isResponse())
          paramsClass = HeapSnapshotAgent_WriteHeapSnapshot_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var HeapSnapshotAgent = {
    name: 'blink.mojom.HeapSnapshotAgent',
    kVersion: 0,
    ptrClass: HeapSnapshotAgentPtr,
    proxyClass: HeapSnapshotAgentProxy,
    stubClass: HeapSnapshotAgentStub,
    validateRequest: validateHeapSnapshotAgentRequest,
    validateResponse: validateHeapSnapshotAgentResponse,
  };
  HeapSnapshotAgentStub.prototype.validator = validateHeapSnapshotAgentRequest;
  HeapSnapshotAgentProxy.prototype.validator = validateHeapSnapshotAgentResponse;
  exports.HeapSnapshotAgent = HeapSnapshotAgent;
  exports.HeapSnapshotAgentPtr = HeapSnapshotAgentPtr;
  exports.HeapSnapshotAgentAssociatedPtr = HeapSnapshotAgentAssociatedPtr;
})();