// owl/host/blink/public/mojom/heap_snapshot_agent.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_HOST_BLINK_PUBLIC_MOJOM_HEAP_SNAPSHOT_AGENT_MOJOM_BLINK_H_
#define OWL_HOST_BLINK_PUBLIC_MOJOM_HEAP_SNAPSHOT_AGENT_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/host/blink/public/mojom/heap_snapshot_agent.mojom-features.h"  // IWYU pragma: export
#include "owl/host/blink/public/mojom/heap_snapshot_agent.mojom-shared.h"  // IWYU pragma: export
#include "owl/host/blink/public/mojom/heap_snapshot_agent.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class HeapSnapshotAgentProxy;

template <typename ImplRefTraits>
class HeapSnapshotAgentStub;

class HeapSnapshotAgentRequestValidator;
class HeapSnapshotAgentResponseValidator;


class PLATFORM_EXPORT HeapSnapshotAgent
    : public HeapSnapshotAgentInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.HeapSnapshotAgent";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = HeapSnapshotAgentInterfaceBase;
  using Proxy_ = HeapSnapshotAgentProxy;

  template <typename ImplRefTraits>
  using Stub_ = HeapSnapshotAgentStub<ImplRefTraits>;

  using RequestValidator_ = HeapSnapshotAgentRequestValidator;
  using ResponseValidator_ = HeapSnapshotAgentResponseValidator;
  enum MethodMinVersions : uint32_t {
    kWriteHeapSnapshotMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct WriteHeapSnapshot_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~HeapSnapshotAgent() = default;

  using WriteHeapSnapshotCallback = base::OnceCallback<void()>;
  using WriteHeapSnapshotMojoCallback = base::OnceCallback<void()>;

  virtual void WriteHeapSnapshot(::base::File file, WriteHeapSnapshotCallback callback) = 0;
};



class PLATFORM_EXPORT HeapSnapshotAgentProxy
    : public HeapSnapshotAgent {
 public:
  using InterfaceType = HeapSnapshotAgent;

  explicit HeapSnapshotAgentProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void WriteHeapSnapshot(::base::File file, WriteHeapSnapshotCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT HeapSnapshotAgentStubDispatch {
 public:
  static bool Accept(HeapSnapshotAgent* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HeapSnapshotAgent* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HeapSnapshotAgent>>
class HeapSnapshotAgentStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HeapSnapshotAgentStub() = default;
  ~HeapSnapshotAgentStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HeapSnapshotAgentStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HeapSnapshotAgentStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT HeapSnapshotAgentRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT HeapSnapshotAgentResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // OWL_HOST_BLINK_PUBLIC_MOJOM_HEAP_SNAPSHOT_AGENT_MOJOM_BLINK_H_