// owl/host/blink/public/mojom/heap_snapshot_agent.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/host/blink/public/mojom/heap_snapshot_agent.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/host/blink/public/mojom/heap_snapshot_agent.mojom-params-data.h"
#include "owl/host/blink/public/mojom/heap_snapshot_agent.mojom-shared-message-ids.h"

#include "owl/host/blink/public/mojom/heap_snapshot_agent.mojom-blink-import-headers.h"
#include "owl/host/blink/public/mojom/heap_snapshot_agent.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

HeapSnapshotAgent::IPCStableHashFunction HeapSnapshotAgent::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::HeapSnapshotAgent>(message.name())) {
    case messages::HeapSnapshotAgent::kWriteHeapSnapshot: {
      return &HeapSnapshotAgent::WriteHeapSnapshot_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* HeapSnapshotAgent::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::HeapSnapshotAgent>(message.name())) {
      case messages::HeapSnapshotAgent::kWriteHeapSnapshot:
            return "Receive blink::mojom::HeapSnapshotAgent::WriteHeapSnapshot";
    }
  } else {
    switch (static_cast<messages::HeapSnapshotAgent>(message.name())) {
      case messages::HeapSnapshotAgent::kWriteHeapSnapshot:
            return "Receive reply blink::mojom::HeapSnapshotAgent::WriteHeapSnapshot";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t HeapSnapshotAgent::WriteHeapSnapshot_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf5ccb96e;  // IPCStableHash for blink::mojom::HeapSnapshotAgent::WriteHeapSnapshot
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class HeapSnapshotAgent_WriteHeapSnapshot_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HeapSnapshotAgent_WriteHeapSnapshot_ForwardToCallback(
      HeapSnapshotAgent::WriteHeapSnapshotCallback callback
      ) : callback_(std::move(callback)) {
  }

  HeapSnapshotAgent_WriteHeapSnapshot_ForwardToCallback(const HeapSnapshotAgent_WriteHeapSnapshot_ForwardToCallback&) = delete;
  HeapSnapshotAgent_WriteHeapSnapshot_ForwardToCallback& operator=(const HeapSnapshotAgent_WriteHeapSnapshot_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  HeapSnapshotAgent::WriteHeapSnapshotCallback callback_;
};

HeapSnapshotAgentProxy::HeapSnapshotAgentProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HeapSnapshotAgentProxy::WriteHeapSnapshot(
    ::base::File in_file, WriteHeapSnapshotCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::HeapSnapshotAgent::WriteHeapSnapshot", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file,
                        "<value of type ::base::File>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HeapSnapshotAgent::kWriteHeapSnapshot), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::HeapSnapshotAgent_WriteHeapSnapshot_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
    in_file,
    file_fragment);

  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file in HeapSnapshotAgent.WriteHeapSnapshot request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HeapSnapshotAgent::Name_);
  message.set_method_name("WriteHeapSnapshot");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HeapSnapshotAgent_WriteHeapSnapshot_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class HeapSnapshotAgent_WriteHeapSnapshot_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static HeapSnapshotAgent::WriteHeapSnapshotCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<HeapSnapshotAgent_WriteHeapSnapshot_ProxyToResponder> proxy(
        new HeapSnapshotAgent_WriteHeapSnapshot_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&HeapSnapshotAgent_WriteHeapSnapshot_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HeapSnapshotAgent_WriteHeapSnapshot_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  HeapSnapshotAgent_WriteHeapSnapshot_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "HeapSnapshotAgent::WriteHeapSnapshotCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool HeapSnapshotAgent_WriteHeapSnapshot_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::HeapSnapshotAgent_WriteHeapSnapshot_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HeapSnapshotAgent_WriteHeapSnapshot_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for HeapSnapshotAgent.0
  bool success = true;
  HeapSnapshotAgent_WriteHeapSnapshot_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HeapSnapshotAgent::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void HeapSnapshotAgent_WriteHeapSnapshot_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::HeapSnapshotAgent::WriteHeapSnapshot");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HeapSnapshotAgent::kWriteHeapSnapshot), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::HeapSnapshotAgent_WriteHeapSnapshot_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HeapSnapshotAgent::Name_);
  message.set_method_name("WriteHeapSnapshot");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool HeapSnapshotAgentStubDispatch::Accept(
    HeapSnapshotAgent* impl,
    mojo::Message* message) {
  switch (static_cast<messages::HeapSnapshotAgent>(message->header()->name)) {
    case messages::HeapSnapshotAgent::kWriteHeapSnapshot: {
      break;
    }
  }
  return false;
}

// static
bool HeapSnapshotAgentStubDispatch::AcceptWithResponder(
    HeapSnapshotAgent* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::HeapSnapshotAgent>(message->header()->name)) {
    case messages::HeapSnapshotAgent::kWriteHeapSnapshot: {
      internal::HeapSnapshotAgent_WriteHeapSnapshot_Params_Data* params =
          reinterpret_cast<
              internal::HeapSnapshotAgent_WriteHeapSnapshot_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for HeapSnapshotAgent.0
      bool success = true;
      ::base::File p_file{};
      HeapSnapshotAgent_WriteHeapSnapshot_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFile(&p_file))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HeapSnapshotAgent::Name_, 0, false);
        return false;
      }
      auto callback =
          HeapSnapshotAgent_WriteHeapSnapshot_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteHeapSnapshot(        
        std::move(p_file), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kHeapSnapshotAgentValidationInfo[] = {
    { &internal::HeapSnapshotAgent_WriteHeapSnapshot_Params_Data::Validate,
     &internal::HeapSnapshotAgent_WriteHeapSnapshot_ResponseParams_Data::Validate},
};

bool HeapSnapshotAgentRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::HeapSnapshotAgent::Name_,
    kHeapSnapshotAgentValidationInfo);
}

bool HeapSnapshotAgentResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::HeapSnapshotAgent::Name_,
    kHeapSnapshotAgentValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void HeapSnapshotAgentInterceptorForTesting::WriteHeapSnapshot(::base::File file, WriteHeapSnapshotCallback callback) {
  GetForwardingInterface()->WriteHeapSnapshot(
    std::move(file)
    , std::move(callback));
}
HeapSnapshotAgentAsyncWaiter::HeapSnapshotAgentAsyncWaiter(
    HeapSnapshotAgent* proxy) : proxy_(proxy) {}

HeapSnapshotAgentAsyncWaiter::~HeapSnapshotAgentAsyncWaiter() = default;


void HeapSnapshotAgentAsyncWaiter::WriteHeapSnapshot(
    ::base::File file) {
  base::RunLoop loop;
  proxy_->WriteHeapSnapshot(
      std::move(file),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif